/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActFormAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.stereotype.Service;

@Service(value="sysActFormAuthService")
public class SysActFormAuthServiceImpl
extends ServiceImpl<SysActFormAuthMapper, SysActFormAuth>
implements SysActFormAuthService {
    @Resource
    private ISysActProcessDeptService iSysActProcessDeptService;
    @Resource
    private HistoryService historyService;
    @Resource
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private ModelService modelService;

    public JSONArray initList(String formName, String processKey, String procVer, String formType, String taskId, String taskDefinitionKey) {
        QueryWrapper flowAuthWrapper = new QueryWrapper();
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)processKey), (Object)"FORM_NAME", (Object)formName);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)processKey), (Object)"PROCESS_DEFINITION_KEY", (Object)processKey);
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)historicTaskInstance)) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            int version = Integer.parseInt(this.modelService.getRealVersion(historicTaskInstance.getProcessDefinitionId()));
            flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)procVer), (Object)"PROC_VER", (Object)version);
            flowAuthWrapper.eq((Object)"TASK_DEFINITION_KEY", (Object)historicTaskInstance.getTaskDefinitionKey());
        } else if (HussarUtils.isEmpty((Object)procVer)) {
            int version = this.iSysActProcessDeptService.getProcessVersion(String.valueOf(BaseSecurityUtil.getUser().getDeptId()), processKey);
            flowAuthWrapper.eq((Object)"PROC_VER", (Object)version);
        } else {
            flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)procVer), (Object)"PROC_VER", (Object)Integer.parseInt(procVer));
        }
        flowAuthWrapper.eq((Object)"FORM_TYPE", (Object)formType);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            flowAuthWrapper.eq((Object)"TASK_DEFINITION_KEY", (Object)taskDefinitionKey);
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
    }

    public boolean saveOrUpdateAuth(JSONArray insertAuth) {
        List list = JSONObject.parseArray((String)insertAuth.toJSONString(), SysActFormAuth.class);
        return this.saveOrUpdateBatch(list);
    }

    public boolean removeAuth(String formName, String formType, String processKey, String procVer) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.eq(SysActFormAuth::getProcVer, (Object)Integer.parseInt(procVer));
        return this.remove((Wrapper)flowAuthWrapper);
    }

    public boolean copyAuth(String processKey, String oldProcessKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey));
        for (SysActFormAuth sysActFormAuth : list) {
            sysActFormAuth.setId(null);
            sysActFormAuth.setProcessKey(processKey);
        }
        return this.saveBatch(list);
    }

    public boolean copyAuth(String processKey, int version, String oldProcessKey, int oldVersion) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey)).eq(SysActFormAuth::getProcVer, (Object)oldVersion));
        for (SysActFormAuth sysActFormAuth : list) {
            sysActFormAuth.setId(null);
            sysActFormAuth.setProcessKey(processKey);
            sysActFormAuth.setProcVer(version);
        }
        return this.saveBatch(list);
    }
}

