/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkFlowRectificationListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkFlowRectificationListenerService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private BpmMsgPushService msgPushService;
    @Autowired
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        String sendId = "";
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
            sendId = ((IdentityLinkEntity)linkEntityList.get(0)).getUserId();
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (!entity.getTasks().isEmpty()) {
            for (TaskEntity taskEntity : entity.getTasks()) {
                this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
            }
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            if ("endProcess".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                this.endProcessMsgPush(map);
            } else {
                this.completeProcessMsgPush(map);
            }
        }
        if (entity.getProcessInstance().getSuperExecution() == null && "rectification".equals(Context.getCommandContext().getAttribute("approvalType"))) {
            map.remove("type");
            map.put("approvalType", "rectification");
            this.rectificationProcess(map);
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            List<SysActCcTask> ccTaskList;
            String endUserId = "";
            if (!linkEntityList.isEmpty()) {
                endUserId = ((IdentityLinkEntity)linkEntityList.get(linkEntityList.size() - 1)).getUserId();
            }
            ProcessDefinition processDefinition = (ProcessDefinition)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(entity.getProcessDefinitionId()).singleResult();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysActCcTaskConfig::getProcDefKey, (Object)entity.getProcessDefinitionKey())).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion()));
            if ("accept".equals(Context.getCommandContext().getAttribute("approvalType")) || "agree".equals(Context.getCommandContext().getAttribute("approvalType"))) {
                queryWrapper.eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_pass");
            } else if ("disagree".equals(Context.getCommandContext().getAttribute("approvalType"))) {
                queryWrapper.eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_un_pass");
            } else {
                return;
            }
            List configList = this.sysActCcTaskConfigService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)configList) && HussarUtils.isNotEmpty(ccTaskList = CcTaskUtil.getCcTaskList(entity, configList, sendId, sendId))) {
                this.sysActCcTaskService.saveBatch(ccTaskList);
            }
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void endProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("terminated");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void completeProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("complete");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void addMessage(Map<String, Object> map, BpmActMsgDetail bpmActMsgDetail) {
        bpmActMsgDetail.setProcessName(map.get("processDefinitionName").toString());
        bpmActMsgDetail.setProcessDefinitionId(map.get("processDefinitionId").toString());
        bpmActMsgDetail.setProcessKey(map.get("processDefinitionId").toString().split(":")[0]);
        bpmActMsgDetail.setProcessVer(map.get("processDefinitionId").toString().split(":")[1]);
        ArrayList<String> user = new ArrayList<String>();
        user.add(map.get("starter").toString());
        bpmActMsgDetail.setReceive(user);
    }

    private void rectificationProcess(Map<String, Object> map) {
        try {
            ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
            LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
            String processDefinitionId = map.get("processDefinitionId").toString();
            ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(processDefinitionId);
            if (processDefinition.getRealVersion() != null) {
                processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionByKeyAndVersion(processDefinition.getKey(), processDefinition.getRealVersion());
                processDefinitionId = processDefinition.getId();
            }
            ProcessExtendProperties processExtendProperties = this.processDefinitionsMapper.getProcessExtendProperties(processDefinitionId);
            String beanId = processExtendProperties.getRectificationBeanId();
            String rectificationBusinessId = null;
            if (!lcdpBpmProperties.isStartAlone()) {
                HussarWorkFlowRectificationListener rectificationListener = (HussarWorkFlowRectificationListener)SpringContextHolder.getBean((String)beanId);
                rectificationBusinessId = rectificationListener.notify(map);
            } else {
                String serviceName = modelService.getServiceName(map.get("processDefinitionId").toString().split(":")[0]);
                map.put("beanId", beanId);
                WorkFlowRectificationListenerService workFlowRectificationListenerService = (WorkFlowRectificationListenerService)SpringContextHolder.getBean(WorkFlowRectificationListenerService.class);
                rectificationBusinessId = workFlowRectificationListenerService.executeListener(map, serviceName);
            }
            this.instanceEngineMapper.updateRectification(Long.parseLong(map.get("processInsId").toString()), rectificationBusinessId, null, processExtendProperties.getRectificationFormKey());
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8fd4\u56de\u6574\u6539\u76d1\u542c\u5668\u5931\u8d25", (Throwable)e);
        }
    }
}

