/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.engine.bpm.approvefile.model.ApproveFile;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ApprovalExtendPropertiesVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.Personnel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.vo.PersonnelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.ProcessInstanceHistoryTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstService processInstService;
    private static final Logger logger = LoggerFactory.getLogger(FlowTaskServiceImpl.class);
    private static final Map<String, String> APPROVAL_STATE = new HashMap<String, String>();
    private static final Map<String, String> APPROVAL_TYPE = new HashMap<String, String>();

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        flowTaskQueryModel.setNowTime(new Date());
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setFormAddress((JSONObject)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setIsDeleteProcinst(flowTask.getIsDeleteProcinst());
            taskManagerQueryVo.setStartUserId(flowTask.getStartUserId());
            taskManagerQueryVo.setDepartmentId(flowTask.getDepartmentId());
            taskManagerQueryVo.setUnit(this.getUtilNameByUserId(taskManagerQueryVo.getStartUserId()));
            if (flowTask.getDueTime() != null && flowTask.getDueTime().length() != 0) {
                try {
                    SimpleDateFormat dueTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date now = new Date();
                    Date dueTime = dueTimeFormat.parse(flowTask.getDueTime());
                    Long days = (dueTime.getTime() - now.getTime()) / 86400000L;
                    String numberOfDaysBeforeTimeout = days.toString();
                    taskManagerQueryVo.setNumberOfDaysBeforeTimeout(numberOfDaysBeforeTimeout);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb(taskManagerQueryVo.getFormAddress().getString("web"));
                taskManagerQueryVo.setMobile(taskManagerQueryVo.getFormAddress().getString("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            if (flowTask.getTaskVariableMap() != null) {
                taskManagerQueryVo.setMessage((String)flowTask.getTaskVariableMap().get("todoConfiguration"));
                taskManagerQueryVo.setTaskSourceFlag((String)flowTask.getTaskVariableMap().get("taskSourceFlag"));
                taskManagerQueryVo.setSendUser((String)flowTask.getTaskVariableMap().get("sendUser"));
            }
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getStartUserId()));
            departmentIds.add(taskManagerQueryVo.getDepartmentId());
            resultData.add(taskManagerQueryVo);
        }
        Map map = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Map departments = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(map.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator2.next()).getSendUser()) == null ? "" : (String)map.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(map.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)map.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(map.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)map.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setStartUser(map.get(taskManagerQueryVo.getStartUserId()) == null ? "" : (String)map.get(taskManagerQueryVo.getStartUserId()));
            taskManagerQueryVo.setDepartmentName(departments.get(taskManagerQueryVo.getDepartmentId()) == null ? "" : (String)departments.get(taskManagerQueryVo.getDepartmentId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null, tenantId);
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, tenantId));
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<List<TaskManagerQueryVo>> pendingApprovalList(FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        flowTaskQueryModel.setNowTime(new Date());
        List<FlowTask> todoList = this.flowTaskMapper.pendingApprovalList(flowTaskQueryModel);
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(null, processInsIds);
        }
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            ArrayList<Variables> list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
            if (list == null) {
                list = new ArrayList<Variables>();
            }
            list.add(variables);
            processVariablesMap.put(variables.getProcessInsId(), list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setProcessVariables(processVariablesMap.get((flowTask = (FlowTask)iterator.next()).getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setFormAddress((JSONObject)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setStartUserId(flowTask.getStartUserId());
            taskManagerQueryVo.setDepartmentId(flowTask.getDepartmentId());
            taskManagerQueryVo.setNumberOfDaysBeforeTimeout(flowTask.getNumberOfDaysBeforeTimeout());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb(taskManagerQueryVo.getFormAddress().getString("web"));
                taskManagerQueryVo.setMobile(taskManagerQueryVo.getFormAddress().getString("mobile"));
            }
            taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskId(flowTask.getTaskId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setUnit(this.getUtilNameByUserId(taskManagerQueryVo.getStartUserId()));
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getStartUserId()));
            departmentIds.add(taskManagerQueryVo.getDepartmentId());
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Map departments = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setAssigneeName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator2.next()).getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setStartUser(finalUsers.get(taskManagerQueryVo.getStartUserId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getStartUserId()));
            taskManagerQueryVo.setDepartmentName(departments.get(taskManagerQueryVo.getDepartmentId()) == null ? "" : (String)departments.get(taskManagerQueryVo.getDepartmentId()));
        }
        return ApiResponse.success(resultData);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> rectificationList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        List<FlowTask> rectificationList = this.flowTaskMapper.rectificationList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : rectificationList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!rectificationList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = rectificationList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(rectificationList, tenantId));
        return ApiResponse.success((Object)page);
    }

    /*
     * WARNING - void declaration
     */
    public ApiResponse<ProcessInstanceHistoryTaskVo> processInstanceHistoryTaskList(String businessId, String userId) {
        ProcessInst processInst;
        ProcessInstanceHistoryTaskVo processInstanceHistoryTaskVo = new ProcessInstanceHistoryTaskVo();
        String processInstanceId = "";
        ArrayList<Object> taskManagerQueryVos = new ArrayList<Object>();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> userIdsForDepartmentAndPost = new ArrayList<String>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        ArrayList<String> postIds = new ArrayList<String>();
        Map departmentMap = new HashMap();
        Map postMap = new HashMap();
        String adaptApprover = "0";
        String adaptSubsequentApprover = "0";
        ArrayList<String> permitForApprovalNodes = new ArrayList<String>();
        HashMap<String, String> permitForApprovalMap = new HashMap<String, String>();
        List<FlowTask> flowTasks = this.flowTaskMapper.processInstanceHistoryTaskList(businessId);
        for (FlowTask flowTask : flowTasks) {
            void var22_20;
            ApprovalExtendPropertiesVo approvalExtendPropertiesVo;
            Object processDeyId;
            Object taskManagerQueryVo = new TaskManagerQueryVo();
            ArrayList arrayList = new ArrayList();
            if ("0".equals(flowTask.getApprovalState())) {
                List<ApproveFile> list = this.flowTaskMapper.approveFileList(flowTask.getTaskId());
            }
            ArrayList list = new ArrayList();
            taskManagerQueryVo.setTaskId(flowTask.getTaskId());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getAssigneeId());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setApprovalState(APPROVAL_STATE.get(flowTask.getApprovalState()));
            taskManagerQueryVo.setApprovalType(APPROVAL_TYPE.get(flowTask.getApprovalType()));
            taskManagerQueryVo.setEndTime(flowTask.getEndTime());
            taskManagerQueryVo.setDueTime(flowTask.getDueTime());
            taskManagerQueryVo.setComment(flowTask.getComment());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefKey());
            taskManagerQueryVo.setBusinessId(businessId);
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setSeq(Integer.valueOf(flowTask.getSeq()));
            taskManagerQueryVo.setDepartmentId(flowTask.getDepartmentId());
            taskManagerQueryVo.setPostId(flowTask.getPostId());
            if ("1".equals(flowTask.getApprovalState()) && userId.equals(flowTask.getAssigneeId())) {
                taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
                processDeyId = flowTask.getProcessDefinitionId();
                String string = flowTask.getTaskDefKey();
                approvalExtendPropertiesVo = this.sysActExtendPropertiesService.getApprovalExtendProperties((String)processDeyId, string);
                adaptApprover = approvalExtendPropertiesVo.getAdaptApprover();
                if ("0".equals(adaptSubsequentApprover)) {
                    adaptSubsequentApprover = approvalExtendPropertiesVo.getAdaptSubsequentApprover();
                }
                taskManagerQueryVo.setIsPermitForModifyingAssignee(adaptApprover);
                taskManagerQueryVo.setIsPermitForApproval("1");
                permitForApprovalNodes.add(flowTask.getTaskDefKey());
                permitForApprovalMap.put(flowTask.getTaskDefKey(), adaptApprover);
            } else if ("2".equals(flowTask.getApprovalState())) {
                taskManagerQueryVo.setIsPermitForModifyingAssignee(adaptSubsequentApprover);
                taskManagerQueryVo.setIsPermitForApproval("0");
            } else {
                taskManagerQueryVo.setIsPermitForModifyingAssignee("0");
                taskManagerQueryVo.setIsPermitForApproval("0");
            }
            if ("1".equals(flowTask.getApprovalState()) && ("0".equals(processInstanceHistoryTaskVo.getIsPermitForAddApprovalNode()) || "0".equals(processInstanceHistoryTaskVo.getIsPermitForEditForm())) && userId.equals(flowTask.getAssigneeId())) {
                String string;
                processDeyId = flowTask.getProcessDefinitionId();
                approvalExtendPropertiesVo = this.sysActExtendPropertiesService.getApprovalExtendProperties((String)processDeyId, string = flowTask.getTaskDefKey());
                if ("1".equals(String.valueOf(approvalExtendPropertiesVo.getAddApprovalNode()))) {
                    processInstanceHistoryTaskVo.setIsPermitForAddApprovalNode("1");
                }
                if ("1".equals(String.valueOf(approvalExtendPropertiesVo.getAllowEditForm()))) {
                    processInstanceHistoryTaskVo.setIsPermitForEditForm("1");
                }
            }
            if ("0".equals(flowTask.getApprovalState()) && var22_20 != null && var22_20.size() != 0) {
                for (ApproveFile approveFile : var22_20) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fileId", approveFile.getFileId());
                    map.put("attachmentName", approveFile.getAttachmentName());
                    list.add(map);
                }
            }
            taskManagerQueryVo.setApproveFile(list);
            userIds.add(flowTask.getAssigneeId());
            if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                userIdsForDepartmentAndPost.add(taskManagerQueryVo.getOwner());
            } else if (taskManagerQueryVo.getAssigneeId() != null && taskManagerQueryVo.getAssigneeId().length() != 0) {
                userIdsForDepartmentAndPost.add(taskManagerQueryVo.getAssigneeId());
            }
            if (taskManagerQueryVo.getDepartmentId() != null && taskManagerQueryVo.getDepartmentId().length() != 0) {
                departmentIds.add(taskManagerQueryVo.getDepartmentId());
            }
            if (taskManagerQueryVo.getPostId() != null && taskManagerQueryVo.getPostId().length() != 0) {
                postIds.add(taskManagerQueryVo.getPostId());
            }
            taskManagerQueryVos.add(taskManagerQueryVo);
        }
        if (permitForApprovalNodes != null && permitForApprovalNodes.size() != 0) {
            for (String permitForApprovalNode : permitForApprovalNodes) {
                for (TaskManagerQueryVo taskManagerQueryVo : taskManagerQueryVos) {
                    if (!taskManagerQueryVo.getTaskDefinitionKey().equals(permitForApprovalNode) || APPROVAL_STATE.get("0").equals(taskManagerQueryVo.getApprovalState())) continue;
                    taskManagerQueryVo.setIsPermitForModifyingAssignee((String)permitForApprovalMap.get(permitForApprovalNode));
                }
            }
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, null);
        Map userDepartmentAndPostModelMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIdsForDepartmentAndPost);
        departmentMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        postMap = this.iAssigneeChooseService.getPostNameBypostIds(postIds);
        Iterator<Object> iterator = taskManagerQueryVos.iterator();
        while (iterator.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setAssignee(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            if (taskManagerQueryVo.getDepartmentId() == null || taskManagerQueryVo.getDepartmentId().length() == 0) {
                if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                    taskManagerQueryVo.setDepartmentId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner())).getDepartmentId());
                    taskManagerQueryVo.setDepartmentName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner())).getDepartmentName());
                } else if (taskManagerQueryVo.getAssigneeId() != null && taskManagerQueryVo.getAssigneeId().length() != 0) {
                    taskManagerQueryVo.setDepartmentId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())).getDepartmentId());
                    taskManagerQueryVo.setDepartmentName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())).getDepartmentName());
                }
            } else {
                taskManagerQueryVo.setDepartmentName((String)departmentMap.get(taskManagerQueryVo.getDepartmentId()));
            }
            if (taskManagerQueryVo.getPostId() == null || taskManagerQueryVo.getPostId().length() == 0 || "null".equals(taskManagerQueryVo.getPostId())) {
                if (taskManagerQueryVo.getOwner() != null && taskManagerQueryVo.getOwner().length() != 0) {
                    taskManagerQueryVo.setPostId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner())).getPostId());
                    taskManagerQueryVo.setPostName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getOwner())).getPostName());
                    continue;
                }
                if (taskManagerQueryVo.getAssigneeId() == null || taskManagerQueryVo.getAssigneeId().length() == 0) continue;
                taskManagerQueryVo.setPostId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())).getPostId());
                taskManagerQueryVo.setPostName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(taskManagerQueryVo.getAssigneeId())).getPostName());
                continue;
            }
            taskManagerQueryVo.setPostName((String)postMap.get(taskManagerQueryVo.getPostId()));
        }
        Collections.sort(taskManagerQueryVos, new Comparator<TaskManagerQueryVo>(){

            @Override
            public int compare(TaskManagerQueryVo t1, TaskManagerQueryVo t2) {
                Integer seq1 = t1.getSeq();
                Integer seq2 = t2.getSeq();
                if (seq1 == 0 && seq2 == 0) {
                    if (t1.getStartTime() != null && t2.getStartTime() != null) {
                        Long time1 = t1.getStartTime().getTime();
                        Long time2 = t2.getStartTime().getTime();
                        if (time2 - time1 < 0L) {
                            return 1;
                        }
                        if (time1 - time2 == 0L) {
                            return 0;
                        }
                        return -1;
                    }
                    if (t1.getStartTime() != null && t2.getStartTime() == null) {
                        return -1;
                    }
                    if (t2.getStartTime() != null && t1.getStartTime() == null) {
                        return 1;
                    }
                    return 0;
                }
                if (seq1 != 0 && seq2 == 0) {
                    return 1;
                }
                if (seq2 != 0 && seq1 == 0) {
                    return -1;
                }
                if (seq2 - seq1 < 0) {
                    return 1;
                }
                if (seq1 - seq2 == 0) {
                    return 0;
                }
                return -1;
            }
        });
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null && historicProcessInstance.getId() != null && historicProcessInstance.getId().length() != 0) {
            processInstanceId = historicProcessInstance.getId();
        }
        if ("".equals(processInstanceId) && (processInst = this.processInstService.getProcessInstByOriginalProcInstId(businessId)) != null && processInst.getProcessInsId() != null && processInst.getProcessInsId().length() != 0) {
            processInstanceId = processInst.getProcessInsId();
        }
        if (!"".equals(processInstanceId)) {
            List<ApproveFile> approveFiles = this.flowTaskMapper.approveFileListByProcessInstanceId(processInstanceId);
            ArrayList processAttachmentList = new ArrayList();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (approveFiles != null) {
                for (ApproveFile approveFile : approveFiles) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("fileId", approveFile.getFileId());
                    hashMap.put("fileName", approveFile.getAttachmentName());
                    hashMap.put("createTime", simpleDateFormat.format(approveFile.getCreateTime()));
                    processAttachmentList.add(hashMap);
                }
                processInstanceHistoryTaskVo.setProcessAttachmentList(processAttachmentList);
            }
        } else {
            for (Object taskManagerQueryVo : taskManagerQueryVos) {
                taskManagerQueryVo.setIsPermitForModifyingAssignee("1");
            }
        }
        processInstanceHistoryTaskVo.setProcessInstanceHistoryTaskList(taskManagerQueryVos);
        return ApiResponse.success((Object)processInstanceHistoryTaskVo);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByDepartmentId(String organType, String departmentId) {
        List personnels;
        ArrayList<PersonnelQueryVo> personnelQueryVos = new ArrayList<PersonnelQueryVo>();
        if (departmentId != null && departmentId.length() != 0 && (personnels = this.iAssigneeChooseService.getPersonnelByDepartmentId(organType, departmentId)) != null) {
            for (Personnel personnel : personnels) {
                PersonnelQueryVo personnelQueryVo = new PersonnelQueryVo();
                personnelQueryVo.setUserId(personnel.getUserId());
                personnelQueryVo.setUserName(personnel.getUserName());
                personnelQueryVo.setUnitId(personnel.getUnitId());
                personnelQueryVo.setUnit(this.getUtilNameByDeptId(personnel.getDepartmentId()));
                personnelQueryVo.setDepartmentId(personnel.getDepartmentId());
                personnelQueryVo.setDepartmentName(personnel.getDepartmentName());
                personnelQueryVo.setPostId(personnel.getPostId());
                personnelQueryVo.setPostName(personnel.getPostName());
                personnelQueryVos.add(personnelQueryVo);
            }
        }
        return ApiResponse.success(personnelQueryVos);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByUserName(String userName) {
        List personnels = this.iAssigneeChooseService.getPersonnelByUserName(userName);
        ArrayList<PersonnelQueryVo> personnelQueryVos = new ArrayList<PersonnelQueryVo>();
        if (personnels != null) {
            for (Personnel personnel : personnels) {
                PersonnelQueryVo personnelQueryVo = new PersonnelQueryVo();
                personnelQueryVo.setUserId(personnel.getUserId());
                personnelQueryVo.setUserName(personnel.getUserName());
                personnelQueryVo.setUnit(this.getUtilNameByDeptId(personnel.getDepartmentId()));
                personnelQueryVo.setDepartmentId(personnel.getDepartmentId());
                personnelQueryVo.setDepartmentName(personnel.getDepartmentName());
                personnelQueryVo.setPostId(personnel.getPostId());
                personnelQueryVo.setPostName(personnel.getPostName());
                personnelQueryVos.add(personnelQueryVo);
            }
        }
        return ApiResponse.success(personnelQueryVos);
    }

    public ApiResponse<String> eliminateReminders(String taskId) {
        String message = "";
        taskId = this.getRealTaskId(taskId);
        BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)((Object)this.bpmActHiTaskinstMapper.selectById(Long.valueOf(taskId)));
        bpmActHiTaskinst.setIsEliminateReminders("1");
        message = this.bpmActHiTaskinstMapper.updateById((Object)bpmActHiTaskinst) > 0 ? BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage() : BpmEnum.DEFAULT_FAILURE_MESSAGE.getMessage();
        return ApiResponse.success((String)message);
    }

    public ApiResponse<String> eliminateRemindersByProcessInstanceId(String processInstanceId) {
        String message = "";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BpmActHiTaskinst::getProcInstId, (Object)processInstanceId)).eq(BpmActHiTaskinst::getApprovalType, (Object)"rectification");
        List bpmActHiTaskinsts = this.bpmActHiTaskinstMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (bpmActHiTaskinsts != null && bpmActHiTaskinsts.size() != 0) {
            for (BpmActHiTaskinst bpmActHiTaskinst : bpmActHiTaskinsts) {
                bpmActHiTaskinst.setIsEliminateReminders("1");
                if (this.bpmActHiTaskinstMapper.updateById((Object)bpmActHiTaskinst) > 0) {
                    message = BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage();
                    continue;
                }
                message = BpmEnum.DEFAULT_FAILURE_MESSAGE.getMessage();
            }
        }
        return ApiResponse.success((String)message);
    }

    private String getRealTaskId(String taskId) {
        if (taskId == null) {
            return null;
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return str[0];
        }
        return taskId;
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, String tenantId) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> departmentIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        Map departments = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                userIds.add(String.valueOf(flowTask.getStartUserId()));
                departmentIds.add(flowTask.getDepartmentId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            departments = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setOldBusinessId(flowTask.getOldBusinessId());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTaskSourceFlag((String)taskVariables.get("taskSourceFlag"));
                taskManagerQueryVo.setIsDeleteProcinst(flowTask.getIsDeleteProcinst());
                taskManagerQueryVo.setStartUser((String)finalUsers.get(flowTask.getStartUserId()));
                taskManagerQueryVo.setDepartmentName((String)departments.get(flowTask.getDepartmentId()));
                taskManagerQueryVo.setRectificationFormKey(flowTask.getRectificationFormKey());
                taskManagerQueryVo.setUnit(this.getUtilNameByUserId(flowTask.getStartUserId()));
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : (HussarUtils.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser((String)taskVariables.get("sendUser"));
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(taskVariables.get("sendUser")));
                String message = HussarUtils.isNotEmpty((Object)flowTask.getTodoConfiguration()) ? flowTask.getTodoConfiguration() : (taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString());
                taskManagerQueryVo.setMessage(message);
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }

    String getUtilNameByUserId(String userId) {
        String organId;
        HashMap<String, String> organTree = new HashMap<String, String>();
        HashMap<String, String> organMap = new HashMap<String, String>();
        Map unitMap = new HashMap();
        String childrenId = organId = this.iAssigneeChooseService.getDeptIdByUserIds(userId, null);
        List organs = this.iAssigneeChooseService.getAllOrgans();
        if (organs != null && organs.size() != 0) {
            for (Map organ : organs) {
                organMap.put(String.valueOf(organ.get("ORGAN_ID")), String.valueOf(organ.get("PARENT_ID")));
            }
        }
        if (organMap != null && organMap.size() != 0) {
            organTree.put(userId, organId);
            while (!"11".equals(organMap.get(organId)) && organMap.get(organId) != null) {
                organTree.put(organId, (String)organMap.get(organId));
                childrenId = organId;
                organId = (String)organMap.get(organId);
            }
            ArrayList<String> childrenIds = new ArrayList<String>();
            childrenIds.add(childrenId);
            unitMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(childrenIds);
        }
        return (String)unitMap.get(childrenId);
    }

    String getUtilNameByDeptId(String deptId) {
        String organId;
        HashMap organTree = new HashMap();
        HashMap<String, String> organMap = new HashMap<String, String>();
        Map unitMap = new HashMap();
        String childrenId = organId = deptId;
        List organs = this.iAssigneeChooseService.getAllOrgans();
        if (organs != null && organs.size() != 0) {
            for (Map organ : organs) {
                organMap.put(String.valueOf(organ.get("ORGAN_ID")), String.valueOf(organ.get("PARENT_ID")));
            }
        }
        if (organMap != null && organMap.size() != 0) {
            while (!"11".equals(organMap.get(organId)) && organMap.get(organId) != null) {
                organTree.put(organId, organMap.get(organId));
                childrenId = organId;
                organId = (String)organMap.get(organId);
            }
            ArrayList<String> childrenIds = new ArrayList<String>();
            childrenIds.add(childrenId);
            unitMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(childrenIds);
        }
        return (String)unitMap.get(childrenId);
    }

    static {
        APPROVAL_STATE.put("0", "\u5ba1\u6279\u5b8c\u6210");
        APPROVAL_STATE.put("1", "\u672a\u5ba1\u6279");
        APPROVAL_STATE.put("2", "\u672a\u6d41\u8f6c\u5230");
        APPROVAL_TYPE.put("agree", "\u540c\u610f");
        APPROVAL_TYPE.put("disagree", "\u4e0d\u540c\u610f");
        APPROVAL_TYPE.put("accept", "\u63a5\u53d7");
        APPROVAL_TYPE.put("rectification", "\u8fd4\u56de\u6574\u6539");
        APPROVAL_TYPE.put("suspend", "\u7ec8\u6b62");
        APPROVAL_TYPE.put("reject", "\u8fd4\u56de\u5230\u6307\u5b9a\u4eba");
    }
}

