/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ApprovalExtendPropertiesVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.RejectToAssigneeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteLeapTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.PreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ReceiveTaskAddVariablesCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RejectReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompletePrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskRejectCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UnPreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.updateHisProcessVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.updateHisTaskVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.model.SysActProcessApproveFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.model.SysActProcessApproveFileDerivation;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.service.ISysActProcessApproveFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.cmd.GetExecutionVariablesCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class TaskEngineServiceImpl
implements ITaskEngineService {
    private static Logger logger = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Resource
    private ICandidateUserService candidateUserService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private ISubCandidateService subCandidateService;
    @Autowired
    private BpmActPendingTaskService pendingTaskService;
    @Autowired
    private BpmMsgPushService msgPushService;
    @Autowired
    private SqlConditionHandleService sqlConditionHandleService;
    @Autowired
    private ISysActProcessApproveFileService processApproveFileService;
    protected static List<String> CALL_REJECT_LIST = new ArrayList<String>();
    protected static List<String> SUB_PROCESS_REJECT_LIST = new ArrayList<String>();

    public static List<String> getCallRejectList() {
        return CALL_REJECT_LIST;
    }

    public static List<String> getSubProcessRejectList() {
        return SUB_PROCESS_REJECT_LIST;
    }

    private RealTaskId getRealTaskIdAndMandatary(String taskId) {
        if (taskId == null) {
            return new RealTaskId(null, null);
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return new RealTaskId(str[0], str[1]);
        }
        return new RealTaskId(taskId, null);
    }

    private String getRealTaskId(String taskId) {
        if (taskId == null) {
            return null;
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return str[0];
        }
        return taskId;
    }

    public Task getTask(String taskId, String state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskId(taskId);
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        return task;
    }

    public Task getTaskWithOutCheckSuspended(String taskId, String state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables();
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        return task;
    }

    public ApiResponse<Map<String, Object>> queryTask(String taskId, String tenantId) {
        String message;
        String sendUser;
        if ((taskId = this.getRealTaskId(taskId)) == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getTaskNotFound());
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        Map taskVariables = historicTaskInstance.getTaskLocalVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
        }
        Map finalUsers = new HashMap();
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set<String> users = this.getAssigneeByTaskId(taskId);
            if (HussarUtils.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (!userIds.isEmpty()) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            }
        }
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
        String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
        if (HussarUtils.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("formKey", historicTaskInstance.getFormKey());
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(historicTaskInstance.getTaskDefinitionKey());
        String formDetail = (String)this.iSysActExtendPropertiesService.queryList(ids, historicTaskInstance.getProcessDefinitionId()).get(historicTaskInstance.getTaskDefinitionKey());
        map.put("formDetailKey", formDetail);
        return ApiResponse.success(map);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, Integer page, Integer size, String tag) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        taskManagerDto.setTag(tag);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, String tenantId, Integer page, Integer size, String tag) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        taskManagerDto.setBusinessList(!HussarUtils.isNotEmpty(businessList) ? businessList : null);
        taskManagerDto.setTag(tag);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId, String tag) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey, tag);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows, String tag) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey, tag);
        return this.flowTaskService.todoList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, List<String> businessIds, String tenantId, String tag) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setBusinessIds(businessIds);
        flowTaskQueryModel.setTag(tag);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, null);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, String tag) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey, tag);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows, String tag) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey, tag);
        return this.flowTaskService.doneList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCount(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTask(userId));
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCountByNode(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTaskByNode(userId));
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.claim(taskId, userId);
        this.claimDataPush(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.unclaim(taskId);
        this.claimDataPush(taskId, null);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator, isAuditAuthority));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, map));
        this.completeDataPush(task, "", userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map, String comment, String approvalType) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new CompleteLeapTaskCmd(taskId, mandator, userId, comment, map, true).setApprovalType(approvalType).setIdentityLink(prepareReturn.getIdentityLink()));
        this.completeDataPush(task, comment, userId, prepareReturn.getMandator(), prepareReturn.getTaskState());
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, newMap));
        this.completeDataPush(task, "", userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, comment, newMap));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, comment, newMap));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, comment, map));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String[] subs = subProcesses.split(",");
        JSONArray jsonArray = new JSONArray();
        for (String sub : subs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessId", (Object)"");
            jsonObject.put("processKey", (Object)sub);
            jsonObject.put("userId", (Object)"");
            jsonArray.add((Object)jsonObject);
        }
        newMap.put("call_activity_info", jsonArray);
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, comment, newMap));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator).isAuditAuthority(isAuditAuthority))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, mandator, comment, newMap));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult approvalTask(String taskId, String userId, String assignee, String comment, Map<String, Object> map, String approvalType, List<SysActProcessApproveFile> sysActProcessApproveFileList) {
        BpmResponseResult bpmResponseResult = this.approvalSubCandidateTask(taskId, userId, comment, approvalType, sysActProcessApproveFileList);
        if (bpmResponseResult.isSuccess()) {
            return bpmResponseResult;
        }
        switch (approvalType) {
            case "agree": 
            case "disagree": 
            case "accept": {
                bpmResponseResult = this.completeTask(taskId, userId, map, comment, approvalType);
                break;
            }
            case "reject": {
                bpmResponseResult = this.rejectToAssignee(taskId, userId, assignee, comment, map);
                break;
            }
            case "suspend": 
            case "rectification": {
                bpmResponseResult = this.instanceEngineService.endProcess(taskId, userId, comment, approvalType);
                break;
            }
            default: {
                throw new PublicClientException(this.bpmConstantProperties.getApprovalTypeNotFound());
            }
        }
        if (bpmResponseResult.isSuccess()) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
            SysActProcessApproveFileDerivation sysActProcessApproveFileDerivation = new SysActProcessApproveFileDerivation();
            sysActProcessApproveFileDerivation.setProcessInsId(Long.valueOf(historicTaskInstance.getProcessInstanceId()));
            sysActProcessApproveFileDerivation.setTaskId(Long.valueOf(historicTaskInstance.getId()));
            sysActProcessApproveFileDerivation.setSysActProcessApproveFileList(sysActProcessApproveFileList);
            this.processApproveFileService.saveOrUpdateFile(sysActProcessApproveFileDerivation);
        }
        return bpmResponseResult;
    }

    BpmResponseResult approvalSubCandidateTask(String taskId, String userId, String comment, String approvalType, List<SysActProcessApproveFile> sysActProcessApproveFileList) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        List subCandidateList = this.subCandidateService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SubCandidate::getTaskId, (Object)Long.valueOf(taskId))).eq(SubCandidate::getUserId, (Object)userId)).eq(mandator != null, SubCandidate::getOwner, (Object)mandator));
        if (subCandidateList.isEmpty()) {
            return InstallResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u975e\u5ba1\u6279\u4eba\u4efb\u52a1");
        }
        SubCandidate subCandidate = null;
        if (mandator != null) {
            subCandidate = (SubCandidate)subCandidateList.get(0);
        } else {
            for (SubCandidate candidate : subCandidateList) {
                if (candidate.getOwner() != null) continue;
                subCandidate = candidate;
            }
            if (subCandidate == null) {
                List identityLinks = this.taskService.getIdentityLinksType(taskId);
                for (IdentityLink identityLink : identityLinks) {
                    if (!identityLink.getUserId().equals(userId)) continue;
                    return InstallResult.fail((String)"\u6709\u5bf9\u5e94\u4e3b\u5ba1\u6279\u4eba\u4efb\u52a1");
                }
                subCandidate = (SubCandidate)subCandidateList.get(0);
            }
        }
        SubCandidate approvalSubCandidate = subCandidate;
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            HistoricTaskInstanceEntity historicTaskInstance = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(approvalSubCandidate.getTaskId().toString());
            if (historicTaskInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            HistoricTaskInstanceEntity insertHistoryTask = new HistoricTaskInstanceEntity();
            commandContext.getHistoricProcessInstanceEntityManager().insert((PersistentObject)insertHistoryTask);
            insertHistoryTask.setProcessDefinitionId(historicTaskInstance.getProcessDefinitionId());
            insertHistoryTask.setTaskDefinitionKey(historicTaskInstance.getTaskDefinitionKey());
            insertHistoryTask.setProcessInstanceId(historicTaskInstance.getProcessInstanceId());
            insertHistoryTask.setName(historicTaskInstance.getName());
            insertHistoryTask.setDescription(historicTaskInstance.getDescription());
            insertHistoryTask.setOwner(approvalSubCandidate.getOwner());
            insertHistoryTask.setAssignee(approvalSubCandidate.getUserId());
            insertHistoryTask.setStartTime(historicTaskInstance.getStartTime());
            insertHistoryTask.setEndTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            insertHistoryTask.setDurationInMillis(Long.valueOf(insertHistoryTask.getEndTime().getTime() - insertHistoryTask.getStartTime().getTime()));
            insertHistoryTask.setDeleteReason("completed");
            insertHistoryTask.setPriority(historicTaskInstance.getPriority());
            insertHistoryTask.setDueDate(historicTaskInstance.getDueDate());
            insertHistoryTask.setFormKey(historicTaskInstance.getFormKey());
            insertHistoryTask.setCategory(historicTaskInstance.getCategory());
            insertHistoryTask.setTenantId(historicTaskInstance.getTenantId());
            insertHistoryTask.setTaskState(approvalSubCandidate.getOwner() != null ? "1" : null);
            insertHistoryTask.setSubProcessKey(historicTaskInstance.getSubProcessKey());
            insertHistoryTask.setCycleCount(historicTaskInstance.getCycleCount());
            insertHistoryTask.setApprovalType(approvalType);
            insertHistoryTask.setMainTaskId(approvalSubCandidate.getTaskId());
            insertHistoryTask.setPostId(approvalSubCandidate.getPostId());
            insertHistoryTask.setDeptId(approvalSubCandidate.getDeptId());
            if (HussarUtils.isNotEmpty((Object)comment)) {
                CommentEntity commentEntity = new CommentEntity();
                commentEntity.setUserId(userId);
                commentEntity.setType("complete");
                commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                commentEntity.setTaskId(insertHistoryTask.getId());
                commentEntity.setProcessInstanceId(null);
                commentEntity.setAction("AddComment");
                String eventMessage = comment.replaceAll("\\s+", " ");
                if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                    eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
                }
                commentEntity.setMessage(eventMessage);
                commentEntity.setFullMessage(comment);
                commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
            }
            SysActProcessApproveFileDerivation sysActProcessApproveFileDerivation = new SysActProcessApproveFileDerivation();
            sysActProcessApproveFileDerivation.setProcessInsId(Long.valueOf(insertHistoryTask.getProcessInstanceId()));
            sysActProcessApproveFileDerivation.setTaskId(Long.valueOf(insertHistoryTask.getId()));
            sysActProcessApproveFileDerivation.setSysActProcessApproveFileList(sysActProcessApproveFileList);
            this.processApproveFileService.saveOrUpdateFile(sysActProcessApproveFileDerivation);
            return null;
        });
        this.subCandidateService.removeById((Object)approvalSubCandidate);
        return InstallResult.success();
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String comment = "";
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        Map variable = task.getTaskLocalVariables();
        if (variable.get("reject_from") != null) {
            HistoricTaskInstance historicTaskInstance;
            List comments;
            String rejectTask = ((String)variable.get("reject_from")).split(",")[0];
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(rejectTask)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (HussarUtils.isNotEmpty((Object)historicTaskInstanceList) && HussarUtils.isNotEmpty((Object)(comments = this.taskService.getTaskComments((historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceList.get(0)).getId(), "complete")))) {
                comment = ((Comment)comments.get(0)).getFullMessage();
            }
        }
        json.add((Object)comment);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, null, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, users, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new CompleteLeapTaskCmd(taskId, mandator, userId, comment, newMap, isSubmit));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private String recentSharedGateway(List<String> nodes, String procDefId) {
        Collections.sort(nodes);
        String node = nodes.get(0);
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        FlowElement flowElement = process.getFlowElement(node);
        while (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) {
            SequenceFlow sequenceFlow = (SequenceFlow)((FlowNode)flowElement).getIncomingFlows().get(0);
            if (!((flowElement = process.getFlowElement(sequenceFlow.getSourceRef())) instanceof StartEvent)) continue;
            throw new PublicClientException("\u672a\u627e\u5230\u76ee\u6807\u8282\u70b9\u7684\u516c\u5171\u7f51\u5173");
        }
        return flowElement.getId();
    }

    private void setCompleteLeapAppointAssignee(Map<String, Object> map, String rejectNodes, String processInstanceId) {
        HashMap<String, String> appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((appointAssignee = (HashMap<String, String>)map.get("appoint_assignee")) == null) {
            appointAssignee = new HashMap<String, String>();
        }
        String targetNodeId = rejectNodes.split(",")[0];
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"reject")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
        if (historicTaskInstanceList.size() == 1) {
            String oldAppointAssignee;
            Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
            if (oldAppointMessage instanceof HashMap) {
                Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                oldAppointAssignee = (String)oldAppointAssigneeMap.get(targetNodeId);
            } else {
                oldAppointAssignee = (String)oldAppointMessage;
            }
            if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                appointAssignee.put(targetNodeId, oldAppointAssignee);
            }
        }
        map.put("appoint_assignee", appointAssignee);
    }

    private boolean multiCondition(Task task) {
        Map multiVariables = (Map)this.processEngine.getManagementService().executeCommand((Command)new GetExecutionVariablesCmd(task.getExecutionId(), null, false));
        int nrOfCompletedInstances = (Integer)multiVariables.get("nrOfCompletedInstances") + 1;
        int nrOfInstances = (Integer)multiVariables.get("nrOfInstances");
        if (nrOfInstances != 0 && nrOfInstances > nrOfCompletedInstances) {
            String multiType = (String)multiVariables.get("multi_type");
            String multiFinishCondition = multiVariables.get("multi_finish_condition").toString();
            if (HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiFinishCondition)) {
                if ("0".equals(multiType) ? (double)nrOfCompletedInstances / (double)nrOfInstances >= Double.parseDouble(multiFinishCondition) / 100.0 : "1".equals(multiType) && nrOfCompletedInstances == Integer.parseInt(multiFinishCondition)) {
                    return true;
                }
            } else {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("nrOfCompletedInstances", nrOfCompletedInstances);
                contextMap.put("nrOfInstances", nrOfInstances);
                boolean condition = false;
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                String k = ((Activity)bm.getFlowElement(task.getTaskDefinitionKey())).getLoopCharacteristics().getCompletionCondition();
                ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                SimpleContext context = TaskEngineServiceImpl.getVariables(contextMap);
                ValueExpression e = factory.createValueExpression((ELContext)context, k, Boolean.TYPE);
                if (((Boolean)e.getValue((ELContext)context)).booleanValue()) {
                    condition = true;
                }
                if (condition) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void complete(Task task, Map<String, Object> map, String userId, String mandator) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("sendUser", userId);
        if (map != null) {
            newMap.putAll(map);
        }
        newMap.put("bpm_submit_source", task.getTaskDefinitionKey());
        Map<String, Object> appointAssignee = new HashMap();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        HashMap<String, String> executionVariableMap = new HashMap<String, String>();
        executionVariableMap.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
        this.runtimeService.setVariablesLocal(task.getExecutionId(), executionVariableMap);
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, newMap);
        } else {
            this.taskService.resolveTask(taskId, newMap);
            this.taskService.complete(taskId, newMap);
        }
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    private FlowNode getGateway(FlowNode node, Process process) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)process.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway) {
                return flowNode;
            }
            if ((flowNode = this.getGateway(flowNode, process)) == null) continue;
            return flowNode;
        }
        return null;
    }

    private void getAllFlowNodeFromPerGateWay(FlowNode node, Process process, Set<String> nodeIdSet) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)process.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof StartEvent) continue;
            nodeIdSet.add(flowNode.getId());
            this.getAllFlowNodeFromPerGateWay(flowNode, process, nodeIdSet);
        }
    }

    private String checkRejectActivityId(Task task, String backActivityId, String rejectActivityId) {
        if (HussarUtils.isEmpty((Object)backActivityId)) {
            throw new PublicClientException(this.bpmConstantProperties.getForbidReject());
        }
        if (!backActivityId.contains(",")) {
            return backActivityId;
        }
        HashSet<String> backActivityIdSet = new HashSet<String>(Arrays.asList(backActivityId.split(",")));
        if (backActivityIdSet.size() == 1) {
            return (String)backActivityIdSet.iterator().next();
        }
        if (rejectActivityId == null || rejectActivityId.equals("")) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (this.canRejectToAnyNode(task.getProcessDefinitionId(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        Process process = bm.getMainProcess();
        FlowNode flowNode = (FlowNode)process.getFlowElement(rejectActivityId);
        if ((flowNode = this.getGateway(flowNode, process)) == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotRejectToLastNode());
        }
        HashSet<String> nodeIdSet = new HashSet<String>();
        this.getAllFlowNodeFromPerGateWay(flowNode, process, nodeIdSet);
        backActivityIdSet.retainAll(nodeIdSet);
        if (this.canRejectToAnyNode(task.getProcessDefinitionId(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        throw new PublicClientException(this.bpmConstantProperties.getNotRejectToLastNode());
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map, String rejectActivityId, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, "reject", null, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getTargetIds(), mandator == null ? userId : mandator, task.getTaskDefinitionKey(), "reject", task.getName()));
        boolean needReject = false;
        String rejectTaskId = "";
        if (HussarUtils.isNotEmpty((Object)json)) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject object = json.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(taskRejectModel.getTargetIds()) || !HussarUtils.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(task.getProcessInstanceId())) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(rejectTaskId, userId, comment, assignees, isSubmit, taskRejectModel.getMap(), rejectActivityId, true);
        }
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        boolean isSubProcessFirst = false;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, "reject", null, Boolean.valueOf(true), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setCanRejectToMainProcess(true);
        if (isSubProcessFirst) {
            taskRejectModel.setSubProcessFirst(true);
            taskRejectModel.setFirst(false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), true, taskRejectModel.getStartUserId(), taskRejectModel.getFirstNodeId(), mandator == null ? userId : mandator, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, "reject", backActivityId, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(true);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), backActivityId, mandator == null ? userId : mandator, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority, String approvalType) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, "reject", backActivityId, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(true);
        taskRejectModel.setApprovalType(approvalType);
        taskRejectModel.setIdentityLink(prepareReturn.getIdentityLink());
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), backActivityId, mandator == null ? userId : mandator, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToAssignee(String taskId, String userId, String backUserId, String comment, Map<String, Object> map) {
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull());
        }
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(realTaskId.getTaskId())).singleResult();
        if (HussarUtils.isEmpty((Object)task)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        List<HistoricTaskInstance> historicTaskInstances = this.getRejectTask((TaskInfo)task);
        Optional<String> targetTask = historicTaskInstances.stream().filter(o -> backUserId.equals(o.getOriginalAssignee())).map(TaskInfo::getTaskDefinitionKey).findFirst();
        if (!targetTask.isPresent()) {
            throw new PublicClientException(this.bpmConstantProperties.getRejectTaskNotFound());
        }
        String backActivityId = targetTask.get();
        return this.rejectToAnyTask(taskId, userId, backActivityId, comment, backUserId, null, true, map, true, "reject");
    }

    public BpmResponseResult getRejectAssignee(String taskId) {
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull());
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)task)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        List<HistoricTaskInstance> historicTaskInstances = this.getRejectTask((TaskInfo)task);
        List assignees = historicTaskInstances.stream().collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (c1, c2) -> c1.getEndTime().compareTo(c2.getEndTime()) > 0 ? c1 : c2)).values().stream().map(HistoricTaskInstance::getOriginalAssignee).distinct().collect(Collectors.toList());
        Map assigneeMap = this.iAssigneeChooseService.getUserListByUserId(assignees, "");
        JSONArray json = new JSONArray();
        for (String assignee : assignees) {
            RejectToAssigneeVo rejectToAssignee = new RejectToAssigneeVo();
            rejectToAssignee.setAssignee(assignee);
            rejectToAssignee.setAssigneeName((String)assigneeMap.get(assignee));
            json.add((Object)rejectToAssignee);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private List<HistoricTaskInstance> getRejectTask(TaskInfo task) {
        Date createTime = task.getCreateTime();
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        for (int i = historicTaskInstances.size() - 1; i >= 0; --i) {
            if (!((HistoricTaskInstance)historicTaskInstances.get(i)).getTaskDefinitionKey().equals(task.getTaskDefinitionKey())) continue;
            createTime = ((HistoricTaskInstance)historicTaskInstances.get(i)).getCreateTime();
            break;
        }
        Date limitTime = createTime;
        historicTaskInstances.removeIf(historicTaskInstance -> historicTaskInstance.getMainTaskId() != null || historicTaskInstance.getCreateTime().compareTo(limitTime) >= 0);
        return historicTaskInstances;
    }

    public boolean canRejectToAnyNode(String procDefId, String taskDefinitionKey, String targetNodeIds) {
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        FlowNode userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(taskDefinitionKey);
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        for (List list : lists) {
            boolean listContain = false;
            for (String targetNode : targetNodes) {
                if (!list.contains(targetNode)) continue;
                if (listContain) {
                    return false;
                }
                listContain = true;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canRejectToAnyNodePlus(String procDefId, String targetNodeIds) {
        void var8_11;
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        ArrayList<ArrayList<List<String>>> targetNodePathList = new ArrayList<ArrayList<List<String>>>();
        for (String string : targetNodes) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(string);
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            FlowNode userTask = (FlowNode)process.getFlowElement(string);
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
            targetNodePathList.add(lists);
        }
        ArrayList<String> canRejectNodeIds = new ArrayList<String>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) continue;
            canRejectNodeIds.add(flowElement.getId());
        }
        boolean bl = false;
        while (var8_11 < targetNodePathList.size()) {
            for (void j = var8_11 + true; j < targetNodePathList.size(); ++j) {
                List nodePathList1 = (List)targetNodePathList.get((int)var8_11);
                List nodePathList2 = (List)targetNodePathList.get((int)j);
                for (List path1 : nodePathList1) {
                    block5: for (List path2 : nodePathList2) {
                        for (String node : path1) {
                            if (!path2.contains(node)) continue;
                            if (canRejectNodeIds.contains(node)) continue block5;
                            return false;
                        }
                    }
                }
            }
            ++var8_11;
        }
        return true;
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }

    public BpmResponseResult queryRejectNode(String taskId) {
        Task task = this.getTaskWithOutCheckSuspended(taskId = this.getRealTaskId(taskId), "1");
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            Process process = bm.getMainProcess();
            FlowNode userTask = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (HussarUtils.isNotEmpty((Object)processInstance.getSuperProcessInstanceId()) && !(hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list()).isEmpty()) {
                bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                String taskDefinitionKey = "";
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    taskDefinitionKey = historicActivityInstance.getActivityId();
                }
                hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                hisTaskDefinitionKey.remove(taskDefinitionKey);
                process = bm.getMainProcess();
                userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
                ids = new HashSet();
                ids.add(taskDefinitionKey);
                lists = new ArrayList();
                if (userTask == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, true);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? "main_process_" : "";
        String namePreFix = isRejectMain ? "\u4e3b\u6d41\u7a0b" : "";
        for (String id : finalList) {
            FlowElement flowElement = process.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private String getTaskCommitUser(String processInsId, String backActivityId) {
        List hisTaskList;
        HashSet<String> assignees = new HashSet<String>();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && !hisTaskList.isEmpty()) {
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                assignees.add(historicTaskInstance.getOriginalAssignee());
                for (int j = i + 1; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    assignees.add(historicTaskInstance.getOriginalAssignee());
                }
                break;
            }
        }
        return String.join((CharSequence)",", assignees);
    }

    private String getLastActivityId(Task task) {
        Map map;
        Map map2 = map = task.getTaskLocalVariables() == null ? new HashMap() : task.getTaskLocalVariables();
        if (map.get("call_complete_from") != null) {
            return "main_process_" + map.get("call_complete_from");
        }
        if (map.get("all_prev_node") != null) {
            return map.get("all_prev_node").toString().replace("'", "");
        }
        return "";
    }

    private String getFirstActivityId(String processInsId, String taskDefinitionKey) {
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).listPage(0, 1);
        if (list != null && !list.isEmpty()) {
            return ((HistoricTaskInstance)list.get(0)).getTaskDefinitionKey();
        }
        return taskDefinitionKey;
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.delegateTask(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        if (HussarUtils.isEmpty((Object)userId) || HussarUtils.isEmpty((Object)mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        if (!this.auditAuthority(userId, taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityTransferTask(), null);
        }
        if (userId.equals(mandatary)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        if (!this.auditAuthority(mandatary, taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, mandatary, false, false));
            this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, userId, 0);
            SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
            sysActUrgeTask.setReceiveUser(mandatary);
            this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        } else {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, null, false, true));
            this.activityRedisTimerService.updateTimeOutModel(taskId, null, userId, 0);
            this.sysActUrgeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary, int state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId))) || HussarUtils.isEmpty((Object)mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if (state != 0 && mandatary.contains(",") && this.isMulti(task) == 2) {
            return InstallResult.getResult((String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), (String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", mandatary, state == 0, false));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            String[] receiveUsers = mandatary.split(",");
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : receiveUsers) {
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(urgeTask.getTaskId());
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            if (state == 1) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, mandatary);
        }
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, null, state);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, Map<String, String> assigneeMap, boolean isSubmit, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        boolean canRejectToMainProcess = false;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, "freejump", activitiId, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        this.freeJumpDataPush(taskRejectModel.getTask(), comment, userId, taskRejectModel.getAllAffectedTaskIds(), mandator, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(mandator == null ? userId : mandator, taskRejectModel.getProcInsId(), taskRejectModel.getTask().getTaskDefinitionKey(), taskRejectModel.getMap()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        taskId = this.getRealTaskId(taskId);
        if (assigneeList == null || assigneeList.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
        variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
        Map newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType, variableMap));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : assigneeList) {
                String newTaskId = (String)newTaskIdMap.get(receiveUser);
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, String.join((CharSequence)",", assigneeList));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String assignees) {
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty((Object)assignees)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            this.entrustTask(taskId, assignees, 0);
        } else {
            List list;
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(assignees.split(",")));
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!HussarUtils.isNotEmpty((Object)runningTask.getAssignee())) continue;
                users.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            Map newTaskIdMap = null;
            if (HussarUtils.isNotEmpty(users)) {
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
                variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
                newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), users, dueTime, outTimeType, variableMap));
            }
            if ((list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId))) != null && !list.isEmpty()) {
                String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
                HashSet<String> set = new HashSet<String>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    set.add(((SysActUrgeTask)list.get(i)).getReceiveUser());
                    if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                    list.remove(i);
                }
                String[] receiveUsers = assignees.split(",");
                ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
                for (String receiveUser : receiveUsers) {
                    String newTaskId;
                    if (set.contains(receiveUser) || (newTaskId = (String)newTaskIdMap.get(receiveUser)) == null) continue;
                    for (SysActUrgeTask urgeTask : list) {
                        SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                        saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                        saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                        saveUrgeTask.setProcName(urgeTask.getProcName());
                        saveUrgeTask.setTaskName(urgeTask.getTaskName());
                        saveUrgeTask.setSendUser(urgeTask.getSendUser());
                        saveUrgeTask.setReceiveUser(receiveUser);
                        saveUrgeTask.setSendTime(urgeTask.getSendTime());
                        saveUrgeTask.setFormKey(urgeTask.getFormKey());
                        saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                        saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                        saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                        saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                        saveList.add(saveUrgeTask);
                    }
                }
                this.sysActUrgeTaskService.saveBatch(saveList);
                this.addUrgeTask(task, assignees);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty((Object)users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
        } else {
            if (businessId == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (tasks.isEmpty()) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAppointAssigneesSuccess(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Object level;
        String appointAssignees;
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
        if (publicAppointAssignee != null && HussarUtils.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
            HashSet<String> users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            JSONArray jsonArray = new JSONArray();
            if (!users.isEmpty()) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (HussarUtils.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
            map.put("security_level", level);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, task, map);
        Set<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, tenantId, map, task);
        if (!users.isEmpty()) {
            jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = process.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            Set<Object> users = new HashSet();
            try {
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, map);
                users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, tenantId, map, null);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            if (!users.isEmpty()) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public List<BpmTreeModel> queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        List<String> users = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null, nodeAssigneeQueryDto.getUserId());
        if (HussarUtils.isNotEmpty(users)) {
            return this.iAssigneeChooseService.queryAssigneeAndDept(users, nodeAssigneeQueryDto.getOrganName(), null);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> page, NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        List<String> users = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null, nodeAssigneeQueryDto.getUserId());
        if (HussarUtils.isNotEmpty(users)) {
            return this.iAssigneeChooseService.queryNodeAssigneeListByPage(page, users, nodeAssigneeQueryDto, null);
        }
        return page.setRecords(new ArrayList());
    }

    public BpmResponseResult getTaskVariable(String taskId) {
        List<Variables> variableList = this.taskEngineMapper.getTaskVariables(taskId);
        Map<Object, Object> map = new HashMap();
        if (!HussarUtils.isNotEmpty(variableList)) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        map = this.traverseVariables(variableList);
        map.put("taskId", taskId);
        ArrayList<Map<Object, Object>> taskVarList = new ArrayList<Map<Object, Object>>();
        taskVarList.add(map);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(taskVarList);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getProcessVariable(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        Map<Object, Object> map = new HashMap();
        ArrayList varList = new ArrayList();
        JSONArray jsonArray = new JSONArray();
        List<Variables> variableList = this.taskEngineMapper.getProcessVariables(processInsId);
        map = this.traverseVariables(variableList);
        varList.add(map);
        jsonArray.addAll(varList);
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByTaskCreateTime()).asc()).list();
        for (HistoricTaskInstance historicTaskInstance : taskList) {
            BpmResponseResult result = this.getTaskVariable(historicTaskInstance.getId());
            Object obj = result.getResult().get(0);
            jsonArray.add(obj);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public Map<String, Object> traverseVariables(List<Variables> variableList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Variables variables : variableList) {
            if (map.containsKey(variables.getName())) continue;
            if ("string".equals(variables.getVariableType()) || "json".equals(variables.getVariableType()) || "uuid".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getTextValue());
                continue;
            }
            if ("integer".equals(variables.getVariableType()) || "boolean".equals(variables.getVariableType()) || "date".equals(variables.getVariableType()) || "long".equals(variables.getVariableType()) || "short".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getLongValue());
                continue;
            }
            if ("double".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getDoubleValue());
                continue;
            }
            if ("serializable".equals(variables.getVariableType()) || "bytes".equals(variables.getVariableType())) {
                byte[] bytes = variables.getBytes();
                Object obj = null;
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(bis);
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new PublicClientException(this.bpmConstantProperties.getErrorFormatTransfer());
                }
                finally {
                    try {
                        bis.close();
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                String str = "[" + jsonString + "]";
                JSONArray objects = JSONArray.parseArray((String)str);
                map.put(variables.getName(), objects);
                continue;
            }
            map.put(variables.getName(), "");
        }
        return map;
    }

    public BpmResponseResult updateTaskVariable(String taskId, List<Map<String, Object>> variableList) {
        try {
            if (HussarUtils.isNotEmpty(variableList)) {
                for (Map<String, Object> map : variableList) {
                    Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                    if (task != null) {
                        this.taskService.setVariables(taskId, map);
                        continue;
                    }
                    this.processEngine.getManagementService().executeCommand((Command)new updateHisTaskVariableCmd(taskId, map));
                }
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessUpdate(), null);
            }
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    public BpmResponseResult updateProcessVariable(String processInsId, String businessKey, List<Map<String, Object>> variableList) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            for (Map<String, Object> variableMap : variableList) {
                List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
                if (executionList.size() > 0) {
                    this.runtimeService.setVariables(processInsId, variableMap);
                    continue;
                }
                this.processEngine.getManagementService().executeCommand((Command)new updateHisProcessVariableCmd(processInsId, variableMap));
            }
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    public BpmResponseResult getCommentByTaskId(List<String> taskIds) {
        try {
            JSONArray jsonArray = new JSONArray();
            List<Long> longTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<Map<String, String>> taskComments = this.taskEngineMapper.getTaskComments(longTaskIds);
            jsonArray.addAll(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getSelectFailed());
        }
    }

    public BpmResponseResult getComments(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            List taskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
            JSONArray jsonArray = new JSONArray();
            List<Map<String, String>> processComments = this.taskEngineMapper.getProcessComments(processInsId);
            jsonArray.add(processComments);
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (HistoricTaskInstance taskInstance : taskInstanceList) {
                taskIds.add(Long.parseLong(taskInstance.getId()));
            }
            List<Map<String, String>> taskComments = this.taskEngineMapper.getTaskComments(taskIds);
            jsonArray.add(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getSelectFailed());
        }
    }

    public BpmResponseResult deleteComment(String taskId) {
        try {
            this.taskEngineMapper.deleteComment(taskId);
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getDeleteFail());
        }
    }

    public String getProcessInsId(String businessKey) {
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    private List<String> queryNodeAssignee(String processKey, String taskId, String nodeId, String tenantId, String userId) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            BpmnModel bm;
            Object level;
            String appointAssignees;
            Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", task.getTaskDefinitionKey());
            Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
            if (publicAppointAssignee != null && HussarUtils.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
                return new ArrayList<String>(new HashSet<String>(Arrays.asList(appointAssignees.split(","))));
            }
            if (HussarUtils.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
                map.put("security_level", level);
            }
            if ((bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())) == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, task, map);
            Set<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, tenantId, map, task);
            return new ArrayList<String>(users);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = process.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", taskDefinitionKey);
            map.put("userId", userId);
            AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, map);
            Set<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, tenantId, map, null);
            return new ArrayList<String>(users);
        }
        throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
    }

    public BpmResponseResult queryAllAssignee(String procDefinitionKey, String taskDefinitionKey) {
        JSONObject jsonObject;
        String tenantId = "";
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(procDefinitionKey).getId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        HashSet<String> userIds = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, variableMap);
                Set<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, variableMap, null);
                userIds.addAll(users);
                jsonObject.put("assignee", users);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
                isContain = true;
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)flowElement.getId());
                jsonObject2.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, variableMap);
                Set<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, variableMap, null);
                userIds.addAll(users);
                jsonObject2.put("assignee", users);
                jsonArray.add((Object)jsonObject2);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        Map userMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIds), tenantId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            JSONArray users = jsonObject.getJSONArray("assignee");
            ArrayList user = new ArrayList();
            for (int j = 0; j < users.size(); ++j) {
                String userId = users.getString(j);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", userId);
                map.put("userName", (String)userMap.get(userId));
                user.add(map);
            }
            jsonObject.put("assignee", user);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public ApiResponse<Map<String, Object>> queryHistoryActByTaskId(String taskId, String processInsId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInsId;
        if (newProcessInstanceId == null) {
            Task task = this.getTask(taskId, "0");
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && !list.isEmpty()) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                    json.add((Object)object);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", list != null ? list.size() : 0);
            result.put("data", (Integer)json);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<JSONObject> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONObject object = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (definitionModel != null) {
                object.put("processDefinitionId", (Object)definitionModel.getId());
            }
        } else {
            Task task = this.getTask(taskId, "0");
            object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult queryTaskIdByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInsId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private BpmResponseResult queryNextNode(String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        Map variables;
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, isGetRevokeNode ? "1" : "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        if (isGetRevokeNode && HussarUtils.isNotEmpty((Object)(variables = task.getTaskLocalVariables())) && HussarUtils.isNotEmpty(variables.get("reject_from"))) {
            String nodeId = String.valueOf(variables.get("reject_from"));
            for (String id : nodeId.split(",")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                FlowElement flowElement = process.getFlowElement(id);
                if (flowElement instanceof UserTask) {
                    jsonObject.put("type", (Object)"userTask");
                    jsonObject.put("allowSetParticipant", (Object)"true");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                }
                jsonObject.put("mustCheck", (Object)true);
                jsonObject.put("relatedNodes", new ArrayList());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonArray.add((Object)jsonObject);
            }
            if (isGetWithGroup) {
                JSONArray group = new JSONArray();
                group.add((Object)jsonArray);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)group);
                jsonObject.put("mustCheckGroups", new ArrayList());
                JSONArray result = new JSONArray();
                result.add((Object)jsonObject);
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)result);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        if (lineCondition != null) {
            resultMap.putAll(lineCondition);
        }
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution("", task, resultMap);
        this.getUserTaskByCondition(jsonArray, process, sequenceFlows, 0, userTask.getId(), HussarUtils.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
        if (isGetWithGroup) {
            JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
            JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)result);
            jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
        } else {
            JSONArray result = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                result.add((Object)jsonArray.getJSONObject(i));
            }
            jsonArray = result;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private JSONArray getNextNodeGroupMessage(String firstNode, Map<String, SimpleGroupMessage> simpleGroupMessages) {
        ArrayList<SimpleGroupMessage> simpleGroupMessageList = new ArrayList<SimpleGroupMessage>();
        SimpleGroupMessage simpleGroupMessage = simpleGroupMessages.get(firstNode);
        simpleGroupMessageList.add(simpleGroupMessage);
        int i = 0;
        while (i < simpleGroupMessageList.size()) {
            SimpleGroupMessage groupMessage = (SimpleGroupMessage)simpleGroupMessageList.get(i);
            if (!groupMessage.childGroupIds.isEmpty()) {
                simpleGroupMessageList.remove(i);
                List<String> childIds = groupMessage.childGroupIds.get(0);
                groupMessage.childGroupIds.remove(0);
                for (String childId : childIds) {
                    SimpleGroupMessage child = simpleGroupMessages.get(childId);
                    SimpleGroupMessage simpleGroupMessage1 = new SimpleGroupMessage();
                    simpleGroupMessage1.groupId = groupMessage.groupId;
                    simpleGroupMessage1.childGroupIds = new ArrayList<List<String>>(groupMessage.childGroupIds);
                    simpleGroupMessage1.childGroupIds.addAll(child.childGroupIds);
                    simpleGroupMessage1.jsonObjects = new ArrayList<JSONObject>(groupMessage.jsonObjects);
                    simpleGroupMessage1.jsonObjects.addAll(child.jsonObjects);
                    simpleGroupMessageList.add(simpleGroupMessage1);
                }
                continue;
            }
            ++i;
        }
        JSONArray result = new JSONArray();
        for (SimpleGroupMessage groupMessage : simpleGroupMessageList) {
            List jsonObjects = groupMessage.jsonObjects.stream().filter(o -> !o.getString("type").contains("Gateway")).collect(Collectors.toList());
            result.add(jsonObjects);
        }
        return result;
    }

    private JSONArray getNodeRelationMessages(Map<String, NodeMessage> nodeMessages, JSONArray jsonArray) {
        if (nodeMessages.size() == 1) {
            jsonArray.getJSONObject(0).put("mustCheck", (Object)true);
            jsonArray.getJSONObject(0).put("relatedNodes", new ArrayList());
            return new JSONArray();
        }
        HashMap<String, JSONArray> mustCheckGroupMap = new HashMap<String, JSONArray>();
        JSONArray mustCheckGroups = new JSONArray();
        ArrayList<String> removeGroupIds = new ArrayList<String>();
        for (NodeMessage nodeMessage : nodeMessages.values()) {
            if (!"inclusiveGateway".equals(nodeMessage.getewayType)) continue;
            boolean isMustCheckGroup = true;
            for (String string : nodeMessage.childNodes) {
                if (nodeMessages.get((Object)string).conditionWithNextNode) continue;
                isMustCheckGroup = false;
            }
            if (isMustCheckGroup) {
                NodeMessage parent = nodeMessages.get(nodeMessage.parentNode);
                while (parent != null) {
                    if ("inclusiveGateway".equals(parent.getewayType)) {
                        for (String childNode : parent.childNodes) {
                            if (nodeMessages.get((Object)childNode).conditionWithNextNode) continue;
                            isMustCheckGroup = false;
                            break;
                        }
                        if (!isMustCheckGroup) break;
                    }
                    parent = nodeMessages.get(parent.parentNode);
                }
            }
            JSONArray mustCheckGroup = new JSONArray();
            if (!isMustCheckGroup) continue;
            ArrayList<String> arrayList = new ArrayList<String>(nodeMessage.childNodes);
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeMessage node = nodeMessages.get(arrayList.get(i));
                if (node.getewayType != null) {
                    removeGroupIds.add(node.nodeId);
                    arrayList.addAll(node.childNodes);
                    continue;
                }
                mustCheckGroup.add((Object)node.nodeId);
            }
            mustCheckGroupMap.put(nodeMessage.nodeId, mustCheckGroup);
        }
        for (Map.Entry entry : mustCheckGroupMap.entrySet()) {
            if (removeGroupIds.contains(entry.getKey())) continue;
            mustCheckGroups.add(entry.getValue());
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            NodeMessage parentNode;
            JSONObject jSONObject = jsonArray.getJSONObject(i);
            if (jSONObject.getString("type").contains("Gateway")) continue;
            String nodeId = jSONObject.getString("id");
            NodeMessage nodeMessage = nodeMessages.get(nodeId);
            boolean bl = true;
            ArrayList<String> relatedNodes = new ArrayList<String>();
            NodeMessage parent = parentNode = nodeMessages.get(nodeMessage.parentNode);
            NodeMessage child = nodeMessage;
            while (parent != null) {
                if ("inclusiveGateway".equals(parent.getewayType) && child.conditionWithNextNode) {
                    bl = false;
                    break;
                }
                child = parent;
                parent = nodeMessages.get(parent.parentNode);
            }
            ArrayList<String> relateGroupIds = new ArrayList<String>();
            String currentNodeId = nodeId;
            while (parentNode != null) {
                NodeMessage childNode;
                if ("inclusiveGateway".equals(parentNode.getewayType)) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                } else if (parentNode.getewayType != null) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                }
                currentNodeId = parentNode.nodeId;
                parentNode = nodeMessages.get(parentNode.parentNode);
            }
            jSONObject.put("mustCheck", (Object)bl);
            jSONObject.put("relatedNodes", relatedNodes);
            JSONArray relateGroups = new JSONArray();
            for (String relateGroupId : relateGroupIds) {
                relateGroups.add(mustCheckGroupMap.get(relateGroupId));
            }
            jSONObject.put("relateGroups", (Object)relateGroups);
        }
        return mustCheckGroups;
    }

    private void setNodeMessage(List<String> relatedNodes, NodeMessage parentNode, Map<String, NodeMessage> nodeMessages, List<String> relateGroupIds) {
        if ("inclusiveGateway".equals(parentNode.getewayType)) {
            boolean containsRelateNode = false;
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                containsRelateNode = true;
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
            if (!containsRelateNode) {
                relateGroupIds.add(parentNode.nodeId);
            }
        } else {
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
        }
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            return this.queryNextNode(taskId, isGetRevokeNode, isGetWithGroup, lineCondition);
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String procDefId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(process.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)process.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), "", procDefId);
                }
                if (lineCondition != null) {
                    resultMap.putAll(lineCondition);
                }
                HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
                HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, resultMap);
                this.getUserTaskByCondition(jsonArray, process, sequenceFlows, 0, userTask.getId(), HussarUtils.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
                if (isGetWithGroup) {
                    JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
                    JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("data", (Object)result);
                    jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)jsonObject);
                    continue;
                }
                JSONArray result = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                    result.add((Object)jsonArray.getJSONObject(i));
                }
                jsonArray = result;
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    private void getUserTaskByCondition(JSONArray jsonArray, Process process, List<SequenceFlow> sfs, int sourceType, String superParentId, Map<String, Object> visitorMap, Map<String, NodeMessage> nodeMessages, Map<String, SimpleGroupMessage> simpleGroupMessages, SimpleGroupMessage oldSimpleGroupMessage) {
        if (sfs != null && !sfs.isEmpty()) {
            String parentId = sfs.get(0).getSourceRef();
            if (superParentId.equals(parentId)) {
                parentId = "";
            }
            for (SequenceFlow sequenceFlow : sfs) {
                boolean required = true;
                if (sfs.size() > 1) {
                    if (sourceType == 1) {
                        required = false;
                    } else if (sourceType == 2 && sequenceFlow.getConditionExpression() != null && sequenceFlow.getConditionExpression().contains("bpm_next_node")) {
                        required = false;
                    }
                }
                FlowElement flowElement = process.getFlowElement(sequenceFlow.getTargetRef());
                SimpleGroupMessage simpleGroupMessage = oldSimpleGroupMessage;
                if (simpleGroupMessage == null) {
                    simpleGroupMessage = new SimpleGroupMessage();
                    simpleGroupMessage.jsonObjects = new ArrayList<JSONObject>();
                    simpleGroupMessage.childGroupIds = new ArrayList<List<String>>();
                    simpleGroupMessage.groupId = flowElement.getId();
                    simpleGroupMessages.put(simpleGroupMessage.groupId, simpleGroupMessage);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonObject.put("parentId", (Object)parentId);
                NodeMessage nodeMessage = new NodeMessage(sequenceFlow.getTargetRef(), sequenceFlow.getSourceRef(), !required, null, null);
                if (flowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)flowElement;
                    if (gateway instanceof ParallelGateway) {
                        this.getUserTaskByCondition(jsonArray, process, gateway.getOutgoingFlows(), 3, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        jsonObject.put("type", (Object)"parallelGateway");
                        nodeMessage.getewayType = "parallelGateway";
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : gateway.getOutgoingFlows()) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                    } else {
                        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                        SimpleContext context = new SimpleContext();
                        if (visitorMap != null && !visitorMap.isEmpty()) {
                            SequenceFlow flow;
                            flow = visitorMap.keySet().iterator();
                            while (flow.hasNext()) {
                                String k = flow.next();
                                if (visitorMap.get(k.toString()) != null) {
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                    continue;
                                }
                                context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                            }
                        }
                        ArrayList<SequenceFlow> defaultList = new ArrayList<SequenceFlow>();
                        ArrayList<SequenceFlow> allList = new ArrayList<SequenceFlow>();
                        boolean flag = true;
                        List sequenceFlowsList = gateway.getOutgoingFlows();
                        for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                            if (sequenceFlows.getConditionExpression() != null) {
                                String condition = sequenceFlows.getConditionExpression();
                                boolean isConditionWithNextNode = condition.contains("bpm_next_node");
                                if (isConditionWithNextNode) {
                                    Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(condition);
                                    String bpmNextNodeCondition = "";
                                    if (matcher.find()) {
                                        bpmNextNodeCondition = matcher.group();
                                    }
                                    String bpmNextNodeConditionValue = "";
                                    if (bpmNextNodeCondition.contains("==")) {
                                        bpmNextNodeConditionValue = bpmNextNodeCondition.split("'")[1];
                                    }
                                    context.setVariable("bpm_next_node", factory.createValueExpression((Object)bpmNextNodeConditionValue, Object.class));
                                }
                                condition = this.sqlConditionHandleService.getSqlRealCondition(condition, visitorMap);
                                ValueExpression valueExpression = factory.createValueExpression((ELContext)context, condition, Boolean.TYPE);
                                try {
                                    if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                    allList.add(sequenceFlows);
                                    if (isConditionWithNextNode) continue;
                                    flag = false;
                                }
                                catch (PropertyNotFoundException e) {
                                    allList.add(sequenceFlows);
                                }
                                continue;
                            }
                            defaultList.add(sequenceFlows);
                        }
                        int type = 1;
                        if (gateway instanceof ExclusiveGateway) {
                            jsonObject.put("type", (Object)"exclusiveGateway");
                            nodeMessage.getewayType = "exclusiveGateway";
                        } else if (gateway instanceof InclusiveGateway) {
                            flag = true;
                            type = 2;
                            jsonObject.put("type", (Object)"inclusiveGateway");
                            nodeMessage.getewayType = "inclusiveGateway";
                        }
                        if (flag) {
                            allList.addAll(defaultList);
                        }
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : allList) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                        if (gateway instanceof ExclusiveGateway) {
                            simpleGroupMessage.childGroupIds.add(childNode);
                            this.getUserTaskByCondition(jsonArray, process, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, null);
                        } else {
                            this.getUserTaskByCondition(jsonArray, process, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        }
                    }
                } else if (flowElement instanceof UserTask) {
                    UserTask u = (UserTask)flowElement;
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                } else if (flowElement instanceof EndEvent) {
                    jsonObject.put("type", (Object)"endEvent");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                } else if (flowElement instanceof ServiceTask) {
                    jsonObject.put("type", (Object)"serviceTask");
                } else if (flowElement instanceof ReceiveTask) {
                    jsonObject.put("type", (Object)"receiveTask");
                }
                simpleGroupMessage.jsonObjects.add(jsonObject);
                nodeMessages.put(sequenceFlow.getTargetRef(), nodeMessage);
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && !map.isEmpty()) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    private void getUserTask(JSONArray jsonArray, Process process, List<SequenceFlow> sfs) {
        if (sfs != null && !sfs.isEmpty()) {
            for (SequenceFlow sequenceFlow : sfs) {
                ParallelGateway p;
                List sequenceFlows;
                ExclusiveGateway exclusiveGateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"UserTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"EndEvent");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    exclusiveGateway = (ExclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    exclusiveGateway = (InclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonObject2.put("type", (Object)"callActivity");
                    jsonArray.add((Object)jsonObject2);
                }
                if (process.getFlowElement(targetRef) instanceof ParallelGateway) {
                    jsonObject = new JSONObject();
                    p = (ParallelGateway)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ParallelGateway");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ServiceTask) {
                    jsonObject = new JSONObject();
                    p = (ServiceTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ServiceTask");
                    jsonArray.add((Object)jsonObject);
                }
                if (!(process.getFlowElement(targetRef) instanceof ReceiveTask)) continue;
                jsonObject = new JSONObject();
                p = (ReceiveTask)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonObject.put("type", (Object)"ReceiveTask");
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        ProcessInstance instance;
        if (historicTaskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            logger.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (HussarUtils.isEmpty((Object)currTask.getEndTime())) {
            logger.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        if ("skip".equals(currTask.getTaskLocalVariables().get("taskSourceFlag"))) {
            result = false;
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            logger.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessEnd(), null);
        }
        if (instance.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", Long.parseLong(currTask.getProcessInstanceId()));
        map.put("endTime", currTask.getEndTime());
        map.put("taskDefinitionKey", currTask.getTaskDefinitionKey());
        map.put("isEnd", "true");
        map.put("userId", currTask.getAssignee());
        if (!"0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        map.put("isEnd", "false");
        if ("0".equals(this.taskEngineMapper.withdrawState(map))) {
            List taskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).finished().taskVariableValueEquals("taskSourceFlag", (Object)"revoke")).orderByHistoricTaskInstanceEndTime().desc()).list();
            if (HussarUtils.isNotEmpty((Object)taskInstanceList)) {
                HistoricTaskInstance historicTaskInstance;
                Iterator iterator = taskInstanceList.iterator();
                while (iterator.hasNext() && (historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime().after(currTask.getEndTime())) {
                    if (!historicTaskInstance.getAssignee().equals(currTask.getAssignee())) continue;
                    result = false;
                    break;
                }
            }
            if (result) {
                if (this.runtimeService.createExecutionQuery().processInstanceId(currTask.getProcessInstanceId()).variableValueLike("all_prev_node", "%'" + currTask.getTaskDefinitionKey() + "'%").listPage(0, 1).isEmpty()) {
                    result = false;
                } else {
                    HistoricTaskInstance historicTaskInstance;
                    List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).list();
                    list.sort((o1, o2) -> {
                        if (o1.getEndTime() == null) {
                            return -1;
                        }
                        if (o2.getEndTime() == null) {
                            return 1;
                        }
                        return o2.getEndTime().compareTo(o1.getEndTime());
                    });
                    Date date = ((HistoricTaskInstance)list.get(0)).getStartTime();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && ((historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime() == null || historicTaskInstance.getEndTime().compareTo(date) >= 0)) {
                        if (historicTaskInstance.getCreateTime().compareTo(date) >= 0) continue;
                        date = historicTaskInstance.getCreateTime();
                    }
                    if (currTask.getEndTime().before(date)) {
                        result = false;
                    }
                }
            }
        }
        json.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, null, comment, isSubmit, null, "revoke", null, Boolean.valueOf(false), map);
        taskRejectModel.setHistoryTaskId(historicTaskId);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getHistoricTaskInstance().getProcessInstanceId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), taskRejectModel.getHistoricTaskInstance().getTaskLocalVariables().get("sendUser") != null ? taskRejectModel.getHistoricTaskInstance().getTaskLocalVariables().get("sendUser").toString() : "", taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), "revoke", taskRejectModel.getHistoricTaskInstance().getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            logger.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Object> backType(ExecutionEntity execution, Task task, String nodeId, boolean isRejectFirst) {
        Map<String, Object> result = this.getBackTypeWithTasks(nodeId, execution, task, isRejectFirst);
        int num = (Integer)result.get("num");
        if (num != 1 || task == null) {
            return result;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            logger.error(this.bpmConstantProperties.getProcessNotFound());
            num = 0;
            result.put("num", num);
            return result;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        if (currActivity == null) {
            throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
        }
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        result.put("num", num);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(String nodeId, ExecutionEntity execution, Task task, boolean isRejectFirst, String state) {
        String taskDefinitionKey;
        String processDefinitionId;
        String processInstanceId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<Object> affectedTasks = new HashSet<String>();
        Set<Object> affectedUserTasks = new HashSet<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        if (task == null) {
            processInstanceId = execution.getProcessInstanceId();
            processDefinitionId = execution.getProcessDefinitionId();
            taskDefinitionKey = execution.getActivityId();
        } else {
            processInstanceId = task.getProcessInstanceId();
            processDefinitionId = task.getProcessDefinitionId();
            taskDefinitionKey = task.getTaskDefinitionKey();
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        result.put("runningActivitiNodeIds", runningActivityNodeIds);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution1 : executions) {
            if (((ExecutionEntity)execution1).isScope() || execution1.getActivityId() == null) continue;
            taskIds.add(execution1.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bm.getProcesses().get(0);
            if (isRejectFirst) {
                newNum = 3;
                for (String[] flowElement : process.getFlowElements()) {
                    if (!taskIds.contains(flowElement.getId())) continue;
                    if (flowElement instanceof UserTask) {
                        affectedUserTasks.add(flowElement.getId());
                    }
                    affectedTasks.add(flowElement.getId());
                }
            } else {
                boolean bl;
                if (nodeId.contains(",")) {
                    void var21_32;
                    String[] stringArray = nodeId.split(",");
                    int flowElement = stringArray.length;
                    boolean bl2 = false;
                    while (var21_32 < flowElement) {
                        String targetNodeId = stringArray[var21_32];
                        if (HussarUtils.isEmpty((Object)process.getFlowElement(targetNodeId))) {
                            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                        }
                        ++var21_32;
                    }
                } else if (HussarUtils.isEmpty((Object)process.getFlowElement(nodeId))) {
                    throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                }
                boolean bl3 = false;
                if (nodeId.contains(",")) {
                    for (String targetNodeId : nodeId.split(",")) {
                        Map<String, Set<String>> map = this.findAffectedTask(process, targetNodeId, true, taskIds);
                        affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                        affectedUserTasks.addAll((Collection)map.get("affectedUserTasks"));
                    }
                } else {
                    Map<String, Set<String>> map = this.findAffectedTask(process, nodeId, true, taskIds);
                    affectedTasks = map.get("affectedTasks");
                    affectedUserTasks = map.get("affectedUserTasks");
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    bl = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!bl) {
                    boolean bl4;
                    Set<Object> affetedAllTasks = new HashSet();
                    if (!affectedTasks.isEmpty()) {
                        affetedAllTasks = affectedTasks;
                    }
                    if (nodeId.contains(",")) {
                        for (String targetNodeId : nodeId.split(",")) {
                            Map<String, Set<String>> map = this.findAffectedTask(process, targetNodeId, false, taskIds);
                            affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                            affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                        }
                    } else {
                        Map<String, Set<String>> map = this.findAffectedTask(process, nodeId, false, taskIds);
                        affectedTasks = map.get("affectedTasks");
                        affectedUserTasks = map.get("affectedUserTasks");
                    }
                    if (affectedTasks.contains(taskDefinitionKey)) {
                        bl4 = true;
                        affectedTasks.remove(taskDefinitionKey);
                    }
                    if (!affectedTasks.isEmpty()) {
                        newNum = 3;
                    }
                    if (!bl4 && affectedTasks.size() + affetedAllTasks.size() > 0) {
                        newNum = -1;
                    }
                }
            }
        }
        HashSet<String> affectedCallActivity = new HashSet<String>();
        for (String string : runningActivityNodeIds) {
            if (!affectedTasks.contains(string)) continue;
            affectedCallActivity.add(string);
        }
        affectedUserTasks.addAll(affectedCallActivity);
        if ("1".equals(state)) {
            HashMap affectedExecution = new HashMap();
            for (Execution execution1 : executions) {
                if (((ExecutionEntity)execution1).isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId())) continue;
                if (affectedExecution.get(execution1.getActivityId()) != null) {
                    List list2 = (List)affectedExecution.get(execution1.getActivityId());
                    list2.add(this.runtimeService.getVariablesLocal(execution1.getId()));
                    continue;
                }
                ArrayList<Map> arrayList = new ArrayList<Map>();
                arrayList.add(this.runtimeService.getVariablesLocal(execution1.getId()));
                affectedExecution.put(execution1.getActivityId(), arrayList);
            }
            result.put("affectedExecution", affectedExecution);
        }
        affectedTasks.add(taskDefinitionKey);
        affectedUserTasks.remove(taskDefinitionKey);
        String affectedUserTaskStr = taskDefinitionKey;
        if (!affectedUserTasks.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(taskDefinitionKey);
            for (String string : affectedUserTasks) {
                stringBuilder.append(",").append(string);
            }
            affectedUserTaskStr = stringBuilder.toString();
        }
        result.put("affectedTasks", new ArrayList(affectedTasks));
        result.put("affectedUserTasks", affectedUserTaskStr);
        result.put("affectedCallActivity", affectedCallActivity);
        result.put("num", newNum);
        return result;
    }

    private Map<String, Object> getBackTypeWithTasks(String nodeId, ExecutionEntity execution, Task task, boolean isRejectFirst) {
        return this.getBackTypeWithTasks(nodeId, execution, task, isRejectFirst, "1");
    }

    private void callActivitiReject(List<String> nodeIds, Set<String> callActivitiNodeIds, String processInsId, String userId, String comment, String type) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            if (!callActivitiNodeIds.remove(nodeId)) continue;
            ids.add(nodeId);
        }
        if (ids.isEmpty()) {
            return;
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("callActivity").list();
        for (HistoricActivityInstance historicActivityInstance : list) {
            if (!ids.contains(historicActivityInstance.getActivityId())) continue;
            CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
            CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
        }
    }

    private void endCallProcess(String instanceId, String userId, String comment, String type) {
        List list;
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(instanceId);
            dataPush.setUserId(userId);
            dataPush.setComment(comment);
            this.dataPushService.endProcess(dataPush);
        }
        if (!(list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list()).isEmpty()) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
                CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, null, historicActivityInstance.getExecutionId(), destinationActivity.getId(), comment, type, null, new HashMap<String, Object>(), currentActivity).setProcessEventType("process_end"));
        }
    }

    private Map<String, Set<String>> findAffectedTask(Process process, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(process.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(process.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(process.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if ((taskId = this.getRealTaskId(taskId)) == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TaskComment::getTaskId, (Object)taskId)).eq(TaskComment::getType, (Object)"complete")).eq(TaskComment::getAction, (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(taskId, comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        Task task = this.getTask(taskId = this.getRealTaskId(taskId), "0");
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCanDelAssignee(), null);
        }
        if (assignees == null && task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId, assignees == null ? null : Arrays.asList(assignees.split(","))));
        this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd("", task.getProcessInstanceId(), task.getTaskDefinitionKey(), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public Map<String, Map<String, Set<String>>> updateRejectForm(Map<String, Object> map) {
        String procDefId = (String)map.get("procDefId");
        Set delNodeIds = (Set)map.get("delNodeIds");
        Set changeNodeIds = (Set)map.get("changeNodeIds");
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        HashMap del = new HashMap();
        HashMap change = new HashMap();
        HashSet<String> processAll = new HashSet<String>();
        result.put("delNode", del);
        result.put("changeNode", change);
        del.put("", processAll);
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        if (list.isEmpty()) {
            return result;
        }
        for (String delNode : delNodeIds) {
            del.put(delNode, new HashSet());
        }
        for (String changeNode : changeNodeIds) {
            change.put(changeNode, new HashSet());
        }
        for (Execution execution : list) {
            if (delNodeIds.contains(execution.getActivityId())) {
                Set nodeDelSet = (Set)del.get(execution.getActivityId());
                nodeDelSet.add(execution.getProcessInstanceId());
                processAll.add(execution.getProcessInstanceId());
                continue;
            }
            if (!changeNodeIds.contains(execution.getActivityId())) continue;
            Set nodeChangeSet = (Set)change.get(execution.getActivityId());
            nodeChangeSet.add(execution.getActivityId());
            processAll.add(execution.getProcessInstanceId());
        }
        for (String delNode : delNodeIds) {
            if (((Set)del.get(delNode)).size() != 0) continue;
            del.remove(delNode);
        }
        for (String changeNode : changeNodeIds) {
            if (((Set)change.get(changeNode)).size() != 0) continue;
            change.remove(changeNode);
        }
        return result;
    }

    public void reStartProcessUpdate(String processInsId, String businessId, String processDefinitionId, String parentExecutionId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        map.put("tenantId", tenantId);
        map.put("parentExecutionId", parentExecutionId);
        map.put("processDefinitionId", processDefinitionId);
        this.taskEngineMapper.reStartProcessUpdate(map);
        this.taskEngineMapper.reStartProcessInsert(map);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
            throw new PublicClientException("\u4e0d\u5141\u8bb8\u91cd\u542f\u5b50\u6d41\u7a0b\uff01", Boolean.valueOf(false));
        }
        if (historicProcessInstance != null) {
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), Boolean.valueOf(false));
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    taskDefinitionKey = ((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination().getId();
                    break;
                }
            }
            if (HussarUtils.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("sendUser", userId);
            if (isSubmit && HussarUtils.isEmpty((Object)assignee)) {
                assignee = this.getTaskCommitUser(historicProcessInstance.getId(), taskDefinitionKey);
            }
            if (HussarUtils.isNotEmpty((Object)assignee)) {
                HashMap<String, String> appointAssignee = new HashMap<String, String>();
                appointAssignee.put("static_appoint_assignee", assignee);
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), historicProcessInstance.getBusinessKey(), historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, null, historicProcessInstance.getId(), taskDefinitionKey, null, "", null, map, null).setProcessEventType("process_restart"));
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, historicProcessInstance.getId(), null, map));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        List<Map<String, String>> multiTaskMessages = this.taskEngineMapper.getSecurityLevelMultiTask(userId, level);
        for (Map<String, String> map : multiTaskMessages) {
            if (map.get("DUEDATE") != null) {
                this.activityRedisTimerService.delTimeOutModel(String.valueOf(map.get("TASKID")));
            }
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(String.valueOf(map.get("EXECUTIONID")), String.valueOf(map.get("TASKID")), null));
            this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, String.valueOf(map.get("processInsId")), map.get("TASKDEFKEY"), new HashMap<String, Object>()));
        }
        this.taskEngineMapper.updateRuIdentityLink(userId, level);
        this.taskEngineMapper.updateRuTask(userId, level);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)businessId) || HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorReset(), null);
        }
        if (HussarUtils.isEmpty((Object)processInsId)) {
            processInsId = this.taskEngineMapper.getProcessInsIdByBusinessId(businessId);
        }
        this.taskEngineMapper.updateActHiProcinstStater(processInsId, userId);
        this.taskEngineMapper.updateActHiIdentitylinkStater(processInsId, userId);
        this.taskEngineMapper.updateActRuIdentitylinkStater(processInsId, userId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CandidateUser::getTaskId, (Object)taskId);
        List candidateUserList = this.candidateUserService.list((Wrapper)ew);
        List users = candidateUserList.stream().map(CandidateUser::getAssignee).collect(Collectors.toList());
        if (HussarUtils.isEmpty(users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Map entrustMap = this.sysActEntrustService.queryByUsers(users, task.getProcessDefinitionId().split(":")[0], task.getTaskDefinitionKey());
        ArrayList userList = new ArrayList();
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(task.getId());
            if (taskEntity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
            }
            ArrayList userMapList = new ArrayList();
            candidateUserList.forEach(candidateUser -> {
                HashMap<String, String> userMap = new HashMap<String, String>();
                IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
                identityLinkEntity.setPostId(candidateUser.getPostId());
                identityLinkEntity.setDeptId(candidateUser.getDeptId());
                identityLinkEntity.setType("candidate");
                String assignee = (String)entrustMap.get(candidateUser.getAssignee());
                if (assignee != null) {
                    userMap.put("userId", assignee);
                    userMap.put("mandator", candidateUser.getAssignee());
                    identityLinkEntity.setUserId(assignee);
                    identityLinkEntity.setMandator(candidateUser.getAssignee());
                    identityLinkEntity.setTaskState("1");
                } else {
                    userMap.put("userId", candidateUser.getAssignee());
                    identityLinkEntity.setUserId(candidateUser.getAssignee());
                }
                userList.add(identityLinkEntity.getUserId());
                userMapList.add(userMap);
                taskEntity.addCandidateUser(identityLinkEntity);
            });
            this.dataPushService.entrustDataPush(new DataPush().setTaskId(taskEntity.getId()).setUserId(String.join((CharSequence)",", userList)).setUserMaps(userMapList));
            return null;
        });
        this.candidateUserService.remove((Wrapper)ew);
        this.activityRedisTimerService.updateTimeOutModel(taskId, String.join((CharSequence)",", userList), null, 0);
        return InstallResult.success((String)this.bpmConstantProperties.getAppointAssigneesSuccess());
    }

    public BpmResponseResult getExecutionByBusinessId(String businessId) {
        String processInsId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()).getId();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            JSONArray json = new JSONArray();
            if (HussarUtils.isEmpty((Object)historicActivityInstances)) {
                return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
            }
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                JSONObject object = new JSONObject();
                object.put("activitiName", (Object)historicActivityInstance.getActivityName());
                object.put("activitiType", (Object)historicActivityInstance.getActivityType());
                object.put("activitiId", (Object)historicActivityInstance.getActivityId());
                object.put("executionId", (Object)historicActivityInstance.getExecutionId());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
    }

    public BpmResponseResult receiveTaskSignalByProcessInfo(TaskReceiveDto taskReceiveDto) {
        if (HussarUtils.isEmpty((Object)taskReceiveDto.getTaskDefinitionKey())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{taskReceiveDto.getProcessInsId(), taskReceiveDto.getBusinessId()})) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricProcessInstance processInstance = HussarUtils.isEmpty((Object)taskReceiveDto.getProcessInsId()) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(taskReceiveDto.getBusinessId()).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskReceiveDto.getProcessInsId()).singleResult();
        if (processInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart());
        }
        if (processInstance.getEndTime() != null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessEnd());
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityType("receiveTask").unfinished().list();
        if (historicActivityInstances == null || historicActivityInstances.isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessReceiveTaskNotFound());
        }
        String taskDefKey = taskReceiveDto.getTaskDefinitionKey();
        if ((historicActivityInstances = historicActivityInstances.stream().filter(o -> taskDefKey.equals(o.getActivityId())).collect(Collectors.toList())).isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getReceiveTaskNotFound());
        }
        Map map = new HashMap();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            String executionId = historicActivityInstance.getExecutionId();
            map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, taskReceiveDto.getVariableMap()));
            this.runtimeService.signal(executionId);
            this.activityRedisTimerService.delTimeOutModel(executionId);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd((String)map.get("userId"), (String)map.get("processInsId"), (String)map.get("backActivityId"), null));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> variableMap) {
        Map map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, variableMap));
        this.runtimeService.signal(executionId);
        this.activityRedisTimerService.delTimeOutModel(executionId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd((String)map.get("userId"), (String)map.get("processInsId"), (String)map.get("backActivityId"), null));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void rejectDataPush(Task task, String comment, String userId, String mandator, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            this.dataPushService.rejectDataPush(dataPush);
        }
    }

    private void completeDataPush(Task task, String comment, String userId, String mandator, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            this.dataPushService.completeDataPush(dataPush);
        }
    }

    private void claimDataPush(String taskId, String userId) {
        if (this.dataPushService.isDataPush()) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.claimDataPush(dataPush);
        }
    }

    private void freeJumpDataPush(Task task, String comment, String userId, String taskIds, String mandator, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            if (HussarUtils.isNotEmpty((Object)taskIds)) {
                dataPush.setTaskId(taskIds);
            }
            this.dataPushService.freeJumpDataPush(dataPush);
        }
    }

    private void addUrgeTask(Task task, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.addUrgeTask(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setTenantId(task.getTenantId());
        return dataPush;
    }

    private void setRejectAppointAssignee(String processInstanceId, String backActivityId, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map) {
        Map<String, String> appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!isSubmit) {
            List historicTaskInstanceList;
            if (HussarUtils.isEmpty((Object)assignees) && !backActivityId.contains(",") && (historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() == 1) {
                String oldAppointAssignee;
                Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (oldAppointMessage instanceof HashMap) {
                    Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                    oldAppointAssignee = (String)oldAppointAssigneeMap.get(backActivityId);
                } else {
                    oldAppointAssignee = (String)oldAppointMessage;
                }
                if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                    map.put("reject_appoint_assignee", oldAppointAssignee);
                }
            }
            if (backActivityId.contains(",")) {
                appointAssignee = (HashMap<String, String>)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap<String, String>();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    String oldAppointAssignee;
                    List historicTaskInstanceList2;
                    if (appointAssignee.containsKey(targetNodeId) || (historicTaskInstanceList2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() != 1) continue;
                    Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList2.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                    if (oldAppointMessage instanceof HashMap) {
                        Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                        oldAppointAssignee = (String)oldAppointAssigneeMap.get(targetNodeId);
                    } else {
                        oldAppointAssignee = (String)oldAppointMessage;
                    }
                    if (!HussarUtils.isNotEmpty((Object)oldAppointAssignee)) continue;
                    appointAssignee.put(targetNodeId, oldAppointAssignee);
                }
                map.put("appoint_assignee", appointAssignee);
            }
        }
        if (HussarUtils.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        if (isSubmit) {
            if (backActivityId.contains(",")) {
                appointAssignee = (Map)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    String assignee = this.getTaskCommitUser(processInstanceId, targetNodeId);
                    if (!HussarUtils.isNotEmpty((Object)assignee)) continue;
                    appointAssignee.put(targetNodeId, assignee);
                }
                map.put("appoint_assignee", appointAssignee);
            } else {
                String assignee = this.getTaskCommitUser(processInstanceId, backActivityId);
                if (HussarUtils.isNotEmpty((Object)assignee)) {
                    map.put("reject_appoint_assignee", assignee);
                }
            }
        }
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        String userId = preemptCommonDto.getUserId();
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId());
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new PreemptTaskCmd(taskId, userId, realTaskId.getMandatary()));
        return InstallResult.success();
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        String userId = preemptCommonDto.getUserId();
        boolean isAuditAuthority = preemptCommonDto.getIsAuditAuthority();
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId());
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new UnPreemptTaskCmd(taskId, userId, realTaskId.getMandatary(), isAuditAuthority));
        return InstallResult.success();
    }

    public BpmResponseResult getApprovalType(String taskId) {
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.success();
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)task)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        JSONArray json = this.iSysActExtendPropertiesService.getApprovalType(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        return InstallResult.success((JSONArray)json);
    }

    public BpmResponseResult getApprovalExtendProperties(String taskId) {
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.success();
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)task)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ApprovalExtendPropertiesVo vo = this.iSysActExtendPropertiesService.getApprovalExtendProperties(historicProcessInstance.getProcessDefinitionId(), task.getTaskDefinitionKey());
        JSONArray json = new JSONArray();
        json.add((Object)vo);
        return InstallResult.success((JSONArray)json);
    }

    public BpmResponseResult getApprovalUser(String businessId, String taskId, String taskDefKey) {
        ArrayList<String> departmentIds = new ArrayList<String>();
        ArrayList<String> postIds = new ArrayList<String>();
        taskId = this.getRealTaskId(taskId);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        ArrayList approvalUserList = new ArrayList();
        HashSet users = new HashSet();
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            if (historicProcessInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart());
            }
            if (((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult() != null) {
                this.taskService.getIdentityLinksType(taskId).forEach(identityLink -> {
                    approvalUserList.add(AnalyticalModelUtil.getApprovalUser(identityLink));
                    users.add(identityLink.getUserId());
                    users.add(identityLink.getMandator());
                });
            }
            this.subCandidateService.getTaskSubCandidate(taskId).forEach(subCandidate -> {
                approvalUserList.add(AnalyticalModelUtil.getApprovalUser(subCandidate));
                users.add(subCandidate.getUserId());
                users.add(subCandidate.getOwner());
            });
        } else if (!HussarUtils.isAllEmpty((Object[])new Object[]{businessId, taskDefKey})) {
            this.pendingTaskService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getBusinessId, (Object)businessId)).eq(BpmActPendingTask::getTaskDefKey, (Object)taskDefKey)).forEach(pendingTask -> {
                if (pendingTask.getAssignee() != null) {
                    approvalUserList.add(AnalyticalModelUtil.getApprovalUser(pendingTask));
                    users.add(pendingTask.getAssignee());
                    users.add(pendingTask.getOwner());
                }
            });
        } else {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (approvalUserList != null && approvalUserList.size() != 0) {
            for (ApprovalUser approvalUser2 : approvalUserList) {
                departmentIds.add(approvalUser2.getDeptId());
                postIds.add(approvalUser2.getPostId());
            }
        }
        if (!users.isEmpty()) {
            Map userMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(users), historicProcessInstance != null ? historicProcessInstance.getTenantId() : null);
            Map userDepartmentAndPostModelMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(new ArrayList(users));
            Map departmentMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
            Map postMap = this.iAssigneeChooseService.getPostNameBypostIds(postIds);
            userMap.put(null, null);
            approvalUserList.forEach(approvalUser -> {
                approvalUser.setUserName((String)userMap.get(approvalUser.getUserId()));
                if (approvalUser.getOwner() == null) {
                    approvalUser.setOwner(approvalUser.getUserId());
                }
                approvalUser.setOwnerName((String)userMap.get(approvalUser.getOwner()));
                if (approvalUser.getDeptId() == null || approvalUser.getDeptId().length() == 0 || "null".equals(approvalUser.getDeptId())) {
                    if (approvalUser.getOwner() != null && approvalUser.getOwner().length() != 0) {
                        approvalUser.setDeptId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(approvalUser.getOwner())).getDepartmentId());
                        approvalUser.setDeptName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(approvalUser.getOwner())).getDepartmentName());
                    }
                } else {
                    approvalUser.setDeptName((String)departmentMap.get(approvalUser.getDeptId()));
                }
                if (approvalUser.getPostId() == null || approvalUser.getPostId().length() == 0) {
                    if (approvalUser.getOwner() != null && approvalUser.getOwner().length() != 0) {
                        approvalUser.setPostId(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(approvalUser.getOwner())).getPostId());
                        approvalUser.setPostName(((UserDepartmentAndPostModel)userDepartmentAndPostModelMap.get(approvalUser.getOwner())).getPostName());
                    }
                } else {
                    approvalUser.setPostName((String)postMap.get(approvalUser.getPostId()));
                }
            });
        }
        return InstallResult.success((JSONArray)JSONArray.parseArray((String)JSON.toJSONString(approvalUserList)));
    }

    public BpmResponseResult appointApprovalUser(String taskId, List<ApprovalUser> approvalUserList) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId))) || approvalUserList == null || approvalUserList.isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (historicTaskInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        ArrayList<SubCandidate> subCandidateList = new ArrayList<SubCandidate>();
        if (historicTaskInstance.getEndTime() == null) {
            boolean isAppointMain = false;
            for (ApprovalUser approvalUser : approvalUserList) {
                if (!"1".equals(approvalUser.getIsMain())) continue;
                isAppointMain = true;
                break;
            }
            if (!isAppointMain) {
                throw new PublicClientException("\u672a\u6307\u5b9a\u4e3b\u5ba1\u6279\u4eba");
            }
            this.processEngine.getManagementService().executeCommand(commandContext -> {
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(historicTaskInstance.getId());
                HashSet delAssignee = new HashSet();
                HashSet<String> addAssignee = new HashSet<String>();
                taskEntity.getIdentityLinks().forEach(identityLink -> delAssignee.add(identityLink.getUserId()));
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(historicTaskInstance.getId());
                for (ApprovalUser approvalUser : approvalUserList) {
                    if ("1".equals(approvalUser.getIsMain())) {
                        taskEntity.addCandidateUser(AnalyticalModelUtil.getIdentityLinkEntityByApprovalUser(approvalUser));
                        addAssignee.add(approvalUser.getUserId());
                        continue;
                    }
                    subCandidateList.add(new SubCandidate(approvalUser, historicTaskInstance.getId(), taskEntity.getProcessInstanceId()));
                }
                String delAssigneeStr = String.join((CharSequence)",", delAssignee);
                String addAssigneeStr = String.join((CharSequence)",", addAssignee);
                this.activityRedisTimerService.updateTimeOutModel(historicTaskInstance.getId(), addAssigneeStr, delAssigneeStr, 1);
                this.entrustDataPush((Task)taskEntity, addAssigneeStr, delAssigneeStr, taskEntity.getCreateTime(), new Date());
                return null;
            });
        } else {
            for (ApprovalUser approvalUser : approvalUserList) {
                subCandidateList.add(new SubCandidate(approvalUser, taskId, historicTaskInstance.getProcessInstanceId()));
            }
        }
        this.subCandidateService.remove((Wrapper)new LambdaQueryWrapper().eq(SubCandidate::getTaskId, (Object)taskId));
        if (!subCandidateList.isEmpty()) {
            this.subCandidateService.saveBatch(subCandidateList);
        }
        return InstallResult.success();
    }

    private void entrustDataPush(Task task, String userId, String consignee, Date startTime, Date endTime) {
        this.messagePush((TaskEntity)task, new ArrayList<String>(Arrays.asList(userId.split(","))));
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(startTime);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(endTime);
            }
            dataPush.setTenantId(task.getTenantId());
            this.dataPushService.entrustDataPush(dataPush);
        }
    }

    private void messagePush(TaskEntity taskEntity, List<String> users) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        bpmActMsgDetail.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        bpmActMsgDetail.setProcessName(taskEntity.getProcessInstance().getProcessDefinition().getName());
        bpmActMsgDetail.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        bpmActMsgDetail.setTaskDefKey(taskEntity.getTaskDefinitionKey());
        bpmActMsgDetail.setTaskDefName(taskEntity.getName());
        bpmActMsgDetail.setReceive(users);
        bpmActMsgDetail.setChannelType(null);
        bpmActMsgDetail.setSceneCode("todo");
        bpmActMsgDetail.setProcessVer(taskEntity.getProcessDefinitionId().split(":")[1]);
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private static class NodeMessage {
        String nodeId;
        String parentNode;
        boolean conditionWithNextNode;
        String getewayType;
        List<String> childNodes;

        public NodeMessage(String nodeId, String parentNode, boolean conditionWithNextNode, String gatewayType, List<String> childNodes) {
            this.nodeId = nodeId;
            this.parentNode = parentNode;
            this.conditionWithNextNode = conditionWithNextNode;
            this.getewayType = gatewayType;
            this.childNodes = childNodes;
        }
    }

    private static class SimpleGroupMessage {
        String groupId;
        List<JSONObject> jsonObjects;
        List<List<String>> childGroupIds;

        private SimpleGroupMessage() {
        }
    }

    private static class RealTaskId {
        private String taskId;
        private String mandatary;

        public String getTaskId() {
            return this.taskId;
        }

        public String getMandatary() {
            return this.mandatary;
        }

        public RealTaskId(String taskId, String mandatary) {
            this.taskId = taskId;
            this.mandatary = mandatary;
        }
    }
}

