/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dto.UpdatePendingTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.model.SysActProcessApproveFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.model.SysActProcessApproveFileDerivation;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.service.ISysActProcessApproveFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.impl.ProcessInstServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class InstanceEngineServiceImpl
implements IInstanceEngineService {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ProcessInstServiceImpl processInstService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Autowired
    private BpmActPendingTaskService bpmActPendingTaskService;
    @Autowired
    private ProcessInstMapper processInstMapper;
    @Autowired
    private ISubCandidateService subCandidateService;
    @Autowired
    private ISysActProcessDeptService processDeptService;
    @Autowired
    private BpmActPendingTaskService pendingTaskService;
    @Autowired
    private ISysActProcessApproveFileService processApproveFileService;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, String tenantId, Map<String, Object> variables, String departmentId, String postId, List<SysActProcessApproveFile> sysActProcessApproveFileList) {
        List list;
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && !instance.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(processDefinitionId);
        if (ProcessExtendProperties.TRUE.equals(processExtendProperties.getMustUploadAttachment()) && (sysActProcessApproveFileList == null || sysActProcessApproveFileList.isEmpty())) {
            throw new PublicClientException("\u672a\u4e0a\u4f20\u9644\u4ef6");
        }
        if (!ProcessExtendProperties.TRUE.equals(processExtendProperties.getAllowNullApprover()) && (list = this.pendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getBusinessId, (Object)businessId))) != null) {
            for (BpmActPendingTask bpmActPendingTask : list) {
                if (!HussarUtils.isEmpty((Object)bpmActPendingTask.getAssignee())) continue;
                throw new PublicClientException("\u8282\u70b9\u5ba1\u6279\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
            }
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("tenantId", tenantId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        if (departmentId != null && !departmentId.isEmpty()) {
            this.processInstMapper.updateDepartmentIdByProcinstId(processInstance.getProcessInstanceId(), departmentId);
        }
        if (postId != null && !postId.isEmpty()) {
            this.processInstMapper.updatePostIdByProcinstId(processInstance.getProcessInstanceId(), postId);
        }
        if (sysActProcessApproveFileList != null && !sysActProcessApproveFileList.isEmpty()) {
            SysActProcessApproveFileDerivation sysActProcessApproveFileDerivation = new SysActProcessApproveFileDerivation();
            sysActProcessApproveFileDerivation.setProcessInsId(Long.valueOf(processInstance.getProcessInstanceId()));
            sysActProcessApproveFileDerivation.setSysActProcessApproveFileList(sysActProcessApproveFileList);
            this.processApproveFileService.saveOrUpdateFile(sysActProcessApproveFileDerivation);
        }
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        this.pendingTaskService.updatePendingTask(null, businessId);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String userName, String businessId, String tenantId, Map<String, Object> variables, String departmentId, String postId, List<SysActProcessApproveFile> sysActProcessApproveFileList, List<SysActCcTask> ccTaskList) {
        List list;
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && !instance.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).processDefinitionVersion(Integer.valueOf(this.processDeptService.getProcessVersion(departmentId, processKey))).singleResult()).getId();
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(processDefinitionId);
        if (ProcessExtendProperties.TRUE.equals(processExtendProperties.getMustUploadAttachment()) && (sysActProcessApproveFileList == null || sysActProcessApproveFileList.isEmpty())) {
            throw new PublicClientException("\u672a\u4e0a\u4f20\u9644\u4ef6");
        }
        if (!ProcessExtendProperties.TRUE.equals(processExtendProperties.getAllowNullApprover()) && (list = this.pendingTaskService.list((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getBusinessId, (Object)businessId))) != null) {
            for (BpmActPendingTask bpmActPendingTask : list) {
                if (!HussarUtils.isEmpty((Object)bpmActPendingTask.getAssignee())) continue;
                throw new PublicClientException("\u8282\u70b9\u5ba1\u6279\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
            }
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("tenantId", tenantId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        if (departmentId != null && !departmentId.isEmpty()) {
            this.processInstMapper.updateDepartmentIdByProcinstId(processInstance.getProcessInstanceId(), departmentId);
        }
        if (postId != null && !postId.isEmpty()) {
            this.processInstMapper.updatePostIdByProcinstId(processInstance.getProcessInstanceId(), postId);
        }
        if (sysActProcessApproveFileList != null && !sysActProcessApproveFileList.isEmpty()) {
            SysActProcessApproveFileDerivation sysActProcessApproveFileDerivation = new SysActProcessApproveFileDerivation();
            sysActProcessApproveFileDerivation.setProcessInsId(Long.valueOf(processInstance.getProcessInstanceId()));
            sysActProcessApproveFileDerivation.setSysActProcessApproveFileList(sysActProcessApproveFileList);
            this.processApproveFileService.saveOrUpdateFile(sysActProcessApproveFileDerivation);
        }
        if (ccTaskList != null && !ccTaskList.isEmpty()) {
            this.iSysActCcTaskService.buildCcTaskList(ccTaskList, processInstance, userId, userName);
            this.iSysActCcTaskService.saveBatch(ccTaskList);
        }
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        this.pendingTaskService.updatePendingTask(null, businessId);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult updatePendingTask(UpdatePendingTaskDto updatePendingTaskDto) {
        ApiResponse apiResponse = this.pendingTaskService.updatePendingTask(updatePendingTaskDto.getProcessKey(), updatePendingTaskDto.getBusinessId(), updatePendingTaskDto.getUserId(), updatePendingTaskDto.getDeptId(), updatePendingTaskDto.getPostId());
        if (apiResponse.isSuccess()) {
            return InstallResult.success();
        }
        return InstallResult.fail((String)apiResponse.getMsg());
    }

    public BpmResponseResult validationStartProcess(String processKey, String userId, String businessId, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && !instance.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult checkProcessInstByBusinessId(String businessId) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && !instance.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONObject object = new JSONObject();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processKey", (Object)task.getProcessDefinitionId().split(":")[0]);
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessId", (Object)businessId);
                object.put("taskId", (Object)task.getId());
                return ApiResponse.success((Object)object);
            }
            return ApiResponse.fail((String)bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance)) {
            return ApiResponse.fail((String)bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult validateDeleteByBusinessId(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance)) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String tenantId, String businessId, Map<String, Object> variables) {
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, tenantId, processDefinitionId, businessId, variables);
        if (HussarUtils.isEmpty((Object)sql)) {
            return true;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String serviceName = String.valueOf(this.modelService.getServiceName(processDefinitionKey));
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowStarterUserId", userId);
        processInfo.put("workflowProcessDefinitionId", processDefinitionId);
        processInfo.put("workflowProcessKey", processDefinitionId.split(":")[0]);
        processInfo.put("workflowBusinessId", businessId);
        List users = this.iAssigneeChooseService.getCandidateUser(sql, serviceName, tenantId, (Integer)variables.get("security_level"), processInfo);
        boolean flag = users != null && !users.isEmpty() ? users.contains(userId) : true;
        return flag;
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        if (HussarUtils.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(processDefinitionId, null);
        if (map.isEmpty()) {
            return variables;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("todoConfiguration", map.get("todoConfiguration"));
        return variables;
    }

    private JSONArray installJson(String processInsId, String userId, Map<String, Object> variables) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).active().list();
        for (Task task : tasks) {
            JSONObject object = new JSONObject();
            this.taskService.setVariableLocal(task.getId(), "sendUser", (Object)userId);
            this.taskService.setVariableLocal(task.getId(), "complete_type", (Object)NOW_STATE);
            object.put("processInsId", (Object)processInsId);
            object.put("taskId", (Object)task.getId());
            object.put("userId", new HashSet<String>(this.getAssigneeByTaskId(task.getId())));
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)task.getName());
            object.put("formKey", (Object)task.getFormKey());
            json.add((Object)object);
        }
        return json;
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        this.runtimeService.suspendProcessInstanceById(processInsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "suspendEnd");
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        map.put("processInsId", processInsId);
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        this.runtimeService.activateProcessInstanceById(processInsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "activateEnd");
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        map.put("processInsId", processInsId);
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Task task : tasks) {
            if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInsId, reason);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()).getBusinessKey());
            dataPush.setProcessInsId(processInsId);
            dataPush.setComment(reason);
            this.dataPushService.deleteDataPush(dataPush);
        }
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)processInsId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
        lineQueryWrapper.eq(SysActHiLine::getProcessInsId, (Object)processInsId);
        this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        String businessKey = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()).getBusinessKey();
        this.historyService.deleteHistoricProcessInstance(processInsId);
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)processInsId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(businessKey);
            dataPush.setProcessInsId(processInsId);
            this.dataPushService.deleteDataPush(dataPush);
        }
        this.bpmActPendingTaskService.endProcessUpdatePendingTasks(processInsId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicProcessInstance.getId())).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)historicProcessInstance.getId());
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)historicProcessInstance.getId());
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
            lineQueryWrapper.eq(SysActHiLine::getProcessInsId, (Object)historicProcessInstance.getId());
            this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessKey(businessId);
                dataPush.setProcessInsId(historicProcessInstance.getId());
                this.dataPushService.deleteDataPush(dataPush);
            }
            this.bpmActPendingTaskService.endProcessUpdatePendingTasks(historicProcessInstance.getId());
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessId, boolean isValidate) {
        try {
            List<String> businessIdList;
            if (HussarUtils.isNotEmpty((Object)businessId) && HussarUtils.isNotEmpty(businessIdList = Arrays.asList(businessId.split(",")))) {
                List<String> procIdList;
                if (isValidate) {
                    for (String s : businessIdList) {
                        BpmResponseResult validateResult;
                        if (s.isEmpty() || (validateResult = this.validateDeleteByBusinessId(s)).getResult().get(0) != null && "1".equals(validateResult.getResult().get(0).toString())) continue;
                        return InstallResult.getResult((String)"0", (String)validateResult.getMsg(), null);
                    }
                }
                if (!(procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIdList)).isEmpty()) {
                    ArrayList<String> allProcId = new ArrayList<String>();
                    do {
                        allProcId.addAll(procIdList);
                    } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
                    this.multiDeleteByProcIdList(allProcId);
                    this.bpmActPendingTaskService.endProcessUpdatePendingTasks(String.join((CharSequence)",", allProcId));
                }
            }
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows, String tag) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Page pages = new Page();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        pages.setCurrent((long)page);
        pages.setSize((long)rows);
        ((LambdaQueryWrapper)lambdaQueryWrapper.like(ProcessInst::getBusinessId, (Object)businessId)).like(ProcessInst::getProcessDefinitionId, (Object)processKey);
        if ("0".equals(tag)) {
            lambdaQueryWrapper.eq(ProcessInst::getIsDeleteProcinst, (Object)"0");
        }
        pages = (Page)this.processInstService.page((IPage)pages, (Wrapper)lambdaQueryWrapper);
        object.put("data", (Object)pages.getRecords());
        object.put("count", (Object)pages.getTotal());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            throw new PublicClientException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01");
        }
        if (!processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (processInstance == null) {
            throw new PublicClientException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01");
        }
        if (!processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessTrace(String processInsId, String tenantId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (!user.isEmpty()) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && !comments.isEmpty()) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)bpmConstantProperties.getNullComment());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String tenantId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
        return this.getResult(hisTaskList, tenantId, true);
    }

    public BpmResponseResult getAllProcessTraceForComment(String processInsId, String tenantId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
        return this.getResult(hisTaskList, tenantId, false);
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId, int type, String tenantId) {
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<Object> processInsIds = new ArrayList();
        if (type == 0) {
            if (HussarUtils.isEmpty((Object)processInsId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getProcessNotFound(), null);
                }
                processInsId = historicProcessInstance.getId();
            }
            if ((processInsIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(processInsId))).isEmpty()) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
        } else {
            historicProcessInstance = HussarUtils.isEmpty((Object)processInsId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getProcessNotFound(), null);
            }
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            processInsIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(processInsIds)).list();
        return this.getResult(historicTaskInstances, tenantId, true);
    }

    public BpmResponseResult getAllProcessTraceByBusinessId(String businessId, String tenantId, int page, int size) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, tenantId, true);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, String tenantId, boolean flag) {
        JSONArray json = new JSONArray();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.stream().forEach(o -> {
                if (o.isEntrust() && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        if (this.lcdpBpmProperties.isOrderByTime()) {
            hisTaskList.sort((o1, o2) -> {
                if (!o1.getStartTime().equals(o2.getStartTime())) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
                if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return o2.getEndTime().compareTo(new Date(0L));
                }
                if (o1.getEndTime() != null && o2.getEndTime() == null) {
                    return new Date(0L).compareTo(o1.getEndTime());
                }
                if (o1.getEndTime().equals(o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        } else {
            hisTaskList.sort((o1, o2) -> {
                if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return new Date(0L).compareTo(o2.getEndTime());
                }
                if (o1.getEndTime() != null && o2.getEndTime() == null) {
                    return o1.getEndTime().compareTo(new Date(0L));
                }
                if (o1.getEndTime().equals(o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.parseLong(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap taskComment = new HashMap();
            for (Map map : commentsMap) {
                taskComment.put(String.valueOf(map.get("id")), map.get("comments"));
            }
            List<Object> allVariables = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                hashMap.put(variables.getTaskId(), variables.getTextValue());
            }
            for (HistoricTaskInstance hsi : hisTaskList) {
                String comment;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? bpmConstantProperties.getNullComplete() : (hsi.isEntrust() ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : bpmConstantProperties.getNullComplete();
                String nullCommont = "";
                if (flag) {
                    nullCommont = bpmConstantProperties.getNullComment();
                }
                object.put("comments", (Object)((comment = (String)taskComment.get(hsi.getId())) == null ? nullCommont : comment));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<IdentityLink> users = this.getIdentityLinkByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(users, tenantId));
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)bpmConstantProperties.getNullComplete());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getAllProcessTraceByMicroApp(String processInsId, String tenantId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getDoneProcessTrace(String businessId, String tenantId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setTenantId(processDefinition.getTenantId());
        processDefinitionModel.setProcessName(processDefinition.getName());
        processDefinitionModel.setId(processDefinition.getId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.taskId;
        String mandator = realTaskId.mandatary;
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
        mandator = prepareReturn.getMandator();
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        this.endCallProcess(task.getProcessInstanceId(), userId, reason, "endProcess", prepareReturn.getIdentityLink(), null, 0);
        String superProcessInstanceId = task.getProcessInstanceId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason, String approvalType) {
        HistoricProcessInstance processInstance;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.taskId;
        String mandator = realTaskId.mandatary;
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        this.endCallProcess(task.getProcessInstanceId(), userId, reason, "endProcess", prepareReturn.getIdentityLink(), approvalType, 0);
        String superProcessInstanceId = task.getProcessInstanceId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByProcessInsId(String processInstanceId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getProcessInsIdNull(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process.isSuspended()) {
            throw new PublicClientException(bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        this.endCallProcess(processInstanceId, userId, reason, "endProcess", null, null, 0);
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().size() == 0) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void endCallProcess(String instanceId, String userId, String reason, String taskType, IdentityLink identityLink, String approvalType, int depth) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(instanceId);
            dataPush.setUserId(userId);
            dataPush.setComment(reason);
            if (identityLink != null) {
                dataPush.setConsignor(identityLink.getMandator());
            }
            this.dataPushService.endProcess(dataPush);
        }
        this.bpmActPendingTaskService.endProcessUpdatePendingTasks(instanceId);
        this.subCandidateService.remove((Wrapper)new LambdaQueryWrapper().eq(SubCandidate::getProcInstId, (Object)instanceId));
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list();
        if (!list.isEmpty()) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                TaskEngineServiceImpl.CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, reason, taskType, identityLink, approvalType, depth + 1);
                TaskEngineServiceImpl.CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            ParallelJumpTaskCmd parallelJumpTaskCmd = new ParallelJumpTaskCmd(userId, identityLink != null ? identityLink.getMandator() : null, historicActivityInstance.getExecutionId(), destinationActivity.getId(), reason, taskType, null, new HashMap<String, Object>(), currentActivity, new TaskRejectModel().setIdentityLink(identityLink));
            if ("endProcess".equals(taskType)) {
                parallelJumpTaskCmd.setProcessEventType("process_end");
                parallelJumpTaskCmd.setApprovalType(approvalType);
                if (depth != 0) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_end");
                }
            } else if ("revokeProcess".equals(taskType)) {
                parallelJumpTaskCmd.setProcessEventType("process_revoke");
                if (depth != 0) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_revoke");
                }
            }
            this.processEngine.getManagementService().executeCommand((Command)parallelJumpTaskCmd);
            if ("revokeProcess".equals(taskType) && depth == 0) {
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(instanceId);
                    historicProcessInstance.setDeleteReason("revokeProcess");
                    return null;
                });
            }
        }
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }

    public List<Map<String, String>> getCallNodeType(String processInsId) {
        return this.taskEngineMapper.getCallNodeType(Long.parseLong(processInsId));
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        Page processPage = new Page();
        if (page == null) {
            processPage.setCurrent(1L).setSize(Integer.MAX_VALUE);
        } else {
            processPage.setCurrent(page.getCurrent()).setSize(page.getSize());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getStarter())) {
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getProcessKeyList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getProcessKey()) && processQueryByStarterDto.getProcessKey().contains(",")) {
                processQueryByStarterDto.setProcessKeyList(Arrays.asList(processQueryByStarterDto.getProcessKey().split(",")));
                processQueryByStarterDto.setProcessKey(null);
            }
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getBusinessIdList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getBusinessId()) && processQueryByStarterDto.getBusinessId().contains(",")) {
                processQueryByStarterDto.setBusinessIdList(Arrays.asList(processQueryByStarterDto.getBusinessId().split(",")));
                processQueryByStarterDto.setBusinessId(null);
            }
            List<ProcessInstVo> list = this.instanceEngineMapper.queryProcessByStarter((Page<ProcessInstVo>)processPage, processQueryByStarterDto);
            jsonObject.put("data", list);
            jsonObject.put("count", (Object)processPage.getTotal());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId, String tenantId) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return bpmResponseResult;
            }
        }
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().asc()).list();
        return this.getResult(hisTaskList, tenantId, false);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        if (HussarUtils.isEmpty((Object)processRevokeDto.getStartUserId())) {
            throw new PublicClientException(bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricProcessInstance processInstance = this.getProcessInst(processRevokeDto.getProcessInsId(), processRevokeDto.getBusinessId(), processRevokeDto.getTaskId(), true);
        if (HussarUtils.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
            throw new PublicClientException(bpmConstantProperties.getErrorCallActivityRevoke());
        }
        if (!processInstance.getStartUserId().equals(processRevokeDto.getStartUserId())) {
            throw new PublicClientException(bpmConstantProperties.getErrorStartUser());
        }
        if (!processRevokeDto.getIsForce()) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                throw new PublicClientException(bpmConstantProperties.getForbidPrcoessRevoke());
            }
        }
        this.endCallProcess(processInstance.getId(), processRevokeDto.getStartUserId(), processRevokeDto.getReason(), "revokeProcess", null, null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void multiDeleteByProcIdList(List<String> allProcId) {
        this.instanceEngineMapper.deleteHiComment(allProcId);
        this.instanceEngineMapper.deleteHiDetail(allProcId);
        this.instanceEngineMapper.deleteHiActinst(allProcId);
        this.instanceEngineMapper.deleteHiIdentityLink(allProcId);
        this.instanceEngineMapper.deleteHiTaskinst(allProcId);
        this.instanceEngineMapper.deleteHiVarinst(allProcId);
        this.instanceEngineMapper.deleteRuIdentityLink(allProcId);
        this.instanceEngineMapper.deleteRuTask(allProcId);
        this.instanceEngineMapper.deleteRuVariable(allProcId);
        this.instanceEngineMapper.deleteRuExecution(allProcId);
        this.instanceEngineMapper.deleteCcTask(allProcId);
        this.instanceEngineMapper.deleteHiLine(allProcId);
        this.instanceEngineMapper.deleteUrgeTask(allProcId);
        this.instanceEngineMapper.deleteHiProcinst(allProcId);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(String.join((CharSequence)",", allProcId));
            this.dataPushService.deleteDataPush(dataPush);
        }
    }

    public boolean updateRectification(String processInsId, String rectificationBusinessId, String originalProcessInsId) {
        Long pid = HussarUtils.isEmpty((Object)processInsId) ? Long.valueOf(Long.parseLong(processInsId)) : null;
        Long originalPid = HussarUtils.isEmpty((Object)originalProcessInsId) ? Long.valueOf(Long.parseLong(originalProcessInsId)) : null;
        return this.instanceEngineMapper.updateRectification(pid, rectificationBusinessId, originalPid, null);
    }

    public String getOriginalProcessInstId(String rectificationBusinessId) {
        String originalProcessInsId = this.instanceEngineMapper.selectOriginalProcessInstId(rectificationBusinessId);
        return HussarUtils.isEmpty((Object)originalProcessInsId) ? originalProcessInsId : null;
    }

    public BpmResponseResult getProcessExtendProperties(String processInstId, String businessKey, String taskId) {
        HistoricProcessInstance processInstance = this.getProcessInst(processInstId, businessKey, taskId, null);
        ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(processInstance.getProcessDefinitionId());
        JSONArray json = new JSONArray();
        json.add((Object)processExtendProperties);
        return InstallResult.success((JSONArray)json);
    }

    private HistoricProcessInstance getProcessInst(String processInstId, String businessKey, String taskId, Boolean isUnFinish) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInstId, businessKey, taskId})) {
            throw new PublicClientException(bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isEmpty((Object)processInstId)) {
            if (HussarUtils.isNotEmpty((Object)businessKey)) {
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (processInstance == null) {
                    throw new PublicClientException(bpmConstantProperties.getProcessNotStart());
                }
                processInstId = processInstance.getId();
            } else {
                HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                if (taskInstance == null) {
                    throw new PublicClientException(bpmConstantProperties.getTaskNotFound());
                }
                processInstId = taskInstance.getProcessInstanceId();
            }
        } else {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
            if (processInstance == null) {
                throw new PublicClientException(bpmConstantProperties.getProcessNotStart());
            }
        }
        processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
        if (isUnFinish != null) {
            if (isUnFinish.booleanValue()) {
                if (processInstance.getEndTime() != null) {
                    throw new PublicClientException(bpmConstantProperties.getProcessEnd());
                }
            } else if (processInstance.getEndTime() == null) {
                throw new PublicClientException(bpmConstantProperties.getProcessUnEnd());
            }
        }
        return processInstance;
    }

    private RealTaskId getRealTaskIdAndMandatary(String taskId) {
        if (taskId == null) {
            return new RealTaskId(null, null);
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return new RealTaskId(str[0], str[1]);
        }
        return new RealTaskId(taskId, null);
    }

    public BpmResponseResult getHistoricalApprover(String processKey, String departmentId, String userId) {
        ArrayList tasks = new ArrayList();
        String processDefId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        LambdaQueryWrapper processInstQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)processInstQueryWrapper.eq(ProcessInst::getProcessDefinitionId, (Object)processDefId)).ne(ProcessInst::getEndTime, null)).orderByDesc(ProcessInst::getStartTime);
        ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(processDefId);
        Integer isReturnHistoricalApprover = processExtendProperties.getRuleOfHiApproverAtApproval();
        if (isReturnHistoricalApprover == 1) {
            processInstQueryWrapper.eq(ProcessInst::getDepartmentId, (Object)departmentId);
        } else if (isReturnHistoricalApprover == 2) {
            processInstQueryWrapper.eq(ProcessInst::getStartUserId, (Object)userId);
        } else {
            return InstallResult.success();
        }
        List processInstances = this.processInstService.list((Wrapper)processInstQueryWrapper);
        ProcessInst recentProcessInstance = (ProcessInst)processInstances.get(0);
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(recentProcessInstance.getProcessInsId())).finished().list();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            HashMap<String, String> task = new HashMap<String, String>();
            String taskDefinitionKey = historicTaskInstance.getTaskDefinitionKey();
            String historicalApprover = historicTaskInstance.getOriginalAssignee();
            task.put("taskDefinitionKey", taskDefinitionKey);
            task.put("historicalApprover", historicalApprover);
            tasks.add(task);
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(tasks);
        return InstallResult.success((JSONArray)jsonArray);
    }

    static {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u7ed3\u6d41\u7a0b");
        TASK_SOURCE_FLAG.put("complete_leap", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revokeProcess", "\u6d41\u7a0b\u64a4\u529e");
        if (HussarUtils.isNotEmpty(bpmConstantProperties.getTaskSourceFlag())) {
            TASK_SOURCE_FLAG.putAll(bpmConstantProperties.getTaskSourceFlag());
        }
    }

    private static class RealTaskId {
        private String taskId;
        private String mandatary;

        public String getTaskId() {
            return this.taskId;
        }

        public String getMandatary() {
            return this.mandatary;
        }

        public RealTaskId(String taskId, String mandatary) {
            this.taskId = taskId;
            this.mandatary = mandatary;
        }
    }
}

