/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.dao.SysActCcTaskConfigMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class CcTaskUtil {
    private static IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ProcessDefinitionsMapper processDefinitionsMapper = (ProcessDefinitionsMapper)SpringContextHolder.getBean(ProcessDefinitionsMapper.class);
    private static SysActCcTaskConfigMapper sysActCcTaskConfigMapper = (SysActCcTaskConfigMapper)SpringContextHolder.getBean(SysActCcTaskConfigMapper.class);

    public static List<SysActCcTask> getCcTaskList(ExecutionEntity entity, List<SysActCcTaskConfig> sysActCcTaskConfigList, String sendId, String receiveId) {
        List<UserDepartmentAndPostModel> userInfoVoList;
        DefinitionModel definitionModel = processDefinitionsMapper.getById(entity.getProcessDefinition().getDeploymentId());
        String ccFormKey = HussarUtils.isNull((Object)definitionModel) ? "" : definitionModel.getCcFormKey();
        ArrayList<SysActCcTask> ccTaskList = new ArrayList<SysActCcTask>();
        List sendConfig = sysActCcTaskConfigList.stream().filter(s -> "1".equals(s.getToUserType()) && HussarUtils.isNotEmpty((Object)s.getToUserType())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(sendConfig)) {
            for (SysActCcTaskConfig sysActCcTaskConfig : sendConfig) {
                ccTaskList.add(CcTaskUtil.handlerCcTask(entity, sysActCcTaskConfig, receiveId, sendId, ccFormKey, "1", "", ""));
            }
        }
        List<SysActCcTaskConfig> postConfig = sysActCcTaskConfigList.stream().filter(s -> "0".equals(s.getToUserType()) && HussarUtils.isNotEmpty((Object)s.getToUserType())).collect(Collectors.toList());
        List organVoMap = assigneeChooseService.getAllOrgans();
        if (HussarUtils.isEmpty((Object)organVoMap)) {
            return ccTaskList;
        }
        if (HussarUtils.isNotEmpty(postConfig) && HussarUtils.isNotEmpty(userInfoVoList = CcTaskUtil.getUserInfoVos(postConfig, organVoMap))) {
            for (SysActCcTaskConfig ccTaskConfig : postConfig) {
                for (UserDepartmentAndPostModel userInfoVo : userInfoVoList) {
                    if (!ccTaskConfig.getDepartmentList().contains(userInfoVo.getDepartmentId()) || !String.valueOf(ccTaskConfig.getPostId()).equals(userInfoVo.getPostId())) continue;
                    ccTaskList.add(CcTaskUtil.handlerCcTask(entity, ccTaskConfig, userInfoVo.getUserId(), sendId, ccFormKey, userInfoVo.getUserIsMain(), userInfoVo.getPostId(), userInfoVo.getDepartmentId()));
                }
            }
        }
        return ccTaskList;
    }

    private static List<UserDepartmentAndPostModel> getUserInfoVos(List<SysActCcTaskConfig> postConfig, List<Map<String, String>> organVos) {
        ArrayList<String> allDepartmentList = new ArrayList<String>();
        for (SysActCcTaskConfig ccTaskConfig : postConfig) {
            List<String> departmentIdList;
            if (HussarUtils.isEmpty((Object)ccTaskConfig.getPostId()) || HussarUtils.isEmpty(departmentIdList = CcTaskUtil.handlerDepartmentId(ccTaskConfig.getDepartmentId(), organVos))) continue;
            ccTaskConfig.setDepartmentList(departmentIdList);
            allDepartmentList.addAll(departmentIdList);
        }
        List postIdList = postConfig.stream().map(SysActCcTaskConfig::getPostId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        if (HussarUtils.isEmpty(postIdList) || HussarUtils.isEmpty(allDepartmentList)) {
            return new ArrayList<UserDepartmentAndPostModel>();
        }
        return assigneeChooseService.getUserInfoByPost(allDepartmentList, postIdList);
    }

    public static List<SysActCcTask> getCcTaskList(SysActCcTask entity, List<SysActCcTaskConfig> sysActCcTaskConfigList, String sendId) {
        List<UserDepartmentAndPostModel> userInfoVoList;
        ArrayList<SysActCcTask> ccTaskList = new ArrayList<SysActCcTask>();
        List sendConfig = sysActCcTaskConfigList.stream().filter(s -> "1".equals(s.getToUserType()) && HussarUtils.isNotEmpty((Object)s.getToUserType())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(sendConfig)) {
            for (SysActCcTaskConfig sysActCcTaskConfig : sendConfig) {
                ccTaskList.add(CcTaskUtil.handlerCcTask(entity, sysActCcTaskConfig, sendId, sendId, "1", "", ""));
            }
        }
        List<SysActCcTaskConfig> postConfig = sysActCcTaskConfigList.stream().filter(s -> "0".equals(s.getToUserType()) && HussarUtils.isNotEmpty((Object)s.getToUserType())).collect(Collectors.toList());
        List organVoMap = assigneeChooseService.getAllOrgans();
        if (HussarUtils.isEmpty((Object)organVoMap)) {
            return ccTaskList;
        }
        if (HussarUtils.isNotEmpty(postConfig) && HussarUtils.isNotEmpty(userInfoVoList = CcTaskUtil.getUserInfoVos(postConfig, organVoMap))) {
            for (SysActCcTaskConfig ccTaskConfig : postConfig) {
                for (UserDepartmentAndPostModel userInfoVo : userInfoVoList) {
                    if (!ccTaskConfig.getDepartmentList().contains(userInfoVo.getDepartmentId()) || !String.valueOf(ccTaskConfig.getPostId()).equals(userInfoVo.getPostId())) continue;
                    ccTaskList.add(CcTaskUtil.handlerCcTask(entity, ccTaskConfig, userInfoVo.getUserId(), sendId, userInfoVo.getUserIsMain(), userInfoVo.getPostId(), userInfoVo.getDepartmentId()));
                }
            }
        }
        return ccTaskList;
    }

    private static SysActCcTask handlerCcTask(ExecutionEntity entity, SysActCcTaskConfig ccTaskConfig, String receiveUser, String sendId, String ccTaskFormKey, String isMain, String postId, String postOrganId) {
        SysActCcTask sysActCcTask = new SysActCcTask();
        sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(entity.getProcessInstanceId())));
        sysActCcTask.setProcName(entity.getProcessDefinition().getName());
        sysActCcTask.setReceiveUser(receiveUser);
        sysActCcTask.setSendUser(sendId);
        sysActCcTask.setSendTime(new Timestamp(new Date().getTime()));
        sysActCcTask.setProcDefKey(entity.getProcessDefinitionKey());
        sysActCcTask.setBusinessId(entity.getProcessBusinessKey());
        sysActCcTask.setReadStatus("0");
        sysActCcTask.setIsNeedReply(ccTaskConfig.getIsNeedReply());
        sysActCcTask.setFormKey(ccTaskFormKey);
        if ("0".equals(isMain)) {
            sysActCcTask.setPostId(postId);
            sysActCcTask.setPostOrganId(postOrganId);
        }
        return sysActCcTask;
    }

    private static SysActCcTask handlerCcTask(SysActCcTask entity, SysActCcTaskConfig ccTaskConfig, String receiveUser, String sendId, String isMain, String postId, String postOrganId) {
        Timestamp ts = new Timestamp(new Date().getTime());
        SysActCcTask sysActCcTask = new SysActCcTask();
        sysActCcTask.setProcessInsId(entity.getProcessInsId());
        sysActCcTask.setProcName(entity.getProcName());
        sysActCcTask.setReceiveUser(receiveUser);
        sysActCcTask.setSendUser(sendId);
        sysActCcTask.setSendTime(ts);
        sysActCcTask.setProcDefKey(entity.getProcDefKey());
        sysActCcTask.setBusinessId(entity.getBusinessId());
        sysActCcTask.setIsNeedReply(ccTaskConfig.getIsNeedReply());
        sysActCcTask.setFormKey(entity.getFormKey());
        sysActCcTask.setTaskDefKey(entity.getTaskDefKey());
        sysActCcTask.setIsReplySend("1");
        if ("0".equals(isMain)) {
            sysActCcTask.setPostId(postId);
            sysActCcTask.setPostOrganId(postOrganId);
        }
        return sysActCcTask;
    }

    private static List<String> handlerDepartmentId(String departmentId, List<Map<String, String>> organVos) {
        ArrayList<String> departmentIdList = new ArrayList<String>();
        if (HussarUtils.isEmpty((Object)departmentId)) {
            return departmentIdList;
        }
        String[] split = departmentId.split(",");
        departmentIdList = new ArrayList<String>(Arrays.asList(split));
        ArrayList<String> childIdList = new ArrayList<String>();
        CcTaskUtil.getAllChild(childIdList, organVos, departmentIdList);
        if (HussarUtils.isNotEmpty(childIdList)) {
            departmentIdList.addAll(childIdList);
        }
        return departmentIdList;
    }

    private static void getAllChild(List<String> childIdList, List<Map<String, String>> allOrgan, List<String> departmentIdList) {
        for (String parent : departmentIdList) {
            ArrayList<String> partChildIdList = new ArrayList<String>();
            for (Map<String, String> organ : allOrgan) {
                if (!parent.equals(String.valueOf(organ.get("PARENT_ID")))) continue;
                partChildIdList.add(String.valueOf(organ.get("ORGAN_ID")));
            }
            if (!HussarUtils.isNotEmpty(partChildIdList)) continue;
            childIdList.addAll(partChildIdList);
            CcTaskUtil.getAllChild(childIdList, allOrgan, partChildIdList);
        }
    }

    private CcTaskUtil() {
    }
}

