/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dao.SysActEntrustMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dto.ReTransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.impl.ActivityRedisTimerServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActEntrustServiceImpl
extends ServiceImpl<SysActEntrustMapper, SysActEntrust>
implements ISysActEntrustService {
    private static final Logger logger = LoggerFactory.getLogger(SysActEntrustServiceImpl.class);
    @Resource
    SysActEntrustMapper sysActEntrustMapper;
    @Resource
    ISysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;
    @Autowired
    private ActivityRedisTimerServiceImpl activityRedisTimerService;

    public ApiResponse<IPage<SysActEntrust>> initList(Page<SysActEntrust> pages, String userId, String processKey, String state, Date startTime, Date endTime) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new PublicClientException("\u7528\u6237ID\u4e3a\u7a7a");
        }
        this.queryEntrustByPage(pages, userId, processKey, state, startTime, endTime);
        return ApiResponse.success(pages);
    }

    public BpmResponseResult list(Page<SysActEntrust> pages, String userId, String processKey, String state, String startTime, String endTime) {
        Timestamp endTimeDate;
        Timestamp startTimeDate = HussarUtils.isNotEmpty((Object)startTime) ? Timestamp.valueOf(startTime) : null;
        Timestamp timestamp = endTimeDate = HussarUtils.isNotEmpty((Object)endTime) ? Timestamp.valueOf(endTime) : null;
        if (HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)"\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        this.queryEntrustByPage(pages, userId, processKey, state, startTimeDate, endTimeDate);
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)pages.getRecords());
        jsonArray.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private void queryEntrustByPage(Page<SysActEntrust> pages, String userId, String processKey, String state, Date startTime, Date endTime) {
        List sysActEntrustList = ((Page)this.sysActEntrustService.page(pages, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)userId)).eq(HussarUtils.isNotEmpty((Object)state), SysActEntrust::getState, (Object)state)).le(HussarUtils.isNotEmpty((Object)endTime), SysActEntrust::getStartTime, (Object)endTime)).ge(HussarUtils.isNotEmpty((Object)startTime), SysActEntrust::getEndTime, (Object)startTime))).getRecords();
        if (!"hussar_all_process".equals(processKey) && HussarUtils.isNotEmpty((Object)processKey)) {
            for (SysActEntrust ent : sysActEntrustList) {
                ArrayList<String> processKeyQueryList;
                ArrayList<String> processKeyList = new ArrayList<String>(Arrays.asList(ent.getProcessKey().split(",")));
                ArrayList res = new ArrayList(CollectionUtils.intersection((Collection)processKeyList, processKeyQueryList = new ArrayList<String>(Arrays.asList(processKey.split(",")))));
                if (res.size() != 0) continue;
                sysActEntrustList.remove(ent);
            }
        }
        ArrayList<String> userName = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            userName.add(sysActEntrust.getMandator());
            userName.add(sysActEntrust.getMandatary());
            ArrayList<String> processKeyList = new ArrayList<String>(Arrays.asList(sysActEntrust.getProcessKey().split(",")));
            processKeys.addAll(processKeyList);
        }
        Map userMap = this.assigneeChooseService.getUserListByUserId(userName, BaseSecurityUtil.getUser().getStringTenantId());
        Map processMap = this.modelService.selectModelNames(processKeys);
        processMap.put("hussar_all_process", "\u5168\u90e8\u6d41\u7a0b");
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            sysActEntrust.setMandatorName((String)userMap.get(sysActEntrust.getMandator()));
            sysActEntrust.setMandataryName((String)userMap.get(sysActEntrust.getMandatary()));
            ArrayList<String> processKeyList = new ArrayList<String>(Arrays.asList(sysActEntrust.getProcessKey().split(",")));
            ArrayList processNames = new ArrayList();
            for (String processkey : processKeyList) {
                processNames.add(processMap.get(processkey));
            }
            sysActEntrust.setProcessName(StringUtils.join(processNames, (String)","));
        }
    }

    public BpmResponseResult add(String processKey, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask) {
        return this.add(processKey, null, mandator, mandatary, state, startTime, endTime, isTransferTask);
    }

    public BpmResponseResult add(String processKey, String taskDefKey, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask) {
        SysActEntrust sysActEntrust = new SysActEntrust(processKey, mandator, mandatary, state, startTime, endTime);
        HashSet<String> taskDefinitionKey = null;
        if (HussarUtils.isNotEmpty((Object)taskDefKey)) {
            taskDefinitionKey = new HashSet<String>(Arrays.asList(taskDefKey.split(",")));
        }
        LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey())).lt(SysActEntrust::getStartTime, (Object)sysActEntrust.getEndTime())).gt(SysActEntrust::getEndTime, (Object)sysActEntrust.getStartTime());
        if ("1".equals(sysActEntrust.getState())) {
            ew.eq(SysActEntrust::getState, (Object)"1");
        }
        if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
            ew.in(SysActEntrust::getTaskDefinitionKey, taskDefinitionKey);
        } else {
            ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        }
        List list = this.sysActEntrustService.list((Wrapper)ew);
        if (HussarUtils.isEmpty(taskDefinitionKey)) {
            if (!list.isEmpty()) {
                return InstallResult.fail((String)this.bpmConstantProperties.getExistMandatary());
            }
            this.sysActEntrustService.save((Object)sysActEntrust.setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0"));
            if (isTransferTask) {
                this.transferTask(mandatary, mandator, processKey, taskDefinitionKey);
            }
        } else {
            HashSet<String> illegalTaskDefKey = new HashSet<String>();
            for (SysActEntrust sysActEntrust1 : list) {
                if (!taskDefinitionKey.remove(sysActEntrust1.getTaskDefinitionKey())) continue;
                illegalTaskDefKey.add(sysActEntrust1.getTaskDefinitionKey());
            }
            if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
                ArrayList<SysActEntrust> sysActEntrustList = new ArrayList<SysActEntrust>();
                for (String taskDefKeyStr : taskDefinitionKey) {
                    SysActEntrust entrust = new SysActEntrust(sysActEntrust).setTaskDefinitionKey(taskDefKeyStr).setIsTransferTask(isTransferTask ? "1" : "0");
                    sysActEntrustList.add(entrust);
                }
                this.saveBatch(sysActEntrustList);
                if (isTransferTask) {
                    this.transferTask(mandatary, mandator, processKey, taskDefinitionKey);
                }
            }
            if (HussarUtils.isNotEmpty(illegalTaskDefKey)) {
                String illegalTaskDefKeyStr = String.join((CharSequence)",", this.getTaskDefinitionName(processKey, illegalTaskDefKey).values());
                return InstallResult.fail((String)("\u8282\u70b9" + illegalTaskDefKeyStr + this.bpmConstantProperties.getActiveEntrustExist()));
            }
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public BpmResponseResult addBatch(String processKey, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask) {
        if (HussarUtils.isEmpty((Object)processKey)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HashSet<Object> processKeys = new HashSet();
        if ("hussar_all_process".equals(processKey)) {
            BpmResponseResult bpmResponseResult1 = DefinitionEngineService.queryProcess();
            JSONArray arr = bpmResponseResult1.getResult();
            for (Object obj : arr) {
                JSONObject map = JSONObject.parseObject((String)JSON.toJSONString(obj));
                processKeys.add((String)map.get("id"));
            }
            processKey = "hussar_all_process";
        } else {
            processKeys = new HashSet<String>(Arrays.asList(processKey.split(",")));
        }
        Timestamp startTimeStamp = Timestamp.valueOf(startTime);
        Timestamp endTimeStamp = Timestamp.valueOf(endTime);
        LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)mandator)).lt(SysActEntrust::getStartTime, (Object)endTimeStamp)).gt(SysActEntrust::getEndTime, (Object)startTimeStamp)).eq("1".equals(state), SysActEntrust::getState, (Object)"1")).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        List sysActEntrustList = this.list((Wrapper)ew);
        List<String> illegalProcessKey = new ArrayList();
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            if ("hussar_all_process".equals(sysActEntrust.getProcessKey())) {
                illegalProcessKey = (List)((Object)processKeys);
                break;
            }
            ArrayList<String> entrustProcessKeys = new ArrayList<String>(Arrays.asList(sysActEntrust.getProcessKey().split(",")));
            HashSet<Object> newProcessKeys = processKeys;
            for (String entrustProcessKey : entrustProcessKeys) {
                if (!newProcessKeys.remove(entrustProcessKey)) continue;
                illegalProcessKey.add(entrustProcessKey);
            }
        }
        if (HussarUtils.isNotEmpty(illegalProcessKey)) {
            Map map = this.modelService.selectModelNames(illegalProcessKey);
            String illegalProcessName = String.join((CharSequence)",", map.values());
            return InstallResult.fail((String)("\u6d41\u7a0b" + illegalProcessName + this.bpmConstantProperties.getActiveEntrustExist()));
        }
        if (HussarUtils.isNotEmpty(processKeys)) {
            SysActEntrust sysActEntrust = new SysActEntrust(processKey, mandator, mandatary, state, startTime, endTime).setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0");
            this.save(sysActEntrust);
            if (isTransferTask) {
                this.transferProcessTask(mandatary, mandator, processKeys);
            }
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public Map<String, String> queryByUsers(Collection<String> users, String processKey, int entrustType) {
        return this.queryByUsers(users, processKey, null, entrustType);
    }

    public Map<String, String> queryByUsers(Collection<String> users, String processKey, String taskDefinitionKey, int entrustType) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(formatter.format(currentTime));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<Object> newList = new ArrayList();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysActEntrust::getMandator, users)).eq(SysActEntrust::getState, (Object)"1")).le(SysActEntrust::getStartTime, (Object)date)).ge(SysActEntrust::getEndTime, (Object)date)).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process"));
        for (SysActEntrust ent : list) {
            if ("hussar_all_process".equals(ent.getProcessKey())) {
                newList = new ArrayList();
                newList.add(ent);
                break;
            }
            ArrayList<String> entrustProcessKeys = new ArrayList<String>(Arrays.asList(ent.getProcessKey().split(",")));
            if (!entrustProcessKeys.contains(processKey)) continue;
            newList.add(ent);
        }
        if (entrustType >= 0) {
            newList = newList.stream().filter(sysActEntrust -> sysActEntrust.isTaskEntrustType(entrustType)).collect(Collectors.toList());
        }
        Map<String, String> map = newList.stream().collect(Collectors.toMap(SysActEntrust::getMandator, SysActEntrust::getMandatary, (k1, k2) -> k2));
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysActEntrust::getMandator, users)).eq(HussarUtils.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey)).eq(SysActEntrust::getState, (Object)"1")).le(SysActEntrust::getStartTime, (Object)date)).ge(SysActEntrust::getEndTime, (Object)date)).eq(SysActEntrust::getTaskDefinitionKey, (Object)taskDefinitionKey));
            for (SysActEntrust sysActEntrust2 : list) {
                map.put(sysActEntrust2.getMandator(), sysActEntrust2.getMandatary());
            }
        }
        return map;
    }

    public BpmResponseResult updateState(String tEntrustId, String state) {
        SysActEntrust sysActEntrust;
        if ("1".equals(state)) {
            sysActEntrust = (SysActEntrust)this.getById(Long.valueOf(Long.parseLong(tEntrustId)));
            if (sysActEntrust == null) {
                return InstallResult.fail((String)this.bpmConstantProperties.getErrorUpdate());
            }
            LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysActEntrust::getId, (Object)Long.parseLong(tEntrustId))).eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).lt(SysActEntrust::getStartTime, (Object)sysActEntrust.getEndTime())).gt(SysActEntrust::getEndTime, (Object)sysActEntrust.getStartTime())).eq(SysActEntrust::getState, (Object)"1");
            if (!"hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)sysActEntrust.getTaskDefinitionKey());
            } else {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
            }
            List sysActEntrustList = this.list((Wrapper)ew);
            String processKeyQuery = sysActEntrust.getProcessKey();
            if ("hussar_all_process".equals(sysActEntrust.getProcessKey())) {
                BpmResponseResult bpmResponseResult1 = DefinitionEngineService.queryProcess();
                JSONArray arr = bpmResponseResult1.getResult();
                ArrayList<String> processKeyQuerys = new ArrayList<String>();
                for (Object obj : arr) {
                    JSONObject map = JSONObject.parseObject((String)JSON.toJSONString(obj));
                    processKeyQuerys.add((String)map.get("id"));
                }
                processKeyQuery = StringUtils.join(processKeyQuerys, (String)",");
            }
            for (SysActEntrust ent : sysActEntrustList) {
                ArrayList<String> processKeyQueryList;
                ArrayList<String> processKeyList = new ArrayList<String>(Arrays.asList(ent.getProcessKey().split(",")));
                ArrayList res = new ArrayList(CollectionUtils.intersection(processKeyList, processKeyQueryList = new ArrayList<String>(Arrays.asList(processKeyQuery.split(",")))));
                if (res.size() != 0) continue;
                sysActEntrustList.remove(ent);
            }
            if (HussarUtils.isNotEmpty((Object)sysActEntrustList)) {
                return InstallResult.fail((String)this.bpmConstantProperties.getActiveEntrustExist());
            }
        }
        this.sysActEntrustMapper.updateState(Long.parseLong(tEntrustId), state);
        if ("1".equals(state) && "1".equals((sysActEntrust = (SysActEntrust)this.sysActEntrustService.getById((Serializable)Long.valueOf(Long.parseLong(tEntrustId)))).getIsTransferTask())) {
            this.transferTask(sysActEntrust.getMandatary(), sysActEntrust.getMandator(), sysActEntrust.getProcessKey(), "hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey()) ? null : Collections.singletonList(sysActEntrust.getTaskDefinitionKey()));
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessUpdate());
    }

    public BpmResponseResult update(Long id, String mandatary, Date startTime, Date endTime) {
        SysActEntrust entrust = (SysActEntrust)this.getById(id);
        if (entrust == null) {
            return InstallResult.fail((String)this.bpmConstantProperties.getErrorUpdate());
        }
        if ("1".equals(entrust.getState())) {
            LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysActEntrust::getId, (Object)entrust.getId())).eq(SysActEntrust::getMandator, (Object)entrust.getMandator())).lt(SysActEntrust::getStartTime, (Object)endTime)).gt(SysActEntrust::getEndTime, (Object)startTime)).eq(SysActEntrust::getState, (Object)"1");
            if (!"hussar_all_process".equals(entrust.getTaskDefinitionKey())) {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)entrust.getTaskDefinitionKey());
            } else {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
            }
            List sysActEntrustList = this.list((Wrapper)ew);
            String processKeyQuery = entrust.getProcessKey();
            if ("hussar_all_process".equals(entrust.getProcessKey())) {
                BpmResponseResult bpmResponseResult1 = DefinitionEngineService.queryProcess();
                JSONArray arr = bpmResponseResult1.getResult();
                ArrayList<String> processKeyQuerys = new ArrayList<String>();
                for (Object obj : arr) {
                    JSONObject map = JSONObject.parseObject((String)JSON.toJSONString(obj));
                    processKeyQuerys.add((String)map.get("id"));
                }
                processKeyQuery = StringUtils.join(processKeyQuerys, (String)",");
            }
            for (SysActEntrust ent : sysActEntrustList) {
                ArrayList<String> processKeyQueryList;
                ArrayList<String> processKeyList = new ArrayList<String>(Arrays.asList(ent.getProcessKey().split(",")));
                ArrayList res = new ArrayList(CollectionUtils.intersection(processKeyList, processKeyQueryList = new ArrayList<String>(Arrays.asList(processKeyQuery.split(",")))));
                if (res.size() != 0) continue;
                sysActEntrustList.remove(ent);
            }
            if (HussarUtils.isNotEmpty((Object)sysActEntrustList)) {
                return InstallResult.fail((String)this.bpmConstantProperties.getActiveEntrustExist());
            }
        }
        SysActEntrust sysActEntrust = new SysActEntrust(id, null, null, mandatary, null, startTime, endTime);
        this.sysActEntrustService.updateById((Object)sysActEntrust);
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessUpdate());
    }

    public SysActEntrust selectById(Long id, String tenantId) {
        SysActEntrust sysActEntrust = (SysActEntrust)this.sysActEntrustMapper.selectById(id);
        ArrayList<String> userName = new ArrayList<String>();
        userName.add(sysActEntrust.getMandatary());
        sysActEntrust.setMandataryName(this.assigneeChooseService.getUserNames(userName, tenantId));
        List<String> processKeys = Arrays.asList(sysActEntrust.getProcessKey().split(","));
        Map modelNameMap = new HashMap<String, String>();
        if (processKeys.contains("hussar_all_process")) {
            modelNameMap.put("hussar_all_process", "\u5168\u90e8\u6d41\u7a0b");
        } else {
            modelNameMap = this.modelService.selectModelNames(processKeys);
        }
        if (HussarUtils.isNotEmpty(modelNameMap)) {
            ArrayList list = new ArrayList(modelNameMap.values());
            if (list.contains("hussar_all_process")) {
                sysActEntrust.setProcessName("\u5168\u90e8\u6d41\u7a0b");
            } else {
                sysActEntrust.setProcessName(StringUtils.join(list, (String)","));
            }
        }
        if (!"hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) {
            ArrayList<String> taskDefinitionKey = new ArrayList<String>();
            taskDefinitionKey.add(sysActEntrust.getTaskDefinitionKey());
            Map<String, String> taskNameMap = this.getTaskDefinitionName(sysActEntrust.getProcessKey(), taskDefinitionKey);
            sysActEntrust.setTaskDefinitionName(sysActEntrust.getTaskDefinitionKey() != null ? taskNameMap.get(sysActEntrust.getTaskDefinitionKey()) : null);
        }
        return sysActEntrust;
    }

    public SysActEntrust selectById(String id, String tenantId) {
        return this.selectById(Long.parseLong(id), tenantId);
    }

    public BpmResponseResult queryCommissionedInfo(String userId, String processKey, String mandator, Date startTime, Date endTime, String page, String size) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        Page pages = new Page(HussarUtils.isNotEmpty((Object)page) ? Long.parseLong(page) : 1L, HussarUtils.isNotEmpty((Object)size) ? Long.parseLong(size) : 10L);
        List sysActEntrustList = ((Page)this.page((IPage)pages, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandatary, (Object)userId)).eq(HussarUtils.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey)).eq(HussarUtils.isNotEmpty((Object)mandator), SysActEntrust::getMandator, (Object)mandator)).lt(HussarUtils.isNotEmpty((Object)endTime), SysActEntrust::getStartTime, (Object)endTime)).gt(HussarUtils.isNotEmpty((Object)startTime), SysActEntrust::getEndTime, (Object)startTime)).eq(SysActEntrust::getState, (Object)"1"))).getRecords();
        ArrayList<String> userName = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        HashMap<String, List<String>> taskDefinitionKey = new HashMap<String, List<String>>();
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            userName.add(sysActEntrust.getMandator());
            processKeys.add(sysActEntrust.getProcessKey());
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            if (!taskDefinitionKey.containsKey(sysActEntrust.getProcessKey())) {
                taskDefinitionKey.put(sysActEntrust.getProcessKey(), new ArrayList());
            }
            ((List)taskDefinitionKey.get(sysActEntrust.getProcessKey())).add(sysActEntrust.getTaskDefinitionKey());
        }
        Map userMap = this.assigneeChooseService.getUserListByUserId(userName, BaseSecurityUtil.getUser().getStringTenantId());
        Map processMap = this.modelService.selectModelNames(processKeys);
        Map<String, Map<String, String>> nodeMap = this.getTaskDefinitionNames(taskDefinitionKey);
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            sysActEntrust.setMandatorName((String)userMap.get(sysActEntrust.getMandator()));
            sysActEntrust.setProcessName((String)processMap.get(sysActEntrust.getProcessKey()));
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            sysActEntrust.setTaskDefinitionName(nodeMap.get(sysActEntrust.getProcessKey()).get(sysActEntrust.getTaskDefinitionKey()));
        }
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)pages.getRecords());
        jsonArray.add((Object)result);
        return InstallResult.success((JSONArray)jsonArray);
    }

    private void transferTask(String userId, String mandator, String processKey, Collection<String> taskDefKey) {
        ArrayList<String> taskIds = new ArrayList<String>(this.sysActEntrustMapper.getTransferTask(mandator, processKey, taskDefKey));
        this.sysActEntrustMapper.transferTask(userId, mandator, processKey, taskDefKey);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKey(processKey)).list();
        tasks.removeIf(task -> !taskDefKey.contains(task.getTaskDefinitionKey()));
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (Task task : tasks) {
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                taskEntity.setAssignee(null);
                ((TaskEntity)task).addCandidateUser(userId, mandator, "1", null);
                taskIds.add(task.getId());
            }
            return null;
        });
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).eq(SysActUrgeTask::getProcDefKey, (Object)processKey)).in(HussarUtils.isNotEmpty(taskDefKey), SysActUrgeTask::getTaskDefKey, taskDefKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
        taskIds.forEach(taskId -> this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
        if (this.dataPushService.isDataPush()) {
            this.dataPushService.transferTask(new DataPush().setTaskIds(taskIds).setUserId(userId).setConsignor(mandator).setTaskState("1").setTenantId(BaseSecurityUtil.getUser().getStringTenantId()));
        }
    }

    private void transferProcessTask(String userId, String mandator, Collection<String> processKey) {
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        ArrayList<String> taskIds = new ArrayList<String>(this.sysActEntrustMapper.getTransferProcessTask(mandator, processKey));
        this.sysActEntrustMapper.transferProcessTask(userId, mandator, processKey);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKeyIn(new ArrayList<String>(processKey))).list();
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (Task task : tasks) {
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                taskEntity.setAssignee(null);
                ((TaskEntity)task).addCandidateUser(userId, mandator, "1");
                taskIds.add(task.getId());
            }
            return null;
        });
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).in(SysActUrgeTask::getProcDefKey, processKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
        taskIds.forEach(taskId -> this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
        if (this.dataPushService.isDataPush()) {
            this.dataPushService.transferTask(new DataPush().setTaskIds(taskIds).setUserId(userId).setConsignor(mandator).setTaskState("1").setTenantId(BaseSecurityUtil.getUser().getStringTenantId()));
        }
    }

    public BpmResponseResult reTransferTask(ReTransferTaskDto reTransferTaskDto) {
        if (HussarUtils.isEmpty((Object)reTransferTaskDto.getTaskIds()) || HussarUtils.isEmpty((Object)reTransferTaskDto.getUserId())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        String userId = reTransferTaskDto.getUserId();
        List<String> taskIds = Arrays.stream(reTransferTaskDto.getTaskIds().split(",")).map(o -> o.split(":")[0]).collect(Collectors.toList());
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (String taskId : taskIds) {
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(taskId);
                taskEntity.getCandidates().forEach(identityLink -> {
                    if (userId.equals(identityLink.getMandator())) {
                        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, identityLink.getUserId(), 1);
                    }
                });
            }
            return null;
        });
        this.sysActEntrustMapper.reTransferTask(taskIds, reTransferTaskDto.getUserId());
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, null)).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, null)).in(SysActUrgeTask::getTaskId, taskIds));
        if (this.dataPushService.isDataPush()) {
            this.dataPushService.reTransferTask(new DataPush().setTaskIds(taskIds).setUserId(userId).setTaskState("1").setTenantId(BaseSecurityUtil.getUser().getStringTenantId()));
        }
        return InstallResult.success();
    }

    private Map<String, String> getTaskDefinitionName(String processKey, Collection<String> taskDefinitionKey) {
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        HashMap<String, String> map = new HashMap<String, String>();
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof UserTask && taskDefinitionKey.contains(flowElement.getId())) {
                    map.put(flowElement.getId(), flowElement.getName());
                    continue;
                }
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof UserTask) || !taskDefinitionKey.contains(element.getId())) continue;
                    map.put(element.getId(), element.getName());
                }
            }
        }
        return map;
    }

    private Map<String, Map<String, String>> getTaskDefinitionNames(Map<String, List<String>> taskDefinitionKey) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<String>> entry : taskDefinitionKey.entrySet()) {
            map.put(entry.getKey(), this.getTaskDefinitionName(entry.getKey(), (Collection<String>)entry.getValue()));
        }
        return map;
    }

    private void removeEntrustList(List<SysActEntrust> sysActEntrustList, String entrustType) {
        String entrustTypeRegex = "^" + entrustType.replaceAll("0.*$", ".*").replace('0', '.') + "$";
        sysActEntrustList.removeIf(sysActEntrust -> sysActEntrust.getEntrustTaskType() == null ? entrustType.charAt(0) != '1' : sysActEntrust.getEntrustTaskType().matches(entrustTypeRegex));
    }
}

