/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.archive.provider.ArchiveReadonlyContext;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceMetadata;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceProvider;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceResult;
import com.jxdinfo.hussar.archive.provider.ArchiveWritableContext;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.DumpAndLoadMetadata;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.DumpAndLoadResultVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysBpmService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DumpAndLoadServiceImpl
implements ArchiveServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DumpAndLoadServiceImpl.class);
    private static final DumpAndLoadMetadata METADATA = new DumpAndLoadMetadata();
    @Resource
    private SysBpmService sysBpmService;
    @Resource
    private ModelService modelService;

    public ArchiveServiceMetadata metadata() {
        return METADATA;
    }

    public ArchiveServiceResult<Object> dump(ArchiveWritableContext context, Map<String, Object> parameters) {
        DumpAndLoadResultVo resultVo = new DumpAndLoadResultVo();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Map workflowInfo = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)entry.getValue()), Map.class);
            String fileName = (String)workflowInfo.get("name");
            String key = entry.getKey();
            HashMap fileInfo = new HashMap();
            fileInfo.put("version", workflowInfo.get("version"));
            fileInfo.put("name", workflowInfo.get("name"));
            fileInfo.put("myKey", entry.getKey());
            List<String> keys = Arrays.asList(entry.getKey());
            String table = workflowInfo.get("table").toString();
            if (table.contains("auth")) {
                List sysActExtendProperties = this.sysBpmService.actExtendPropertiesExportData(keys);
                context.setPayloadOfByteArray(fileName + "-" + key + "/" + fileName + key + "-\u62d3\u5c55.json", JsonUtil.toJsonAsBytes((Object)sysActExtendProperties));
                Map fileModel = this.modelService.exportAllFileModel(workflowInfo.get("tenantId").toString(), entry.getKey(), Integer.parseInt(workflowInfo.get("version").toString()));
                if (ToolUtil.isNotEmpty((Object)fileModel)) {
                    context.setPayloadOfByteArray(fileName + "-" + key + "/" + fileName + key + ".bpmn20.xml", (byte[])fileModel.get("xml"));
                    context.setPayloadOfByteArray(fileName + "-" + key + "/" + fileName + key + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", JsonUtil.toJsonAsBytes(fileModel.get("file")));
                }
            }
            if (table.contains("assignee")) {
                List sysActAssignees = this.sysBpmService.actAssigneeExportData(keys);
                context.setPayloadOfByteArray(fileName + "-" + key + "/" + fileName + key + "-\u53c2\u4e0e\u8005.json", JsonUtil.toJsonAsBytes((Object)sysActAssignees));
            }
            if (table.contains("export")) {
                List sysActFormAuths = this.sysBpmService.actFormAuthExportData(keys);
                context.setPayloadOfByteArray(fileName + "-" + key + "/" + fileName + key + "-\u6743\u9650.json", JsonUtil.toJsonAsBytes((Object)sysActFormAuths));
            }
            context.setAttribute(entry.getKey(), fileInfo);
        }
        context.setVersion(METADATA.getVersion());
        resultVo.setConflicted(Boolean.valueOf(true));
        resultVo.setMessage("\u5bfc\u51fa\u6587\u4ef6\u6210\u529f");
        return ArchiveServiceResult.success((Object)resultVo);
    }

    public ArchiveServiceResult<Object> preload(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        DumpAndLoadResultVo resultVo = new DumpAndLoadResultVo();
        if (!context.getVersion().equals(METADATA.getVersion())) {
            logger.error("\u7a0b\u5e8f\u7248\u672c\u53f7\u4e0d\u4e00\u81f4\uff0c\u5f53\u524d\u7248\u672c {}", (Object)METADATA.getVersion());
            resultVo.setConflicted(Boolean.valueOf(false));
            resultVo.setMessage("\u7a0b\u5e8f\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
            return ArchiveServiceResult.fail((Object)resultVo);
        }
        if (ToolUtil.isEmpty((Object)context.getPayloadList())) {
            logger.error("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
            resultVo.setConflicted(Boolean.valueOf(false));
            resultVo.setMessage("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
            return ArchiveServiceResult.fail((Object)resultVo);
        }
        resultVo.setConflicted(Boolean.valueOf(true));
        resultVo.setMessage("\u5bfc\u5165\u6821\u9a8c\u901a\u8fc7");
        return ArchiveServiceResult.success((Object)resultVo);
    }

    public ArchiveServiceResult<Object> load(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        DumpAndLoadResultVo resultVo = new DumpAndLoadResultVo();
        List payloadList = context.getPayloadList();
        ArrayList auth = new ArrayList();
        ArrayList assignee = new ArrayList();
        ArrayList export = new ArrayList();
        HashMap fileMap = new HashMap();
        Boolean hasFile = false;
        try {
            for (String string : payloadList) {
                if (string.contains("-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                    hasFile = true;
                }
                if (string.contains("-\u6743\u9650.json")) {
                    List sysActFormAuths = (List)JsonUtil.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActFormAuth>>(){});
                    if (sysActFormAuths == null) {
                        logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                        resultVo.setConflicted(Boolean.valueOf(false));
                        resultVo.setMessage(string + "\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                        return ArchiveServiceResult.fail((Object)resultVo);
                    }
                    auth.addAll(sysActFormAuths);
                }
                if (string.contains("-\u53c2\u4e0e\u8005.json")) {
                    List sysActAssignees = (List)JsonUtil.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActAssignee>>(){});
                    if (sysActAssignees == null) {
                        logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                        resultVo.setConflicted(Boolean.valueOf(false));
                        resultVo.setMessage(string + "\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                        return ArchiveServiceResult.fail((Object)resultVo);
                    }
                    assignee.addAll(sysActAssignees);
                }
                if (!string.contains("-\u62d3\u5c55.json")) continue;
                List sysActExtendProperties = (List)JsonUtil.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActExtendProperties>>(){});
                if (sysActExtendProperties == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                    resultVo.setConflicted(Boolean.valueOf(false));
                    resultVo.setMessage(string + "\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                    return ArchiveServiceResult.fail((Object)resultVo);
                }
                export.addAll(sysActExtendProperties);
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        if (auth.size() > 0) {
            this.sysBpmService.actFormAuthBatchImport(auth);
        }
        if (assignee.size() > 0) {
            this.sysBpmService.actAssigneeBatchImport(assignee);
        }
        if (export.size() > 0) {
            this.sysBpmService.actExtendPropertiesImport(export);
        }
        if (hasFile.booleanValue()) {
            for (Map.Entry entry : parameters.entrySet()) {
                Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(entry.getValue()), Map.class);
                Boolean isOverride = Integer.parseInt(map.get("version").toString()) > 0 && "OverrideImport".equals(map.get("importType"));
                HashMap temp = new HashMap();
                fileMap.put(entry.getKey(), temp);
                for (String fileName : payloadList) {
                    if (fileName.contains((String)entry.getKey() + ".bpmn20.xml")) {
                        ((Map)fileMap.get(entry.getKey())).put("xml", context.getPayloadAsString(fileName));
                    }
                    if (!fileName.contains((String)entry.getKey() + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) continue;
                    ((Map)fileMap.get(entry.getKey())).put("lcdpbpm", context.getPayloadAsString(fileName));
                }
                this.modelService.importModel(String.valueOf(map.get("tenantId")), (String)((Map)fileMap.get(entry.getKey())).get("xml"), (String)((Map)fileMap.get(entry.getKey())).get("lcdpbpm"), isOverride);
            }
        }
        resultVo.setConflicted(Boolean.valueOf(true));
        resultVo.setMessage("\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        return ArchiveServiceResult.success((Object)resultVo);
    }
}

