/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class EntrustAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.addCandidateUser(this.mandatary);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
        } else {
            if (this.isSame) {
                taskEntity.deleteCandidateUser(this.userId);
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, null);
                return null;
            }
            Set identityLinks = taskEntity.getCandidates();
            if (HussarUtils.isNotEmpty((Object)this.userId)) {
                taskEntity.deleteCandidateUser(this.userId);
                taskEntity.addCandidateUsers(Arrays.asList(this.mandatary.split(",")));
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
            } else {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.mandatary.split(",")));
                ArrayList<String> currentUsers = new ArrayList<String>();
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId());
                    currentUsers.add(identityLink.getUserId());
                }
                if (!users.isEmpty()) {
                    taskEntity.addCandidateUsers(users);
                    if (this.isAdd) {
                        this.dataPushService.addUserDataPush((Task)taskEntity, String.join((CharSequence)",", users));
                    } else {
                        this.dataPushService.entrustDataPush((Task)taskEntity, String.join((CharSequence)",", currentUsers), String.join((CharSequence)",", users));
                    }
                }
            }
        }
        return null;
    }
}

