/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.Task;

public class ChildTaskCreateCmd
extends NeedsActiveTaskCmd<Task> {
    protected String assistInitiator;
    protected String taskType;
    protected Set<String> userIds;
    protected Map<String, Object> map;
    protected String comment;
    protected ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);

    public Task execute(CommandContext commandContext, TaskEntity parentTask) {
        this.authentication(parentTask);
        new AddHistoryTaskCmd(parentTask, this.comment, this.assistInitiator, "assist"){

            @Override
            protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
                TaskEntity taskEntity = super.initTask(commandContext, task, execution);
                taskEntity.setTaskType(ChildTaskCreateCmd.this.taskType);
                return taskEntity;
            }
        }.execute(commandContext);
        TaskEntity task = TaskEntity.createAndInsert((ActivityExecution)parentTask.getExecution());
        task.setExecutionId(parentTask.getExecutionId());
        task.setParentTaskId(parentTask.getId());
        task.setTaskType(this.taskType);
        task.setProcessDefinitionId(parentTask.getProcessDefinitionId());
        task.setTaskDefinitionKey(parentTask.getTaskDefinitionKey());
        task.setProcessInstanceId(parentTask.getProcessInstanceId());
        task.setFormKey(parentTask.getFormKey());
        task.setTenantId(parentTask.getTenantId());
        task.setName(parentTask.getName());
        if (this.map != null) {
            task.setVariablesLocal(this.map);
        }
        task.setSubProcessKey(parentTask.getSubProcessKey());
        task.setVariableLocal("sendUser", (Object)this.assistInitiator);
        task.setVariableLocal("todoConfiguration", task.getVariableLocal("todoConfiguration"));
        Map userMap = this.sysActEntrustService.queryByUsers(this.userIds, task.getProcessDefinitionId().split(":")[0], task.getTaskDefinitionKey(), 1);
        for (String userId : this.userIds) {
            if (userMap.containsKey(userId)) {
                task.addCandidateUser((String)userMap.get(userId), userId, "1", this.assistInitiator);
                continue;
            }
            task.addCandidateUser(userId, null, null, this.assistInitiator);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        return task;
    }

    private void authentication(TaskEntity task) {
        if (HussarUtils.equals((Object)this.taskType, (Object)"2")) {
            List childTask;
            List identityLinkEntityList;
            if (this.userIds.contains(this.assistInitiator)) {
                throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u81ea\u5df1\u4e3a\u534f\u529e\u4eba");
            }
            if (task.getExecution().getActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
                List tasks = task.getExecution().getSuperExecution().getTasks();
                for (TaskEntity taskEntity : tasks) {
                    if (taskEntity.getTaskType() != null) continue;
                    if (taskEntity.getAssignee() != null && this.userIds.contains(taskEntity.getAssignee())) {
                        throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                    }
                    identityLinkEntityList = taskEntity.getIdentityLinks();
                    if (identityLinkEntityList == null) continue;
                    for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                        if (!this.userIds.contains(identityLink.getUserId())) continue;
                        throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                    }
                }
            } else {
                List identityLinkEntityList2 = task.getIdentityLinks();
                for (IdentityLinkEntity identityLink : identityLinkEntityList2) {
                    if (!this.userIds.contains(identityLink.getUserId())) continue;
                    throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                }
            }
            if ((childTask = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(this.taskId)) != null && !childTask.isEmpty()) {
                for (TaskEntity taskEntity : childTask) {
                    if (!"2".equals(taskEntity.getTaskType())) continue;
                    identityLinkEntityList = taskEntity.getIdentityLinks();
                    for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                        if (!this.userIds.contains(identityLink.getUserId()) || !this.assistInitiator.equals(identityLink.getAssistInitiator())) continue;
                        throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5df2\u6709\u534f\u529e\u4eba\u4e3a\u534f\u529e\u4eba");
                    }
                }
            }
        }
    }

    public ChildTaskCreateCmd(String taskId, String assistInitiator, Set<String> userIds, String comment, String taskType) {
        super(taskId);
        this.assistInitiator = assistInitiator;
        this.taskType = taskType;
        this.userIds = userIds;
        this.comment = comment;
    }

    public ChildTaskCreateCmd(String taskId, String assistInitiator, Map<String, Object> map, String comment, Set<String> userIds, String taskType) {
        super(taskId);
        this.assistInitiator = assistInitiator;
        this.taskType = taskType;
        this.userIds = userIds;
        this.map = map;
        this.comment = comment;
    }
}

