/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.UpdateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.UpdateStateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u59d4\u6258\u7ba1\u7406"})
@RequestMapping(value={"/bpm/entrust"})
public class EntrustListController {
    @Autowired
    IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u59d4\u6258\u67e5\u8be2", notes="\u59d4\u6258\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u59d4\u6258\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysActEntrust>> initList(Page<SysActEntrust> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        return this.sysActEntrustService.initList(pages, userId, processKey);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u59d4\u6258", notes="\u6dfb\u52a0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u6dfb\u52a0\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> saveEntrust(@RequestBody SaveEntrustDto saveEntrustDto) {
        List processKey = saveEntrustDto.getProcessKey();
        String mandator = String.valueOf(BaseSecurityUtil.getUser().getId());
        String mandatary = saveEntrustDto.getMandatary();
        String state = "1";
        String startTime = String.valueOf(saveEntrustDto.getStartTime()).concat(" 00:00:00");
        String endTime = String.valueOf(saveEntrustDto.getEndTime()).concat(" 23:59:59");
        return this.sysActEntrustService.saveEntrust(processKey, mandator, mandatary, state, startTime, endTime);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u59d4\u6258", notes="\u5220\u9664\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u5220\u9664\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteEntrust(@RequestBody String tEntrustId) {
        this.sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return ApiResponse.success((String)this.bpmConstantProperties.getDeleteSuccess());
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u770b\u59d4\u6258\u8be6\u60c5", notes="\u67e5\u770b\u59d4\u6258\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u67e5\u770b\u59d4\u6258\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysActEntrust> detailEntrust(String tEntrustId) {
        return ApiResponse.success((Object)this.sysActEntrustService.selectById(tEntrustId, BaseSecurityUtil.getUser().getStringTenantId()));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258", notes="\u66f4\u65b0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u66f4\u65b0\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateEntrust(@RequestBody UpdateEntrustDto updateEntrustDto) {
        updateEntrustDto.setEndTime(Timestamp.valueOf(String.valueOf(updateEntrustDto.getEndTime()).replace(" 00:00:00", " 23:59:59")));
        try {
            this.sysActEntrustService.updateById((Object)updateEntrustDto);
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    @PostMapping(value={"/updateState"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258\u72b6\u6001", notes="\u66f4\u65b0\u59d4\u6258\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u66f4\u65b0\u59d4\u6258\u72b6\u6001", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateStateEntrust(@RequestBody UpdateStateEntrustDto updateStateEntrustDto) {
        String tEntrustId = updateStateEntrustDto.getId() == null ? null : updateStateEntrustDto.getId().toString();
        String state = "";
        state = "1".equals(String.valueOf(updateStateEntrustDto.getState())) ? "0" : "1";
        this.sysActEntrustService.updateState(tEntrustId, state);
        if ("1".equals(state)) {
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessStart());
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getSuccessStop());
    }

    @GetMapping(value={"/user"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7528\u6237\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> userTree(@RequestParam String id) {
        return ApiResponse.success((Object)this.assigneeChooseService.userTree(id, null, false, false));
    }

    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b", notes="\u67e5\u8be2\u6d41\u7a0b")
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((Object)bpmResponseResult);
        }
        return ApiResponse.success((String)"");
    }
}

