/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActUrgeTaskServiceImpl
extends ServiceImpl<SysActUrgeTaskMapper, SysActUrgeTask>
implements ISysActUrgeTaskService {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private HistoryService historyService;

    public ApiResponse<IPage<SysActUrgeTask>> query(Page<SysActUrgeTask> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List<SysActUrgeTask> sysActUrgeTasks = this.sysActUrgeTaskMapper.query(pages, userId, processKey, sendUser, start, end);
        if (sysActUrgeTasks != null && sysActUrgeTasks.size() > 0) {
            List users = sysActUrgeTasks.stream().map(SysActUrgeTask::getSendUser).collect(Collectors.toList());
            Map map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            for (SysActUrgeTask sysActUrgeTask : sysActUrgeTasks) {
                String userName = (String)map.get(sysActUrgeTask.getSendUser());
                sysActUrgeTask.setSendUserName(userName);
                String formKey = sysActUrgeTask.getFormKey();
                if (!ToolUtil.isNotEmpty((Object)formKey)) continue;
                JSONObject object = JSON.parseObject((String)formKey);
                sysActUrgeTask.setWeb(object.getString("web"));
                sysActUrgeTask.setMobile(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActUrgeTasks);
        return ApiResponse.success(pages);
    }

    public String urgeTask(String processInsId, String userId) {
        Set<String> users;
        if (ToolUtil.isEmpty((Object)processInsId)) {
            return this.bpmConstantProperties.getProcessInsIdNull();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return this.bpmConstantProperties.getProcessEndUrgeFail();
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            users = this.getAssigneeByTaskId(task.getId());
            if (users.size() <= 0) continue;
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcessInsId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.saveBatch(list);
            for (Task task : tasks) {
                users = this.getAssigneeByTaskId(task.getId());
                if (users.size() <= 0 || !this.dataPushService.isDataPush()) continue;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setTenantId(task.getTenantId());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    public String urgeTaskByTaskId(String taskId, String userId) {
        Task task = this.taskEngineService.getTask(taskId, "1");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Set<String> users = this.getAssigneeByTaskId(task.getId());
        if (users.size() > 0) {
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcessInsId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.saveBatch(list);
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

