/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GodAxeModelServiceImpl
implements GodAxeModelService {
    private static final Logger logger = LoggerFactory.getLogger(GodAxeModelServiceImpl.class);
    private static final String USERTASK_NAME = "com.jxdinfo.workflow.User";
    private Bpm2XMLService bpm2XMLService;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private BpmConstantProperties bpmConstantProperties;
    private ModelService modelService;
    private SysActProcessFileService sysActProcessFileService;
    private ProcessDefinitionsService processDefinitionsService;
    private ITaskEngineService taskEngineService;
    private LcdpBpmProperties lcdpBpmProperties;
    private SysActAssigneeService sysActAssigneeService;
    private SysActFormAuthService sysActFormAuthService;

    @Autowired
    public GodAxeModelServiceImpl(Bpm2XMLService bpm2XMLService, ModelService modelService, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ProcessDefinitionsService processDefinitionsService, ISysActExtendPropertiesService iSysActExtendPropertiesService, ITaskEngineService iTaskEngineService, LcdpBpmProperties lcdpBpmProperties, SysActAssigneeService sysActAssigneeService, SysActFormAuthService sysActFormAuthService) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.processDefinitionsService = processDefinitionsService;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.taskEngineService = iTaskEngineService;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.sysActAssigneeService = sysActAssigneeService;
        this.sysActFormAuthService = sysActFormAuthService;
    }

    public ApiResponse<String> saveAndPublish(WorkFlow workFlow, String tenantId, boolean isOverride) {
        return this.saveWorkflow(workFlow, tenantId, true, isOverride);
    }

    public void saveAssignee(WorkFlow workFlow) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            String identityKey = workFlow.getIdentity();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            if (HussarUtils.isEmpty((Object)flowModel.getSlots())) {
                return;
            }
            List flowObjects = flowModel.getSlots().getElement() != null ? flowModel.getSlots().getElement() : new ArrayList();
            ArrayList<SysActAssignee> list = new ArrayList<SysActAssignee>();
            for (FlowObject flowObject : flowObjects) {
                if (!USERTASK_NAME.equals(flowObject.getName())) continue;
                List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
                HashMap<String, String> functionMap = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)flowFunctionConfigs)) {
                    Iterator iterator = flowFunctionConfigs.iterator();
                    while (iterator.hasNext()) {
                        FlowFunctionConfig flowFunctionConfig = (FlowFunctionConfig)iterator.next();
                        functionMap.put(flowFunctionConfig.getId(), flowFunctionConfig.getValue().substring(2, flowFunctionConfig.getValue().length() - 2));
                    }
                }
                SysActAssignee assigneeModel = new SysActAssignee();
                assigneeModel.setProcDefKey(identityKey);
                assigneeModel.setContentType("assign_model");
                assigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                assigneeModel.setContent(JSON.toJSONString((Object)flowObject.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                list.add(assigneeModel);
                SysActAssignee ccAssigneeModel = new SysActAssignee();
                ccAssigneeModel.setProcDefKey(identityKey);
                ccAssigneeModel.setContentType("cc_assign_model");
                ccAssigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                ccAssigneeModel.setContent(JSON.toJSONString((Object)flowObject.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                list.add(ccAssigneeModel);
                SysActAssignee modelAssignee = new SysActAssignee();
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setContentType("defaultAssign");
                modelAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String assignee = flowObject.getProps().getFlowAssignment().getDefaultBackCondtion();
                if (HussarUtils.isNotEmpty((Object)assignee)) {
                    for (Map.Entry entry : functionMap.entrySet()) {
                        assignee = assignee.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                }
                modelAssignee.setContent(assignee == null ? "".getBytes(StandardCharsets.UTF_8) : assignee.getBytes(StandardCharsets.UTF_8));
                list.add(modelAssignee);
                SysActAssignee conditionAssignee = new SysActAssignee();
                conditionAssignee.setProcDefKey(identityKey);
                conditionAssignee.setContentType("conditionAssign");
                conditionAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeBackConditions = flowObject.getProps().getFlowAssignment().getJudgeBackCondition();
                String condAssignee = null;
                if (HussarUtils.isNotEmpty((Object)judgeBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    condAssignee = JSON.toJSONString(condition);
                    if (HussarUtils.isNotEmpty((Object)condAssignee)) {
                        for (Map.Entry entry : functionMap.entrySet()) {
                            condAssignee = condAssignee.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                    }
                }
                conditionAssignee.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                list.add(conditionAssignee);
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCcAssign");
                ccAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String ccAssigneeValue = flowObject.getProps().getFlowRecipients().getDefaultCcCondtion();
                if (HussarUtils.isNotEmpty((Object)ccAssigneeValue)) {
                    for (Map.Entry entry2 : functionMap.entrySet()) {
                        ccAssigneeValue = ccAssigneeValue.replace((CharSequence)entry2.getKey(), (CharSequence)entry2.getValue());
                    }
                }
                ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccAssignee);
                SysActAssignee sysActAssignee = new SysActAssignee();
                sysActAssignee.setProcDefKey(identityKey);
                sysActAssignee.setContentType("conditionCcAssign");
                sysActAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeCcBackConditions = flowObject.getProps().getFlowRecipients().getJudgeCcCondition();
                String ccConditionAssigneeValue = null;
                if (HussarUtils.isNotEmpty((Object)judgeCcBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeCcBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    ccConditionAssigneeValue = JSON.toJSONString(condition);
                    if (HussarUtils.isNotEmpty((Object)ccConditionAssigneeValue)) {
                        for (Map.Entry entry : functionMap.entrySet()) {
                            ccConditionAssigneeValue = ccConditionAssigneeValue.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                    }
                }
                sysActAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(sysActAssignee);
            }
            ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
            QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
            for (SysActAssignee sysActAssignee : list) {
                String procDefKey = sysActAssignee.getProcDefKey();
                String taskDefKey = sysActAssignee.getTaskDefKey();
                String contentType = sysActAssignee.getContentType();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey)).eq((Object)"CONTENT_TYPE", (Object)contentType);
            }
            List sameList = queryWrapper.list();
            ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
            for (SysActAssignee sysActAssignee : list) {
                boolean isadd = true;
                for (SysActAssignee actAssignee : sameList) {
                    if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                    sysActAssignee.setId(actAssignee.getId());
                    updateList.add(sysActAssignee);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActAssignee);
            }
            this.sysActAssigneeService.updateBatchById(updateList);
            this.sysActAssigneeService.saveBatch(addList);
        }
    }

    public synchronized ApiResponse<String> saveWorkflow(WorkFlow workFlow, String tenantId, boolean isPublish, boolean isOverride) {
        try {
            if (!isPublish) {
                this.saveAssignee(workFlow);
                return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getSuccessSave());
            }
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
            if (!isOverride && oldWorkFlow != null && workFlow.getVersion() != null && Integer.parseInt(workFlow.getVersion()) < Integer.parseInt(oldWorkFlow.getVersion())) {
                return ApiResponse.fail((int)10010, (String)"\u7248\u672c\u4e0d\u4e00\u81f4");
            }
            List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
            if (baseList.size() == 2 && oldWorkFlow != null) {
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            } else {
                String id = this.modelService.getIdByIdentity(workFlow.getIdentity());
                if (HussarUtils.isNotEmpty((Object)id)) {
                    return ApiResponse.fail((String)this.bpmConstantProperties.getSameIdentity());
                }
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
            }
            String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
            if (HussarUtils.isEmpty((Object)modelId)) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrorSave());
            }
            if (HussarUtils.isEmpty((Object)oldWorkFlow) || HussarUtils.isEmpty((Object)oldWorkFlow.getModelId())) {
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            String processId = this.modelService.deployModel(modelId, tenantId);
            return ApiResponse.success((Object)"", (String)processId);
        }
        catch (BpmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    public ApiResponse<String> deleteModel(String identity, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identity, tenantId, Integer.valueOf(0));
        String modelId = workFlow.getModelId();
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            this.repositoryService.deleteModel(modelId);
        }
        return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getDeleteSuccess());
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (variables != null) {
            for (Map.Entry<String, Object> vo : variables.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processKey, businessId, userId, map, tenantId);
    }

    public ApiResponse<String> updateMeta(String identity, String name, String category, String tenantId) {
        try {
            if (this.modelService.updateCategory(identity, category) > 0) {
                this.sysActProcessFileService.updateMetaByIdentity(identity, name, category, tenantId);
            }
            return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public synchronized ApiResponse<String> updateProcess(WorkFlow workFlow, String tenantId) {
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                String processDefId = workFlow.getIdentity();
                try {
                    processDefId = this.processDefinitionsService.getMainOrNew(workFlow.getIdentity()).getId();
                }
                catch (PublicClientException publicClientException) {
                    // empty catch block
                }
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(workFlow.getIdentity(), processDefId, tenantId);
                workFlow.setModelId(oldWorkFlow.getModelId());
                Map<String, Object> nodeMessage = this.getRejectFromList(workFlow, oldWorkFlow);
                Map delNodeName = (Map)nodeMessage.get("delNodeName");
                Map result = this.taskEngineService.updateRejectForm(nodeMessage);
                Integer numAll = (Integer)result.get("");
                if (numAll == null) {
                    this.sysActProcessFileService.updateFile(workFlow, tenantId);
                    String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                    this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId, false);
                    this.saveModelExtendProperties(modelId, workFlow.getName());
                    return ApiResponse.success((Object)"", (String)BpmEnum.SUCCESS_SAVE.getMessage());
                }
                result.remove("");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u672c\u6b21\u5fae\u8c03\u5f71\u54cd\u4e86").append(numAll).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c.\u5176\u4e2d\uff1a");
                for (Map.Entry entry : result.entrySet()) {
                    stringBuilder.append("\u5220\u9664\u8282\u70b9\u540d\u4e3a").append(entry.getValue()).append("\u7684\u8282\u70b9\u5f71\u54cd\u4e86");
                    stringBuilder.append(entry.getValue()).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                String message = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1) + ".";
                return ApiResponse.fail((String)message);
            }
            return ApiResponse.fail((String)BpmEnum.MODEL_NOT_FOUND.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private Map<String, Object> getRejectFromList(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            if (!USERTASK_NAME.equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
            nodeIds.add(flowObject.getId());
        }
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        List oldElements = oldFlowModel.getSlots().getElement();
        ArrayList<String> delNodeIds = new ArrayList<String>();
        HashMap<String, String> delNodeName = new HashMap<String, String>();
        for (FlowObject flowObject : oldElements) {
            if (!USERTASK_NAME.equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName()) || nodeIds.contains(flowObject.getId())) continue;
            delNodeIds.add(flowObject.getId());
            delNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
        }
        map.put("delNodeName", delNodeName);
        map.put("delNodeIds", delNodeIds);
        map.put("nodeIds", nodeIds);
        map.put("procDefId", this.bpm2XMLService.getActDefIdByModelId(workFlow.getModelId()));
        return map;
    }

    private void saveModelExtendProperties(String modelId, String name) {
        ModelBuild modelBuild = this.modelService.queryModel(modelId);
        if (modelBuild != null) {
            String procDefId = modelBuild.getProcessDefinitionId();
            this.processDefinitionsService.updateProcessName(procDefId, name);
            BpmnModel model = this.repositoryService.getBpmnModel(procDefId);
            ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
            if (model != null) {
                Collection flowElements = model.getMainProcess().getFlowElements();
                for (FlowElement node : flowElements) {
                    if (!(node instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    JSONObject object = new JSONObject();
                    if (!HussarUtils.isNotEmpty((Object)formDetailKey)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                    if (jsonObject != null) {
                        for (String key : jsonObject.keySet()) {
                            object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)object));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
            if (!sysActExtendProperties.isEmpty()) {
                ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
                ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
                QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
                for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                    String getProcDefId = sysActExtendProperty.getProcDefId();
                    String taskDefKey = sysActExtendProperty.getTaskDefKey();
                    queryWrapper = (QueryChainWrapper)queryWrapper.or();
                    queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)getProcDefId)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
                }
                List sameList = queryWrapper.list();
                for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                    boolean isadd = true;
                    for (SysActExtendProperties actExtendProperties : sameList) {
                        if (!sysActExtendProperty.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperty.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                        sysActExtendProperty.setId(actExtendProperties.getId());
                        updateList.add(sysActExtendProperty);
                        isadd = false;
                        break;
                    }
                    if (!isadd) continue;
                    addList.add(sysActExtendProperty);
                }
                this.iSysActExtendPropertiesService.saveBatch(addList);
                this.iSysActExtendPropertiesService.updateBatchById(updateList);
            }
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    public WorkFlow getFileByProcessKey(String processKey, String tenantId, Integer version) {
        return this.sysActProcessFileService.getFileByProcessKey(processKey, tenantId, version);
    }

    public ApiResponse<String> updateWorkflowProcessKey(String processKey, String oldProcessKey) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline() && HussarUtils.isEmpty((Object)this.modelService.getIdByIdentity(processKey))) {
            this.sysActFormAuthService.copyAuth(processKey, oldProcessKey);
            this.sysActAssigneeService.copyAssignee(processKey, oldProcessKey);
        }
        return ApiResponse.success((Object)"", (String)"");
    }
}

