/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Set;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.apache.commons.lang3.StringUtils;

public class AcceptTaskCmd
implements Command<Void> {
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    ICandidateUserService candidateUserService = (ICandidateUserService)SpringContextHolder.getBean(ICandidateUserService.class);
    private String taskId;
    private String userId;

    public AcceptTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity == null) {
            throw new PublicClientException(bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.userId)) {
            ArrayList<CandidateUser> invalidUserIds = new ArrayList<CandidateUser>();
            Set candidates = taskEntity.getCandidates();
            for (IdentityLink candidate : candidates) {
                if (this.userId.equals(candidate.getUserId())) continue;
                CandidateUser invalidUser = new CandidateUser();
                invalidUser.setTaskId(taskEntity.getId());
                invalidUser.setAssignee(candidate.getUserId());
                invalidUserIds.add(invalidUser);
                taskEntity.deleteCandidateUser(candidate.getUserId());
            }
            this.candidateUserService.saveBatch(invalidUserIds);
        }
        return null;
    }
}

