/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskBaseInfoMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskBaseInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AcceptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceRevokeTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ReceiveTaskAddVariablesCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RejectReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ReleaseTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompletePrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskRejectCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.cmd.GetExecutionVariablesCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskEngineServiceImpl
implements ITaskEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Resource
    private ICandidateUserService candidateUserService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private TaskBaseInfoMapper taskBaseInfoMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    public static final List<String> CALL_REJECT_LIST = new ArrayList<String>();

    public Task getTask(String taskId, String state) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskId(taskId);
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        return task;
    }

    public Task getTaskWithOutCheckSuspended(String taskId, String state) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables();
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        return task;
    }

    public ApiResponse<?> queryTask(String taskId, String tenantId) {
        String message;
        String sendUser;
        if (taskId == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getTaskNotFound());
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        Map taskVariables = historicTaskInstance.getTaskLocalVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
        }
        Map finalUsers = new HashMap();
        if (ToolUtil.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set<String> users = this.getAssigneeByTaskId(taskId);
            if (ToolUtil.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (userIds.size() > 0) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            }
        }
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
        String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
        if (ToolUtil.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("formKey", historicTaskInstance.getFormKey());
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(historicTaskInstance.getTaskDefinitionKey());
        String formDetail = (String)this.iSysActExtendPropertiesService.queryList(ids, historicTaskInstance.getProcessDefinitionId()).get(historicTaskInstance.getTaskDefinitionKey());
        map.put("formDetailKey", formDetail);
        return ApiResponse.success(map);
    }

    public ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(suspensionState);
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, String tenantId, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(suspensionState);
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        taskManagerDto.setBusinessList(!ToolUtil.isNotEmpty(businessList) ? businessList : null);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, List<String> businessIds, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setBusinessIds(businessIds);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, null);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryUserTaskCount(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTask(userId));
    }

    public ApiResponse<?> queryUserTaskCountByNode(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTaskByNode(userId));
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
        this.claimDataPush(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        this.taskService.unclaim(taskId);
        this.claimDataPush(taskId, null);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, map));
        this.completeDataPush(task, "", userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, newMap));
        this.completeDataPush(task, "", userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, comment, newMap));
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, comment, newMap));
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, comment, map));
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String[] subs = subProcesses.split(",");
        JSONArray jsonArray = new JSONArray();
        for (String sub : subs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessId", (Object)"");
            jsonObject.put("processKey", (Object)sub);
            jsonObject.put("userId", (Object)"");
            jsonArray.add((Object)jsonObject);
        }
        newMap.put("call_activity_info", jsonArray);
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, comment, newMap));
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId).isAuditAuthority(isAuditAuthority));
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userId, comment, newMap));
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        JSONArray json = new JSONArray();
        String comment = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            json.add((Object)comment);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        Map variable = task.getTaskLocalVariables();
        if (variable.get("reject_from") != null) {
            HistoricTaskInstance historicTaskInstance;
            List comments;
            String rejectTask = ((String)variable.get("reject_from")).split(",")[0];
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(rejectTask)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (ToolUtil.isNotEmpty((Object)historicTaskInstanceList) && ToolUtil.isNotEmpty((Object)(comments = this.taskService.getTaskComments((historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceList.get(0)).getId(), "complete")))) {
                comment = ((Comment)comments.get(0)).getFullMessage();
            }
        }
        json.add((Object)comment);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, null, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, null, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        this.addComment(taskId, comment);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete_leap");
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).taskVariableValueNotEquals("reject_to", null)).orderByTaskCreateTime()).desc()).listPage(0, 1);
        if (historicTaskInstanceList.size() != 0) {
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            Map variables = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables();
            String rejectTo = (String)variables.get("reject_to");
            String rejectFrom = (String)variables.get("reject_from");
            if (ToolUtil.isEmpty((Object)rejectFrom)) {
                this.complete(task, newMap, userId);
                this.completeDataPush(task, comment, userId);
                JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
            }
            Map rejectExecution = (Map)variables.get("reject_execution");
            String executionId = task.getExecutionId();
            String processDefinition = task.getProcessDefinitionId();
            ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
            ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
            StringBuilder stringBuilder = new StringBuilder();
            if (rejectExecution != null) {
                for (String key : rejectExecution.keySet()) {
                    stringBuilder.append(",").append(key);
                }
            }
            Map<String, Object> objectMap = this.getBackTypeWithTasks(rejectFrom + stringBuilder, null, task, false, "1");
            if (!rejectTo.contains(",")) {
                List affectedTasks = (List)objectMap.get("affectedTasks");
                if (affectedTasks.size() == 1 && ((String)affectedTasks.get(0)).equals(task.getTaskDefinitionKey())) {
                    if (!isScope) {
                        newMap.put("reject_execution", rejectExecution);
                        newMap.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                        if (isSubmit) {
                            this.setCompleteLeapAppointAssignee(newMap, rejectFrom, task.getProcessInstanceId());
                        }
                        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(userId, executionId, rejectFrom, comment, "complete", newMap, currentActivity));
                    } else if (this.multiCondition(task)) {
                        newMap.put("reject_execution", rejectExecution);
                        newMap.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                        if (isSubmit) {
                            this.setCompleteLeapAppointAssignee(newMap, rejectFrom, task.getProcessInstanceId());
                        }
                        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, rejectFrom, taskId, comment, "complete", newMap, currentActivity));
                    } else {
                        this.complete(task, newMap, userId);
                    }
                } else {
                    this.complete(task, newMap, userId);
                }
            } else {
                HashSet<String> rejectToNodes = new HashSet<String>(Arrays.asList(rejectTo.split(",")));
                String targetGateway = this.recentSharedGateway(new ArrayList<String>(Arrays.asList(rejectFrom.split(","))), task.getProcessDefinitionId());
                List executionList = this.runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).activityId(targetGateway).setIsActive(false).list();
                boolean isCompleteLeap = true;
                HashSet<String> affectedUserTasks = new HashSet<String>(Arrays.asList(((String)objectMap.get("affectedUserTasks")).split(",")));
                Map affectedExecution = (Map)objectMap.get("affectedExecution");
                Set affectedCallActicity = (Set)objectMap.get("affectedCallActivity");
                if (ToolUtil.isNotEmpty((Object)affectedCallActicity)) {
                    isCompleteLeap = false;
                } else if (affectedExecution.size() > 1 || affectedExecution.size() == 1 && !affectedExecution.containsKey(targetGateway)) {
                    isCompleteLeap = false;
                } else if (rejectToNodes.size() < affectedExecution.size() || rejectToNodes.addAll(affectedUserTasks)) {
                    isCompleteLeap = false;
                } else {
                    List targetGatewayExecution = affectedExecution.get(targetGateway) != null ? (List)affectedExecution.get(targetGateway) : new ArrayList();
                    List runningRejectTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).includeTaskLocalVariables()).list().stream().filter(o -> affectedUserTasks.contains(o.getTaskDefinitionKey())).collect(Collectors.toList());
                    HashSet<String> runningRejectNode = new HashSet<String>();
                    Iterator iterator = runningRejectTasks.iterator();
                    while (iterator.hasNext()) {
                        Task runningRejectTask = (Task)iterator.next();
                        if (runningRejectNode.add(runningRejectTask.getTaskDefinitionKey()) || rejectTo.equals(runningRejectTask.getTaskLocalVariables().get("reject_to"))) continue;
                        isCompleteLeap = false;
                        break;
                    }
                    if (isCompleteLeap && rejectTo.split(",").length != runningRejectNode.size() + targetGatewayExecution.size()) {
                        isCompleteLeap = false;
                    }
                }
                if (!isCompleteLeap) {
                    this.complete(task, newMap, userId);
                } else if (!isScope || this.multiCondition(task)) {
                    int targetGatewayExecutionNum = 0;
                    for (String[] execution : executionList) {
                        if (!targetGateway.equals(execution.getActivityId())) continue;
                        ++targetGatewayExecutionNum;
                    }
                    if (targetGatewayExecutionNum >= rejectToNodes.size() - 1) {
                        StringBuilder allPrevNode = new StringBuilder();
                        for (String rejectToNode : rejectTo.split(",")) {
                            allPrevNode.append("'").append(rejectToNode).append("'").append(",");
                        }
                        allPrevNode.deleteCharAt(allPrevNode.length() - 1);
                        newMap.put("reject_execution", rejectExecution);
                        newMap.put("all_prev_node", allPrevNode.toString());
                        if (isSubmit) {
                            this.setCompleteLeapAppointAssignee(newMap, rejectFrom, task.getProcessInstanceId());
                        }
                        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, rejectFrom, comment, "complete", newMap, currentActivity));
                    } else {
                        HashMap<String, Object> executionParamvar = new HashMap<String, Object>(newMap);
                        executionParamvar.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(Collections.singletonList(executionParamvar));
                        HashMap<String, ArrayList<HashMap<String, Object>>> rejectExecutionMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                        rejectExecutionMap.put(targetGateway, list);
                        newMap.put("reject_execution", rejectExecutionMap);
                        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(userId, executionId, "", comment, "complete", newMap, currentActivity));
                    }
                } else {
                    this.complete(task, newMap, userId);
                }
            }
        } else {
            this.complete(task, newMap, userId);
        }
        this.completeDataPush(task, comment, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private String recentSharedGateway(List<String> nodes, String procDefId) {
        Collections.sort(nodes);
        String node = nodes.get(0);
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        FlowElement flowElement = process.getFlowElement(node);
        while (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) {
            SequenceFlow sequenceFlow = (SequenceFlow)((FlowNode)flowElement).getIncomingFlows().get(0);
            if (!((flowElement = process.getFlowElement(sequenceFlow.getSourceRef())) instanceof StartEvent)) continue;
            throw new PublicClientException("\u672a\u627e\u5230\u76ee\u6807\u8282\u70b9\u7684\u516c\u5171\u7f51\u5173");
        }
        return flowElement.getId();
    }

    private void setCompleteLeapAppointAssignee(Map<String, Object> map, String rejectNodes, String processInstanceId) {
        String[] stringArray;
        int n;
        int n2;
        HashMap<String, String> appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((appointAssignee = (HashMap<String, String>)map.get("appoint_assignee")) == null) {
            appointAssignee = new HashMap<String, String>();
        }
        if ((n2 = 0) < (n = (stringArray = rejectNodes.split(",")).length)) {
            Map oldAppointAssigneeMap;
            String oldAppointAssignee;
            String targetNodeId = stringArray[n2];
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"reject")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (historicTaskInstanceList.size() == 1 && ToolUtil.isNotEmpty((Object)(oldAppointAssignee = (String)(oldAppointAssigneeMap = (Map)((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee")).get(targetNodeId)))) {
                appointAssignee.put(targetNodeId, oldAppointAssignee);
            }
        }
        map.put("appoint_assignee", appointAssignee);
    }

    private boolean multiCondition(Task task) {
        Map multiVariables = (Map)this.processEngine.getManagementService().executeCommand((Command)new GetExecutionVariablesCmd(task.getExecutionId(), null, false));
        int nrOfCompletedInstances = (Integer)multiVariables.get("nrOfCompletedInstances") + 1;
        int nrOfInstances = (Integer)multiVariables.get("nrOfInstances");
        if (nrOfInstances != 0 && nrOfInstances > nrOfCompletedInstances) {
            String multiType = (String)multiVariables.get("multi_type");
            String multiFinishCondition = multiVariables.get("multi_finish_condition").toString();
            if (ToolUtil.isNotEmpty((Object)multiType) && ToolUtil.isNotEmpty((Object)multiFinishCondition)) {
                if ("0".equals(multiType) ? (double)nrOfCompletedInstances / (double)nrOfInstances >= Double.parseDouble(multiFinishCondition) / 100.0 : "1".equals(multiType) && nrOfCompletedInstances == Integer.parseInt(multiFinishCondition)) {
                    return true;
                }
            } else {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("nrOfCompletedInstances", nrOfCompletedInstances);
                contextMap.put("nrOfInstances", nrOfInstances);
                boolean condition = false;
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                String k = ((Activity)bm.getFlowElement(task.getTaskDefinitionKey())).getLoopCharacteristics().getCompletionCondition();
                ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                SimpleContext context = TaskEngineServiceImpl.getVariables(contextMap);
                ValueExpression e = factory.createValueExpression((ELContext)context, k, Boolean.TYPE);
                if (((Boolean)e.getValue((ELContext)context)).booleanValue()) {
                    condition = true;
                }
                if (condition) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void complete(Task task, Map<String, Object> map, String userId) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("sendUser", userId);
        if (map != null) {
            newMap.putAll(map);
        }
        newMap.put("bpm_submit_source", task.getTaskDefinitionKey());
        Map<String, Object> appointAssignee = new HashMap();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        if (ToolUtil.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        HashMap<String, String> executionVariableMap = new HashMap<String, String>();
        executionVariableMap.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
        this.runtimeService.setVariablesLocal(task.getExecutionId(), executionVariableMap);
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, newMap);
        } else {
            this.taskService.resolveTask(taskId, newMap);
            this.taskService.complete(taskId, newMap);
        }
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        LambdaQueryWrapper candidateUserLambdaQueryWrapper = new LambdaQueryWrapper();
        candidateUserLambdaQueryWrapper.eq(CandidateUser::getTaskId, (Object)taskId);
        this.candidateUserService.remove((Wrapper)candidateUserLambdaQueryWrapper);
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map, String rejectActivityId) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = this.getTask(taskId, "1");
        String backActivityId = this.getLastActivityId(task);
        if (ToolUtil.isEmpty((Object)backActivityId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidReject(), null);
        }
        if (backActivityId.contains("main_process_")) {
            boolean isScope;
            String superExecutionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getSuperExecutionId();
            if (superExecutionId == null) {
                throw new PublicClientException("\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            if (backActivityId.startsWith("main_process_")) {
                if (backActivityId.contains(",")) {
                    for (String targerNodeId : backActivityId.split(",")) {
                        if (targerNodeId.contains("main_process_")) continue;
                        throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
                    }
                }
            } else if (backActivityId.contains("main_process_")) {
                throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
            }
            backActivityId = backActivityId.replace("main_process_", "");
            Execution entity = (Execution)this.runtimeService.createExecutionQuery().executionId(superExecutionId).singleResult();
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(((ExecutionEntity)entity).getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(entity.getActivityId());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean bl = isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            if (entity.getParentId() != null && isScope) {
                entity = (Execution)this.runtimeService.createExecutionQuery().executionId(entity.getParentId()).singleResult();
            }
            return this.rejectWithExecution((ExecutionEntity)entity, backActivityId, userId, "reject", comment, assignees, new HashMap<String, String>(), isSubmit, map);
        }
        Map<String, Object> result = this.backType(null, task, backActivityId, false);
        int backType = (Integer)result.get("num");
        if (ToolUtil.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (backActivityId.equals(this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey()))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        this.setRejectAppointAssignee(task.getProcessInstanceId(), backActivityId, assignees, null, isSubmit, newMap);
        this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), task.getProcessInstanceId(), userId, comment, "reject");
        String affectedTaskIds = null;
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
            newMap.put("reject_from", result.get("affectedUserTasks"));
            newMap.put("reject_execution", result.get("affectedExecution"));
            if (this.dataPushService.isDataPush()) {
                HashSet nodeId = new HashSet((List)newMap.get("affectedTasks"));
                affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list().stream().filter(o -> nodeId.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
            }
        }
        newMap.put("isSubmit", isSubmit);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, (TaskEntity)task, null, backActivityId, comment, backType, "reject", newMap));
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), "reject", task.getName()));
        boolean needReject = false;
        String rejectTaskId = "";
        if (ToolUtil.isNotEmpty((Object)json)) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject object = json.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(backActivityId) || !ToolUtil.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(task.getProcessInstanceId())) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(rejectTaskId, userId, comment, assignees, isSubmit, newMap, rejectActivityId);
        }
        LambdaQueryWrapper candidateUserLambdaQueryWrapper = new LambdaQueryWrapper();
        candidateUserLambdaQueryWrapper.eq(CandidateUser::getTaskId, (Object)taskId);
        this.candidateUserService.remove((Wrapper)candidateUserLambdaQueryWrapper);
        this.rejectDataPush(task, comment, userId, affectedTaskIds);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        Task task = this.getTask(taskId, "1");
        String firstTaskId = this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        if (task.getTaskDefinitionKey().equals(firstTaskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getForbidReject(), Boolean.valueOf(false));
        }
        String starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        Map<String, Object> result = this.backType(null, task, "", true);
        int backType = (Integer)result.get("num");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        this.setRejectAppointAssignee(task.getProcessInstanceId(), firstTaskId, assignees, null, isSubmit, newMap);
        this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), task.getProcessInstanceId(), userId, comment, "reject");
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
            newMap.put("reject_from", result.get("affectedUserTasks"));
            newMap.put("reject_execution", result.get("affectedExecution"));
        }
        String affectedTaskIds = null;
        if (backType == 3 && this.dataPushService.isDataPush()) {
            HashSet nodeId = new HashSet((List)newMap.get("affectedTasks"));
            affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list().stream().filter(o -> nodeId.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
        }
        newMap.put("isSubmit", isSubmit);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, (TaskEntity)task, null, firstTaskId, comment, backType, "reject", newMap));
        this.rejectDataPush(task, comment, userId, affectedTaskIds);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), true, starterUserId, firstTaskId, userId, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = this.getTask(taskId, "1");
        if (backActivityId.contains("main_process_")) {
            boolean isScope;
            String superExecutionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getSuperExecutionId();
            if (superExecutionId == null) {
                throw new PublicClientException("\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            if (backActivityId.startsWith("main_process_")) {
                if (backActivityId.contains(",")) {
                    for (String targerNodeId : backActivityId.split(",")) {
                        if (targerNodeId.contains("main_process_")) continue;
                        throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
                    }
                }
            } else if (backActivityId.contains("main_process_")) {
                throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
            }
            backActivityId = backActivityId.replace("main_process_", "");
            Execution entity = (Execution)this.runtimeService.createExecutionQuery().executionId(superExecutionId).singleResult();
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(((ExecutionEntity)entity).getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(entity.getActivityId());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean bl = isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            if (entity.getParentId() != null && isScope) {
                entity = (Execution)this.runtimeService.createExecutionQuery().executionId(entity.getParentId()).singleResult();
            }
            return this.rejectWithExecution((ExecutionEntity)entity, backActivityId, userId, "reject", comment, assignees, assigneeMap, isSubmit, map);
        }
        if (!this.canRejectToAnyNode(task.getProcessDefinitionId(), task.getTaskDefinitionKey(), backActivityId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        Map<String, Object> result = this.backType(null, task, backActivityId, false);
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRejectToAnyCannotToAnotherBranch(), null);
        }
        if (backActivityId.equals(this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey()))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        this.setRejectAppointAssignee(task.getProcessInstanceId(), backActivityId, assignees, assigneeMap, isSubmit, newMap);
        this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), task.getProcessInstanceId(), userId, comment, "reject");
        String affectedTaskIds = null;
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
            newMap.put("reject_from", result.get("affectedUserTasks"));
            newMap.put("reject_execution", result.get("affectedExecution"));
            if (this.dataPushService.isDataPush()) {
                HashSet nodeId = new HashSet((List)newMap.get("affectedTasks"));
                affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list().stream().filter(o -> nodeId.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
            }
        }
        newMap.put("isSubmit", isSubmit);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, (TaskEntity)task, null, backActivityId, comment, backType, "reject", newMap));
        this.rejectDataPush(task, comment, userId, affectedTaskIds);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public boolean canRejectToAnyNode(String procDefId, String taskDefinitionKey, String targetNodeIds) {
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        FlowNode userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(taskDefinitionKey);
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        for (List list : lists) {
            boolean listContain = false;
            for (String targetNode : targetNodes) {
                if (!list.contains(targetNode)) continue;
                if (listContain) {
                    return false;
                }
                listContain = true;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canRejectToAnyNodePlus(String procDefId, String targetNodeIds) {
        void var8_11;
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(procDefId);
        Process process = bm.getMainProcess();
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        ArrayList<ArrayList<List<String>>> targetNodePathList = new ArrayList<ArrayList<List<String>>>();
        for (String string : targetNodes) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(string);
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            FlowNode userTask = (FlowNode)process.getFlowElement(string);
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
            targetNodePathList.add(lists);
        }
        ArrayList<String> canRejectNodeIds = new ArrayList<String>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) continue;
            canRejectNodeIds.add(flowElement.getId());
        }
        boolean bl = false;
        while (var8_11 < targetNodePathList.size()) {
            for (void j = var8_11 + true; j < targetNodePathList.size(); ++j) {
                List nodePathList1 = (List)targetNodePathList.get((int)var8_11);
                List nodePathList2 = (List)targetNodePathList.get((int)j);
                for (List path1 : nodePathList1) {
                    block5: for (List path2 : nodePathList2) {
                        for (String node : path1) {
                            if (!path2.contains(node)) continue;
                            if (canRejectNodeIds.contains(node)) continue block5;
                            return false;
                        }
                    }
                }
            }
            ++var8_11;
        }
        return true;
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }

    public BpmResponseResult queryRejectNode(String taskId) {
        Task task = this.getTaskWithOutCheckSuspended(taskId, "1");
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            Process process = bm.getMainProcess();
            FlowNode userTask = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (ToolUtil.isNotEmpty((Object)processInstance.getSuperProcessInstanceId()) && (hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list()).size() > 0) {
                bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                String taskDefinitionKey = "";
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    taskDefinitionKey = historicActivityInstance.getActivityId();
                }
                hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                hisTaskDefinitionKey.remove(taskDefinitionKey);
                process = bm.getMainProcess();
                userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
                ids = new HashSet();
                ids.add(taskDefinitionKey);
                lists = new ArrayList();
                if (userTask == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, true);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.size() == 0) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? "main_process_" : "";
        String namePreFix = isRejectMain ? "\u4e3b\u6d41\u7a0b" : "";
        for (String id : finalList) {
            FlowElement flowElement = process.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private String getTaskCommitUser(String processInsId, String backActivityId) {
        List hisTaskList;
        HashSet<String> assignees = new HashSet<String>();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && hisTaskList.size() > 0) {
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                assignees.add(historicTaskInstance.getAssignee());
                for (int j = i + 1; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    assignees.add(historicTaskInstance.getAssignee());
                }
                break;
            }
        }
        return String.join((CharSequence)",", assignees);
    }

    private String getLastActivityId(Task task) {
        Map map;
        Map map2 = map = task.getTaskLocalVariables() == null ? new HashMap() : task.getTaskLocalVariables();
        if (map.get("call_complete_from") != null) {
            return "main_process_" + map.get("call_complete_from");
        }
        if (map.get("all_prev_node") != null) {
            return map.get("all_prev_node").toString().replace("'", "");
        }
        return "";
    }

    private String getFirstActivityId(String processInsId, String taskDefinitionKey) {
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).listPage(0, 1);
        if (list != null && !list.isEmpty()) {
            return ((HistoricTaskInstance)list.get(0)).getTaskDefinitionKey();
        }
        return taskDefinitionKey;
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        this.taskService.delegateTask(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userId, mandatary})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if (userId.equals(mandatary)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        if (!this.auditAuthority(mandatary, taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, mandatary, false, false));
            this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, userId, 0);
            SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
            sysActUrgeTask.setReceiveUser(mandatary);
            this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        } else {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, null, false, true));
            this.activityRedisTimerService.updateTimeOutModel(taskId, null, userId, 0);
            this.sysActUrgeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary, int state) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{taskId, mandatary})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if (state != 0 && mandatary.contains(",") && this.isMulti(task) == 2) {
            return InstallResult.getResult((String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), (String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", mandatary, state == 0, false));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && list.size() != 0) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            String[] receiveUsers = mandatary.split(",");
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : receiveUsers) {
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(urgeTask.getTaskId());
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            if (state == 1) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, mandatary);
        }
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, null, state);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, Map<String, String> assigneeMap, boolean isSubmit, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        if (activitiId.contains("main_process_")) {
            boolean isScope;
            String superExecutionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getSuperExecutionId();
            if (superExecutionId == null) {
                throw new PublicClientException("\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            if (activitiId.startsWith("main_process_")) {
                if (activitiId.contains(",")) {
                    for (String targerNodeId : activitiId.split(",")) {
                        if (targerNodeId.contains("main_process_")) continue;
                        throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
                    }
                }
            } else if (activitiId.contains("main_process_")) {
                throw new PublicClientException(this.bpmConstantProperties.getNotRejectToTargetNode(), Boolean.valueOf(false));
            }
            activitiId = activitiId.replace("main_process_", "");
            Execution entity = (Execution)this.runtimeService.createExecutionQuery().executionId(superExecutionId).singleResult();
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(((ExecutionEntity)entity).getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(entity.getActivityId());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean bl = isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            if (entity.getParentId() != null && isScope) {
                entity = (Execution)this.runtimeService.createExecutionQuery().executionId(entity.getParentId()).singleResult();
            }
            return this.rejectWithExecution((ExecutionEntity)entity, activitiId, userId, "freejump", comment, assignees, assigneeMap, isSubmit, map);
        }
        if (!this.canRejectToAnyNodePlus(task.getProcessDefinitionId(), activitiId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotFreeJumpToTargetNode(), null);
        }
        Map<String, Object> result = this.backType(null, task, activitiId, false);
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getFreeJumpCannotToAnotherBranch(), null);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        this.setRejectAppointAssignee(task.getProcessInstanceId(), activitiId, assignees, assigneeMap, isSubmit, newMap);
        this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), task.getProcessInstanceId(), userId, comment, "freejump");
        String affectedTaskIds = null;
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
            if (backType == 3 && this.dataPushService.isDataPush()) {
                HashSet nodeId = new HashSet((List)newMap.get("affectedTasks"));
                affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list().stream().filter(o -> nodeId.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
            }
        }
        newMap.put("isSubmit", isSubmit);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, (TaskEntity)task, null, activitiId, comment, backType, "freejump", newMap));
        this.freeJumpDataPush(task, comment, userId, affectedTaskIds);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        if (assigneeList == null || assigneeList.size() < 1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
        variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
        Map newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType, variableMap));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && list.size() != 0) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : assigneeList) {
                String newTaskId = (String)newTaskIdMap.get(receiveUser);
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(newTaskId);
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, String.join((CharSequence)",", assigneeList));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String assignees) {
        if (ToolUtil.isEmpty((Object)assignees)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            this.entrustTask(taskId, assignees, 0);
        } else {
            List list;
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(assignees.split(",")));
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!ToolUtil.isNotEmpty((Object)runningTask.getAssignee())) continue;
                users.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            Map newTaskIdMap = null;
            if (ToolUtil.isNotEmpty(users)) {
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
                variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
                newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), users, dueTime, outTimeType, variableMap));
            }
            if ((list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId))) != null && list.size() != 0) {
                String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
                HashSet<String> set = new HashSet<String>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    set.add(((SysActUrgeTask)list.get(i)).getReceiveUser());
                    if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                    list.remove(i);
                }
                String[] receiveUsers = assignees.split(",");
                ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
                for (String receiveUser : receiveUsers) {
                    String newTaskId;
                    if (set.contains(receiveUser) || (newTaskId = (String)newTaskIdMap.get(receiveUser)) == null) continue;
                    for (SysActUrgeTask urgeTask : list) {
                        SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                        saveUrgeTask.setTaskId(newTaskId);
                        saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                        saveUrgeTask.setProcName(urgeTask.getProcName());
                        saveUrgeTask.setTaskName(urgeTask.getTaskName());
                        saveUrgeTask.setSendUser(urgeTask.getSendUser());
                        saveUrgeTask.setReceiveUser(receiveUser);
                        saveUrgeTask.setSendTime(urgeTask.getSendTime());
                        saveUrgeTask.setFormKey(urgeTask.getFormKey());
                        saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                        saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                        saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                        saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                        saveList.add(saveUrgeTask);
                    }
                }
                this.sysActUrgeTaskService.saveBatch(saveList);
                this.addUrgeTask(task, assignees);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        Task task = this.getTask(taskId, "0");
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        if (ToolUtil.isEmpty((Object)users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
        } else {
            if (businessId == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (tasks.size() == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAppointAssigneesSuccess(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Object level;
        String appointAssignees;
        Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
        if (publicAppointAssignee != null && ToolUtil.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
            HashSet<String> users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            JSONArray jsonArray = new JSONArray();
            if (users.size() > 0) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (ToolUtil.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
            map.put("security_level", level);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, tenantId, map);
        if (users.size() > 0) {
            jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = process.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            HashSet<Object> users = new HashSet();
            try {
                users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, tenantId, map);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            if (users.size() > 0) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public List<BpmTreeModel> queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        List<String> users = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null);
        if (ToolUtil.isNotEmpty(users)) {
            return this.iAssigneeChooseService.queryAssigneeAndDept(users, nodeAssigneeQueryDto.getOrganName(), null);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> page, NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        List<String> users = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null);
        if (ToolUtil.isNotEmpty(users)) {
            return this.iAssigneeChooseService.queryNodeAssigneeListByPage(page, users, nodeAssigneeQueryDto, null);
        }
        return page.setRecords(new ArrayList());
    }

    private List<String> queryNodeAssignee(String processKey, String taskId, String nodeId, String tenantId) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            BpmnModel bm;
            Object level;
            String appointAssignees;
            Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", task.getTaskDefinitionKey());
            Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
            if (publicAppointAssignee != null && ToolUtil.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
                return new ArrayList<String>(new HashSet<String>(Arrays.asList(appointAssignees.split(","))));
            }
            if (ToolUtil.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
                map.put("security_level", level);
            }
            if ((bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())) == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, tenantId, map);
            return new ArrayList<String>(users);
        }
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = process.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", taskDefinitionKey);
            HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, tenantId, map);
            return new ArrayList<String>(users);
        }
        throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
    }

    public BpmResponseResult queryAllAssignee(String procDefinitionKey, String taskDefinitionKey) {
        Object users;
        JSONObject jsonObject;
        String tenantId = "";
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(procDefinitionKey).getId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        HashSet<String> userIds = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, new HashMap<String, Object>());
                userIds.addAll((Collection<String>)users);
                jsonObject.put("assignee", users);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
                isContain = true;
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)flowElement.getId());
                jsonObject2.put("name", (Object)flowElement.getName());
                HashSet<String> users2 = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, new HashMap<String, Object>());
                userIds.addAll(users2);
                jsonObject2.put("assignee", users2);
                jsonArray.add((Object)jsonObject2);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        Map userMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIds), tenantId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            users = jsonObject.getJSONArray("assignee");
            ArrayList user = new ArrayList();
            for (int j = 0; j < users.size(); ++j) {
                String userId = users.getString(j);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", userId);
                map.put("userName", (String)userMap.get(userId));
                user.add(map);
            }
            jsonObject.put("assignee", user);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public ApiResponse<?> queryHistoryActByTaskId(String taskId, String processInsId) {
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInsId;
        if (newProcessInstanceId == null) {
            Task task = this.getTask(taskId, "0");
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && list.size() > 0) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                    json.add((Object)object);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", list.size());
            result.put("data", (Integer)json);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        JSONObject object = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (definitionModel != null) {
                object.put("processDefinitionId", (Object)definitionModel.getId());
            }
        } else {
            Task task = this.getTask(taskId, "0");
            object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult queryTaskIdByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInsId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryNextNode(String taskId, boolean isGetRevokeNode) {
        Map variables;
        Task task = this.getTaskWithOutCheckSuspended(taskId, isGetRevokeNode ? "1" : "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        if (isGetRevokeNode && ToolUtil.isNotEmpty((Object)(variables = task.getTaskLocalVariables())) && ToolUtil.isNotEmpty(variables.get("reject_from"))) {
            String nodeId = String.valueOf(variables.get("reject_from"));
            for (String id : nodeId.split(",")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                FlowElement flowElement = process.getFlowElement(id);
                if (flowElement instanceof UserTask) {
                    jsonObject.put("type", (Object)"userTask");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                }
                jsonObject.put("name", (Object)flowElement.getName());
                jsonArray.add((Object)jsonObject);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        this.getUserTaskByCondition(jsonArray, process, sequenceFlows, ToolUtil.isNotEmpty(resultMap) ? resultMap : null);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextNode(taskId, isGetRevokeNode);
        }
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            String procDefId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(process.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)process.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap();
                if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), "", procDefId);
                }
                this.getUserTaskByCondition(jsonArray, process, sequenceFlows, ToolUtil.isNotEmpty(resultMap) ? resultMap : null);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, Map<String, Object> lineCondition) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return this.queryNextNode(processKey, taskId, false);
        }
        Task task = this.getTaskWithOutCheckSuspended(taskId, "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        Map<String, Object> visitorMap = CommonCodeUtil.getGodAxeResult(null, task.getTaskDefinitionKey(), hpi.getBusinessKey(), task.getProcessDefinitionId());
        visitorMap.putAll(lineCondition);
        return this.getUserTaskByCondition(jsonArray, process, sequenceFlows, visitorMap);
    }

    private BpmResponseResult getUserTaskByCondition(JSONArray jsonArray, Process process, List<SequenceFlow> sfs, Map<String, Object> visitorMap) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                ServiceTask p;
                ArrayList<Object> seqList;
                Object valueExpression;
                SimpleContext context;
                ExpressionFactoryImpl factory;
                ArrayList<SequenceFlow> defaultList;
                List sequenceFlowsList;
                Gateway gateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"endEvent");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    gateway = (Gateway)process.getFlowElement(targetRef);
                    sequenceFlowsList = gateway.getOutgoingFlows();
                    boolean flag = true;
                    defaultList = new ArrayList<SequenceFlow>();
                    for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                        if (sequenceFlows.getConditionExpression() != null) {
                            factory = new ExpressionFactoryImpl();
                            context = new SimpleContext();
                            if (visitorMap != null && visitorMap.size() > 0) {
                                for (String k : visitorMap.keySet()) {
                                    if (visitorMap.get(k.toString()) != null) {
                                        context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                        continue;
                                    }
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                                }
                            }
                            if ((valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE)).getExpressionString().contains("bpm_next_node")) {
                                seqList = new ArrayList<SequenceFlow>();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            try {
                                if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                if (!flag && process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                                    jsonArray.remove(0);
                                    return InstallResult.getResult((String)"0", (String)"\u6d41\u7a0b\u6761\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e!", (JSONArray)jsonArray);
                                }
                                flag = false;
                                seqList = new ArrayList();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            catch (PropertyNotFoundException e) {
                                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)new JSONArray());
                            }
                        }
                        defaultList.add(sequenceFlows);
                    }
                    if (flag) {
                        this.getUserTaskByCondition(jsonArray, process, defaultList, visitorMap);
                    }
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    gateway = (Gateway)process.getFlowElement(targetRef);
                    sequenceFlowsList = gateway.getOutgoingFlows();
                    boolean flag = true;
                    defaultList = new ArrayList();
                    for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                        if (sequenceFlows.getConditionExpression() != null) {
                            factory = new ExpressionFactoryImpl();
                            context = new SimpleContext();
                            if (visitorMap != null && visitorMap.size() > 0) {
                                valueExpression = visitorMap.keySet().iterator();
                                while (valueExpression.hasNext()) {
                                    String k;
                                    k = valueExpression.next();
                                    if (visitorMap.get(k.toString()) != null) {
                                        context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                        continue;
                                    }
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                                }
                            }
                            if ((valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE)).getExpressionString().contains("bpm_next_node")) {
                                seqList = new ArrayList();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            try {
                                if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                seqList = new ArrayList();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            catch (PropertyNotFoundException e) {
                                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)new JSONArray());
                            }
                        }
                        defaultList.add(sequenceFlows);
                    }
                    this.getUserTaskByCondition(jsonArray, process, defaultList, visitorMap);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonObject2.put("type", (Object)"callActivity");
                    jsonArray.add((Object)jsonObject2);
                }
                if (process.getFlowElement(targetRef) instanceof ParallelGateway) {
                    ParallelGateway p2 = (ParallelGateway)process.getFlowElement(targetRef);
                    this.getUserTaskByCondition(jsonArray, process, p2.getOutgoingFlows(), visitorMap);
                }
                if (process.getFlowElement(targetRef) instanceof ServiceTask) {
                    jsonObject = new JSONObject();
                    p = (ServiceTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"serviceTask");
                    jsonArray.add((Object)jsonObject);
                }
                if (!(process.getFlowElement(targetRef) instanceof ReceiveTask)) continue;
                jsonObject = new JSONObject();
                p = (ReceiveTask)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonObject.put("type", (Object)"receiveTask");
                jsonArray.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && map.size() > 0) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    private void getUserTask(JSONArray jsonArray, Process process, List<SequenceFlow> sfs) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                ParallelGateway p;
                List sequenceFlows;
                ExclusiveGateway exclusiveGateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"UserTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"EndEvent");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    exclusiveGateway = (ExclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    exclusiveGateway = (InclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonObject2.put("type", (Object)"CallActivity");
                    jsonArray.add((Object)jsonObject2);
                }
                if (process.getFlowElement(targetRef) instanceof ParallelGateway) {
                    jsonObject = new JSONObject();
                    p = (ParallelGateway)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ParallelGateway");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ServiceTask) {
                    jsonObject = new JSONObject();
                    p = (ServiceTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ServiceTask");
                    jsonArray.add((Object)jsonObject);
                }
                if (!(process.getFlowElement(targetRef) instanceof ReceiveTask)) continue;
                jsonObject = new JSONObject();
                p = (ReceiveTask)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonObject.put("type", (Object)"ReceiveTask");
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        ProcessInstance instance;
        if (historicTaskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)currTask.getEndTime())) {
            LOGGER.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        if ("skip".equals(currTask.getTaskLocalVariables().get("taskSourceFlag"))) {
            result = false;
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessEnd(), null);
        }
        if (instance.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", currTask.getProcessInstanceId());
        map.put("endTime", currTask.getEndTime());
        map.put("taskDefinitionKey", currTask.getTaskDefinitionKey());
        map.put("isEnd", "true");
        map.put("userId", currTask.getAssignee());
        if (!"0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        map.put("isEnd", "false");
        if ("0".equals(this.taskEngineMapper.withdrawState(map))) {
            List taskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).finished().taskVariableValueEquals("taskSourceFlag", (Object)"revoke")).orderByHistoricTaskInstanceEndTime().desc()).list();
            if (ToolUtil.isNotEmpty((Object)taskInstanceList)) {
                HistoricTaskInstance historicTaskInstance;
                Iterator iterator = taskInstanceList.iterator();
                while (iterator.hasNext() && (historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime().after(currTask.getEndTime())) {
                    if (!historicTaskInstance.getAssignee().equals(currTask.getAssignee())) continue;
                    result = false;
                    break;
                }
            }
            if (result) {
                if (this.runtimeService.createExecutionQuery().processInstanceId(currTask.getProcessInstanceId()).variableValueLike("all_prev_node", "%'" + currTask.getTaskDefinitionKey() + "'%").listPage(0, 1).size() == 0) {
                    result = false;
                } else {
                    HistoricTaskInstance historicTaskInstance;
                    List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).list();
                    list.sort((o1, o2) -> {
                        if (o1.getEndTime() == null) {
                            return -1;
                        }
                        if (o2.getEndTime() == null) {
                            return 1;
                        }
                        return o2.getEndTime().compareTo(o1.getEndTime());
                    });
                    Date date = ((HistoricTaskInstance)list.get(0)).getStartTime();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && ((historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime() == null || historicTaskInstance.getEndTime().compareTo(date) >= 0)) {
                        if (historicTaskInstance.getCreateTime().compareTo(date) >= 0) continue;
                        date = historicTaskInstance.getCreateTime();
                    }
                    if (currTask.getEndTime().before(date)) {
                        result = false;
                    }
                }
            }
        }
        json.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HistoricTaskInstance currTask;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if ((currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult()) == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)currTask.getEndTime())) {
            LOGGER.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        String taskSourceFlag = (String)currTask.getTaskLocalVariables().get("taskSourceFlag");
        boolean revokeReject = false;
        if ("reject".equals(taskSourceFlag)) {
            revokeReject = true;
        }
        if ("revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
        }
        if ("complete_leap".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
        }
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).taskVariableValueEquals(revokeReject ? "reject_from" : "complete_from", (Object)currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        if (ToolUtil.isEmpty((Object)taskList)) {
            taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).taskVariableValueLike("all_prev_node", "%'" + currTask.getTaskDefinitionKey() + "'%")).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        }
        if (taskList != null && taskList.size() > 0) {
            boolean isScope;
            int backType;
            Task task = (Task)taskList.get(0);
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            Object allPrevNode = task.getTaskLocalVariables().get("all_prev_node");
            if (!revokeReject && currTask.getProcessInstanceId().equals(task.getProcessInstanceId()) && ToolUtil.isNotEmpty(allPrevNode) && allPrevNode.toString().contains(",")) {
                newMap.put("all_prev_node", allPrevNode);
                String prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)task.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)task.getTaskDefinitionKey())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                while (!(((Process)bm.getProcesses().get(0)).getFlowElement(prevNode) instanceof ParallelGateway) && !(((Process)bm.getProcesses().get(0)).getFlowElement(prevNode) instanceof InclusiveGateway)) {
                    prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)task.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)prevNode)).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                }
                newMap.put("prev_node", prevNode);
            }
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = currTask.getTaskDefinitionKey();
            Map<String, Object> results = this.backType(null, task, backActivityId, false);
            if (!("complete".equals(taskSourceFlag) || this.canReject(bm, task.getTaskDefinitionKey(), backActivityId, null, null, true) || this.canReject(bm, task.getTaskDefinitionKey(), backActivityId, null, null, false))) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRevokeToTargetNode(), null);
            }
            if (backActivityId.equals(this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey()))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            if ((backType = ((Integer)results.get("num")).intValue()) == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
            }
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean bl = isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            if (!isSubmit && !isScope || revokeReject) {
                List historicTaskInstances;
                Map variables;
                Map oldAppointAssigneeMap;
                String oldAppointAssignee;
                List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).taskVariableValueEquals("complete_type", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
                if (historicTaskInstanceList.size() == 1 && ToolUtil.isNotEmpty((Object)(oldAppointAssignee = (String)(oldAppointAssigneeMap = (Map)((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee")).get(currTask.getTaskDefinitionKey())))) {
                    newMap.put("reject_appoint_assignee", oldAppointAssignee);
                }
                if (revokeReject && ToolUtil.isNotEmpty((variables = ((HistoricTaskInstance)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).taskVariableValueEquals("complete_type", (Object)"complete")).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).get(0)).getTaskLocalVariables()).get("multi_type")) && ToolUtil.isNotEmpty(variables.get("multi_finish_condition"))) {
                    newMap.put("multi_type", variables.get("multi_type").toString());
                    newMap.put("multi_finish_condition", variables.get("multi_finish_condition").toString());
                }
            } else {
                newMap.put("reject_appoint_assignee", userId);
            }
            this.callActivitiReject((List)results.get("affectedTasks"), (Set)results.get("runningActivitiNodeIds"), task.getProcessInstanceId(), userId, comment, revokeReject ? "reject_revoke" : "revoke");
            if (backType == 3) {
                newMap.put("affectedTasks", results.get("affectedTasks"));
            }
            newMap.put("ADD_HISTORY_TASK_START_TIME", currTask.getEndTime());
            newMap.put("isSubmit", isSubmit);
            this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, (TaskEntity)task, null, backActivityId, comment, backType, revokeReject ? "reject_revoke" : "revoke", newMap));
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), revokeReject ? "reject_revoke" : "revoke", (String)results.get("taskName")));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(currTask.getProcessInstanceId()).variableValueLike("all_prev_node", "%'" + currTask.getTaskDefinitionKey() + "'%").list();
        ExecutionEntity executionEntity = (ExecutionEntity)executionList.get(0);
        for (Execution execution : executionList) {
            if (execution.getParentId() != null) {
                executionEntity = (ExecutionEntity)execution;
            }
            if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) continue;
            executionEntity = (ExecutionEntity)execution;
            break;
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(executionEntity.getProcessDefinitionId());
        if (!currTask.getTaskDefinitionKey().equals(executionEntity.getActivityId())) {
            boolean isScope;
            ProcessDefinitionEntity definition;
            Map variables = (Map)this.processEngine.getManagementService().executeCommand((Command)new GetExecutionVariablesCmd(executionEntity.getId(), null, true));
            Object allPrevNode = variables.get("all_prev_node");
            if (ToolUtil.isNotEmpty(allPrevNode) && allPrevNode.toString().contains(",")) {
                newMap.put("all_prev_node", allPrevNode);
                String prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)executionEntity.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)executionEntity.getActivityId())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                while (!(((Process)bm.getProcesses().get(0)).getFlowElement(prevNode) instanceof ParallelGateway) && !(((Process)bm.getProcesses().get(0)).getFlowElement(prevNode) instanceof InclusiveGateway)) {
                    prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)executionEntity.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)prevNode)).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                }
                newMap.put("prev_node", prevNode);
            }
            if ((definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId())) == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            boolean bl = isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            if (!isSubmit && !isScope) {
                Map oldAppointAssigneeMap;
                String oldAppointAssignee;
                List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).taskVariableValueEquals("complete_type", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
                if (historicTaskInstanceList.size() == 1 && ToolUtil.isNotEmpty((Object)(oldAppointAssignee = (String)(oldAppointAssigneeMap = (Map)((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee")).get(currTask.getTaskDefinitionKey())))) {
                    newMap.put("reject_appoint_assignee", oldAppointAssignee);
                }
            } else {
                newMap.put("reject_appoint_assignee", userId);
            }
            return this.revokeTaskWithExecution(executionEntity, currTask, userId, revokeReject ? "reject_revoke" : "revoke", comment, isSubmit, newMap);
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).listPage(0, 1);
        if (tasks.size() == 1) {
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceRevokeTaskCmd(currTask, comment));
            newMap.put("reject_appoint_assignee", userId);
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(currTask.getProcessInstanceId(), false, null, currTask.getTaskDefinitionKey(), userId, currTask.getTaskDefinitionKey(), "revoke", currTask.getName()));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        LambdaQueryWrapper candidateUserLambdaQueryWrapper = new LambdaQueryWrapper();
        candidateUserLambdaQueryWrapper.eq(CandidateUser::getTaskId, (Object)historicTaskId);
        this.candidateUserService.remove((Wrapper)candidateUserLambdaQueryWrapper);
        return InstallResult.getResult((String)"0", (String)"error", null);
    }

    private BpmResponseResult revokeTaskWithExecution(ExecutionEntity execution, HistoricTaskInstance currTask, String userId, String type, String comment, boolean isSubmit, Map<String, Object> map) {
        map.put("ADD_HISTORY_TASK_START_TIME", currTask.getEndTime());
        boolean isFirst = false;
        String starterUserId = "";
        String backActivityId = currTask.getTaskDefinitionKey();
        Map<String, Object> results = this.backType(execution, null, backActivityId, false);
        String processInstanceId = currTask.getProcessInstanceId();
        if (backActivityId.equals(this.getFirstActivityId(processInstanceId, backActivityId))) {
            starterUserId = this.getTaskStarterUserId(execution.getProcessInstanceId());
            isFirst = true;
        }
        int backType = (Integer)results.get("num");
        this.setRejectAppointAssignee(execution.getProcessInstanceId(), currTask.getTaskDefinitionKey(), null, null, isSubmit, map);
        this.callActivitiReject((List)results.get("affectedTasks"), (Set)results.get("runningActivitiNodeIds"), processInstanceId, userId, comment, type);
        if (backType == 3) {
            map.put("affectedTasks", results.get("affectedTasks"));
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, null, execution, backActivityId, comment, backType, type, map));
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(processInstanceId, isFirst, starterUserId, backActivityId, userId, backActivityId, type, execution.getCurrentActivityName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private BpmResponseResult rejectWithExecution(ExecutionEntity execution, String backActivityId, String userId, String type, String comment, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map) {
        if (!this.canRejectToAnyNodePlus(execution.getProcessDefinitionId(), backActivityId)) {
            if ("freejump".equals(type)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotFreeJumpToTargetNode(), null);
            }
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        boolean isFirst = false;
        String starterUserId = "";
        Map<String, Object> results = this.backType(execution, null, backActivityId, false);
        String processInstanceId = execution.getProcessInstanceId();
        if (backActivityId.equals(this.getFirstActivityId(processInstanceId, backActivityId))) {
            starterUserId = this.getTaskStarterUserId(execution.getProcessInstanceId());
            isFirst = true;
        }
        int backType = (Integer)results.get("num");
        this.setRejectAppointAssignee(processInstanceId, backActivityId, assignees, assigneeMap, isSubmit, newMap);
        this.callActivitiReject((List)results.get("affectedTasks"), (Set)results.get("runningActivitiNodeIds"), processInstanceId, userId, comment, type);
        if (backType == 3) {
            newMap.put("affectedTasks", results.get("affectedTasks"));
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(userId, null, execution, backActivityId, comment, backType, type, newMap));
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(processInstanceId, isFirst, starterUserId, backActivityId, userId, backActivityId, type, execution.getCurrentActivityName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private String getTaskStarterUserId(String processInsId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Object> backType(ExecutionEntity execution, Task task, String nodeId, boolean isRejectFirst) {
        Map<String, Object> result = this.getBackTypeWithTasks(nodeId, execution, task, isRejectFirst);
        int num = (Integer)result.get("num");
        if (num != 1 || task == null) {
            return result;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            num = 0;
            result.put("num", num);
            return result;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        if (currActivity == null) {
            throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
        }
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        result.put("num", num);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(String nodeId, ExecutionEntity execution, Task task, boolean isRejectFirst, String state) {
        String taskDefinitionKey;
        String processDefinitionId;
        String processInstanceId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<Object> affectedTasks = new HashSet<String>();
        Set<Object> affectedUserTasks = new HashSet<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        if (task == null) {
            processInstanceId = execution.getProcessInstanceId();
            processDefinitionId = execution.getProcessDefinitionId();
            taskDefinitionKey = execution.getActivityId();
        } else {
            processInstanceId = task.getProcessInstanceId();
            processDefinitionId = task.getProcessDefinitionId();
            taskDefinitionKey = task.getTaskDefinitionKey();
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        result.put("runningActivitiNodeIds", runningActivityNodeIds);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution1 : executions) {
            if (((ExecutionEntity)execution1).isScope() || execution1.getActivityId() == null) continue;
            taskIds.add(execution1.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bm.getProcesses().get(0);
            if (isRejectFirst) {
                newNum = 3;
                for (FlowElement flowElement : process.getFlowElements()) {
                    if (!taskIds.contains(flowElement.getId())) continue;
                    if (flowElement instanceof UserTask) {
                        affectedUserTasks.add(flowElement.getId());
                    }
                    affectedTasks.add(flowElement.getId());
                }
            } else {
                if (nodeId.contains(",")) {
                    for (String targetNodeId : nodeId.split(",")) {
                        if (!ToolUtil.isEmpty((Object)process.getFlowElement(targetNodeId))) continue;
                        throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                    }
                } else if (ToolUtil.isEmpty((Object)process.getFlowElement(nodeId))) {
                    throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                }
                boolean isFindTask = false;
                if (nodeId.contains(",")) {
                    for (String targetNodeId : nodeId.split(",")) {
                        Map<String, Set<String>> map = this.findAffectedTask(process, targetNodeId, true, taskIds);
                        affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                        affectedUserTasks.addAll((Collection)map.get("affectedUserTasks"));
                    }
                } else {
                    Map<String, Set<String>> map = this.findAffectedTask(process, nodeId, true, taskIds);
                    affectedTasks = map.get("affectedTasks");
                    affectedUserTasks = map.get("affectedUserTasks");
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (affectedTasks.size() > 0) {
                    newNum = 3;
                }
                if (!isFindTask) {
                    void var20_29;
                    HashSet hashSet = new HashSet();
                    if (affectedTasks.size() > 0) {
                        Set<Object> set = affectedTasks;
                    }
                    if (nodeId.contains(",")) {
                        for (String targetNodeId : nodeId.split(",")) {
                            Map<String, Set<String>> map = this.findAffectedTask(process, targetNodeId, false, taskIds);
                            affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                            affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                        }
                    } else {
                        Map<String, Set<String>> map = this.findAffectedTask(process, nodeId, false, taskIds);
                        affectedTasks = map.get("affectedTasks");
                        affectedUserTasks = map.get("affectedUserTasks");
                    }
                    if (affectedTasks.contains(taskDefinitionKey)) {
                        isFindTask = true;
                        affectedTasks.remove(taskDefinitionKey);
                    }
                    if (affectedTasks.size() > 0) {
                        newNum = 3;
                    }
                    if (!isFindTask && affectedTasks.size() + var20_29.size() > 0) {
                        newNum = -1;
                    }
                }
            }
        }
        if ("1".equals(state)) {
            HashMap affectedExecution = new HashMap();
            for (Execution execution1 : executions) {
                if (((ExecutionEntity)execution1).isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId())) continue;
                if (affectedExecution.get(execution1.getActivityId()) != null) {
                    List list2 = (List)affectedExecution.get(execution1.getActivityId());
                    list2.add(this.runtimeService.getVariablesLocal(execution1.getId()));
                    continue;
                }
                ArrayList<Map> arrayList = new ArrayList<Map>();
                arrayList.add(this.runtimeService.getVariablesLocal(execution1.getId()));
                affectedExecution.put(execution1.getActivityId(), arrayList);
            }
            result.put("affectedExecution", affectedExecution);
        }
        affectedTasks.add(taskDefinitionKey);
        affectedUserTasks.remove(taskDefinitionKey);
        affectedUserTasks.addAll(runningActivityNodeIds);
        String affectedUserTaskStr = taskDefinitionKey;
        if (affectedUserTasks.size() != 0) {
            StringBuilder affectedUserTaskSb = new StringBuilder(taskDefinitionKey);
            for (String string : affectedUserTasks) {
                affectedUserTaskSb.append(",").append(string);
            }
            affectedUserTaskStr = affectedUserTaskSb.toString();
        }
        result.put("affectedTasks", new ArrayList(affectedTasks));
        result.put("affectedUserTasks", affectedUserTaskStr);
        result.put("affectedCallActivity", runningActivityNodeIds);
        result.put("num", newNum);
        return result;
    }

    private Map<String, Object> getBackTypeWithTasks(String nodeId, ExecutionEntity execution, Task task, boolean isRejectFirst) {
        return this.getBackTypeWithTasks(nodeId, execution, task, isRejectFirst, "1");
    }

    private void callActivitiReject(List<String> nodeIds, Set<String> callActivitiNodeIds, String processInsId, String userId, String comment, String type) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            if (!callActivitiNodeIds.remove(nodeId)) continue;
            ids.add(nodeId);
        }
        if (ids.size() == 0) {
            return;
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("callActivity").list();
        for (HistoricActivityInstance historicActivityInstance : list) {
            if (!ids.contains(historicActivityInstance.getActivityId())) continue;
            CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
            CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
        }
    }

    private void endCallProcess(String instanceId, String userId, String comment, String type) {
        List list;
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(instanceId);
            dataPush.setUserId(userId);
            dataPush.setComment(comment);
            this.dataPushService.endProcess(dataPush);
        }
        if ((list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list()).size() > 0) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
                CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicActivityInstance.getExecutionId(), destinationActivity.getId(), comment, type, new HashMap<String, Object>(), currentActivity));
        }
    }

    private Map<String, Set<String>> findAffectedTask(Process process, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(process.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(process.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(process.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if (taskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (ToolUtil.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TaskComment::getTaskId, (Object)taskId)).eq(TaskComment::getType, (Object)"complete")).eq(TaskComment::getAction, (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(taskId, comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        Task task = this.getTask(taskId, "0");
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCanDelAssignee(), null);
        }
        if (assignees == null) {
            assignees = "";
        }
        if ("".equals(assignees) && task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId, Arrays.asList(assignees.split(","))));
        this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd("", task.getProcessInstanceId(), task.getTaskDefinitionKey(), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public Map<String, Integer> updateRejectForm(Map<String, Object> map) {
        List nodeIds = (List)map.get("nodeIds");
        String procDefId = (String)map.get("procDefId");
        List delNodeIds = (List)map.get("delNodeIds");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(procDefId).unfinished().orderByActivityId().asc()).list();
        HashSet<String> instanceIds = new HashSet<String>();
        if (list.size() == 0) {
            return result;
        }
        String taskDefKey = ((HistoricActivityInstance)list.get(0)).getActivityId();
        HashSet<String> nodeInstanceId = new HashSet<String>();
        HashSet<String> allInstanceIds = new HashSet<String>();
        int processNumAll = 0;
        for (HistoricActivityInstance activityInstance : list) {
            instanceIds.add(activityInstance.getProcessInstanceId());
            if (!delNodeIds.contains(activityInstance.getActivityId())) continue;
            Object num = (Integer)result.get(activityInstance.getActivityId());
            if (num == null) {
                num = 0;
            }
            if (!taskDefKey.equals(activityInstance.getActivityId())) {
                nodeInstanceId = new HashSet();
                taskDefKey = activityInstance.getActivityId();
            }
            if (nodeInstanceId.add(activityInstance.getProcessInstanceId())) {
                Object object = num;
                Object object2 = num = Integer.valueOf((Integer)num + 1);
                result.put(activityInstance.getActivityId(), (Integer)num);
            }
            if (!allInstanceIds.add(activityInstance.getProcessInstanceId())) continue;
            ++processNumAll;
        }
        if (processNumAll > 0) {
            result.put("", processNumAll);
            return result;
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(new ArrayList(instanceIds))).includeTaskLocalVariables()).orderByProcessInstanceId()).orderByTaskCreateTime()).asc()).list();
        HashMap<String, ArrayList<HistoricTaskInstance>> hisTaskMap = new HashMap<String, ArrayList<HistoricTaskInstance>>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            ArrayList<HistoricTaskInstance> hisTasks = (ArrayList<HistoricTaskInstance>)hisTaskMap.get(historicTaskInstance.getProcessInstanceId());
            if (hisTasks == null) {
                hisTasks = new ArrayList<HistoricTaskInstance>();
            }
            hisTasks.add(historicTaskInstance);
            hisTaskMap.put(historicTaskInstance.getProcessInstanceId(), hisTasks);
        }
        HashMap<String, List<String>> finishTaskId = new HashMap<String, List<String>>();
        HashMap<String, List<String>> unFinishTaskId = new HashMap<String, List<String>>();
        for (List hisTasks : hisTaskMap.values()) {
            for (int i = 0; i < hisTasks.size(); ++i) {
                ArrayList<String> taskIds;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTasks.get(i);
                String completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                if (!ToolUtil.isNotEmpty((Object)completeFrom) || nodeIds.contains(completeFrom)) continue;
                String newCompleteFrom = completeFrom;
                boolean isDelFrom = i == 0;
                for (int j = i - 1; j > -1; --j) {
                    newCompleteFrom = (String)((HistoricTaskInstance)hisTasks.get(j)).getTaskLocalVariables().get("complete_from");
                    if (ToolUtil.isEmpty((Object)newCompleteFrom)) {
                        isDelFrom = true;
                        break;
                    }
                    if (nodeIds.contains(newCompleteFrom)) break;
                }
                if (isDelFrom) {
                    newCompleteFrom = "";
                }
                if ((taskIds = (ArrayList<String>)finishTaskId.get(newCompleteFrom)) == null) {
                    taskIds = new ArrayList<String>();
                }
                taskIds.add(historicTaskInstance.getId());
                finishTaskId.put(newCompleteFrom, taskIds);
                if (historicTaskInstance.getEndTime() != null) continue;
                ArrayList<String> unFinishTaskIds = (ArrayList<String>)unFinishTaskId.get(newCompleteFrom);
                if (unFinishTaskIds == null) {
                    unFinishTaskIds = new ArrayList<String>();
                }
                unFinishTaskIds.add(historicTaskInstance.getId());
                unFinishTaskId.put(newCompleteFrom, unFinishTaskIds);
            }
        }
        if (finishTaskId.size() > 0) {
            this.taskEngineMapper.updateHiVarinst(finishTaskId, unFinishTaskId);
            this.taskEngineMapper.updateRuVarinst(finishTaskId, unFinishTaskId);
        }
        return result;
    }

    public void reStartProcessUpdate(String processInsId, String businessId, String processDefinitionId, String parentExecutionId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        map.put("tenantId", tenantId);
        map.put("parentExecutionId", parentExecutionId);
        map.put("processDefinitionId", processDefinitionId);
        this.taskEngineMapper.reStartProcessUpdate(map);
        this.taskEngineMapper.reStartProcessInsert(map);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        if (ToolUtil.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            if (ToolUtil.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), Boolean.valueOf(false));
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    taskDefinitionKey = ((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination().getId();
                    break;
                }
            }
            if (ToolUtil.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("sendUser", userId);
            if (isSubmit && ToolUtil.isEmpty((Object)assignee)) {
                assignee = this.getTaskCommitUser(historicProcessInstance.getId(), taskDefinitionKey);
            }
            if (ToolUtil.isNotEmpty((Object)assignee)) {
                HashMap<String, String> appointAssignee = new HashMap<String, String>();
                appointAssignee.put("static_appoint_assignee", assignee);
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), businessId, historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicProcessInstance.getId(), taskDefinitionKey, null, null, map, null));
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, historicProcessInstance.getId(), null, map));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        List<Map<String, String>> multiTaskMessages = this.taskEngineMapper.getSecurityLevelMultiTask(userId, level);
        for (Map<String, String> map : multiTaskMessages) {
            if (map.get("DUEDATE") != null) {
                this.activityRedisTimerService.delTimeOutModel(String.valueOf(map.get("TASKID")));
            }
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(String.valueOf(map.get("EXECUTIONID")), String.valueOf(map.get("TASKID")), null));
            this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userId, String.valueOf(map.get("processInsId")), map.get("TASKDEFKEY"), new HashMap<String, Object>()));
        }
        this.taskEngineMapper.updateRuIdentityLink(userId, level);
        this.taskEngineMapper.updateRuTask(userId, level);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        if (ToolUtil.isEmpty((Object)processInsId) && ToolUtil.isEmpty((Object)businessId) || ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorReset(), null);
        }
        if (ToolUtil.isEmpty((Object)processInsId)) {
            processInsId = this.taskEngineMapper.getProcessInsIdByBusinessId(businessId);
        }
        this.taskEngineMapper.updateActHiProcinstStater(processInsId, userId);
        this.taskEngineMapper.updateActHiIdentitylinkStater(processInsId, userId);
        this.taskEngineMapper.updateActRuIdentitylinkStater(processInsId, userId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        BpmResponseResult result;
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(CandidateUser::getTaskId, (Object)taskId);
        List candidateUserList = this.candidateUserService.list((Wrapper)ew);
        String users = "";
        StringBuilder candidateUsers = new StringBuilder();
        for (CandidateUser candidateUser : candidateUserList) {
            String userId = candidateUser.getAssignee();
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            candidateUsers.append(",").append(userId);
        }
        users = candidateUsers.toString();
        if (ToolUtil.isNotEmpty((Object)users)) {
            users = users.substring(1);
        }
        if ("1".equals((result = this.addAssignees(taskId, null, users)).getCode())) {
            this.candidateUserService.remove((Wrapper)ew);
        }
        return result;
    }

    public BpmResponseResult getExecutionByBusinessId(String businessId) {
        String processInsId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()).getId();
        if (ToolUtil.isNotEmpty((Object)processInsId)) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            JSONArray json = new JSONArray();
            if (ToolUtil.isEmpty((Object)historicActivityInstances)) {
                return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
            }
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                JSONObject object = new JSONObject();
                object.put("activitiName", (Object)historicActivityInstance.getActivityName());
                object.put("activitiType", (Object)historicActivityInstance.getActivityType());
                object.put("activitiId", (Object)historicActivityInstance.getActivityId());
                object.put("executionId", (Object)historicActivityInstance.getExecutionId());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> variableMap) {
        Map map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, variableMap));
        this.runtimeService.signal(executionId);
        this.activityRedisTimerService.delTimeOutModel(executionId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd((String)map.get("userId"), (String)map.get("processInsId"), (String)map.get("backActivityId"), null));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void rejectDataPush(Task task, String comment, String userId, String taskIds) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.rejectDataPush(dataPush);
        }
    }

    private void completeDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.completeDataPush(dataPush);
        }
    }

    private void claimDataPush(String taskId, String userId) {
        if (this.dataPushService.isDataPush()) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.claimDataPush(dataPush);
        }
    }

    private void freeJumpDataPush(Task task, String comment, String userId, String taskIds) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            if (ToolUtil.isNotEmpty((Object)taskIds)) {
                dataPush.setTaskId(taskIds);
            }
            this.dataPushService.freeJumpDataPush(dataPush);
        }
    }

    private void acceptTaskDataPush(String taskId, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(taskId);
            dataPush.setUserId(userId);
            this.dataPushService.acceptTask(dataPush);
        }
    }

    private void releaseTaskDataPush(String taskId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(taskId);
            this.dataPushService.releaseTask(dataPush);
        }
    }

    private void addUrgeTask(Task task, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.addUrgeTask(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (ToolUtil.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setTenantId(task.getTenantId());
        return dataPush;
    }

    private void setRejectAppointAssignee(String processInstanceId, String backActivityId, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map) {
        Map<String, String> appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!isSubmit) {
            Map oldAppointAssigneeMap;
            String oldAppointAssignee;
            List historicTaskInstanceList;
            if (ToolUtil.isEmpty((Object)assignees) && !backActivityId.contains(",") && (historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() == 1 && ToolUtil.isNotEmpty((Object)(oldAppointAssignee = (String)(oldAppointAssigneeMap = (Map)((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee")).get(backActivityId)))) {
                map.put("reject_appoint_assignee", oldAppointAssignee);
            }
            if (backActivityId.contains(",")) {
                appointAssignee = (HashMap<String, String>)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap<String, String>();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    Map oldAppointAssigneeMap2;
                    String oldAppointAssignee2;
                    List historicTaskInstanceList2;
                    if (appointAssignee.containsKey(targetNodeId) || (historicTaskInstanceList2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() != 1 || !ToolUtil.isNotEmpty((Object)(oldAppointAssignee2 = (String)(oldAppointAssigneeMap2 = (Map)((HistoricTaskInstance)historicTaskInstanceList2.get(0)).getTaskLocalVariables().get("old_appoint_assignee")).get(targetNodeId)))) continue;
                    appointAssignee.put(targetNodeId, oldAppointAssignee2);
                }
                map.put("appoint_assignee", appointAssignee);
            }
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        if (isSubmit) {
            if (backActivityId.contains(",")) {
                appointAssignee = (Map)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    String assignee = this.getTaskCommitUser(processInstanceId, targetNodeId);
                    if (!ToolUtil.isNotEmpty((Object)assignee)) continue;
                    appointAssignee.put(targetNodeId, assignee);
                }
                map.put("appoint_assignee", appointAssignee);
            } else {
                String assignee = this.getTaskCommitUser(processInstanceId, backActivityId);
                if (ToolUtil.isNotEmpty((Object)assignee)) {
                    map.put("reject_appoint_assignee", assignee);
                }
            }
        }
    }

    public ApiResponse<TaskBaseInfo> getTaskBaseParamByTaskId(String taskId, String userId) {
        TaskBaseInfo taskBaseInfo = new TaskBaseInfo();
        TaskBaseInfo taskInfo = this.taskBaseInfoMapper.getTaskInfoByTaskId(Long.parseLong(taskId));
        TaskBaseInfo userInfo = this.iAssigneeChooseService.getUserInfoByUserId(userId);
        BeanUtils.copyProperties((Object)userInfo, (Object)taskBaseInfo);
        taskBaseInfo.setPiid(taskInfo.getPiid());
        taskBaseInfo.setTkiid(taskInfo.getTkiid());
        taskBaseInfo.setHtName(taskInfo.getHtName());
        taskBaseInfo.setHtDescription(taskInfo.getHtDescription());
        taskBaseInfo.setDealTime(new Date());
        return ApiResponse.success((Object)taskBaseInfo);
    }

    public BpmResponseResult acceptTask(String taskId) {
        Long userId = BaseSecurityUtil.getUser().getId();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new PublicClientException(this.bpmConstantProperties.getUnableGetLoginUserId(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new AcceptTaskCmd(taskId, userId.toString()));
        this.acceptTaskDataPush(taskId, userId.toString());
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAcceptSuccess(), null);
    }

    public BpmResponseResult releaseTask(String taskId) {
        this.processEngine.getManagementService().executeCommand((Command)new ReleaseTaskCmd(taskId));
        this.releaseTaskDataPush(taskId);
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getReleaseSuccess(), null);
    }
}

