/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.model.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u6d41\u7a0b\u7ba1\u7406"})
@RequestMapping(value={"/bpm/model"})
public class ModelController {
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private IDefinitionEngineService definitionEngineService;

    @GetMapping(value={"/modelQuery"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", notes="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<ModelBuild>> queryModelList(Page<ModelBuild> page, String modelName) {
        try {
            return ApiResponse.success((Object)this.modelService.queryModelList(modelName, page));
        }
        catch (Exception e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    @GetMapping(value={"/modelDeploy"})
    @ApiOperation(value="\u90e8\u7f72\u6d41\u7a0b", notes="\u90e8\u7f72\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u90e8\u7f72\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            this.modelService.deployModel(modelId, BaseSecurityUtil.getUser().getStringTenantId());
        }
        catch (Exception e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        return ApiResponse.success((String)BpmEnum.DEPLOY_SUCCESS.getMessage());
    }

    @PostMapping(value={"/batchImport"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165", notes="\u6279\u91cf\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u4e0a\u4f20\u7684\u538b\u7f29\u6587\u4ef6", required=true, paramType="query"), @ApiImplicitParam(name="request", value="\u8bf7\u6c42", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u6279\u91cf\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        return this.modelService.importModel(BaseSecurityUtil.getUser().getStringTenantId(), file, request);
    }

    @PostMapping(value={"/exportFiles"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6240\u9009\u6d41\u7a0bid", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public void exportAllFile(@RequestBody String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportAllFileModel(BaseSecurityUtil.getUser().getStringTenantId(), modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/deleteModel"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5220\u9664\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteModel(@RequestBody String modelId) {
        return this.modelService.deleteModel(BaseSecurityUtil.getUser().getStringTenantId(), modelId);
    }

    @GetMapping(value={"/deleteModelWithVersion"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5220\u9664\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteModelWithVersion(String processDefId) {
        return this.modelService.deleteModelWithVersion(BaseSecurityUtil.getUser().getStringTenantId(), processDefId);
    }

    @GetMapping(value={"/getAllModel"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", notes="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b")
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.success((Object)this.modelService.getAllModel());
    }

    @GetMapping(value={"/getProcessAssignee"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskDefKey", value="\u8282\u70b9id", required=false, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getProcessAssignee(String procDefKey, String taskDefKey) {
        return this.sysActAssigneeService.getAssigneeModel(procDefKey, taskDefKey);
    }

    @PostMapping(value={"/downloadFiles"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="request", value="\u8bf7\u6c42", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public void downloadXmlTest(@RequestBody DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        this.modelService.downloadFiles(downloadFilesDto, response);
    }

    @GetMapping(value={"/judgeProcessName"})
    @ApiOperation(value="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d", notes="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult judgeProcessName(@RequestParam(value="processName") String processName) {
        return this.definitionEngineService.judgeProcessName(processName);
    }

    @GetMapping(value={"/judgeProcDefKey"})
    @ApiOperation(value="\u5224\u65ad\u6d41\u7a0b\u6807\u8bc6\u662f\u5426\u91cd\u590d", notes="\u5224\u65ad\u6d41\u7a0b\u6807\u8bc6\u662f\u5426\u91cd\u590d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u5224\u65ad\u6d41\u7a0b\u6807\u8bc6\u662f\u5426\u91cd\u590d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult judgeProcDefKey(@RequestParam(value="procDefKey") String procDefKey) {
        return this.definitionEngineService.judgeProcDefKey(procDefKey);
    }
}

