/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.vo.TaskVo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private TaskManagerMapper taskManagerMapper;
    @Resource
    private AssigneeChooseServiceImpl assigneeChooseService;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private HistoryService historyService;

    public int count() {
        return this.taskManagerMapper.count(new Date());
    }

    public List<TaskManager> getTask(Page<TaskManager> pages, GetTaskManagerDto taskManagerDto) {
        Map map;
        taskManagerDto.setDateTime(new Date());
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, taskManagerDto);
        ArrayList<String> taskIds = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            taskIds.add(taskManager.getId());
        }
        List<Object> allVariables = new ArrayList();
        if (!list.isEmpty()) {
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
        }
        HashMap<String, Map> variableMap = new HashMap<String, Map>();
        for (Variables variables : allVariables) {
            if (!"todoConfiguration".equals(variables.getName()) && !"sendUser".equals(variables.getName())) continue;
            map = (Map)variableMap.get(variables.getTaskId());
            map = map == null ? new HashMap() : map;
            map.put(variables.getName(), variables.getTextValue());
            variableMap.put(variables.getTaskId(), map);
        }
        for (TaskManager taskManager : list) {
            map = (Map)variableMap.get(taskManager.getId());
            map = map == null ? new HashMap() : map;
            taskManager.setSendUser((String)map.get("sendUser"));
            taskManager.setTodoConfiguration((String)map.get("todoConfiguration"));
        }
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)taskManager.getReceivers())) {
                receiver = new ArrayList(new HashSet(taskManager.getReceivers()));
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getFirstReceiver())) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getSendUser())) {
                receiver.add(0, taskManager.getSendUser());
            }
            users.addAll(receiver);
        }
        HashSet hashSet = new HashSet(users);
        hashSet.remove(null);
        users.clear();
        users.addAll(hashSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users, String.valueOf(taskManagerDto.getTenantId()));
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (taskManager.getReceivers() != null) {
                receiver = new ArrayList(new HashSet(taskManager.getReceivers()));
            }
            if (taskManager.getFirstReceiver() != null) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (receiver.size() > 0) {
                taskManager.setFirstReceiver((String)receiver.get(0));
            }
            taskManager.setReceivers(receiver);
            ArrayList<String> name = new ArrayList<String>();
            for (String id : receiver) {
                name.add(userMap.get(id));
            }
            taskManager.setReceiverName(name);
            taskManager.setSendUserName(userMap.get(taskManager.getSendUser()));
        }
        return list;
    }

    public ApiResponse<String> suspendTaskById(String processInsId) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    public ApiResponse<String> activateTaskById(String processInsId) {
        try {
            this.runtimeService.activateProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    private Map<String, String> getFileByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (historicTaskInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessId, (Object)historicTaskInstance.getProcessDefinitionId());
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        SysActProcessFile sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
        String file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        map.put("main", file);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        if (historicProcessInstance.getSuperProcessInstanceId() != null) {
            String procDefId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicProcessInstance.getSuperProcessInstanceId()).singleResult()).getProcessDefinitionId();
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
            file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            map.put("call", file);
        }
        return map;
    }

    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        if (BpmTenantInfoUtils.isStartAlone()) {
            taskManagerDto.setTenantId(BaseSecurityUtil.getUser().getStringTenantId());
        }
        List<TaskManager> list = this.getTask(page, taskManagerDto);
        page.setRecords(list);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<TaskVo>> getJumpTasks(String taskId) {
        TaskVo task;
        FlowModel flowModel;
        Map<String, String> flowModelMessage = this.getFileByTaskId(taskId);
        ArrayList<TaskVo> tasks = new ArrayList<TaskVo>();
        if (flowModelMessage.get("main") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("main"), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new TaskVo();
                task.setId(flowObject.getId());
                task.setValue(flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        if (flowModelMessage.get("call") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("call"), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new TaskVo();
                task.setId("main_process_" + flowObject.getId());
                task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        return ApiResponse.success(tasks);
    }
}

