/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPushService {
    @Autowired
    List<DataPushListener> dataPushListeners;

    public boolean isDataPush() {
        return true;
    }

    public void addDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void completeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.completeTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.entrustTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.rejectTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.revokeTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.freeJumpTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUser(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteMultiTask(List<String> taskIds) {
        try {
            DataPush dataPush = new DataPush();
            dataPush.setTaskIds(taskIds);
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteMultiTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCcTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUrgeTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.endProcess(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void acceptTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.acceptTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void releaseTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.releaseTask(dataPush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

