/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessFileServiceImpl
extends ServiceImpl<SysActProcessFileMapper, SysActProcessFile>
implements SysActProcessFileService {
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;
    @Autowired
    ProcessDefinitionsService processDefinitionsService;

    public void updateFile(WorkFlow workFlow, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity());
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        wfdFile.setModelId(workFlow.getModelId());
        this.sysActProcessFileMapper.updateById(wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        this.sysActProcessFileMapper.updateById(metaFile);
        workFlow.setData(data);
    }

    public void addFile(WorkFlow workFlow, String tenantId, Integer latestVersion) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Integer realLatestVersion = latestVersion;
        if (ToolUtil.isEmpty((Object)latestVersion)) {
            realLatestVersion = this.sysActProcessFileMapper.selectLatestVersion(workFlow.getIdentity()) + 1;
        }
        SysActProcessFile file = new SysActProcessFile();
        file.setId(null);
        file.setCreateTime(ts);
        file.setVersion(realLatestVersion);
        if (ToolUtil.isNotEmpty((Object)workFlow.getProcDefId()) && Integer.parseInt(workFlow.getProcDefId().split(":")[1]) < 1) {
            file.setVersion(Integer.valueOf(-1));
        }
        file.setProcessKey(workFlow.getIdentity());
        file.setModelId(workFlow.getModelId());
        file.setProcessId(workFlow.getProcDefId());
        file.setTenantId(tenantId);
        file.setType("wfd");
        file.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        this.sysActProcessFileMapper.insert(file);
        file.setId(null);
        file.setType("meta");
        String data = workFlow.getData();
        workFlow.setData(null);
        file.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        this.sysActProcessFileMapper.insert(file);
        workFlow.setData(data);
    }

    public WorkFlow getFileByProcessKey(String processKey, String tenantId, Integer version) {
        Integer lastVersion = version;
        if (ToolUtil.isEmpty((Object)version)) {
            lastVersion = this.sysActProcessFileMapper.selectLatestVersion(processKey);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (ToolUtil.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (ToolUtil.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            workFlow.setVersion(String.valueOf(this.processDefinitionsService.queryLatestVersion(processKey)));
            return workFlow;
        }
        return null;
    }

    public WorkFlow getFileByProcessKeyAndProcessId(String processKey, String processId, String tenantId) {
        LambdaQueryWrapper queryWrapper;
        String wfdInfo = null;
        String metaInfo = null;
        if (ToolUtil.equals((Object)processId, (Object)processKey)) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
            if (BpmTenantInfoUtils.isStartAlone()) {
                queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
            }
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            }
        } else {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processId);
            if (BpmTenantInfoUtils.isStartAlone()) {
                queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
            }
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            }
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject(metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    public List<SysActProcessFile> getBaseFileList(String processKey, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public boolean copyFiles(String processKey, String id, String tenantId) {
        WorkFlow workFlow = ToolUtil.isNotEmpty((Object)id) ? this.getFileByProcessKeyAndProcessId(processKey, id, tenantId) : this.getFileByProcessKey(processKey, tenantId, 0);
        this.updateFile(workFlow, tenantId);
        return true;
    }

    public List<SysActProcessFile> exportFileList(List<String> modelIds, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getModelId, modelIds);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFileListByKeys(List<String> keys, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessKey, keys);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFile(String procId, String tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessId, new Object[]{procId});
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public void updateMetaByIdentity(String identity, String name, String category, String tenantId) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(identity);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(lastVersion);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)identity);
        queryWrapper.in(SysActProcessFile::getVersion, list);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
        if (BpmTenantInfoUtils.isStartAlone()) {
            queryWrapper.eq(SysActProcessFile::getTenantId, (Object)tenantId);
        }
        List sysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessFile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
            if (ToolUtil.isNotEmpty((Object)name)) {
                workFlow.setName(name);
            }
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            this.sysActProcessFileMapper.updateById(sysActProcessFile);
        }
    }
}

