/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendParallelGatewayActivityBehavior
extends ParallelGatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ParallelGatewayActivityBehavior.class);
    private static String GONE_GATEWAY_IDS = "gone_gateway_ids";

    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity activity = execution.getActivity();
        List outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        List joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
        execution.removeVariable("reject_execution");
        int nbrOfExecutionsToJoin = execution.getActivity().getIncomingTransitions().size();
        int nbrOfExecutionsJoined = joinedExecutions.size();
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
        if (!this.activeConcurrentExecutionsExist(execution)) {
            if (log.isDebugEnabled()) {
                log.debug("parallel gateway '{}' activates: {} of {} joined", new Object[]{activity.getId(), nbrOfExecutionsJoined, nbrOfExecutionsToJoin});
            }
            execution.takeAll(outgoingTransitions, joinedExecutions);
        } else if (log.isDebugEnabled()) {
            log.debug("parallel gateway '{}' does not activate: {} of {} joined", new Object[]{activity.getId(), nbrOfExecutionsJoined, nbrOfExecutionsToJoin});
        }
    }

    public boolean activeConcurrentExecutionsExist(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        if (execution.isConcurrent()) {
            for (ActivityExecution activityExecution : this.getLeaveExecutions(execution.getParent())) {
                TransitionImpl pvmTransition;
                boolean reachable;
                if (!activityExecution.isActive() || activityExecution.getId().equals(execution.getId()) || !(reachable = (pvmTransition = ((ExecutionEntity)activityExecution).getTransitionBeingTaken()) != null ? this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>()) : this.isReachable(activityExecution.getActivity(), activity, new HashSet<PvmActivity>()))) continue;
                if (log.isDebugEnabled()) {
                    log.debug("an active concurrent execution found: '{}'", (Object)activityExecution.getActivity());
                }
                return true;
            }
        } else if (execution.isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("an active concurrent execution found: '{}'", (Object)execution.getActivity());
            }
            return true;
        }
        return false;
    }

    List<? extends ActivityExecution> getLeaveExecutions(ActivityExecution parent) {
        ArrayList<Object> executionlist = new ArrayList<Object>();
        List subExecutions = parent.getExecutions();
        if (subExecutions.isEmpty()) {
            executionlist.add(parent);
        } else {
            for (ActivityExecution concurrentExecution : subExecutions) {
                executionlist.addAll(this.getLeaveExecutions(concurrentExecution));
            }
        }
        return executionlist;
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.getOutgoingTransitions().isEmpty()) {
            visitedActivities.add(srcActivity);
            if (!(srcActivity.getParent() instanceof PvmActivity)) {
                return false;
            }
            srcActivity = (PvmActivity)srcActivity.getParent();
        }
        if (srcActivity.equals(targetActivity)) {
            return true;
        }
        visitedActivities.add(srcActivity);
        List transitionList = srcActivity.getOutgoingTransitions();
        if (transitionList != null && !transitionList.isEmpty()) {
            for (PvmTransition pvmTransition : transitionList) {
                boolean reachable;
                PvmActivity destinationActivity = pvmTransition.getDestination();
                if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
                return true;
            }
        }
        return false;
    }
}

