/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class CommonJumpTaskCmd
implements Command<Void> {
    private String userId;
    private String executionId;
    private String targetNodeIds;
    private String comment;
    private String type;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);

    public Void execute(CommandContext commandContext) {
        boolean needRemoveTask = this.paramvar.get("ADD_HISTORY_TASK_START_TIME") != null;
        boolean reject = this.type.equals("reject");
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        List executionEntities = executionEntity.getExecutions();
        for (int i = executionEntities.size() - 1; i >= 0; --i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        if (needRemoveTask) {
            ArrayList<String> delTaskIds = new ArrayList<String>();
            for (TaskEntity taskEntity : taskEntities) {
                delTaskIds.add(taskEntity.getId().replace("'", ""));
            }
            if (ToolUtil.isNotEmpty(delTaskIds)) {
                this.taskEngineMapper.removeMultiHistoryTask(delTaskIds);
                if (this.dataPushService.isDataPush()) {
                    this.dataPushService.deleteMultiTask(delTaskIds);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "CommonJumpTaskCmd-Completed", false);
        }
        if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        if (reject) {
            this.paramvar.put("reject_from", this.currentActivity.getId());
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    public CommonJumpTaskCmd(String userId, String executionId, String targetNodeIds, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
    }
}

