/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActEntrustApiService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActEntrustWorkflowApiService
implements SysActEntrustApiService {
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ModelService modelService;

    public BpmResponseResult list(String userId, String processKey, Integer page, Integer size) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)"\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey);
        ew.eq(SysActEntrust::getMandator, (Object)userId);
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        List list = ((Page)this.sysActEntrustService.page((IPage)pages, (Wrapper)ew)).getRecords();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (SysActEntrust sysActEntrust : list) {
            userIds.add(sysActEntrust.getMandatary());
            processKeys.add(sysActEntrust.getProcessKey());
        }
        Map userNameMap = this.assigneeChooseService.getUserListByUserId(userIds, BaseSecurityUtil.getUser().getStringTenantId());
        Map modelNameMap = this.modelService.selectModelNames(processKeys);
        for (SysActEntrust sysActEntrust : list) {
            sysActEntrust.setProcessName((String)modelNameMap.get(sysActEntrust.getProcessKey()));
            sysActEntrust.setMandataryName((String)userNameMap.get(sysActEntrust.getMandatary()));
        }
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)list);
        jsonArray.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult add(String processKey, String mandator, String mandatary, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust1 = new SysActEntrust(processKey, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)ew.eq(SysActEntrust::getMandator, (Object)sysActEntrust1.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust1.getProcessKey());
        List list = this.sysActEntrustService.list((Wrapper)ew);
        if (list.size() >= 1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getExistMandatary(), null);
        }
        this.sysActEntrustService.save((Object)sysActEntrust1);
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessSave(), null);
    }

    public BpmResponseResult addBatch(List<String> processKey, String mandator, String mandatary, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        List list = null;
        int isRight = 0;
        for (int i = 0; i < processKey.size(); ++i) {
            String id = String.valueOf(processKey.get(i));
            sysActEntrust = new SysActEntrust(id, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            LambdaQueryWrapper ew = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)ew.eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey());
            list = this.sysActEntrustService.list((Wrapper)ew);
            if (list.size() >= 1) continue;
            sysActEntrust = new SysActEntrust(id, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getExistMandatary(), null);
        }
        this.sysActEntrustService.saveBatch(tt, processKey.size());
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessSave(), null);
    }

    public BpmResponseResult delete(String tEntrustId) {
        this.sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
    }

    public BpmResponseResult update(Long id, String mandatary, String startTime, String endTime) {
        try {
            SysActEntrust sysActEntrust = new SysActEntrust(id, null, null, mandatary, null, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            this.sysActEntrustService.updateById((Object)sysActEntrust);
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessUpdate(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorUpdate(), null);
        }
    }

    public BpmResponseResult detail(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(this.sysActEntrustService.getById((Serializable)((Object)tEntrustId)));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult updateState(String tEntrustId, String state) {
        this.sysActEntrustService.updateState(tEntrustId, state);
        if ("1".equals(state)) {
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessStart(), null);
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessStop(), null);
    }
}

