/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.TaskEngineApiService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskEngineWorkflowApiService
implements TaskEngineApiService {
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private AddCustomNodeService addCustomNodeService;

    public ApiResponse<?> queryTask(String taskId, String tenantId) {
        return this.taskEngineService.queryTask(taskId, tenantId);
    }

    public ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, Integer page, Integer size) {
        return this.taskEngineService.queryAllToDoTaskList(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, tenantId, page, size);
    }

    public ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, List<String> businessList, Integer page, Integer size) {
        return this.taskEngineService.queryAllToDoTaskListByBusiness(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, businessList, tenantId, page, size);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        return this.taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, tenantId);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows, String tenantId) {
        return this.taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, tenantId, Integer.valueOf(page == null ? 1 : page), Integer.valueOf(rows == null ? 10 : rows));
    }

    public ApiResponse<?> queryToDoTaskList(String userId, List<String> businessIds, String tenantId) {
        return this.taskEngineService.queryToDoTaskList(userId, businessIds, tenantId);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        return this.taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, tenantId);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        return this.taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, tenantId, Integer.valueOf(page == null ? 1 : page), Integer.valueOf(rows == null ? 10 : rows));
    }

    public ApiResponse<?> queryUserTaskCount(String userId) {
        return this.taskEngineService.queryUserTaskCount(userId);
    }

    public ApiResponse<?> queryUserTaskCountByNode(String userId) {
        return this.taskEngineService.queryUserTaskCountByNode(userId);
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        return this.taskEngineService.claimTask(taskId, userId);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        return this.taskEngineService.unClaimTask(taskId);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, comment, map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, comment, map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, comment, subProcesses, map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public BpmResponseResult completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeLeapTask(taskId, userId, assigneeMap, comment, map);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeLeapTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, "", isSubmit, map, null);
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, assignees, isSubmit, map, null);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToFirstTask(taskId, userId, comment, assignees, isSubmit, map);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToFirstTask(taskId, userId, comment, "", isSubmit, map);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, assignees, null, isSubmit, map);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, "", null, isSubmit, map);
    }

    public BpmResponseResult queryRejectNode(String taskId) {
        return this.taskEngineService.queryRejectNode(taskId);
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        return this.taskEngineService.delegateTask(taskId, userId);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        return this.taskEngineService.entrustTask(taskId, userId, mandatary);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary) {
        return this.taskEngineService.entrustTask(taskId, mandatary, 1);
    }

    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        return this.taskEngineService.freeJump(taskId, activitiId, userId, assignees, null, isSubmit, comment, map);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        return this.taskEngineService.multiInstanceAddAssignee(taskId, assigneeList);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return this.taskEngineService.queryAssigneeByTaskId(taskId);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        return this.taskEngineService.addAssignees(taskId, businessId, users);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String mandatary) {
        return this.taskEngineService.taskAddAssignee(taskId, mandatary);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return this.taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
    }

    public BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processKey, taskId, nodeId, userId, map);
    }

    public BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map, String tenantId) {
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processKey, taskId, nodeId, null, map);
    }

    public BpmResponseResult queryAllAssignee(String processKey) {
        return this.taskEngineService.queryAllAssignee(processKey, null);
    }

    public BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(String processKey, String taskDefinitionKey) {
        return this.taskEngineService.queryAllAssignee(processKey, taskDefinitionKey);
    }

    public ApiResponse<?> queryHistoryActByTaskId(String taskId) {
        return this.taskEngineService.queryHistoryActByTaskId(taskId, null);
    }

    public ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        return this.taskEngineService.getProcessDefinitionIdAndNodeId(processKey, taskId);
    }

    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        return this.taskEngineService.queryTaskIdByBusinessId(businessId);
    }

    public BpmResponseResult queryNextNode(String taskId) {
        return this.taskEngineService.queryNextNode(taskId, false);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId) {
        return this.taskEngineService.queryNextNode(processKey, taskId, false);
    }

    public BpmResponseResult queryRejectNodeOrNextNode(String processKey, String taskId) {
        return this.taskEngineService.queryNextNode(processKey, taskId, true);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, Map<String, Object> lineCondition) {
        return this.taskEngineService.queryNextNode(processKey, taskId, lineCondition);
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        return this.taskEngineService.withdrawState(historicTaskId);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.revokeTask(historicTaskId, userId, comment, isSubmit, map);
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        return this.taskEngineService.editTaskComment(taskId, comment);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.reStartProcess(processInsId, businessId, taskDefinitionKey, userId, assignee, isSubmit, map);
    }

    public ApiResponse<String> addCustomNode(String taskId, List<Map<String, Object>> list, String tenantId, String parallel) {
        return this.addCustomNodeService.addNode(taskId, JSON.toJSONString(list), tenantId, parallel);
    }

    public ApiResponse<String> isAddParallel(String taskId, String tenantId) {
        return this.addCustomNodeService.isAddParallel(taskId, tenantId);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId) {
        return this.taskEngineService.multiInstanceDelAssignee(taskId, null);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        return this.taskEngineService.multiInstanceDelAssignee(taskId, assignees);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        return this.taskEngineService.updateUserSecurityLevel(userId, level);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        return this.taskEngineService.activeTaskCandidates(taskId);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        return this.taskEngineService.updateStarter(processInsId, businessId, userId);
    }

    public BpmResponseResult getExecutionByBusinessKey(String businessId) {
        return this.taskEngineService.getExecutionByBusinessId(businessId);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> map) {
        return this.taskEngineService.receiveTaskSignal(executionId, map);
    }

    public BpmResponseResult acceptTask(String taskId) {
        return this.taskEngineService.acceptTask(taskId);
    }

    public BpmResponseResult releaseTask(String taskId) {
        return this.taskEngineService.releaseTask(taskId);
    }
}

