/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.inspur.frame.security.JwtFlag;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f85\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpm/toDoManage"})
public class ToDoManageController {
    private static Logger logger = LoggerFactory.getLogger(ToDoManageController.class);
    @Autowired
    private FlowEventsService flowEventsService;

    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b")
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @JwtFlag(inUse=false)
    public ApiResponse<JSONArray> queryProcess() {
        try {
            return ApiResponse.success((Object)this.flowEventsService.flowType());
        }
        catch (Exception exception) {
            throw new PublicClientException("");
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @JwtFlag(inUse=false)
    public ApiResponse<IPage<TaskManagerQueryVo>> list(Page<FlowTask> pages, TaskManageQueryDto taskManageQueryDto) {
        logger.info("----------------------------------- \u8fdb\u5165\u5f85\u529e\u67e5\u8be2\u63a5\u53e3 {/bpm/toDoManage/list}");
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        long startTimeValue = System.currentTimeMillis();
        ApiResponse response = this.flowEventsService.todoList(pages, userId, processKey, null, null, message, sendUserId, startTime, endTime, BaseSecurityUtil.getUser().getStringTenantId());
        logger.info("----------------------------------------------------------------------------");
        logger.info("----------------------------------- {/bpm/toDoManage/list} \u5f85\u529e\u67e5\u8be2\u6267\u884c\u6210\u529f \u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTimeValue));
        logger.info("----------------------------------------------------------------------------");
        return response;
    }
}

