/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private String taskId;
    private String userId;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (ToolUtil.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > 1503) {
                eventMessage = eventMessage.substring(0, 1500) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        this.variables.put("sendUser", this.userId);
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocalWithOutQuery("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (ToolUtil.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        task.complete(this.variables, false);
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, Map<String, Object> variables) {
        this(taskId, userId);
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        if (variables != null) {
            this.variables = variables;
        }
    }
}

