/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExeListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.TimeOutStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.UserTask;

public final class FormBpmnUtil {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");

    private FormBpmnUtil() {
    }

    public static GraphicInfo createGraphicInfo(FlowObject currentValue) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(Double.parseDouble(currentValue.getLeft().replace("px", "")));
        graphicInfo.setY(Double.parseDouble(currentValue.getTop().replace("px", "")));
        graphicInfo.setWidth(Double.parseDouble(currentValue.getWidth().replace("px", "")));
        graphicInfo.setHeight(Double.parseDouble(currentValue.getHeight().replace("px", "")));
        return graphicInfo;
    }

    public static List<GraphicInfo> createFlowGraphicInfo(FlowSequence currentValue) {
        ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
        for (FlowSequenceXy xy : currentValue.getPoints()) {
            GraphicInfo graphicInfo = new GraphicInfo();
            graphicInfo.setX(Double.parseDouble(xy.getX()));
            graphicInfo.setY(Double.parseDouble(xy.getY()));
            graphicInfoList.add(graphicInfo);
        }
        return graphicInfoList;
    }

    public static SequenceFlow createSequenceFlow(FlowSequence formSequence, List<FlowObject> element) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(formSequence.getId());
        flow.setName(formSequence.getName());
        flow.setSourceRef(FormBpmnUtil.getNodeId(formSequence.getStart().getKey(), element));
        flow.setTargetRef(FormBpmnUtil.getNodeId(formSequence.getEnd().getKey(), element));
        if (!formSequence.isFlowDefault()) {
            flow.setConditionExpression(formSequence.getProps().getBackFlowCondition());
        }
        return flow;
    }

    private static String getNodeId(String key, List<FlowObject> element) {
        String nodeId = key;
        for (FlowObject flowObject : element) {
            if (!key.equals(flowObject.getInstanceKey())) continue;
            nodeId = flowObject.getNodeId();
            break;
        }
        return nodeId;
    }

    public static void extendHandle(FlowObject flowObject, UserTask userTask) {
        String markNode;
        int i;
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowObject.getProps().getTodoConfiguration().getModalValue()));
        JSONArray assignmentNodes = (JSONArray)flowObject.getProps().getFlowAssignment().getParticipantConfigs();
        StringBuilder assignmentNodeValue = new StringBuilder();
        if (ToolUtil.isNotEmpty((Object)assignmentNodes)) {
            for (i = 0; i < assignmentNodes.size(); ++i) {
                markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!ToolUtil.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(assignmentNodes = (JSONArray)flowObject.getProps().getFlowRecipients().getCarbonCopyConfigs()))) {
            for (i = 0; i < assignmentNodes.size(); ++i) {
                markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!ToolUtil.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        String assignmentNode = assignmentNodeValue.toString().length() > 0 ? assignmentNodeValue.toString().substring(1) : "";
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNode));
        String skiprepetition = flowObject.getProps().getFlowSkipRepetition();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("skiprepetition", skiprepetition));
        String allowSetParticipant = flowObject.getProps().getAllowSetParticipant();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("allowSetParticipant", allowSetParticipant));
        TimeOutStrategy timeOutStrategy = flowObject.getProps().getTimeOutStrategy();
        if (ToolUtil.isNotEmpty((Object)timeOutStrategy) && !"unHandle".equals(timeOutStrategy.getTimeoutStrategyType()) && ToolUtil.isNotEmpty((Object)timeOutStrategy.getTimeoutStrategyType())) {
            if ("outInterface".equals(timeOutStrategy.getTimeoutStrategyType())) {
                String path = timeOutStrategy.getOutInterface();
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", path));
            } else if (!"".equals(timeOutStrategy.getTimeoutStrategyType())) {
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", timeOutStrategy.getTimeoutStrategyType()));
            }
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("currentdept", "false"));
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowStarter", "false"));
        String formDetailAddress = flowObject.getProps().getFormDetailAddress();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowFormDetailKey", formDetailAddress));
        String delayToAssign = flowObject.getProps().getDelayToAssign();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("delayToAssign", delayToAssign));
    }

    public static void assigneeInstall(FlowObject flowObject, UserTask userTask, Map<String, String> map) {
        FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
        String strTemp = flowAssignment.getDefaultBackCondtion();
        userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List judgeBackConditions = flowAssignment.getJudgeBackCondition();
        JSONObject jsonObject = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)judgeBackConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObject.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionAssign", jsonObject.toJSONString()));
        }
    }

    public static void callActivityAssigneeInstall(FlowObject flowObject, CallActivity callActivity, Map<String, String> map) {
        FlowAssignment flowAssignment;
        if (ToolUtil.isNotEmpty((Object)flowObject.getProps().getFlowParamConfig())) {
            String flowParamConfigField = flowObject.getProps().getFlowParamConfig().getField() == null ? "" : flowObject.getProps().getFlowParamConfig().getField();
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("flowParamConfigField", flowParamConfigField));
        }
        if ((flowAssignment = flowObject.getProps().getFlowSelector()) != null) {
            String defaultProcessKey = flowAssignment.getDefaultProcessKey();
            String defaultAssignee = flowAssignment.getDefaultBackCondtion();
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("defaultCallAssignee", FormBpmnUtil.getRealAssignee(defaultAssignee, map)));
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("defaultCallProcessKey", defaultProcessKey));
            List judgeBackConditions = flowAssignment.getJudgeBackCondition();
            JSONObject conditionCallProcessKey = new JSONObject();
            JSONObject conditionCallAssignee = new JSONObject();
            if (ToolUtil.isNotEmpty((Object)judgeBackConditions)) {
                for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                    if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                    conditionCallAssignee.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
                    conditionCallProcessKey.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getConditionProcessKey(), map));
                }
                callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("conditionCallAssign", conditionCallAssignee.toJSONString()));
                callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("conditionCallProcessKey", conditionCallProcessKey.toJSONString()));
            }
            JSONArray assignmentNodes = (JSONArray)flowObject.getProps().getFlowSelector().getParticipantConfigs();
            StringBuilder assignmentNodeValue = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)assignmentNodes)) {
                for (int i = 0; i < assignmentNodes.size(); ++i) {
                    String markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                    if (!ToolUtil.isNotEmpty((Object)markNode)) continue;
                    assignmentNodeValue.append(",").append(markNode);
                }
            }
            String assignmentNode = assignmentNodeValue.toString().length() > 0 ? assignmentNodeValue.toString().substring(1) : "";
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNode));
        }
    }

    private static String getRealAssignee(String assignee, Map<String, String> map) {
        if (assignee != null && assignee.contains("@{")) {
            String realAssignee = assignee;
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                String functionString = matcher.group();
                realAssignee = realAssignee.replace(functionString, map.get(functionString.substring(2, functionString.length() - 2)));
            }
            return realAssignee;
        }
        return assignee;
    }

    public static void ccInstall(FlowObject jsonObject, UserTask userTask, Map<String, String> map) {
        FlowRecipients flowRecipients = jsonObject.getProps().getFlowRecipients();
        if (flowRecipients == null) {
            return;
        }
        String strTemp = flowRecipients.getDefaultCcCondtion();
        userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultCcAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List judgeCcConditions = flowRecipients.getJudgeCcCondition();
        JSONObject jsonObjectCc = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)judgeCcConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeCcConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObjectCc.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            userTask.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionCcAssign", jsonObjectCc.toJSONString()));
        }
    }

    public static void addTaskListener(UserTask userTask, FlowObject flowObject) {
        List taskListeners;
        ExtendTaskListener extendTaskListener;
        OriginalTaskListener originalTaskListener = flowObject.getProps().getOriginalTaskListener();
        if (ToolUtil.isNotEmpty((Object)originalTaskListener)) {
            List taskListeners2 = originalTaskListener.getTaskListener();
            for (ActivitiListener activitiListener : taskListeners2) {
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            }
            userTask.setTaskListeners(taskListeners2);
        }
        if (ToolUtil.isNotEmpty((Object)(extendTaskListener = flowObject.getProps().getTaskListener())) && ToolUtil.isNotEmpty((Object)(taskListeners = extendTaskListener.getTaskListener()))) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendTaskListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                userTask.addExtensionElement(extensionElement);
            }
        }
    }

    public static ExtensionElement addExtensionElement(String name, String value) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespacePrefix("extend");
        extensionElement.setNamespace("http://activiti.org/bpmn");
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(name);
        extensionAttribute.setValue(ToolUtil.isEmpty((Object)value) ? "" : value);
        extensionElement.addAttribute(extensionAttribute);
        return extensionElement;
    }

    public static ExtensionAttribute addExtensionAttribute(String name, String value) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setNamespacePrefix("extend");
        extensionAttribute.setNamespace("http://activiti.org/bpmn");
        extensionAttribute.setName(name);
        extensionAttribute.setValue(ToolUtil.isEmpty((Object)value) ? "" : value);
        return extensionAttribute;
    }

    public static void addExeListener(FlowElement userTask, List<FlowVariables> useVariables, List<String> pathIds, boolean flag) {
        ActivitiListener activitiListener;
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        boolean addStart = flag;
        boolean addEnd = flag;
        for (FlowVariables flowVariables : useVariables) {
            if (addStart && addEnd) break;
            if (pathIds.contains(flowVariables.getAction())) {
                addEnd = true;
                continue;
            }
            addStart = true;
        }
        if (addStart) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("start");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.workflow.engine.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        if (addEnd) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("end");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.workflow.engine.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        userTask.setExecutionListeners(executionListeners);
    }

    public static void addExecutionListener(UserTask userTask, ServiceTask serviceTask, CallActivity callActivity, ReceiveTask receiveTask, FlowObject flowObject) {
        List activityListeners;
        ExtendTaskListener extendActivityListener;
        OriginalTaskListener originalActivityListener = flowObject.getProps().getOriginalActivityListener();
        if (ToolUtil.isNotEmpty((Object)originalActivityListener)) {
            List listeners;
            List activityListeners2 = originalActivityListener.getActivityListener();
            for (ActivitiListener activitiListener : activityListeners2) {
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            }
            if (ToolUtil.isNotEmpty((Object)userTask)) {
                listeners = userTask.getExecutionListeners();
                if (ToolUtil.isNotEmpty((Object)listeners)) {
                    activityListeners2.addAll(listeners);
                }
                userTask.setExecutionListeners(activityListeners2);
            }
            if (ToolUtil.isNotEmpty((Object)serviceTask)) {
                serviceTask.setExecutionListeners(activityListeners2);
            }
            if (ToolUtil.isNotEmpty((Object)callActivity)) {
                listeners = callActivity.getExecutionListeners();
                if (ToolUtil.isNotEmpty((Object)listeners)) {
                    activityListeners2.addAll(listeners);
                }
                callActivity.setExecutionListeners(activityListeners2);
            }
            if (ToolUtil.isNotEmpty((Object)receiveTask)) {
                listeners = receiveTask.getExecutionListeners();
                if (ToolUtil.isNotEmpty((Object)listeners)) {
                    activityListeners2.addAll(listeners);
                }
                receiveTask.setExecutionListeners(activityListeners2);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(extendActivityListener = flowObject.getProps().getActivityListener())) && ToolUtil.isNotEmpty((Object)(activityListeners = extendActivityListener.getActivityListener()))) {
            for (ExeListener exeListener : activityListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                if (ToolUtil.isNotEmpty((Object)userTask)) {
                    userTask.addExtensionElement(extensionElement);
                }
                if (ToolUtil.isNotEmpty((Object)serviceTask)) {
                    serviceTask.addExtensionElement(extensionElement);
                }
                if (ToolUtil.isNotEmpty((Object)callActivity)) {
                    callActivity.addExtensionElement(extensionElement);
                }
                if (!ToolUtil.isNotEmpty((Object)receiveTask)) continue;
                receiveTask.addExtensionElement(extensionElement);
            }
        }
    }
}

