/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.User")
public class UserTaskVisitor
implements FormObjectVisitor {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");

    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel) {
        FlowRecipients flowRecipients;
        String dueDate;
        UserTask userTask = new UserTask();
        FlowProps flowProps = flowObject.getProps();
        userTask.setName(flowProps.getFlowName());
        userTask.setId(flowObject.getId());
        userTask.setDocumentation(flowProps.getFlowDescription());
        JSONObject jsonObject = flowProps.getFormAddress();
        if (jsonObject != null) {
            JSONObject object = new JSONObject();
            for (String key : jsonObject.keySet()) {
                object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
            }
            userTask.setFormKey(JSON.toJSONString((Object)object));
        }
        if (ToolUtil.isNotEmpty((Object)(dueDate = flowProps.getDueDate()))) {
            userTask.setDueDate(dueDate);
        }
        HashSet<String> functionIds = new HashSet<String>();
        FlowAssignment flowAssignment = flowProps.getFlowAssignment();
        if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
            this.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
            if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                    this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)(flowRecipients = flowProps.getFlowRecipients()))) {
            this.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
            if (ToolUtil.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowRecipients.getJudgeCcCondition()) {
                    this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList functionUserVariables = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
            for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                if (!functionIds.contains(flowFunctionConfig.getId())) continue;
                map.put(flowFunctionConfig.getId(), flowFunctionConfig.getValue());
                functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
            }
        }
        FormBpmnUtil.assigneeInstall(flowObject, userTask, map);
        FormBpmnUtil.ccInstall(flowObject, userTask, map);
        FormBpmnUtil.extendHandle(flowObject, userTask);
        if (ToolUtil.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, userTask);
        }
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = flowModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        FormBpmnUtil.addTaskListener(userTask, flowObject);
        ArrayList<FlowVariables> useVariables = flowProps.getUseVariables();
        List modelUseVariables = flowModel.getProps().getUseVariables();
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)modelUseVariables)) {
            flag = true;
        }
        if (ToolUtil.isEmpty((Object)useVariables)) {
            useVariables = new ArrayList<FlowVariables>();
        }
        if (ToolUtil.isNotEmpty(functionUserVariables)) {
            useVariables.addAll(functionUserVariables);
        }
        FormBpmnUtil.addExeListener((FlowElement)userTask, useVariables, pathIds, flag);
        FormBpmnUtil.addExecutionListener(userTask, null, null, null, flowObject);
        process.addFlowElement((FlowElement)userTask);
    }

    private void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (ToolUtil.isNotEmpty((Object)assignee) && assignee.contains("@{")) {
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }

    private void counterSign(FlowObject flowObject, UserTask userTask) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

