/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private TaskManagerMapper taskManagerMapper;
    @Resource
    private AssigneeChooseServiceImpl assigneeChooseService;
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;
    @Autowired
    private DruidProperties druidProperties;

    public int count() {
        return this.taskManagerMapper.count(new Date());
    }

    public List<TaskManager> getTask(Page<TaskManager> pages, GetTaskManagerDto taskManagerDto) {
        taskManagerDto.setDateTime(new Date());
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, taskManagerDto);
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)taskManager.getReceivers())) {
                receiver = new ArrayList(new HashSet(taskManager.getReceivers()));
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getFirstReceiver())) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getSendUser())) {
                receiver.add(0, taskManager.getSendUser());
            }
            users.addAll(receiver);
        }
        HashSet userSet = new HashSet(users);
        userSet.remove(null);
        users.clear();
        users.addAll(userSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users, String.valueOf(taskManagerDto.getTenantId()));
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (taskManager.getReceivers() != null) {
                receiver = new ArrayList(new HashSet(taskManager.getReceivers()));
            }
            if (taskManager.getFirstReceiver() != null) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (receiver.size() > 0) {
                taskManager.setFirstReceiver((String)receiver.get(0));
            }
            taskManager.setReceivers(receiver);
            ArrayList<String> name = new ArrayList<String>();
            for (String id : receiver) {
                name.add(userMap.get(id));
            }
            taskManager.setReceiverName(name);
            taskManager.setSendUserName(userMap.get(taskManager.getSendUser()));
        }
        return list;
    }

    public ApiResponse<String> suspendTaskById(String processInsId) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    public ApiResponse<String> activateTaskById(String processInsId) {
        try {
            this.runtimeService.activateProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    public Map<String, String> getFileByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.inSql(SysActProcessFile::getProcessId, "SELECT PROC_DEF_ID_ FROM BPM_ACT_RU_TASK WHERE ID_ = '" + taskId + "'");
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        SysActProcessFile sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
        String file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        map.put("main", file);
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.inSql(SysActProcessFile::getProcessId, "SELECT A.PROC_DEF_ID_ FROM BPM_ACT_HI_PROCINST A LEFT JOIN BPM_ACT_HI_PROCINST B ON A.PROC_INST_ID_ = B.SUPER_PROCESS_INSTANCE_ID_ LEFT JOIN BPM_ACT_RU_TASK C ON B.PROC_INST_ID_ = C.PROC_INST_ID_ WHERE C.ID_ = '" + taskId + "'");
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper);
        file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        map.put("call", file);
        return map;
    }
}

