/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends ServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DruidProperties druidProperties;

    public ApiResponse<IPage<SysActCcTask>> query(Page<SysActCcTask> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, userId, processKey, sendUser, start, end);
        if (sysActCcTasks != null && sysActCcTasks.size() > 0) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                JSONObject object;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if (!ToolUtil.isNotEmpty((Object)formDetailKey) || !ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWebFormDetailKey(object.getString("web"));
                sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }
}

