/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntityManager taskEntityManager;
        List childTasks;
        if (this.variables.containsKey("bpm_next_node")) {
            commandContext.addAttribute("bpm_next_node", this.variables.get("bpm_next_node"));
            this.variables.remove("bpm_next_node");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            TaskComment taskComment = new TaskComment();
            taskComment.setUserId(this.userId);
            taskComment.setType("complete");
            taskComment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            taskComment.setTaskId(this.taskId);
            taskComment.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > 2003) {
                eventMessage = eventMessage.substring(0, 2000) + "...";
            }
            taskComment.setMessage(eventMessage);
            taskComment.setFullMsg(JSON.toJSONString((Object)this.comment).getBytes(StandardCharsets.UTF_8));
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(this.userId);
            Map deptParams = this.iAssigneeChooseService.getDeptParamsByUserId(this.userId, "");
            taskComment.setUserName((String)deptParams.get("userName"));
            taskComment.setDeptName((String)deptParams.get("organFullName"));
            if (ToolUtil.isNotEmpty(deptParams.get("deptId"))) {
                taskComment.setDeptId(deptParams.get("deptId").toString());
            }
            taskComment.insert();
        }
        this.variables.put("sendUser", HussarUtils.isEmpty((Object)this.mandator) ? this.userId : this.mandator);
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocal("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        if (!(childTasks = (taskEntityManager = commandContext.getTaskEntityManager()).findTasksByParentTaskId(this.taskId)).isEmpty()) {
            ArrayList<String> childTaskIds = new ArrayList<String>();
            childTasks.forEach(childTask -> {
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(childTaskIds);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }
}

