/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.vo.SysActUrgeTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActUrgeTaskServiceImpl
extends HussarServiceImpl<SysActUrgeTaskMapper, SysActUrgeTask>
implements ISysActUrgeTaskService {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private HistoryService historyService;
    private static final Logger logger = LoggerFactory.getLogger(SysActUrgeTaskServiceImpl.class);

    public ApiResponse<Page<SysActUrgeTask>> query(Page<SysActUrgeTask> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActUrgeTaskVo> sysActUrgeTasksVo = this.sysActUrgeTaskMapper.query(pages, userId, processKey, sendUser, start, end);
        ArrayList<SysActUrgeTask> sysActUrgeTasks = new ArrayList<SysActUrgeTask>();
        if (sysActUrgeTasksVo != null && !sysActUrgeTasksVo.isEmpty()) {
            ArrayList users = new ArrayList();
            sysActUrgeTasksVo.forEach(sysActUrgeTask -> {
                users.add(sysActUrgeTask.getSendUser());
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTask.getOwner())) {
                    users.add(sysActUrgeTask.getOwner());
                }
            });
            Map map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            for (SysActUrgeTaskVo sysActUrgeTaskVo : sysActUrgeTasksVo) {
                String userName = (String)map.get(sysActUrgeTaskVo.getSendUser());
                sysActUrgeTaskVo.setSendUserName(userName);
                String formKey = sysActUrgeTaskVo.getFormKey();
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTaskVo.getOwner())) {
                    sysActUrgeTaskVo.setTaskId(sysActUrgeTaskVo.getTaskId() + ":" + sysActUrgeTaskVo.getOwner());
                    sysActUrgeTaskVo.setTaskName(sysActUrgeTaskVo.getTaskName() + "(" + (String)map.get(sysActUrgeTaskVo.getOwner()) + ")");
                }
                if (HussarUtils.isNotEmpty((Object)formKey)) {
                    JSONObject object = JSON.parseObject((String)formKey);
                    sysActUrgeTaskVo.setWeb(object.getString("web"));
                    sysActUrgeTaskVo.setMobile(object.getString("mobile"));
                }
                SysActUrgeTask sysActUrgeTask2 = new SysActUrgeTask();
                sysActUrgeTask2.setId(sysActUrgeTaskVo.getId());
                sysActUrgeTask2.setTaskId(Long.valueOf(Long.parseLong(sysActUrgeTaskVo.getTaskId())));
                sysActUrgeTask2.setProcessInsId(sysActUrgeTaskVo.getProcessInsId());
                sysActUrgeTask2.setProcName(sysActUrgeTaskVo.getProcName());
                sysActUrgeTask2.setTaskName(sysActUrgeTaskVo.getTaskName());
                sysActUrgeTask2.setSendUser(sysActUrgeTaskVo.getSendUser());
                sysActUrgeTask2.setFormKey(sysActUrgeTaskVo.getFormKey());
                sysActUrgeTask2.setProcDefKey(sysActUrgeTaskVo.getProcDefKey());
                sysActUrgeTask2.setBusinessId(sysActUrgeTaskVo.getBusinessId());
                sysActUrgeTask2.setTaskDefKey(sysActUrgeTaskVo.getTaskDefKey());
                sysActUrgeTask2.setSendUserName(sysActUrgeTaskVo.getSendUserName());
                sysActUrgeTask2.setReceiveUser(sysActUrgeTaskVo.getReceiveUser());
                sysActUrgeTask2.setSendTime(sysActUrgeTaskVo.getSendTime());
                sysActUrgeTask2.setToDoConfig(sysActUrgeTaskVo.getToDoConfig());
                sysActUrgeTask2.setOwner(sysActUrgeTaskVo.getOwner());
                sysActUrgeTask2.setTaskState(sysActUrgeTaskVo.getTaskState());
                sysActUrgeTask2.setWeb(sysActUrgeTaskVo.getWeb());
                sysActUrgeTask2.setMobile(sysActUrgeTaskVo.getMobile());
                sysActUrgeTasks.add(sysActUrgeTask2);
            }
        }
        pages.setRecords(sysActUrgeTasks);
        return ApiResponse.success(pages);
    }

    public String urgeTask(String processInsId, String userId) {
        if (HussarUtils.isEmpty((Object)processInsId)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessInsIdNull());
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessEndUrgeFail());
        }
        if (processInstance.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended());
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
            if (identityLinks.isEmpty()) continue;
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                Map map = task.getTaskLocalVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            for (Task task : tasks) {
                Set users = this.getAssigneeByTaskId(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                if (users.isEmpty() || !this.dataPushService.isDataPush()) continue;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setTenantId(task.getTenantId());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    public String urgeTaskByTaskId(String taskId, String userId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "1");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
        if (!identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                Map map = task.getTaskLocalVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            if (this.dataPushService.isDataPush()) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", identityLinks.stream().map(IdentityLink::getUserId).collect(Collectors.toSet())));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setTenantId(task.getTenantId());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    private Collection<IdentityLink> getAssigneeByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }
}

