/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class DefinitionEngineServiceImpl
implements IDefinitionEngineService {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private ModelMapper modelMapper;

    public BpmResponseResult queryProcessName(String processKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        object.put("processName", (Object)this.processDefinitionsService.getMainOrNew(processKey).getName());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public int queryLatestVersion(String processKey) {
        return this.processDefinitionsService.queryLatestVersion(processKey);
    }

    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List deployments = this.processDefinitionsService.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinitionModel item : deployments) {
            if (item.getResourceName() != null) {
                String[] sourceArr = item.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (item.getDiagramResourceName() != null) {
                String[] diagramArr = item.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(item.getDeploymentTime());
                String timeStr = sdf.format(date);
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        object.put("data", result);
        object.put("count", (Object)result.size());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefList(String processName) {
        JSONArray json = new JSONArray();
        List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + processName + "%").orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(deployment.getId());
            item.setProcessName(deployment.getName());
            item.setVersion(Integer.toString(deployment.getVersion()));
            item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        json.add(result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        if (processDefinitionId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(String.valueOf(processDefinitionId)).singleResult();
        if (HussarUtils.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId))) {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getDeleteRunningFail(), null);
    }

    public BpmResponseResult queryProcess() {
        JSONArray json = new JSONArray();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            for (Model model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                try {
                    String temp = new String(arg0, StandardCharsets.UTF_8).replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes(StandardCharsets.UTF_8));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    Process process = bpmnModel.getMainProcess();
                    object.put("id", (Object)process.getId());
                    object.put("name", (Object)process.getName());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessLink(String processKey) {
        JSONArray json = new JSONArray();
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof UserTask) {
                    JSONObject object = new JSONObject();
                    object.put("id", (Object)flowElement.getId());
                    object.put("name", (Object)flowElement.getName());
                    json.add((Object)object);
                    continue;
                }
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof UserTask)) continue;
                    JSONObject object = new JSONObject();
                    object.put("id", (Object)element.getId());
                    object.put("name", (Object)element.getName());
                    json.add((Object)object);
                }
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryStartFormUrl(String processKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(this.processDefinitionsService.getMainOrNew(processKey).getId());
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
            break;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public boolean queryIsPublish(String processKey) {
        List list = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).list();
        return list != null && !list.isEmpty();
    }

    public BpmResponseResult judgeProcessName(String processName) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelName(processName).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult judgeProcDefKey(String procDefKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelKey(procDefKey).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }
}

