/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends HussarServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    private static Logger logger = LoggerFactory.getLogger(SysActCcTaskServiceImpl.class);

    public ApiResponse<Page<SysActCcTask>> query(Page<SysActCcTask> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String tenantId, String type) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, userId, processKey, sendUser, start, end, type);
        if (sysActCcTasks != null && !sysActCcTasks.isEmpty()) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                JSONObject object;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if (!HussarUtils.isNotEmpty((Object)formDetailKey) || !HussarUtils.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWebFormDetailKey(object.getString("web"));
                sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public BpmResponseResult updateCcReadTime(String cctaskId) {
        SysActCcTask task = (SysActCcTask)this.getById((Serializable)((Object)cctaskId));
        if (HussarUtils.isEmpty((Object)task.getReadTime())) {
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            task.setReadTime(new Timestamp(date.getTime()));
            this.updateById((BaseEntity)task);
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)"\u6284\u9001\u5df2\u67e5\u9605", null);
    }
}

