/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Autowired
    List<DataPushListener> dataPushListeners;

    public boolean isDataPush() {
        return true;
    }

    public void addDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.completeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.entrustTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.rejectTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.revokeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.freeJumpTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUser(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMultiTask(List<String> taskIds) {
        try {
            DataPush dataPush = new DataPush();
            dataPush.setTaskIds(taskIds);
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteMultiTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUrgeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void endProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.endProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.reTransferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

