/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutSetListUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutHandleUtil {
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("example-schedule-pool-%d").daemon(true).build());
    private static Logger logger = LogManager.getLogger(TimeOutHandleUtil.class);
    public static final String BPM_ACTIVITY_TIMER_SCORE_LIST = "bpm_activity:timer:score_list";
    public static final String BPM_ACTIVITY_TIMER_TASK_MESSAGE = "bpm_activity:timer:task_Message:";
    public static final String BPM_TIMER_ACTIVITY = "bpm_timer_activity";
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TimeOutSetListUtil timeOutSetListUtil;
    @Autowired
    private RedisTemplate redisTemplate;
    protected static boolean getList = true;
    protected static Set<String> errorSysUsers = new HashSet<String>();
    protected static List<Long> timeOutList = new ArrayList<Long>();
    protected static Map<Long, String> timeOutMap = new HashMap<Long, String>();
    protected static List<Long> getListTimeAddModel = new ArrayList<Long>();
    protected static List<String> getListTimeDelModel = new ArrayList<String>();
    protected static boolean useRedis;
    @Resource
    private HussarCacheProperties hussarCacheProperties;

    public void init() {
        useRedis = "redis".equals(this.hussarCacheProperties.getCacheType());
        this.executorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TimeOutHandleUtil.this.handleAllTimeOutTask(System.currentTimeMillis());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void getList() {
        try {
            if (BpmTenantInfoUtils.isMultiTenant()) {
                List sysUserList = this.sysUserService.querySysTenantList();
                if (!BpmTenantInfoUtils.isStartAlone()) {
                    this.selectTimeOutModels();
                }
                for (SysUser sysUser : sysUserList) {
                    this.timeOutSetListUtil.setList(sysUser, sysUser.getConnName());
                }
            } else {
                this.selectTimeOutModels();
            }
            if (useRedis) {
                getList = false;
                return;
            }
            if (!getListTimeDelModel.isEmpty()) {
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, getListTimeDelModel);
            }
            TimeOutHandleUtil.orderTime();
        }
        catch (Exception e) {
            logger.error("\u8d85\u65f6\u5904\u7406\u4fe1\u606f\u7f13\u5b58\u540c\u6b65\u5931\u8d25{}", (Object)e.getMessage());
        }
        getList = false;
    }

    public static void orderTime() {
        timeOutList.sort(Comparator.naturalOrder());
        while (!getListTimeAddModel.isEmpty()) {
            int index = 0;
            for (int i = 0; i < timeOutList.size() && timeOutList.get(i) < getListTimeAddModel.get(0); ++i) {
                index = i + 1;
            }
            timeOutList.add(index, getListTimeAddModel.get(0));
            getListTimeAddModel.remove(0);
        }
    }

    private void selectTimeOutModels() {
        if (useRedis) {
            try {
                List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                for (TimeOutModel timeOutModel : timeOutModels) {
                    this.redisTemplate.opsForValue().set((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + timeOutModel.getId()), (Object)JSON.toJSONString((Object)timeOutModel));
                    Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                    if (HussarUtils.isEmpty((Object)oldTask)) {
                        this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)timeOutModel.getId(), (double)timeOutModel.getDueTime().getTime());
                        continue;
                    }
                    this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)((String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getId()), (double)timeOutModel.getDueTime().getTime());
                }
                this.activityRedisTimerMapper.delete(null);
            }
            catch (Exception e) {
                logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        List timeOutModels = this.activityRedisTimerMapper.selectList(null);
        for (TimeOutModel timeOutModel : timeOutModels) {
            HussarCacheUtil.put((String)BPM_TIMER_ACTIVITY, (Object)timeOutModel.getId(), (Object)timeOutModel);
            Long time = timeOutModel.getDueTime().getTime();
            timeOutList.add(time);
            timeOutMap.put(time, timeOutMap.get(time) == null ? timeOutModel.getId() : timeOutMap.get(time) + "," + timeOutModel.getId());
        }
    }

    private void timeOutTaskHandler(TimeOutModel timeOutModel, boolean isDelTimeOutTableMessage) {
        if (!BpmTenantInfoUtils.isMultiTenant()) {
            if (isDelTimeOutTableMessage) {
                this.activityRedisTimerMapper.deleteById((Serializable)((Object)timeOutModel.getId()));
            }
            this.handleTimeOutModel(timeOutModel);
        } else {
            if (errorSysUsers.contains(timeOutModel.getTenantId())) {
                return;
            }
            try {
                SysUser sysUser = this.sysUserService.getSysUserByTenantId(timeOutModel.getTenantId());
                if (HussarUtils.isEmpty((Object)sysUser)) {
                    errorSysUsers.add(timeOutModel.getTenantId());
                    return;
                }
                if (!this.sysUserService.testConn(sysUser.getConnName())) {
                    logger.error("\u8fde\u63a5\u5bf9\u5e94\u79df\u6237\u5e93\u5931\u8d25\uff0ctenantId:{}", (Object)timeOutModel.getTenantId());
                    return;
                }
                if (isDelTimeOutTableMessage) {
                    this.activityRedisTimerMapper.deleteById((Serializable)((Object)timeOutModel.getId()));
                }
                this.handleTimeOutModel(timeOutModel);
            }
            catch (Exception e) {
                logger.error("\u8fde\u63a5\u5207\u6362\u81f3\u8d85\u65f6\u4efb\u52a1\u6240\u5728\u79df\u6237\u5e93\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
    }

    private void handleTimeOutModel(TimeOutModel timeOutModel) {
        if ("autoHandle".equals(timeOutModel.getTimeOutType())) {
            String assignee = "";
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getAssignee())) {
                String[] assignees;
                for (String user : assignees = timeOutModel.getAssignee().split(",")) {
                    if ("".equals(user)) continue;
                    assignee = user;
                    break;
                }
            }
            try {
                this.taskEngineService.completeTask(timeOutModel.getId(), assignee, null);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("urging".equals(timeOutModel.getTimeOutType())) {
            String userId = null;
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                Map map = (Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class);
                userId = (String)map.get("sendUser");
            }
            try {
                this.iSysActUrgeTaskService.urgeTaskByTaskId(timeOutModel.getId(), userId);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-urging".equals(timeOutModel.getTimeOutType())) {
            try {
                String processInsId = timeOutModel.getId();
                String assignee = timeOutModel.getAssignee();
                this.iSysActUrgeTaskService.urgeTask(processInsId, assignee);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-terminate".equals(timeOutModel.getTimeOutType())) {
            try {
                String assignee;
                Task runningTask;
                String taskId;
                Set<String> userSet;
                String processInsId = timeOutModel.getId();
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInsId)).list();
                if (!tasks.isEmpty() && !(userSet = this.getAssigneeByTaskId(taskId = (runningTask = (Task)tasks.get(0)).getId())).isEmpty() && HussarUtils.isNotEmpty((Object)(assignee = userSet.iterator().next()))) {
                    this.instanceEngineService.endProcess(taskId, assignee, "");
                }
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u7ec8\u7ed3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("receiveTask-autoHandle".equals(timeOutModel.getTimeOutType())) {
            try {
                String executionId = timeOutModel.getId();
                this.taskEngineService.receiveTaskSignal(executionId, null);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else {
            String outInterface = timeOutModel.getTimeOutType();
            boolean isProcessTimeOut = false;
            if (outInterface.startsWith("global-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("global-", "");
            }
            if (outInterface.startsWith("receiveTask-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("receiveTask-", "");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!isProcessTimeOut) {
                map.put("taskId", timeOutModel.getId());
                map.put("assignee", timeOutModel.getAssignee());
                map.put("startTime", sdf.format(timeOutModel.getCreateTime()));
            }
            map.put("dueTime", sdf.format(timeOutModel.getDueTime()));
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                map.putAll((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class));
            }
            try {
                HttpRequestUtil.getRequestResult(outInterface, map);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private void handleAllTimeOutTask(long time) {
        if (getList) {
            this.getList();
        }
        if (useRedis) {
            try {
                Set tasksList = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                if (HussarUtils.isNotEmpty((Object)tasksList)) {
                    for (String tasks : tasksList) {
                        for (String str : tasks.split(",")) {
                            Object model = this.redisTemplate.opsForValue().get((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                            if (HussarUtils.isNotEmpty((Object)model)) {
                                this.timeOutTaskHandler((TimeOutModel)JSON.parseObject((String)((String)model), TimeOutModel.class), false);
                            }
                            this.redisTemplate.delete((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                        }
                    }
                    this.redisTemplate.opsForZSet().removeRangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                }
            }
            catch (Exception e) {
                logger.error("redis\u83b7\u53d6\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        while (!timeOutList.isEmpty() && time > timeOutList.get(0)) {
            String[] keys;
            if (timeOutMap.get(timeOutList.get(0)) == null) {
                timeOutList.remove(0);
                continue;
            }
            for (String key : keys = timeOutMap.get(timeOutList.get(0)).split(",")) {
                TimeOutModel timeOutModel = (TimeOutModel)HussarCacheUtil.get((String)BPM_TIMER_ACTIVITY, (Object)key);
                if (timeOutModel == null) continue;
                this.timeOutTaskHandler(timeOutModel, true);
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, (Object)key);
            }
            timeOutMap.remove(timeOutList.get(0));
            timeOutList.remove(0);
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public static Set<String> getErrorSysUsers() {
        return errorSysUsers;
    }

    public static List<Long> getTimeOutList() {
        return timeOutList;
    }

    public static Map<Long, String> getTimeOutMap() {
        return timeOutMap;
    }

    public static List<Long> getGetListTimeAddModel() {
        return getListTimeAddModel;
    }

    public static List<String> getGetListTimeDelModel() {
        return getListTimeDelModel;
    }

    public static boolean isGetList() {
        return getList;
    }

    public static boolean isUseRedis() {
        return useRedis;
    }
}

