/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;

public class TaskRejectCmd
implements Command<TaskEntity> {
    private String userId;
    private TaskEntity task;
    private ExecutionEntity execution;
    private String backActivityId;
    private String comment;
    private int backType;
    private String type;
    private Map<String, Object> map;
    private String mandator;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);

    public TaskEntity execute(CommandContext commandContext) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (this.map != null) {
            newMap.putAll(this.map);
        }
        newMap.put("sendUser", HussarUtils.isEmpty((Object)this.mandator) ? this.userId : this.mandator);
        Map<String, Object> appointAssignee = new HashMap<String, Object>();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        appointAssignee.put("static_appoint_assignee", null);
        newMap.put("appoint_assignee", appointAssignee);
        ActivityImpl currentActivity = null;
        String executionId = null;
        if (this.task != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.comment) && (this.type.equals("reject") || this.type.equals("freejump"))) {
                CommentEntity commentEntity = new CommentEntity();
                commentEntity.setUserId(this.userId);
                commentEntity.setType("complete");
                commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                commentEntity.setTaskId(this.task.getId());
                commentEntity.setProcessInstanceId(null);
                commentEntity.setAction("AddComment");
                String eventMessage = this.comment.replaceAll("\\s+", " ");
                if (eventMessage.length() > 1503) {
                    eventMessage = eventMessage.substring(0, 1500) + "...";
                }
                commentEntity.setMessage(eventMessage);
                commentEntity.setFullMessage(this.comment);
                commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
            }
            this.task.setVariableLocalWithOutQuery("taskSourceFlag", (Object)this.type, true);
            this.task.setVariableLocalWithOutQuery("is_normal_commit", (Object)false, true);
            currentActivity = this.task.getExecution().getActivity();
            executionId = this.task.getExecutionId();
        } else {
            currentActivity = this.execution.getActivity();
            executionId = this.execution.getId();
        }
        switch (this.backType) {
            case 2: {
                new MultiInstanceJumpTaskCmd(this.userId, this.mandator, executionId, this.backActivityId, this.task == null ? null : this.task.getId(), this.comment, this.type, newMap, currentActivity).execute(commandContext);
                break;
            }
            case 3: {
                if (this.task != null && HussarUtils.isNotEmpty((Object)this.userId) && HussarUtils.isEmpty((Object)this.task.getAssignee()) && this.task.getAssignee() == null) {
                    this.task.setAssignee(this.userId, true, true);
                }
                new ParallelJumpTaskCmd(this.userId, this.mandator, executionId, this.backActivityId, this.comment, this.type, newMap, currentActivity).execute(commandContext);
                break;
            }
            default: {
                if (this.task != null && StringUtils.isNotEmpty((CharSequence)this.userId) && this.task.getAssignee() == null) {
                    this.task.setAssignee(this.userId, true, true);
                }
                new CommonJumpTaskCmd(this.userId, this.mandator, executionId, this.backActivityId, this.comment, this.type, newMap, currentActivity).execute(commandContext);
            }
        }
        if (this.task != null && HussarUtils.isNotEmpty((Object)this.task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.task.getId());
        }
        return null;
    }

    public TaskRejectCmd(String userId, String mandator, TaskEntity task, ExecutionEntity execution, String backActivityId, String comment, int backType, String type, Map<String, Object> map) {
        this.userId = userId;
        this.task = task;
        this.execution = execution;
        this.backActivityId = backActivityId;
        this.comment = comment;
        this.backType = backType;
        this.type = type;
        this.map = map;
        this.mandator = mandator;
    }
}

