/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.SequenceFlowJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendSequenceFlowJsonConverter
extends SequenceFlowJsonConverter {
    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        FlowElement sourceFlowElement;
        List extendFlowNameElement;
        SequenceFlow sequenceFlow = (SequenceFlow)baseElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape((String)sequenceFlow.getId(), (String)"SequenceFlow", (double)172.0, (double)212.0, (double)128.0, (double)212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getSourceRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getSourceRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() > 2) {
            for (int i = 1; i < model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)model.getFlowLocationGraphicInfo(sequenceFlow.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getTargetRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getTargetRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.put("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode((String)sequenceFlow.getTargetRef()));
        flowNode.put("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.put("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode((String)sequenceFlow.getTargetRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", sequenceFlow.getId());
        Map elementsListMap = sequenceFlow.getExtensionElements();
        if (elementsListMap != null && !elementsListMap.isEmpty() && (extendFlowNameElement = (List)elementsListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty()) {
            ArrayNode itemsNode = this.objectMapper.createArrayNode();
            for (ExtensionElement extensionElement : extendFlowNameElement) {
                ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
                Map maps = extensionElement.getAttributes();
                if (!HussarUtils.isNotEmpty((Object)maps)) continue;
                for (Map.Entry map : maps.entrySet()) {
                    propertyItemNode.put((String)map.getKey(), ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                }
                itemsNode.add((JsonNode)propertyItemNode);
                propertiesNode.put("extendSequenceflow", (JsonNode)itemsNode);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getName())) {
            propertiesNode.put("name", sequenceFlow.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getDocumentation())) {
            propertiesNode.put("documentation", sequenceFlow.getDocumentation());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
            propertiesNode.put("conditionsequenceflow", sequenceFlow.getConditionExpression());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getSourceRef()) && (sourceFlowElement = container.getFlowElement(sequenceFlow.getSourceRef())) != null) {
            String defaultFlowId = null;
            if (sourceFlowElement instanceof ExclusiveGateway) {
                ExclusiveGateway parentExclusiveGateway = (ExclusiveGateway)sourceFlowElement;
                defaultFlowId = parentExclusiveGateway.getDefaultFlow();
            } else if (sourceFlowElement instanceof Activity) {
                Activity parentActivity = (Activity)sourceFlowElement;
                defaultFlowId = parentActivity.getDefaultFlow();
            }
            if (defaultFlowId != null && defaultFlowId.equals(sequenceFlow.getId())) {
                propertiesNode.put("defaultflow", true);
            }
        }
        if (!sequenceFlow.getExecutionListeners().isEmpty()) {
            BpmnJsonConverterUtil.convertListenersToJson((List)sequenceFlow.getExecutionListeners(), (boolean)true, (ObjectNode)propertiesNode);
        }
        flowNode.put("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode conditionNode;
        ArrayNode sequenceFlowName;
        SequenceFlow flow = new SequenceFlow();
        String sourceRef = BpmnJsonConverterUtil.lookForSourceRef((String)elementNode.get("resourceId").asText(), (JsonNode)modelNode.get("childShapes"));
        if (sourceRef != null) {
            Object targetId;
            flow.setSourceRef(sourceRef);
            JsonNode targetNode = elementNode.get("target");
            if (targetNode != null && !targetNode.isNull() && shapeMap.get(targetId = targetNode.get("resourceId").asText()) != null) {
                flow.setTargetRef(BpmnJsonConverterUtil.getElementId((JsonNode)shapeMap.get(targetId)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sequenceFlowName = (ArrayNode)this.getProperty("extendSequenceflow", elementNode)))) {
            for (JsonNode jsonNode : sequenceFlowName) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendSequenceflow");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute xAttribute = new ExtensionAttribute();
                xAttribute.setName("x");
                if (jsonNode.get("x") != null) {
                    xAttribute.setValue(String.valueOf(jsonNode.get("x")).replace("\"", ""));
                } else {
                    xAttribute.setValue(null);
                }
                extensionElement.addAttribute(xAttribute);
                ExtensionAttribute yAttribute = new ExtensionAttribute();
                yAttribute.setName("y");
                if (jsonNode.get("y") != null) {
                    yAttribute.setValue(String.valueOf(jsonNode.get("y")).replace("\"", ""));
                } else {
                    yAttribute.setValue(null);
                }
                extensionElement.addAttribute(yAttribute);
                ExtensionAttribute rotateAttribute = new ExtensionAttribute();
                rotateAttribute.setName("rotate");
                rotateAttribute.setValue(jsonNode.get("rotate").toString().replace("\"", ""));
                extensionElement.addAttribute(rotateAttribute);
                ExtensionAttribute dxAttribute = new ExtensionAttribute();
                dxAttribute.setName("dx");
                dxAttribute.setValue(jsonNode.get("dx").toString().replace("\"", ""));
                extensionElement.addAttribute(dxAttribute);
                ExtensionAttribute widthAttribute = new ExtensionAttribute();
                widthAttribute.setName("width");
                if (jsonNode.get("width") != null) {
                    widthAttribute.setValue(String.valueOf(jsonNode.get("width")).replace("\"", ""));
                } else {
                    widthAttribute.setValue(null);
                }
                extensionElement.addAttribute(widthAttribute);
                ExtensionAttribute heightAttribute = new ExtensionAttribute();
                heightAttribute.setName("height");
                if (jsonNode.get("height") != null) {
                    heightAttribute.setValue(String.valueOf(jsonNode.get("height")).replace("\"", ""));
                } else {
                    heightAttribute.setValue(null);
                }
                extensionElement.addAttribute(heightAttribute);
                ExtensionAttribute lineNameAttribute = new ExtensionAttribute();
                lineNameAttribute.setName("lineName");
                if (jsonNode.get("lineName") != null) {
                    lineNameAttribute.setValue(String.valueOf(jsonNode.get("lineName")).replace("\"", ""));
                } else {
                    lineNameAttribute.setValue(null);
                }
                extensionElement.addAttribute(lineNameAttribute);
                flow.addExtensionElement(extensionElement);
            }
        }
        if ((conditionNode = this.getProperty("conditionsequenceflow", elementNode)) != null) {
            JsonNode expressionNode;
            if (conditionNode.isTextual() && !conditionNode.isNull()) {
                flow.setConditionExpression(conditionNode.asText());
            } else if (conditionNode.get("expression") != null && (expressionNode = conditionNode.get("expression")).get("type") != null) {
                String expressionType = expressionNode.get("type").asText();
                if ("variables".equalsIgnoreCase(expressionType) && expressionNode.get("fieldType") != null) {
                    String fieldType = expressionNode.get("fieldType").asText();
                    if ("field".equalsIgnoreCase(fieldType)) {
                        this.setFieldConditionExpression(flow, expressionNode);
                    } else if ("outcome".equalsIgnoreCase(fieldType)) {
                        this.setOutcomeConditionExpression(flow, expressionNode);
                    }
                } else if (expressionNode.get("staticValue") != null && !expressionNode.get("staticValue").isNull()) {
                    flow.setConditionExpression(expressionNode.get("staticValue").asText());
                }
            }
        }
        return flow;
    }
}

