/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityElement;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExeListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendActivitiListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.LineConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.TimeOutStrategy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormObjectVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ProcessValidatorFactory;
import org.activiti.validation.ValidationError;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class Bpm2XMLServiceImpl
implements Bpm2XMLService {
    private static final Logger logger = LoggerFactory.getLogger(Bpm2XMLServiceImpl.class);
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    private Bpm2XMLMapper bpm2XMLMapper;
    private final RepositoryService repositoryService;
    private SysActProcessFileService sysActProcessFileService;
    private SysActAssigneeService sysActAssigneeService;
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private static final String COMPLETE_STATE = "finish";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    @Autowired
    public Bpm2XMLServiceImpl(UpdateByteArrayModelMapper updateByteArrayModelMapper, Bpm2XMLMapper bpm2XMLMapper, LcdpBpmProperties lcdpBpmProperties, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, SysActAssigneeService sysActAssigneeService) {
        this.updateByteArrayModelMapper = updateByteArrayModelMapper;
        this.bpm2XMLMapper = bpm2XMLMapper;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActAssigneeService = sysActAssigneeService;
    }

    public String formDataToXml(String tenantId, String identityKey) throws BpmException, IOException, XMLStreamException {
        FlowModel flowModel = this.readModel(identityKey, tenantId);
        return this.genXMLByFlowModel(flowModel, identityKey, tenantId);
    }

    private BpmnModel getXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow, boolean updateVersion) throws BpmException, IOException, XMLStreamException {
        List taskListeners;
        ExtendTaskListener executionListener;
        OriginalTaskListener originalExecutionListener;
        TimeOutStrategy globalTimeOutStrategy;
        if (flowModel == null) {
            return null;
        }
        ProcessDefinition latestProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(identityKey).latestVersion().singleResult();
        int processDefinitionVersion = latestProcessDefinition != null ? (updateVersion ? latestProcessDefinition.getVersion() + 1 : latestProcessDefinition.getVersion()) : 1;
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        String processKeyDefault = "key-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String processKey = workFlow.getIdentity();
        String modelName = workFlow.getName();
        process.setDocumentation(flowModel.getProps().getDesc());
        process.setName(HussarUtils.isEmpty((Object)modelName) ? "" : modelName);
        process.setId(HussarUtils.isEmpty((Object)processKey) ? processKeyDefault : processKey);
        FlowTodoCondition flowTodoCondition = flowModel.getProps().getTodoConfiguration();
        if (flowTodoCondition != null) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowTodoCondition.getModalValue()));
        } else {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", ""));
        }
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("version", String.valueOf(processDefinitionVersion)));
        String width = flowModel.getWidth();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasWidth", width));
        String height = flowModel.getHeight();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasHeight", height));
        String globalDueDate = flowModel.getProps().getGlobalDueDate();
        if (HussarUtils.isNotEmpty((Object)globalDueDate)) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalDueDate", globalDueDate));
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategy = flowModel.getProps().getGlobalTimeOutStrategy())) && HussarUtils.isNotEmpty((Object)globalTimeOutStrategy.getTimeoutStrategyType()) && !"unHandle".equals(globalTimeOutStrategy.getTimeoutStrategyType())) {
            String timeoutStrategyType = globalTimeOutStrategy.getTimeoutStrategyType();
            if ("outInterface".equals(timeoutStrategyType)) {
                String path = globalTimeOutStrategy.getOutInterface();
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", path));
            } else if (!"".equals(timeoutStrategyType)) {
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", timeoutStrategyType));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(originalExecutionListener = flowModel.getProps().getOriginalExecutionListener()))) {
            ArrayList<ActivitiListener> taskListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalExecutionListener.getFlowListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                taskListeners2.add(activitiListener);
            }
            process.setExecutionListeners(taskListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(executionListener = flowModel.getProps().getExecutionListener())) && HussarUtils.isNotEmpty((Object)(taskListeners = executionListener.getFlowListener()))) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                process.addExtensionElement(extensionElement);
            }
        }
        this.packageProcess(flowModel, process, processKey, model);
        return this.convertXMLandValidate(model);
    }

    private String genXMLByFlowModel(FlowModel flowModel, String identityKey, String tenantId) throws BpmException, IOException, XMLStreamException {
        if (flowModel == null) {
            return null;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, tenantId, Integer.valueOf(0));
        BpmnModel bpmnModel = this.getXmlByFlowModel(flowModel, identityKey, workFlow, true);
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            ArrayList<Object> list = new ArrayList<Object>();
            List elements = flowModel.getSlots().getElement();
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            block0: for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                SysActAssignee modelAssignee = new SysActAssignee();
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setContentType("defaultAssign");
                modelAssignee.setTaskDefKey(flowElement.getId());
                String string = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultAssign");
                modelAssignee.setContent(string == null ? "".getBytes(StandardCharsets.UTF_8) : string.getBytes(StandardCharsets.UTF_8));
                list.add(modelAssignee);
                SysActAssignee conditionAssignee = new SysActAssignee();
                conditionAssignee.setProcDefKey(identityKey);
                conditionAssignee.setContentType("conditionAssign");
                conditionAssignee.setTaskDefKey(flowElement.getId());
                String string2 = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionAssign");
                conditionAssignee.setContent(string2 == null ? "".getBytes(StandardCharsets.UTF_8) : string2.getBytes(StandardCharsets.UTF_8));
                list.add(conditionAssignee);
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCcAssign");
                ccAssignee.setTaskDefKey(flowElement.getId());
                String ccAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultCcAssign");
                ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccAssignee);
                SysActAssignee ccConditionAssignee = new SysActAssignee();
                ccConditionAssignee.setProcDefKey(identityKey);
                ccConditionAssignee.setContentType("conditionCcAssign");
                ccConditionAssignee.setTaskDefKey(flowElement.getId());
                String ccConditionAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionCcAssign");
                ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccConditionAssignee);
                for (FlowObject object : elements) {
                    if (!flowElement.getId().equals(object.getId())) continue;
                    SysActAssignee assigneeModel = new SysActAssignee();
                    assigneeModel.setProcDefKey(identityKey);
                    assigneeModel.setContentType("assign_model");
                    assigneeModel.setTaskDefKey(flowElement.getId());
                    assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                    list.add(assigneeModel);
                    SysActAssignee ccAssigneeModel = new SysActAssignee();
                    ccAssigneeModel.setProcDefKey(identityKey);
                    ccAssigneeModel.setContentType("cc_assign_model");
                    ccAssigneeModel.setTaskDefKey(flowElement.getId());
                    ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                    list.add(ccAssigneeModel);
                    continue block0;
                }
            }
            ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
            QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
            for (SysActAssignee sysActAssignee : list) {
                String procDefKey = sysActAssignee.getProcDefKey();
                String string = sysActAssignee.getTaskDefKey();
                String contentType = sysActAssignee.getContentType();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)string)).eq((Object)"CONTENT_TYPE", (Object)contentType);
            }
            List sameList = queryWrapper.list();
            ArrayList<SysActAssignee> arrayList = new ArrayList<SysActAssignee>();
            for (SysActAssignee sysActAssignee : list) {
                boolean isadd = true;
                for (SysActAssignee actAssignee : sameList) {
                    if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                    sysActAssignee.setId(actAssignee.getId());
                    arrayList.add(sysActAssignee);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActAssignee);
            }
            this.sysActAssigneeService.updateBatchById(arrayList);
            this.sysActAssigneeService.saveBatch(addList);
        }
        return this.completeAndDeployModel(bpmnModel, workFlow.getName(), flowModel.getModelId(), flowModel.getProps().getDesc(), identityKey, tenantId);
    }

    private void packageProcess(FlowModel flowModel, Process process, String processKeyPath, BpmnModel model) throws BpmException {
        for (FlowObject element : flowModel.getSlots().getPathAndElement()) {
            element.setProcessKeyPath(processKeyPath);
            if (element.getName().equals(BpmNodeTypeEnum.BPM_SEQUENCE.getType())) {
                this.createSequence(flowModel.getSlots().getPath(), flowModel.getSlots().getElement(), element.getNodeId(), process, model);
                continue;
            }
            FormObjectVisitor formObjectVisitor = FormObjectVisitorBeanUtil.getVisitorBean(element.getName());
            formObjectVisitor.visit(element, process, flowModel);
            GraphicInfo graphicInfo = FormBpmnUtil.createGraphicInfo(element);
            model.addGraphicInfo(element.getId(), graphicInfo);
        }
        model.addProcess(process);
    }

    private FlowModel readModel(String identityKey, String tenantId) throws BpmException {
        if (HussarUtils.isEmpty((Object)identityKey)) {
            throw new BpmException("\u6587\u4ef6\u4e0d\u5b58\u5728", "FILE ID: " + identityKey);
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, tenantId, Integer.valueOf(0));
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            if (HussarUtils.isNotEmpty((Object)workFlow)) {
                flowModel.setModelId(workFlow.getModelId());
            }
            return flowModel;
        }
        return null;
    }

    public boolean updateModel(String identityKey, String tenantId, boolean updateVersion) {
        if (HussarUtils.isEmpty((Object)identityKey)) {
            return false;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, tenantId, Integer.valueOf(0));
        try {
            BpmnModel bpmnModel = this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow, updateVersion);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            if (HussarUtils.isNotEmpty((Object)workFlow)) {
                UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                updateByteArrayModel.setBytes(bpmnBytes);
                updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(workFlow.getModelId()));
                this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                SysActProcessFile sysActProcessFile = new SysActProcessFile();
                sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysActProcessFile::getProcessId, (Object)this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId()));
                queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
                this.sysActProcessFileService.update((Object)sysActProcessFile, (Wrapper)queryWrapper);
                sysActProcessFile = new SysActProcessFile();
                workFlow.setData(null);
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysActProcessFile::getProcessId, (Object)this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId()));
                queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
                this.sysActProcessFileService.update((Object)sysActProcessFile, (Wrapper)queryWrapper);
                this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId())));
                return true;
            }
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean updateModel(WorkFlow workFlow, BpmnModel bpmnModel, String procDefId) {
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(bpmnBytes);
            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelByProcDefId(procDefId));
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            SysActProcessFile sysActProcessFile = new SysActProcessFile();
            sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            this.sysActProcessFileService.update((Object)sysActProcessFile, (Wrapper)queryWrapper);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
            return true;
        }
        return false;
    }

    public BpmnModel getBpmnModel(WorkFlow workFlow, String identityKey, String tenantId) {
        try {
            return this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow, true);
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private BpmnModel convertXMLandValidate(BpmnModel model) throws XMLStreamException, BpmException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        byte[] bytes = converter.convertToXML(model, "utf-8");
        XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
        InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        XMLStreamReader xtr = xif.createXMLStreamReader(in);
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        ProcessValidatorFactory processValidatorFactory = new ProcessValidatorFactory();
        ProcessValidator defaultProcessValidator = processValidatorFactory.createDefaultProcessValidator();
        List validate = defaultProcessValidator.validate(bpmnModel);
        if (!CollectionUtils.isEmpty((Collection)validate)) {
            StringBuilder errorMsg = new StringBuilder();
            for (int i = 0; i < validate.size(); ++i) {
                errorMsg.append(((ValidationError)validate.get(i)).getDefaultDescription()).append(',').append(((ValidationError)validate.get(i)).getActivityId());
                if (i == validate.size() - 1) continue;
                errorMsg.append(';');
            }
            throw new BpmException("\u5de5\u4f5c\u6d41xml\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25", errorMsg.toString());
        }
        return bpmnModel;
    }

    private Model newModel(ObjectNode modelObjectNode, String modelName, String key, String tenantId) {
        Model modelData = this.repositoryService.newModel();
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setKey(StringUtils.defaultString((String)key));
        modelData.setName(modelName);
        modelData.setTenantId(tenantId);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Model updateModel(ObjectNode modelObjectNode, String modelName, String modelId) {
        Model modelData = this.repositoryService.getModel(modelId);
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(modelName);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private String deployModel(BpmnModel bpmnModel, Model modelData, String modelId) {
        ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
        child.updateConvertersToBpmnMap();
        child.updateConvertersToJsonMap();
        ObjectNode editorNode = child.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        return modelId;
    }

    private String completeAndDeployModel(BpmnModel bpmnModel, String modelName, String modelId, String flowDesc, String identityKey, String tenantId) {
        Model modelData;
        String newModelId = modelId;
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("description", flowDesc);
        if (HussarUtils.isEmpty((Object)newModelId) || HussarUtils.isEmpty((Object)this.repositoryService.getModel(newModelId))) {
            modelData = this.newModel(modelObjectNode, modelName, identityKey, tenantId);
            newModelId = modelData.getId();
        } else {
            modelData = this.updateModel(modelObjectNode, modelName, newModelId);
        }
        return this.deployModel(bpmnModel, modelData, newModelId);
    }

    private void createSequence(List<FlowSequence> allMapSeq, List<FlowObject> element, String formKey, Process process, BpmnModel bpmnModel) {
        for (FlowSequence formSequence : allMapSeq) {
            if (!formKey.equals(formSequence.getNodeId())) continue;
            FlowProps flowProps = formSequence.getProps();
            boolean isFlowDefault = flowProps.isFlowDefault();
            formSequence.setFlowDefault(isFlowDefault);
            formSequence.setName(flowProps.getFlowName());
            List<GraphicInfo> line = FormBpmnUtil.createFlowGraphicInfo(formSequence);
            SequenceFlow sequenceFlow = FormBpmnUtil.createSequenceFlow(formSequence, element);
            sequenceFlow.setDocumentation(flowProps.getFlowDescription());
            LineConfig lineConfig = formSequence.getLineConfig();
            if (lineConfig != null) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendSequenceflow");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute dxAttribute = new ExtensionAttribute();
                dxAttribute.setName("dx");
                dxAttribute.setValue(lineConfig.getDx());
                extensionElement.addAttribute(dxAttribute);
                ExtensionAttribute rotateAttribute = new ExtensionAttribute();
                rotateAttribute.setName("rotate");
                rotateAttribute.setValue(lineConfig.getRotate());
                extensionElement.addAttribute(rotateAttribute);
                ExtensionAttribute xAttribute = new ExtensionAttribute();
                xAttribute.setName("x");
                xAttribute.setValue(lineConfig.getX());
                extensionElement.addAttribute(xAttribute);
                ExtensionAttribute yAttribute = new ExtensionAttribute();
                yAttribute.setName("y");
                yAttribute.setValue(lineConfig.getY());
                extensionElement.addAttribute(yAttribute);
                ExtensionAttribute lineNameAttribute = new ExtensionAttribute();
                lineNameAttribute.setName("lineName");
                List list = lineConfig.getLineName();
                StringBuilder sb = new StringBuilder();
                if (list != null && !list.isEmpty()) {
                    for (String str : list) {
                        sb.append(str).append("/n");
                    }
                    lineNameAttribute.setValue(sb.toString());
                } else {
                    lineNameAttribute.setValue(null);
                }
                extensionElement.addAttribute(lineNameAttribute);
                ExtensionAttribute widthAttribute = new ExtensionAttribute();
                widthAttribute.setName(WIDTH);
                widthAttribute.setValue(lineConfig.getWidth());
                extensionElement.addAttribute(widthAttribute);
                ExtensionAttribute heightAttribute = new ExtensionAttribute();
                heightAttribute.setName(HEIGHT);
                heightAttribute.setValue(lineConfig.getHeight());
                extensionElement.addAttribute(heightAttribute);
                sequenceFlow.addExtensionElement(extensionElement);
            }
            process.addFlowElement((FlowElement)sequenceFlow);
            bpmnModel.addFlowGraphicInfoList(formKey, line);
        }
    }

    public String getActDefIdByModelId(String modelId) {
        return this.bpm2XMLMapper.getActDefIdByModelId(modelId);
    }

    public JSONObject getProcessInfoByFile(String processKey, String processId, String tenantId, boolean isGetMainOrNew) {
        WorkFlow workFlow;
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (isGetMainOrNew && HussarUtils.equals((Object)processId, (Object)processKey)) {
            try {
                processId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            }
            catch (PublicClientException e) {
                return new JSONObject();
            }
        }
        if (HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(processKey, processId, tenantId)))) {
            JSONObject object;
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                String realName;
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
                object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
                object.put(WIDTH, (Object)Double.parseDouble(flowObject.getWidth()));
                object.put(HEIGHT, (Object)Double.parseDouble(flowObject.getHeight()));
                String[] name = flowObject.getName().split("\\.");
                String subName = name[name.length - 1];
                if (HussarUtils.equals((Object)"Start", (Object)subName)) {
                    realName = "startEvent";
                } else if (HussarUtils.equals((Object)"Exclusive", (Object)subName)) {
                    realName = "exclusiveGateway";
                } else if (HussarUtils.equals((Object)"Parallel", (Object)subName)) {
                    realName = "parallelGateway";
                } else if (HussarUtils.equals((Object)"Inclusive", (Object)subName)) {
                    realName = "inclusiveGateway";
                } else if (HussarUtils.equals((Object)"End", (Object)subName)) {
                    realName = "endEvent";
                } else if (HussarUtils.equals((Object)"ReceiveTask", (Object)subName)) {
                    realName = "receiveTask";
                } else if (HussarUtils.equals((Object)"CallActivity", (Object)subName)) {
                    realName = "callActivity";
                    List callActivityElements = flowObject.getProps().getFlowSelectorArr();
                    JSONArray json = new JSONArray();
                    if (HussarUtils.isNotEmpty((Object)callActivityElements)) {
                        for (CallActivityElement callActivityElement : callActivityElements) {
                            JSONObject jo = new JSONObject();
                            jo.put("superProcessKey", (Object)callActivityElement.getProcessDefinitionKey());
                            jo.put("superProcessName", (Object)callActivityElement.getName());
                            json.add((Object)jo);
                        }
                    }
                    object.put("callActivityElement", (Object)json);
                } else {
                    realName = HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign()) && flowObject.getProps().getFlowCountersign().isCountersign() ? "multiUserTask" : "userTask";
                }
                object.put("type", (Object)realName);
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            for (FlowObject flowObject : flowModel.getSlots().getPath()) {
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
                object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
                if (((FlowSequence)flowObject).getLineConfig().getWidth() != null) {
                    object.put(WIDTH, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getWidth()));
                } else {
                    object.put(WIDTH, null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getHeight() != null) {
                    object.put(HEIGHT, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getHeight()));
                } else {
                    object.put(HEIGHT, null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getX() != null) {
                    object.put("x", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getX()));
                } else {
                    object.put("x", null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getY() != null) {
                    object.put("y", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getY()));
                } else {
                    object.put("y", null);
                }
                List xyList = flowObject.getPoints();
                Double[] xPoints = new Double[xyList.size()];
                Double[] yPoints = new Double[xyList.size()];
                for (int i = 0; i < xyList.size(); ++i) {
                    xPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getX());
                    yPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getY());
                }
                object.put("xPoints", (Object)xPoints);
                object.put("yPoints", (Object)yPoints);
                List lineNameList = ((FlowSequence)flowObject).getLineConfig().getLineName();
                if (lineNameList != null) {
                    String[] strs = new String[lineNameList.size()];
                    for (int i = 0; i < lineNameList.size(); ++i) {
                        strs[i] = (String)lineNameList.get(i);
                    }
                    object.put("lineName", (Object)strs);
                } else {
                    object.put("lineName", null);
                }
                object.put("type", (Object)"sequenceFlow");
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            jsonObject.put("data", (Object)jsonArray);
            jsonObject.put(WIDTH, (Object)flowModel.getWidth());
            jsonObject.put(HEIGHT, (Object)flowModel.getHeight());
            return jsonObject;
        }
        return jsonObject;
    }
}

