/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.FireEvent;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class ExtendCallActivityBehavior
extends CallActivityBehavior {
    private ProcessDefinitionsService processDefinitionsService = (ProcessDefinitionsService)SpringContextHolder.getBean(ProcessDefinitionsService.class);
    private FireEvent fireEvent = (FireEvent)SpringContextHolder.getBean(FireEvent.class);
    private IdentityService identityService = (IdentityService)SpringContextHolder.getBean(IdentityService.class);
    protected String processDefinitonKey;
    private List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    private List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean inheritVariables;
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getApplicationContext().getBean(ITaskEngineService.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);

    public ExtendCallActivityBehavior(String processKey, List<MapExceptionEntry> mapExceptions) {
        super(processKey, mapExceptions);
    }

    public ExtendCallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions) {
        super(processDefinitionExpression, mapExceptions);
    }

    public void addDataInputAssociation(AbstractDataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    public void setInheritVariables(boolean inheritVariables) {
        this.inheritVariables = inheritVariables;
    }

    public void execute(ActivityExecution execution) throws Exception {
        block26: {
            HistoricProcessInstance historicProcessInstance;
            JSONArray allCallActivityInfos;
            int loopCounter = execution.getVariablesLocal().get("loopCounter") == null ? 0 : (Integer)execution.getVariablesLocal().get("loopCounter");
            ActivityExecution parent = execution.getParent();
            ExecutionEntity entity = null;
            JSONArray callActivityInfos = null;
            JSONArray jSONArray = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : JSONArray.parseArray((String)JSON.toJSONString((Object)execution.getVariable("call_activity_info"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (HussarUtils.isNotEmpty(allCallActivityInfos)) {
                callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
            }
            String businessId = "";
            String userId = null;
            String customProcessDefinition = null;
            HashMap<String, Object> callVariables = new HashMap<String, Object>();
            callVariables.putAll(execution.getVariables());
            if (HussarUtils.isNotEmpty((Object)callActivityInfos)) {
                JSONObject jsonObject = (JSONObject)callActivityInfos.get(loopCounter);
                businessId = jsonObject.get((Object)"businessId") == null ? "" : String.valueOf(jsonObject.get((Object)"businessId"));
                customProcessDefinition = jsonObject.get((Object)"processKey") == null ? null : (String)jsonObject.get((Object)"processKey");
                String string = userId = jsonObject.get((Object)"userId") == null ? null : (String)jsonObject.get((Object)"userId");
                if (HussarUtils.isNotEmpty((Object)jsonObject.getObject("variable", Map.class))) {
                    Map map = (Map)jsonObject.getObject("variable", Map.class);
                    CommonCodeUtil.handleVariables(map);
                    callVariables.putAll(map);
                }
            }
            if (null != parent) {
                if (HussarUtils.isEmpty((Object)businessId)) {
                    businessId = "CallActivity" + ((ExecutionEntity)execution).getActivityId() + loopCounter + execution.getProcessBusinessKey();
                }
                entity = (ExecutionEntity)execution;
                entity.setBusinessKey(businessId);
            }
            ExecutionEntity newExecution = entity;
            String processKey = customProcessDefinition;
            BpmnModel bm = this.repositoryService.getBpmnModel(newExecution.getProcessDefinitionId());
            if (HussarUtils.isEmpty(processKey) || HussarUtils.isEmpty(userId)) {
                Map<String, String> assigneeMessage = AnalyticalModelUtil.getCallActivityAssignee(bm, execution, callVariables);
                if (HussarUtils.isEmpty((Object)processKey)) {
                    processKey = assigneeMessage.get("processKey");
                }
                if (HussarUtils.isEmpty(userId)) {
                    userId = assigneeMessage.get("assignee");
                }
            }
            if (!"".equals(businessId) && (historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()) != null) {
                ExecutionEntity propagatingExecution;
                List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"reject")).orderByTaskCreateTime()).asc()).listPage(0, 1);
                if (!historicTaskInstanceList.isEmpty()) {
                    userId = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getAssignee();
                }
                if (!entity.getProcessInstanceId().equals(historicProcessInstance.getSuperProcessInstanceId()) || HussarUtils.isNotEmpty((Object)customProcessDefinition) && !customProcessDefinition.equals(historicProcessInstance.getProcessDefinitionKey())) {
                    throw new PublicClientException(this.bpmConstantProperties.getCallActivityBusinessIdExist(), Boolean.valueOf(false));
                }
                if (HussarUtils.isEmpty((Object)historicProcessInstance.getEndTime())) {
                    throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), Boolean.valueOf(false));
                }
                this.taskEngineService.reStartProcessUpdate(historicProcessInstance.getId(), businessId, historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
                ActivityImpl destinationActivity = null;
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    destinationActivity = (ActivityImpl)((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination();
                    break;
                }
                if (destinationActivity == null) {
                    throw new ActivitiException("\u6d41\u7a0b\u56fe\u5f02\u5e38\uff01");
                }
                ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                ExecutionEntity executionEntity = executionEntityManager.findExecutionById(historicProcessInstance.getId());
                executionEntity.setSuperExecution(entity);
                entity.setSubProcessInstance((InterpretableExecution)executionEntity);
                this.fireEvent.fireEvent(executionEntity, "restart_process", "sub_process_restart");
                HistoricActivityInstanceEntity activitiyInstance = Context.getCommandContext().getHistoryManager().findActivityInstance(entity);
                if (activitiyInstance != null) {
                    activitiyInstance.setCalledProcessInstanceId(executionEntity.getProcessInstanceId());
                }
                Map map = execution.getVariables();
                if (!"".equals(userId)) {
                    HashMap<String, String> appointAssignee = new HashMap<String, String>();
                    appointAssignee.put("static_appoint_assignee", userId);
                    map.put("appoint_assignee", appointAssignee);
                }
                map.remove("public_appoint_assignee");
                map.remove("reject_to");
                map.remove("reject_from");
                map.remove("loopCounter");
                executionEntity.setVariables(map);
                if (destinationActivity.isScope()) {
                    propagatingExecution = executionEntity.createExecution();
                    executionEntity.setTransition(null);
                    executionEntity.setActivity(null);
                    executionEntity.setActive(false);
                    propagatingExecution.setActivity(destinationActivity);
                    propagatingExecution.initialize();
                } else {
                    propagatingExecution = executionEntity;
                }
                propagatingExecution.executeActivity((PvmActivity)destinationActivity);
                return;
            }
            if (HussarUtils.isNotEmpty(execution.getVariables().get("sendUser"))) {
                this.identityService.setAuthenticatedUserId(String.valueOf(execution.getVariables().get("sendUser")));
            }
            DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (HussarUtils.isEmpty((Object)definitionModel)) {
                return;
            }
            String processDefinitionId = definitionModel.getId();
            ProcessDefinitionEntity processDefinition = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
            if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
                throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
            }
            PvmProcessInstance subProcessInstance = newExecution.createSubProcessInstance((PvmProcessDefinition)processDefinition);
            ((ExecutionEntity)subProcessInstance).setBusinessKey(businessId);
            Map variables = newExecution.getVariables();
            variables.remove("public_appoint_assignee");
            variables.remove("reject_to");
            variables.remove("reject_from");
            variables.remove("loopCounter");
            for (Map.Entry entry : variables.entrySet()) {
                subProcessInstance.setVariable((String)entry.getKey(), entry.getValue());
            }
            HashMap<String, String> appointAssignee = new HashMap<String, String>();
            appointAssignee.put("static_appoint_assignee", userId);
            subProcessInstance.setVariable("appoint_assignee", appointAssignee);
            if (HussarUtils.isNotEmpty((Object)userId)) {
                ((ExecutionEntity)subProcessInstance).setVariable("startUser", (Object)userId);
            }
            for (AbstractDataAssociation dataInputAssociation : this.dataInputAssociations) {
                Object value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue((VariableScope)newExecution) : newExecution.getVariable(dataInputAssociation.getSource());
                subProcessInstance.setVariable(dataInputAssociation.getTarget(), value);
            }
            try {
                subProcessInstance.start();
            }
            catch (Exception exception) {
                if (ErrorPropagation.mapException((Exception)exception, (ActivityExecution)newExecution, this.mapExceptions, (boolean)true)) break block26;
                throw exception;
            }
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (int i = 0; i < allCallActivityInfos.size(); ++i) {
            JSONObject object = (JSONObject)allCallActivityInfos.get(i);
            if (!HussarUtils.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }

    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (AbstractDataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue((VariableScope)subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    public void completed(ActivityExecution execution) throws Exception {
        if (TaskEngineServiceImpl.getCallRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        ExecutionEntity activityExecution = new ExecutionEntity();
        if (execution.getParent() != null) {
            activityExecution = execution.getParent();
            activityExecution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
        }
        if (activityExecution.getParent() != null) {
            activityExecution = activityExecution.getParent();
            activityExecution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
        }
        this.leave(execution);
    }
}

