/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.CallActivity")
public class CallActivityVisitor
implements FormObjectVisitor {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");

    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel) {
        List output;
        CallActivity callActivity = new CallActivity();
        FlowProps flowProps = flowObject.getProps();
        callActivity.setId(flowObject.getId());
        callActivity.setName(flowObject.getProps().getFlowName());
        callActivity.setDocumentation(flowObject.getProps().getFlowDescription());
        callActivity.setCalledElement(flowObject.getProps().getFlowSelectorStr());
        List input = flowObject.getProps().getInput();
        if (HussarUtils.isNotEmpty((Object)input)) {
            ArrayList<IOParameter> inList = new ArrayList<IOParameter>();
            for (Object subProps : input) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                inList.add(ioParameter);
            }
            callActivity.setInParameters(inList);
        }
        if (HussarUtils.isNotEmpty((Object)(output = flowObject.getProps().getOutput()))) {
            ArrayList<IOParameter> outList = new ArrayList<IOParameter>();
            for (Object subProps : output) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                outList.add(ioParameter);
            }
            callActivity.setOutParameters(outList);
        }
        if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, callActivity);
        }
        callActivity.setInheritVariables(true);
        HashSet<String> functionIds = new HashSet<String>();
        FlowAssignment flowSelector = flowProps.getFlowSelector();
        if (HussarUtils.isNotEmpty((Object)flowSelector)) {
            this.getFunctionIds(flowSelector.getDefaultBackCondtion(), functionIds);
            if (HussarUtils.isNotEmpty((Object)flowSelector.getJudgeBackCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowSelector.getJudgeBackCondition()) {
                    this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)flowFunctionConfigs)) {
            for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                if (!functionIds.contains(flowFunctionConfig.getId())) continue;
                map.put(flowFunctionConfig.getId(), flowFunctionConfig.getValue());
            }
        }
        FormBpmnUtil.callActivityAssigneeInstall(flowObject, callActivity, map);
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = flowModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        List useVariables = flowObject.getProps().getUseVariables();
        if (HussarUtils.isNotEmpty((Object)useVariables)) {
            FormBpmnUtil.addExeListener((FlowElement)callActivity, useVariables, pathIds, false);
        }
        FormBpmnUtil.addExecutionListener(null, null, callActivity, null, flowObject);
        process.addFlowElement((FlowElement)callActivity);
    }

    private void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (HussarUtils.isNotEmpty((Object)assignee) && assignee.contains("@{")) {
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }

    private void counterSign(FlowObject flowObject, CallActivity callActivity) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

