/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDiagramServiceImpl
implements ProcessDiagramService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DruidProperties druidProperties;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    private static final String FINISH_STATE = "finish";
    private static final String COMPLETE_STATE = "complete";
    private static final String NEXT_STATE = "next";
    private static final String SUSPENDED_STATE = "suspend";
    private static final String OVER_TIME_STATE = "overtime";

    public JSONObject getProcessInfo(String processInsId, String businessId) {
        List<String> idList;
        HistoricProcessInstance processInstance;
        if (ToolUtil.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONObject();
            }
        }
        if (ToolUtil.isEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()))) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        boolean suspended = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).includeTaskLocalVariables()).includeProcessVariables()).list();
        List<Object> lineList = new ArrayList();
        if (taskList.size() == 0) {
            idList = this.queryPreActivitiesByTaskIdFinished(processInsId);
        } else {
            ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            suspended = instance.isSuspended();
            idList = this.queryFinishNode(processInsId, processDefinitonId);
        }
        ArrayList<Object> runningNode = new ArrayList<Object>();
        HashMap nodeState = new HashMap();
        List mapList = this.instanceEngineService.getCallNodeType(processInsId);
        for (Map map : mapList) {
            runningNode.add(map.get("node"));
            nodeState.put(map.get("node"), ToolUtil.isEmpty(map.get("type")) ? COMPLETE_STATE : (String)map.get("type"));
        }
        for (Object task : taskList) {
            String completeType;
            runningNode.add(task.getTaskDefinitionKey());
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), OVER_TIME_STATE);
                continue;
            }
            String string = completeType = task.getTaskLocalVariables().get("complete_type") == null ? COMPLETE_STATE : task.getTaskLocalVariables().get("complete_type").toString();
            if ("reject_revoke".equals(completeType)) {
                completeType = COMPLETE_STATE;
            }
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("receiveTask").list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            runningNode.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId);
        if (sysActHiLines != null && sysActHiLines.size() > 0) {
            lineList = sysActHiLines.stream().map(sysActHiLine -> sysActHiLine.getLineId()).collect(Collectors.toList());
        }
        Process process = bpmnModel.getMainProcess();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Map extensionElementsNode = process.getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String height = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            if (graphicInfo.getX() > Double.parseDouble(width)) {
                width = String.valueOf(graphicInfo.getX());
            }
            object.put("y", (Object)graphicInfo.getY());
            if (graphicInfo.getY() + 100.0 > Double.parseDouble(height)) {
                height = String.valueOf(graphicInfo.getY() + 100.0);
            }
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInstance.getId());
            if (runningNode.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)SUSPENDED_STATE);
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                }
            } else if (idList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)NEXT_STATE);
            }
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put("lineName", null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && stringListMap.size() > 0 && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && extendFlowNameElement.size() > 0 && ToolUtil.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if ("lineName".equals(map.getKey())) {
                            String lineNames_str = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNames_str.split("/n");
                            obj.put("lineName", (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && graphicInfoList.size() > 0) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)NEXT_STATE);
                }
                jsonArray.add((Object)obj);
            }
        }
        jsonObject.put("width", (Object)width);
        jsonObject.put("height", (Object)height);
        jsonObject.put("data", (Object)jsonArray);
        return jsonObject;
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String tenantId) {
        if (ToolUtil.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONArray();
            }
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (ToolUtil.isEmpty((Object)processInstance)) {
            return new JSONArray();
        }
        String processDefinitionId = processInstance.getProcessDefinitionId();
        int version = Integer.parseInt(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinitionId));
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(TaskInfo::getAssignee).filter(x -> x != null).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).includeTaskLocalVariables()).list();
        ArrayList<String> hisTaskIds = new ArrayList<String>();
        for (HistoricTaskInstance hisTask : hisList) {
            if (hisTask.getEndTime() == null) continue;
            hisTaskIds.add(hisTask.getId());
        }
        List<Object> commentsMap = new ArrayList();
        if (ToolUtil.isNotEmpty(hisTaskIds)) {
            commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        HashMap taskComment = new HashMap();
        for (Map map : commentsMap) {
            taskComment.put(String.valueOf(map.get("id")), map.get("comments"));
        }
        for (ActivityImpl activityImpl : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activityImpl.getWidth());
            object.put("height", (Object)activityImpl.getHeight());
            object.put("x", (Object)activityImpl.getX());
            object.put("y", (Object)activityImpl.getY());
            object.put("id", (Object)activityImpl.getId());
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                ArrayList<String> taskIds = new ArrayList<String>();
                for (Task task : taskList) {
                    taskIds.add(task.getId());
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                List<String> user = this.getAssigneeByTaskIds(taskIds);
                List ts = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                Map map = ((Task)ts.get(0)).getTaskLocalVariables();
                if (map != null) {
                    object.put("rejectFrom", (Object)(map.get("reject_name") == null ? "" : map.get("reject_name").toString()));
                    object.put("completeType", (Object)(map.get("complete_type") == null ? "" : map.get("complete_type").toString()));
                } else {
                    object.put("rejectFrom", (Object)"");
                    object.put("completeType", (Object)"");
                }
                if (user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)COMPLETE_STATE);
                if (nowHisActivitList.size() > 0) {
                    nowHisActivitList.sort((o1, o2) -> {
                        if (!o1.getStartTime().equals(o2.getStartTime())) {
                            return o1.getStartTime().compareTo(o2.getStartTime());
                        }
                        if (ToolUtil.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        if (o1.getEndTime() == null && o2.getEndTime() != null) {
                            return o2.getEndTime().compareTo(new Date(0L));
                        }
                        if (o1.getEndTime() != null && o2.getEndTime() == null) {
                            return new Date(0L).compareTo(o1.getEndTime());
                        }
                        if (o1.getEndTime().equals(o2.getEndTime())) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        return o1.getEndTime().compareTo(o2.getEndTime());
                    });
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        JSONObject o = new JSONObject();
                        String nowUser = historicActivityInstance.getAssignee() != null ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) : this.bpmConstantProperties.getNullComplete();
                        String comment = (String)taskComment.get(historicActivityInstance.getId());
                        o.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o.put("assignee", (Object)nowUser);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = this.bpmConstantProperties.getNullComplete();
                    }
                    o.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    public Map<String, Object> list(String processInsId, String businessId, String tenantId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (ToolUtil.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTrace(processInsId, tenantId);
        result.put("count", obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> microAppList(String processInsId, String businessId, String tenantId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (ToolUtil.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTraceByMicroApp(processInsId, tenantId);
        result.put("count", obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isEmpty((Object)supProcessInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                supProcessInsId = instance.getId();
            } else {
                return map;
            }
        }
        map.put("supProcessInsId", supProcessInsId);
        map.put("taskDefinitionKey", taskDefinitionKey);
        List<ProcessInst> instList = this.processInstMapper.getCallActivityProcessInstList((Page<ProcessInst>)pages, map);
        for (ProcessInst processInst : instList) {
            List nodeNames = processInst.getNodeNames();
            if (nodeNames == null) continue;
            nodeNames.remove(null);
            if (nodeNames.size() <= 0) continue;
            processInst.setNames(String.join((CharSequence)",", nodeNames));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (allGraphicInfos.size() > 0) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = "userTask";
        } else if (flowNode instanceof ServiceTask) {
            type = "serviceTask";
        } else if (flowNode instanceof ReceiveTask) {
            type = "receiveTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private List<String> queryPreActivitiesByTaskIdFinished(String processInsId) {
        ArrayList<String> idList = new ArrayList<String>();
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInsId).orderByHistoricActivityInstanceEndTime().finished().asc()).list();
        for (HistoricActivityInstance his : list) {
            idList.add(his.getActivityId());
        }
        return idList;
    }

    private List<String> queryFinishNode(String processInsId, String processDefinitionId) {
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        ArrayList<String> idList = new ArrayList<String>();
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).finished().list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            ActivityImpl activity = def.findActivity(historicActivityInstance.getActivityId());
            if (activity == null) continue;
            idList.add(activity.getId());
        }
        return idList;
    }

    private List<String> getAssigneeByTaskIds(List<String> taskIds) {
        ArrayList<String> users = new ArrayList<String>();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
                if (identityLinkList == null || identityLinkList.size() <= 0) continue;
                for (IdentityLink identityLink : identityLinkList) {
                    users.add(identityLink.getUserId());
                }
            }
        }
        return users;
    }
}

