/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceTaskListener
implements JavaDelegate {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultServiceTaskListener.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);

    public void execute(DelegateExecution delegateExecution) throws Exception {
        BpmnModel bm = repositoryService.getBpmnModel(delegateExecution.getProcessDefinitionId());
        FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(delegateExecution.getCurrentActivityId());
        List list = (List)flowElement.getExtensionElements().get("service_task_url");
        if (list.size() > 0) {
            String serviceTaskUrl;
            boolean isPost = (serviceTaskUrl = ((ExtensionElement)list.get(0)).getAttributeValue(null, "service_task_url")).startsWith("POST");
            String url = serviceTaskUrl.substring(isPost ? 4 : 3);
            HashMap<String, String> map = new HashMap<String, String>();
            ExecutionEntity entity = (ExecutionEntity)delegateExecution;
            map.put("nodeId", delegateExecution.getCurrentActivityId());
            map.put("nodeName", delegateExecution.getCurrentActivityName());
            map.put("businessId", delegateExecution.getProcessBusinessKey());
            map.put("processInsId", delegateExecution.getProcessInstanceId());
            map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
            map.put("processKey", entity.getProcessDefinitionKey());
            map.put("tenantId", delegateExecution.getTenantId());
            for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getIdentityLinks()) {
                if (!"starter".equals(identityLinkEntity.getType())) continue;
                map.put("starter", identityLinkEntity.getUserId());
                break;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("createTime", simpleDateFormat.format(new Date()));
            map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
            try {
                if (isPost) {
                    HttpRequestUtil.post((String)url, map);
                } else {
                    HttpRequestUtil.getRequestResult((String)url, map);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u670d\u52a1\u4efb\u52a1\u53d1\u9001\u8bf7\u6c42\u51fa\u9519");
            }
        }
    }
}

