/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.apache.commons.lang3.StringUtils;

public class AddAssigneeCmd
implements Command<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    protected String users;
    protected String taskId;

    public AddAssigneeCmd(String taskId, String users) {
        this.users = users;
        this.taskId = taskId;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity == null) {
            throw new PublicClientException(bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.users)) {
            Set<String> userSet = this.getAssigneeByTaskId(taskEntity.getId());
            for (String user : userSet) {
                this.taskService.deleteCandidateUser(taskEntity.getId(), user);
            }
            List<String> assigneeList = Arrays.asList(this.users.split(","));
            taskEntity.addCandidateUsers(assigneeList);
        }
        return null;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

