/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.engine.bsp.datasource.model.BpmSysDataSource;
import com.jxdinfo.hussar.workflow.engine.bsp.datasource.service.BpmSysDataSourceService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.dao.SysUserMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Resource
    private SysUserMapper sysUserMapper;
    @Autowired
    private BpmSysDataSourceService bpmSysDataSourceService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public BpmSysDataSource querySysDataSourceByUserId(String userId) {
        try {
            BpmSysDataSource bpmSysDataSource = this.sysUserMapper.querySysDataSourceByUserId(userId);
            return bpmSysDataSource;
        }
        finally {
            this.dynamicDataSourceService.poll();
        }
    }

    public SysUser querySysUserByUserId(String userId) {
        try {
            SysUser sysUser = this.sysUserMapper.querySysUserByUserId(userId);
            return sysUser;
        }
        finally {
            this.dynamicDataSourceService.poll();
        }
    }

    public List<SysUser> querySysTenantList() {
        return this.sysUserMapper.querySysTenantList();
    }

    public SysUser getSysUserByTenantId(String tenantId) {
        return this.sysUserMapper.getSysUserByTenantId(tenantId);
    }

    public List<SysUser> getSysUserListWithoutAccount(String userAccount) {
        return this.sysUserMapper.getSysUserListWithoutAccount(userAccount);
    }

    public SysUser querySysUserByTenantId(String tenantId, String tenantCipher) {
        return this.sysUserMapper.querySysUserByTenantId(tenantId, tenantCipher);
    }

    public SysUser querySysUserByTenantCode(String tenantCode) {
        return this.sysUserMapper.querySysUserByTenantCode(tenantCode);
    }

    public boolean testConn(String connName) {
        Connection conn = null;
        try {
            conn = this.dynamicDataSourceService.getDataSource(connName).getConnection();
            conn.setAutoCommit(false);
            conn.close();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }
}

