/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (linkEntityList.size() > 0) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (!entity.getTasks().isEmpty()) {
            for (TaskEntity taskEntity : entity.getTasks()) {
                this.sysActUrgeTaskMapper.deleteByTaskId(taskEntity.getId());
            }
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

