/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstServiceImpl
implements ProcessInstService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private DataPushService dataPushService;

    public IPage<ProcessInst> getProcessList(Page<ProcessInst> page, ProcessListDto processListDto) {
        List<ProcessInst> instList = this.processInstMapper.getListMySql(page, processListDto);
        for (ProcessInst processInst : instList) {
            List nodeNames = processInst.getNodeNames();
            if (nodeNames == null) continue;
            nodeNames.remove(null);
            if (nodeNames.size() <= 0) continue;
            processInst.setNames(String.join((CharSequence)",", nodeNames));
        }
        page.setRecords(instList);
        return page;
    }

    public ApiResponse<String> suspendProcessInstanceById(String processInstCode) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    public ApiResponse<String> activateProcessById(String processInstCode) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    public ApiResponse<String> deleteProcessInstance(String processInsId) {
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
            StringBuilder taskIds = new StringBuilder();
            for (Task task : tasks) {
                taskIds.append(",").append(task.getId());
            }
            if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
            }
            this.runtimeService.deleteProcessInstance(processInsId, "");
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)processInsId);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            this.historyService.deleteHistoricProcessInstance(processInsId);
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)processInsId);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessInsId(processInsId);
                this.dataPushService.deleteDataPush(dataPush);
            }
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        try {
            this.historyService.deleteHistoricProcessInstance(processInstCode);
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)processInstCode);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessInsId(processInstCode);
                this.dataPushService.deleteDataPush(dataPush);
            }
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.DELETE_FAIL.getMessage());
        }
    }
}

