/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.Map;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.ServiceTask")
public class ServiceTaskVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel) {
        ServiceTask serviceTask = new ServiceTask();
        FlowProps flowProps = flowObject.getProps();
        serviceTask.setName(flowProps.getFlowName());
        serviceTask.setId(flowObject.getId());
        serviceTask.setDocumentation(flowProps.getFlowDescription());
        serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
        Map taskConfiguration = flowProps.getTaskConfiguration();
        if (ToolUtil.isEmpty(taskConfiguration.get("classPath"))) {
            String typeWithUrl = (String)taskConfiguration.get("requestMode") + (String)taskConfiguration.get("protocol") + (String)taskConfiguration.get("requestUrl");
            serviceTask.addExtensionElement(FormBpmnUtil.addExtensionElement("service_task_url", typeWithUrl));
            serviceTask.setImplementation("com.jxdinfo.hussar.workflow.engine.bpm.listener.DefaultServiceTaskListener");
        } else {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            serviceTask.setImplementation((String)taskConfiguration.get("classPath"));
        }
        FormBpmnUtil.addExecutionListener(null, serviceTask, null, null, flowObject);
        process.addFlowElement((FlowElement)serviceTask);
    }
}

