/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class AnalyticalModelUtil {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static SysActEntrustService sysActEntrustService = (SysActEntrustService)SpringContextHolder.getBean(SysActEntrustService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private static SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)SpringContextHolder.getBean(SysActAssigneeService.class);
    private static Logger LOGGER = LoggerFactory.getLogger(AnalyticalModelUtil.class);
    private static final String STARTER = "starter";

    public static HashSet<String> getCandidateUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        HashSet<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, tenantId);
        if (ToolUtil.isEmpty(users)) {
            return new HashSet<String>();
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        ArrayList<String> result = new ArrayList<String>(users);
        users = new HashSet();
        Map userMap = sysActEntrustService.queryByUsers(result, processKey);
        if (result.size() > 0) {
            for (String id : result) {
                if (ToolUtil.isNotEmpty(userMap.get(id))) {
                    users.add((String)userMap.get(id));
                    continue;
                }
                users.add(id);
            }
        }
        return users;
    }

    private static HashSet<String> getConfigUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        JSONObject inExpressions;
        String defaultAssign;
        String appointAssignees;
        Map map;
        String activityId = execution.getActivity().getId();
        HashSet<String> users = new HashSet<String>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        String allowSetParticipantRepetition = "";
        if (extensionElementsNode.get("allowSetParticipant") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant");
            String string = allowSetParticipantRepetition = ToolUtil.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "true";
        }
        if (!"false".equals(allowSetParticipantRepetition)) {
            String appointAssignees2;
            map = execution.getVariableLocal("appoint_assignee") == null ? new HashMap() : (Map)execution.getVariableLocal("appoint_assignee");
            boolean isLocal = true;
            if (ToolUtil.isEmpty(map) && execution.getVariable("appoint_assignee") != null) {
                isLocal = false;
                map = (Map)execution.getVariable("appoint_assignee");
            }
            if (ToolUtil.isNotEmpty((Object)(appointAssignees2 = (String)map.get(activityId)))) {
                if (isLocal) {
                    execution.removeVariableLocal("appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(appointAssignees2.split(",")));
                return users;
            }
            String staticAppointAssignees = (String)map.get("static_appoint_assignee");
            if (ToolUtil.isNotEmpty((Object)staticAppointAssignees)) {
                if (isLocal) {
                    execution.removeVariableLocal("appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(staticAppointAssignees.split(",")));
                return users;
            }
            String rejectAssignees = execution.getVariableLocal("reject_appoint_assignee") == null ? "" : (String)execution.getVariableLocal("reject_appoint_assignee");
            isLocal = true;
            if (ToolUtil.isEmpty((Object)rejectAssignees) && execution.getVariable("reject_appoint_assignee") != null) {
                isLocal = false;
                rejectAssignees = (String)execution.getVariable("reject_appoint_assignee");
            }
            if (ToolUtil.isNotEmpty((Object)rejectAssignees)) {
                if (isLocal) {
                    execution.removeVariableLocal("reject_appoint_assignee");
                } else {
                    execution.removeVariable("reject_appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(rejectAssignees.split(",")));
                return users;
            }
        }
        if (ToolUtil.isEmpty(users) && ToolUtil.isNotEmpty((Object)(appointAssignees = (String)(map = execution.getVariable("public_appoint_assignee") == null ? new HashMap() : (Map)execution.getVariable("public_appoint_assignee")).get(activityId)))) {
            users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            return users;
        }
        boolean flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue());
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        if (flowStarter) {
            users.add(userId);
            return users;
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, false);
        if (ToolUtil.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")));
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
            inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
        }
        HashMap<String, Object> assignmentNodeMap = new HashMap();
        if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId());
        }
        users = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        return users;
    }

    private static Map<String, Object> getAssignmentNodeMap(BpmnModel bm, String activityId, String processInsId) {
        ArrayList<String> list;
        HashMap<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        if (ToolUtil.isEmpty((Object)extensionElementsNode)) {
            return assignmentNodeMap;
        }
        String assignmentNode = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("assignmentnode")).get(0)).getAttributes().get("assignmentnode")).get(0)).getValue();
        if (ToolUtil.isNotEmpty((Object)assignmentNode) && (list = new ArrayList<String>(new HashSet<String>(Arrays.asList(assignmentNode.split(","))))).size() > 0) {
            for (String node : list) {
                if (processInsId == null) {
                    assignmentNodeMap.put(node, "");
                    continue;
                }
                List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(node)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list();
                StringBuilder assignee = new StringBuilder();
                if (hisTaskList != null && hisTaskList.size() > 0) {
                    block1: for (int i = 0; i < hisTaskList.size(); ++i) {
                        String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                        if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                        Date start = historicTaskInstance.getStartTime();
                        assignee.append(historicTaskInstance.getAssignee());
                        for (int j = i; j < hisTaskList.size(); ++j) {
                            historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                            if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block1;
                            assignee.append(",").append(historicTaskInstance.getAssignee());
                        }
                        break;
                    }
                }
                if (ToolUtil.isNotEmpty((Object)assignee.toString())) {
                    assignmentNodeMap.put(node, assignee.toString());
                    continue;
                }
                assignmentNodeMap.put(node, "");
            }
        }
        return assignmentNodeMap;
    }

    private static JSONObject getConditionAssign(BpmnModel bm, String activityId, String type) {
        JSONObject inExpressions = new JSONObject();
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List inCandidate = (List)extensionAttribute.get(type);
        if (inCandidate != null && inCandidate.size() > 0) {
            inExpressions = ((ExtensionAttribute)inCandidate.get(0)).getValue() == null ? null : (JSONObject)JSONObject.parse((String)((ExtensionAttribute)inCandidate.get(0)).getValue());
        }
        return inExpressions;
    }

    private static String getDefaultAssign(BpmnModel bm, String activityId, String type) {
        String defaultAssign = "";
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List defaultCandidate = (List)extensionAttribute.get(type);
        if (defaultCandidate != null && defaultCandidate.size() > 0) {
            defaultAssign = ((ExtensionAttribute)defaultCandidate.get(0)).getValue() == null ? "" : ((ExtensionAttribute)defaultCandidate.get(0)).getValue();
        }
        return defaultAssign;
    }

    private static String getFlowStarter(ActivityExecution execution) {
        HistoricProcessInstance historicProcessInstance;
        String userId = "";
        List identityLink = ((ExecutionEntity)execution).getIdentityLinks();
        for (IdentityLinkEntity il : identityLink) {
            if (!STARTER.equals(il.getType())) continue;
            userId = il.getUserId() == null ? "" : il.getUserId();
            break;
        }
        if ("".equals(userId) && ToolUtil.isNotEmpty((Object)(historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult())) && ToolUtil.isNotEmpty((Object)historicProcessInstance.getStartUserId())) {
            userId = historicProcessInstance.getStartUserId();
        }
        return userId;
    }

    public static Map<String, Object> getCcUser(BpmnModel bm, ActivityExecution execution, String tenantId) {
        String sendUserId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set ccUsers = execution.getVariable("cc_user") == null ? new HashSet() : (Set)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable("sendUser") == null ? "" : (String)execution.getVariable("sendUser");
        if (ccUsers != null && ccUsers.size() > 0) {
            execution.removeVariable("cc_user");
        } else {
            JSONObject inExpressions;
            String defaultAssign;
            String activityId = execution.getActivity().getId();
            String userId = AnalyticalModelUtil.getFlowStarter(execution);
            Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, true);
            if (ToolUtil.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultCcAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionCcAssign")));
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcAssign");
            }
            HashMap<String, Object> assignmentNodeMap = new HashMap();
            if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId());
            }
            ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    private static HashSet<String> getAssigneeByConfiguration(String tenantId, ActivityExecution execution, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> assignmentNodeMap) {
        Map<String, Object> formData = execution.getVariables();
        if (formData != null && formData.size() > 0) {
            formData.putAll(assignmentNodeMap);
        } else {
            formData = assignmentNodeMap;
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        return AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, processKey, userId, defaultAssign, conditionAssign, formData);
    }

    public static Map<String, String> getToDoConfiguration(String processDefinitionId, String taskDefinitionKey) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String todo = "";
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        if (ToolUtil.isNotEmpty((Object)taskDefinitionKey)) {
            Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(taskDefinitionKey).getExtensionElements();
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            map.put("todoConfiguration", todo);
        }
        Map extensionElements = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        if (ToolUtil.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElements.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            if (ToolUtil.isNotEmpty((Object)todo)) {
                map.put("todoConfiguration", todo);
            } else {
                map.put("todoConfiguration", "");
            }
        }
        return map;
    }

    public static String getTodo(Map<String, Object> variables, String todoConfig) {
        if (ToolUtil.isEmpty((Object)todoConfig)) {
            return "";
        }
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(variables);
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, todoConfig, String.class);
        return valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
    }

    private static HashSet<String> getNextAssigneeByConfiguration(String tenantId, String processKey, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> map) {
        String realSql;
        List list;
        HashSet<String> users = new HashSet<String>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        boolean isGetFlowStarterDept = false;
        boolean isGetFlowSameLevelDept = false;
        boolean isGetFlowParentDept = false;
        boolean isGetFlowSubmiterDept = false;
        boolean isGetFlowSubmiterSameLevelDept = false;
        boolean isGetFlowSubmiterParentDept = false;
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
                break;
            }
        }
        if (isGetFlowStarterDept) {
            map.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        if (defaultAssign.contains("flow_sameLevel_dept")) {
            isGetFlowSameLevelDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_sameLevel_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_sameLevel_dept")) continue;
                isGetFlowSameLevelDept = true;
                break;
            }
        }
        if (isGetFlowSameLevelDept) {
            map.put("flow_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserId(userId, tenantId));
        }
        if (defaultAssign.contains("flow_parent_dept")) {
            isGetFlowParentDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_parent_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_parent_dept")) continue;
                isGetFlowParentDept = true;
                break;
            }
        }
        if (isGetFlowParentDept) {
            map.put("flow_parent_dept", iAssigneeChooseService.getParentDeptIdByUserId(userId, tenantId));
        }
        if (defaultAssign.contains("flow_submiter_dept")) {
            isGetFlowSubmiterDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_dept")) continue;
                isGetFlowSubmiterDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterDept) {
            map.put("flow_submiter_dept", iAssigneeChooseService.getDeptIdByUserId(map.get("sendUser").toString(), tenantId));
        }
        if (defaultAssign.contains("flow_submiter_sameLevel_dept")) {
            isGetFlowSubmiterSameLevelDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_sameLevel_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_sameLevel_dept")) continue;
                isGetFlowSubmiterSameLevelDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterSameLevelDept) {
            map.put("flow_submiter_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserId(map.get("sendUser").toString(), tenantId));
        }
        if (defaultAssign.contains("flow_submiter_parent_dept")) {
            isGetFlowSubmiterParentDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_parent_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_parent_dept")) continue;
                isGetFlowSubmiterParentDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterParentDept) {
            map.put("flow_submiter_parent_dept", iAssigneeChooseService.getParentDeptIdByUserId(map.get("sendUser").toString(), tenantId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (ToolUtil.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        if ((list = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(realSql = sql.toString(), userId, tenantId, map), tenantId, (Integer)map.get("security_level"))) == null || list.size() == 0) {
            return users;
        }
        users.addAll(list);
        return users;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && map.size() > 0) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    private static String replaceNextBuiltinVariable(String sql, String starterUserId, String tenantId, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (!sql.contains("('${" + key.getKey() + "}')")) continue;
                map.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        return "and (" + finalSql.replaceFirst("and", "") + ")";
    }

    public static String queryFirstNodeAssigneeConfig(String userId, String tenantId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        Map result;
        HashMap<String, Object> newVariables;
        JSONObject conditionAssign;
        String defaultAssign;
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        StringBuilder sql = new StringBuilder();
        String taskDefinitionKey = "";
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        boolean condition = false;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = process.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = AnalyticalModelUtil.getFirstNode(flowElement, process, variables);
        }
        if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
            return "";
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(processDefinitionId.split(":")[0], taskDefinitionKey, false);
        if (ToolUtil.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            conditionAssign = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")));
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, taskDefinitionKey, "defaultAssign");
            conditionAssign = AnalyticalModelUtil.getConditionAssign(bm, taskDefinitionKey, "conditionAssign");
        }
        if (ToolUtil.isEmpty((Object)defaultAssign) && ToolUtil.isEmpty((Object)conditionAssign)) {
            return "";
        }
        boolean isGetFlowStarterDept = false;
        boolean isRequestVisit = false;
        if (defaultAssign.contains("$")) {
            isRequestVisit = true;
        }
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        }
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (isGetFlowStarterDept && isRequestVisit) break;
                if (!isRequestVisit && (k.toString().contains("$") || ((String)conditionAssign.get((Object)k.toString())).contains("$"))) {
                    isRequestVisit = true;
                }
                if (isGetFlowStarterDept || !k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
            }
        }
        HashMap<String, Object> hashMap = newVariables = variables == null ? new HashMap<String, Object>() : variables;
        if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, conditionAssign})) {
            Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, taskDefinitionKey, null);
            newVariables.putAll(nodeMap);
        }
        if (isRequestVisit && ToolUtil.isNotEmpty((Object)(result = CommonCodeUtil.getGodAxeResult((String)tenantId, (String)taskDefinitionKey, (String)businessId, (String)processDefinitionId)))) {
            newVariables.putAll(result);
        }
        if (isGetFlowStarterDept) {
            newVariables.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (ToolUtil.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return "";
            }
        }
        String finalSql = "";
        if (ToolUtil.isNotEmpty((Object)sql)) {
            finalSql = AnalyticalModelUtil.replaceNextBuiltinVariable(sql.toString(), userId, tenantId, newVariables);
        }
        return finalSql;
    }

    private static boolean getResultByELAndFormData(String el, Map<String, Object> formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Map.Entry<String, Object> k : formData.entrySet()) {
            if (k.getValue() != null) {
                context.setVariable(k.getKey(), factory.createValueExpression(k.getValue(), k.getValue().getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(k.getValue(), Object.class));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private static String getFirstNode(FlowElement flowElement, Process process, Map<String, Object> variables) {
        SequenceFlow sequenceFlow;
        String targetRef;
        FlowElement fe;
        String taskDefinitionKey = "";
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
        String flow = exclusiveGateway.getDefaultFlow();
        List sf = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow s : sf) {
            String ce = s.getConditionExpression();
            if (!ToolUtil.isNotEmpty((Object)ce) || !AnalyticalModelUtil.getResultByELAndFormData(ce, variables)) continue;
            flow = s.getId();
            break;
        }
        if (ToolUtil.isNotEmpty((Object)flow) && (fe = process.getFlowElement(targetRef = (sequenceFlow = (SequenceFlow)process.getFlowElement(flow)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = fe.getId();
        }
        return taskDefinitionKey;
    }

    public static HashSet<String> getNextCandidateUser(String processInsId, String processDefinitionId, BpmnModel bm, String activityId, String tenantId, Map<String, Object> map) {
        String processKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        HashSet<String> users = new HashSet<String>();
        FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId);
        if (flowElement == null) {
            throw new PublicClientException(bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        if (flowElement instanceof ReceiveTask || flowElement instanceof ServiceTask) {
            return users;
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (extensionElementsNode.size() > 0) {
            Map result;
            String startUserId;
            JSONObject inExpressions;
            String defaultAssign;
            Map modelAssignee = sysActAssigneeService.getAssignee(processKey, activityId, false);
            if (ToolUtil.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")));
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            }
            String businessId = null;
            String string = startUserId = ToolUtil.isEmpty(newMap.get("userId")) ? "" : (String)newMap.get("userId");
            if (processInsId != null) {
                HistoricProcessInstance hpi = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
                businessId = hpi.getBusinessKey();
                startUserId = hpi.getStartUserId();
            } else {
                newMap.put("sendUser", startUserId);
            }
            if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, processInsId);
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions) && ToolUtil.isNotEmpty((Object)(result = CommonCodeUtil.getGodAxeResult((String)tenantId, (String)activityId, (String)businessId, (String)processDefinitionId)))) {
                newMap.putAll(result);
            }
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, processKey, startUserId, defaultAssign, inExpressions, newMap);
        }
        return users;
    }

    private static boolean isGetVisitor(String defaultAssign, JSONObject conditionAssign) {
        if (defaultAssign.contains("$")) {
            return true;
        }
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("$") && !((String)conditionAssign.get((Object)k.toString())).contains("$")) continue;
                return true;
            }
        }
        return false;
    }
}

