/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.function.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.function.dao.SysActFunctionMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.function.dto.AddFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bsp.function.dto.EditFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bsp.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bsp.function.model.SysActFunctionParm;
import com.jxdinfo.hussar.workflow.engine.bsp.function.service.ISysActFunctionParmService;
import com.jxdinfo.hussar.workflow.engine.bsp.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysActFunctionServiceImpl
extends ServiceImpl<SysActFunctionMapper, SysActFunction>
implements ISysActFunctionService {
    @Resource
    private SysActFunctionMapper sysActFunctionMapper;
    @Autowired
    private ISysActFunctionParmService sysActFunctionParmService;

    public ApiResponse<Tip> add(AddFunctionDto addFunctionDto) {
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        SysActFunction sysActFunction = new SysActFunction();
        sysActFunction.setFunctionName(addFunctionDto.getFunctionName());
        sysActFunction.setFunctionBean(addFunctionDto.getFunctionBean());
        sysActFunction.setCreateTime(currTime);
        int insertResult = this.sysActFunctionMapper.insert(sysActFunction);
        if (insertResult != 1) {
            throw new PublicClientException(BpmEnum.ERROR_INSERT.getMessage());
        }
        if (ToolUtil.isNotEmpty((Object)addFunctionDto.getFunctionParm())) {
            ArrayList<SysActFunctionParm> parmList = new ArrayList<SysActFunctionParm>();
            JSONArray jsonArray = JSON.parseArray((String)addFunctionDto.getFunctionParm());
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                sysActFunctionParm.setFunctionId(sysActFunction.getId());
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                sysActFunctionParm.setCreateTime(currTime);
                parmList.add(sysActFunctionParm);
            }
            boolean saveResult = this.sysActFunctionParmService.saveBatch(parmList);
            if (!saveResult) {
                throw new PublicClientException(BpmEnum.ERROR_INSERT.getMessage());
            }
        }
        return ApiResponse.success((String)BpmEnum.SUCCESS_INSERT.getMessage());
    }

    public ApiResponse<Tip> update(EditFunctionDto editFunctionDto) {
        List<String> delList;
        boolean delResult;
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        if (Boolean.parseBoolean(editFunctionDto.getChange())) {
            SysActFunction sysActFunction = new SysActFunction();
            sysActFunction.setId(Long.valueOf(editFunctionDto.getId()));
            sysActFunction.setFunctionBean(editFunctionDto.getFunctionBean());
            sysActFunction.setFunctionName(editFunctionDto.getFunctionName());
            sysActFunction.setUpdateTime(currTime);
            int updateResult = this.sysActFunctionMapper.updateById(sysActFunction);
            if (updateResult != 1) {
                throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
            }
        }
        if (ToolUtil.isNotEmpty((Object)editFunctionDto.getFunctionParm())) {
            JSONArray jsonArray = JSON.parseArray((String)editFunctionDto.getFunctionParm());
            ArrayList<SysActFunctionParm> addList = new ArrayList<SysActFunctionParm>();
            ArrayList<SysActFunctionParm> updateList = new ArrayList<SysActFunctionParm>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                Long parmId = jsonArray.getJSONObject(i).getLong("id");
                if (ToolUtil.isNotEmpty((Object)parmId)) {
                    sysActFunctionParm.setId(parmId);
                    sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                    sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                    sysActFunctionParm.setUpdateTime(currTime);
                    updateList.add(sysActFunctionParm);
                    continue;
                }
                sysActFunctionParm.setFunctionId(Long.valueOf(editFunctionDto.getId()));
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                sysActFunctionParm.setCreateTime(currTime);
                addList.add(sysActFunctionParm);
            }
            boolean insertResult = true;
            boolean updateResult = true;
            if (addList.size() != 0) {
                insertResult = this.sysActFunctionParmService.saveBatch(addList);
            }
            if (updateList.size() != 0) {
                updateResult = this.sysActFunctionParmService.updateBatchById(updateList);
            }
            if (!insertResult || !updateResult) {
                throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
            }
        }
        if (ToolUtil.isNotEmpty((Object)editFunctionDto.getDelIds()) && !(delResult = this.sysActFunctionParmService.removeByIds(delList = Arrays.asList(editFunctionDto.getDelIds().split(","))))) {
            throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
        }
        return ApiResponse.success((String)BpmEnum.SUCCESS_UPDATE.getMessage());
    }

    public ApiResponse<IPage<SysActFunction>> queryFunctionList(Page page, String functionName) {
        List<SysActFunction> list = this.sysActFunctionMapper.queryFunctionList(page, functionName);
        page.setRecords(list);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Tip> delete(Long functionId) {
        this.sysActFunctionParmService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActFunctionParm::getFunctionId, (Object)functionId));
        int removeNum = this.sysActFunctionMapper.deleteById(functionId);
        if (removeNum == 0) {
            throw new PublicClientException(BpmEnum.DELETE_FAIL.getMessage());
        }
        return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
    }

    public ApiResponse<Tip> importFunction(MultipartFile file) {
        try {
            byte[] function = file.getBytes();
            String data = new String(function);
            Map map = (Map)JSONObject.parseObject((String)data, HashMap.class);
            if (!"lcdpBpmFunction".equals(map.get("export_type"))) {
                throw new PublicClientException(BpmEnum.ERROR_IMPORT_FUNCTION_TYPE.getMessage());
            }
            if (ToolUtil.isNotEmpty(map.get("function"))) {
                JSONArray functions = (JSONArray)JSONObject.parseObject((String)String.valueOf(map.get("function")), JSONArray.class);
                List functionList = JSONObject.parseArray((String)functions.toJSONString(), SysActFunction.class);
                this.saveOrUpdateBatch(functionList);
                if (ToolUtil.isNotEmpty(map.get("functionParm"))) {
                    JSONArray functionParms = (JSONArray)JSONObject.parseObject((String)String.valueOf(map.get("functionParm")), JSONArray.class);
                    List functionParmList = JSONObject.parseArray((String)functionParms.toJSONString(), SysActFunctionParm.class);
                    this.sysActFunctionParmService.saveOrUpdateBatch((Collection)functionParmList);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PublicClientException(BpmEnum.ERROR_IMPORT.getMessage());
        }
        return ApiResponse.success((String)BpmEnum.IMPORT_SUCCESS.getMessage());
    }

    public void exportFunction(String functionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        List functionIds = Arrays.asList(functionId.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List functionList = this.sysActFunctionMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysActFunction::getId, functionIds));
        List functionParmIds = Arrays.asList(functionId.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List functionParmList = this.sysActFunctionParmService.list((Wrapper)new LambdaQueryWrapper().in(SysActFunctionParm::getFunctionId, functionParmIds));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("function", functionList);
        data.put("functionParm", functionParmList);
        data.put("export_type", "lcdpBpmFunction");
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(JSONObject.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

