/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.springframework.amqp.utils.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ActivityRedisTimerServiceImpl
implements ActivityRedisTimerService {
    private static Logger logger = LogManager.getLogger(ActivityRedisTimerServiceImpl.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    @Autowired
    private RedisTemplate redisTemplate;

    public void addTimeOutModel(TimeOutModel timeOutModel) {
        if (TimeOutHandleUtil.isUseRedis) {
            try {
                this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + timeOutModel.getId()), (Object)JSON.toJSONString((Object)timeOutModel));
                Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                if (ToolUtil.isEmpty((Object)oldTask)) {
                    this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)timeOutModel.getId(), (double)timeOutModel.getDueTime().getTime());
                } else {
                    this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getId()), (double)timeOutModel.getDueTime().getTime());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5b58\u50a8\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u5931\u8d25[taskId:{}]-->{}", new Object[]{timeOutModel.getId(), e.toString()});
            }
            return;
        }
        this.activityRedisTimerMapper.insert(timeOutModel);
        HussarCacheUtil.put((String)"bpm_timer_activity", (Object)timeOutModel.getId(), (Object)timeOutModel);
        Long time = timeOutModel.getDueTime().getTime();
        if (TimeOutHandleUtil.isGetList) {
            TimeOutHandleUtil.getListTimeAddModel.add(time);
        } else {
            int index = TimeOutHandleUtil.timeOutList.size();
            for (int i = 0; i < TimeOutHandleUtil.timeOutList.size() && TimeOutHandleUtil.timeOutList.get(i) < time; ++i) {
                index = i + 1;
            }
            TimeOutHandleUtil.timeOutList.add(index, time);
            TimeOutHandleUtil.orderTime();
        }
        TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? timeOutModel.getId() : TimeOutHandleUtil.timeOutMap.get(time) + "," + timeOutModel.getId());
    }

    public void delTimeOutModel(String taskId) {
        if (TimeOutHandleUtil.isUseRedis) {
            try {
                if (taskId.contains(",")) {
                    String[] list = taskId.split(",");
                    for (int i = 0; i < list.length; ++i) {
                        list[i] = "bpm_activity:timer:task_Message:" + list[i];
                    }
                    this.redisTemplate.delete((Object)list);
                } else {
                    this.redisTemplate.delete((Object)("bpm_activity:timer:task_Message:" + taskId));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5220\u9664\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25[key:{}{}]-->{}", new Object[]{"bpm_activity:timer:task_Message:", taskId, e.toString()});
            }
            return;
        }
        List<String> taskIds = Arrays.asList(taskId.split(","));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TimeOutModel::getId, taskIds);
        this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
        HussarCacheUtil.evict((String)"bpm_timer_activity", taskIds);
        if (TimeOutHandleUtil.isGetList) {
            TimeOutHandleUtil.getListTimeDelModel.addAll(taskIds);
        }
    }

    public void addGlobalTimeOutModel(BpmnModel bm, Map<String, Object> map) {
        List globalTimeOutStrategyElement;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String instanceId = "";
        Date createTime = null;
        String tenantId = "";
        String starter = "";
        Object processInsId = map.get("processInsId");
        Object cTime = map.get("createTime");
        Object tId = map.get("tenantId");
        Object tStarter = map.get("starter");
        if (ToolUtil.isNotEmpty((Object)processInsId)) {
            instanceId = processInsId.toString();
        }
        if (ToolUtil.isNotEmpty((Object)cTime)) {
            try {
                createTime = simpleDateFormat.parse(cTime.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isNotEmpty((Object)tId)) {
            tenantId = tId.toString();
        }
        if (ToolUtil.isNotEmpty((Object)tStarter)) {
            starter = tStarter.toString();
        }
        String globalDueDate = "";
        String globalTimeOutStrategy = "";
        Date globalDueTime = null;
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List globalDueDateElement = (List)extensionElementList.get("globalDueDate");
        if (ToolUtil.isNotEmpty((Object)globalDueDateElement) && ToolUtil.isNotEmpty(((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate"))) {
            globalDueDate = ((ExtensionAttribute)((List)((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate")).get(0)).getValue();
        }
        if (ToolUtil.isNotEmpty((Object)createTime) && ToolUtil.isNotEmpty((Object)globalDueDate)) {
            globalDueTime = new DateTime(createTime.getTime()).plus((ReadablePeriod)Period.parse((String)globalDueDate)).toDate();
        }
        if (ToolUtil.isNotEmpty((Object)(globalTimeOutStrategyElement = (List)extensionElementList.get("globalTimeOutStrategy"))) && ToolUtil.isNotEmpty(((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy"))) {
            globalTimeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy")).get(0)).getValue();
        }
        if (ToolUtil.isNotEmpty((Object)globalTimeOutStrategy)) {
            globalTimeOutStrategy = "global-" + globalTimeOutStrategy;
        }
        if (ToolUtil.isNotEmpty((Object)globalDueTime) && ToolUtil.isNotEmpty((Object)globalTimeOutStrategy) && ToolUtil.isNotEmpty((Object)instanceId)) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(instanceId);
            timeOutModel.setAssignee(starter);
            timeOutModel.setCreateTime(createTime);
            timeOutModel.setDueTime(globalDueTime);
            timeOutModel.setTimeOutType(globalTimeOutStrategy);
            timeOutModel.setTenantId(tenantId);
            if (timeOutModel.getTimeOutType().startsWith("global-http")) {
                map.remove("type");
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.addTimeOutModel(timeOutModel);
        }
    }

    public void delGlobalTimeOutModel(Map<String, Object> map) {
        String instanceId = "";
        Object processInsId = map.get("processInsId");
        if (ToolUtil.isNotEmpty((Object)processInsId)) {
            instanceId = processInsId.toString();
        }
        if (ToolUtil.isNotEmpty((Object)instanceId)) {
            this.delTimeOutModel(instanceId);
        }
    }

    public void updateTimeOutModel(String taskId, String assignee, String userId, int type) {
        if (TimeOutHandleUtil.isUseRedis) {
            try {
                Object model = this.redisTemplate.opsForValue().get((Object)("bpm_activity:timer:task_Message:" + taskId));
                if (ToolUtil.isNotEmpty((Object)model)) {
                    this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + taskId), (Object)SerializationUtils.serialize((Object)this.getTimeOutAssignee((TimeOutModel)JSON.parseObject((String)String.valueOf(model), TimeOutModel.class), assignee, userId, type)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u66f4\u65b0\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u53c2\u4e0e\u8005\u5931\u8d25[taskId:{}]-->{}", new Object[]{taskId, e.toString()});
            }
            return;
        }
        TimeOutModel timeOutModel = (TimeOutModel)HussarCacheUtil.get((String)"bpm_timer_activity", (Object)taskId);
        if (timeOutModel != null) {
            this.activityRedisTimerMapper.updateById(this.getTimeOutAssignee(timeOutModel, assignee, userId, type));
            HussarCacheUtil.put((String)"bpm_timer_activity", (Object)taskId, (Object)timeOutModel);
        }
    }

    private TimeOutModel getTimeOutAssignee(TimeOutModel timeOutModel, String assignee, String userId, int type) {
        String users;
        String string = users = timeOutModel.getAssignee() == null ? "" : timeOutModel.getAssignee();
        if (type == 0) {
            ArrayList<String> userList = new ArrayList<String>(Arrays.asList(users.split(",")));
            if (userId != null) {
                userList.remove(userId);
            }
            if (assignee != null) {
                userList = new ArrayList<String>(userList);
                userList.addAll(new ArrayList<String>(Arrays.asList(assignee.split(","))));
            }
            userList = new ArrayList<String>(new HashSet<String>(userList));
            timeOutModel.setAssignee(String.join((CharSequence)",", userList));
        } else {
            timeOutModel.setAssignee(assignee);
        }
        return timeOutModel;
    }
}

